/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbpm.mservice;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.application.impl.common.CompareDiffController;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiInputParam;
import kd.hr.hbp.business.domain.model.newhismodel.api.comparediff.CompareDiffApiOutPutParam;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbpm.mservice.api.IPositionAPIService;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionAPIService
implements IPositionAPIService {
    private static final String ADD_POSITION = "addPosition";
    private static final String CHANGE_POSITION = "changePosition";
    private Map<Long, String> idNumberMap;
    private static final Set<String> IGNORE_FIELDS = new HashSet<String>(Arrays.asList("issyspreset", "disabler", "disabledate", "initdatasource", "initstatus", "initbatch", "iscurrentversion", "datastatus", "sourcevid", "firstbsed", "changebsed", "bred", "brled", "brfd", "ismodify", "bsed", "bsled", "changedescription", "hisversion", "creator", "modifier", "createtime", "modifytime", "masterid"));

    public Map<String, Object> addPosition(List<DynamicObject> positions) {
        if (positions.size() > 500) {
            return this.buildErroResult("The data volume cannot exceed 500");
        }
        ArrayList<DynamicObject> positionApis = new ArrayList<DynamicObject>(positions.size());
        HashMap<String, List<String>> errorInfoMap = new HashMap<String, List<String>>();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_position_api");
        for (DynamicObject position : positions) {
            String errorMsg = this.checkPosition(position, ADD_POSITION, null);
            if (HRStringUtils.isEmpty((String)errorMsg)) {
                DynamicObject positionApi = new DynamicObject((DynamicObjectType)dataEntityType);
                HRDynamicObjectUtils.copy((DynamicObject)position, (DynamicObject)positionApi);
                positionApi.set("id", (Object)position.getLong("id"));
                positionApi.set("changetype", (Object)1010L);
                positionApi.set("initstatus", (Object)"2");
                positionApi.set("initdatasource", (Object)"0");
                this.addSystemField(positionApi, ADD_POSITION);
                positionApis.add(positionApi);
                continue;
            }
            this.addErrorInfoMsg(errorInfoMap, position.getString("number"), errorMsg);
        }
        if (positionApis.size() > 0) {
            DynamicObject[] positionArrays = positionApis.toArray(new DynamicObject[0]);
            this.initIdNumberMap(positionArrays);
            this.changeJobLevelAndGradeScm(positionArrays);
            OperationResult opResult = this.callOp("save_api", positionArrays);
            return this.buildResult(opResult, errorInfoMap);
        }
        return this.buildResult("fail", errorInfoMap);
    }

    public Map<String, Object> changePosition(List<DynamicObject> positions) {
        if (positions.size() > 500) {
            return this.buildErroResult("The data volume cannot exceed 500");
        }
        HashMap<String, List<String>> errorInfoMap = new HashMap<String, List<String>>(positions.size());
        List<DynamicObject> changePositions = this.buildPositions(positions, errorInfoMap);
        this.removeNoChangeData(changePositions);
        List<DynamicObject> positionInits = this.buildPositionInits(changePositions);
        if (positionInits.size() > 0) {
            DynamicObject[] positionArrays = positionInits.toArray(new DynamicObject[0]);
            this.initIdNumberMap(positionArrays);
            this.changeJobLevelAndGradeScm(positionArrays);
            OperationResult opResult = this.callOp("change_api", positionArrays);
            return this.buildResult(opResult, errorInfoMap);
        }
        return this.buildResult("fail", errorInfoMap);
    }

    public Map<String, Object> enablePosition(List<Long> positionIdList) {
        if (positionIdList.size() > 500) {
            return this.buildErroResult("The data volume cannot exceed 500");
        }
        HRBaseServiceHelper enablePosition = new HRBaseServiceHelper("hbpm_position_api");
        QFilter idFilter = new QFilter("id", "in", positionIdList);
        DynamicObject[] enablePositions = enablePosition.loadDynamicObjectArray(new QFilter[]{idFilter});
        this.initIdNumberMap(enablePositions);
        Map<String, List<String>> errorInfoMap = this.checkIdIsExit(positionIdList, enablePositions);
        OperationResult opResult = this.callOp("enable_api", enablePositions);
        return this.buildResult(opResult, errorInfoMap);
    }

    private Map<Long, DynamicObject> queryJobLevelOrGradeScm(List<Long> ids, String entityNumber) {
        Map<Object, Object> jobLevelOrGradeScmMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        if (CollectionUtils.isEmpty(ids)) {
            return jobLevelOrGradeScmMap;
        }
        HRBaseServiceHelper jobLevelScm = new HRBaseServiceHelper(entityNumber);
        QFilter idFilter = new QFilter("id", "in", ids);
        Object[] jobLevelOrGradeScm = jobLevelScm.loadDynamicObjectArray(new QFilter[]{idFilter});
        if (PositionUtils.isArrayEmpty((Object[])jobLevelOrGradeScm).booleanValue()) {
            return jobLevelOrGradeScmMap;
        }
        jobLevelOrGradeScmMap = Arrays.stream(jobLevelOrGradeScm).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v1));
        return jobLevelOrGradeScmMap;
    }

    public Map<String, Object> disablePosition(List<Long> positionIdList) {
        if (positionIdList.size() > 500) {
            return this.buildErroResult("The data volume cannot exceed 500");
        }
        HRBaseServiceHelper disable = new HRBaseServiceHelper("hbpm_position_api");
        QFilter idFilter = new QFilter("id", "in", positionIdList);
        DynamicObject[] disablePositions = disable.loadDynamicObjectArray(new QFilter[]{idFilter});
        this.initIdNumberMap(disablePositions);
        Map<String, List<String>> errorInfoMap = this.checkIdIsExit(positionIdList, disablePositions);
        OperationResult opResult = this.callOp("disable_api", disablePositions);
        return this.buildResult(opResult, errorInfoMap);
    }

    private void addSystemField(DynamicObject position, String type) {
        position.set("org", position.get("adminorg.org"));
        if (position.getDate("establishmentdate") == null) {
            position.set("establishmentdate", (Object)position.getDate("bsed"));
        }
        DynamicObject parent = position.getDynamicObject("parent");
        if (ADD_POSITION.equals(type) && parent != null) {
            if (parent.getDate("establishmentdate") == null) {
                parent.set("establishmentdate", (Object)parent.getDate("bsed"));
            }
            if (parent.getDate("firstbsed") == null) {
                parent.set("firstbsed", (Object)parent.getDate("bsed"));
            }
        }
        if (position.getString("issensitive") == null) {
            position.set("issensitive", (Object)"0");
        }
        this.fillJobLevelOrGradeScm(position);
    }

    private void fillJobLevelOrGradeScm(DynamicObject position) {
        DynamicObject jobScm = position.getDynamicObject("jobscm");
        if (!HRObjectUtils.isEmpty((Object)jobScm)) {
            return;
        }
        DynamicObject highJobLevel = position.getDynamicObject("highjoblevel");
        DynamicObject lowJobLevel = position.getDynamicObject("lowjoblevel");
        DynamicObject highJobGrade = position.getDynamicObject("highjobgrade");
        DynamicObject lowJobGrade = position.getDynamicObject("lowjobgrade");
        if (!HRObjectUtils.isEmpty((Object)highJobLevel) || !HRObjectUtils.isEmpty((Object)lowJobLevel)) {
            DynamicObject jobLevelScm = null;
            jobLevelScm = !HRObjectUtils.isEmpty((Object)highJobLevel) ? highJobLevel.getDynamicObject("joblevelscm") : lowJobLevel.getDynamicObject("joblevelscm");
            position.set("joblevelscm", (Object)jobLevelScm);
        }
        if (!HRObjectUtils.isEmpty((Object)highJobGrade) || !HRObjectUtils.isEmpty((Object)lowJobGrade)) {
            DynamicObject jobGradeScm = null;
            jobGradeScm = !HRObjectUtils.isEmpty((Object)highJobGrade) ? highJobGrade.getDynamicObject("jobgradescm") : lowJobGrade.getDynamicObject("jobgradescm");
            position.set("jobgradescm", (Object)jobGradeScm);
        }
    }

    private void addErrorInfoMsg(Map<String, List<String>> errorInfoMap, String number, String errorMsg) {
        List<String> errorInfo = errorInfoMap.get(number);
        if (errorInfo == null) {
            errorInfo = new ArrayList<String>();
        }
        errorInfo.add(errorMsg);
        errorInfoMap.put(number, errorInfo);
    }

    private Map<String, List<String>> checkIdIsExit(List<Long> ids, DynamicObject[] positions) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List<Object> positionIds = null;
        HashMap errorInfoMap = Maps.newHashMapWithExpectedSize((int)ids.size());
        positionIds = PositionUtils.isArrayEmpty((Object[])positions) != false ? new ArrayList() : Arrays.stream(positions).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        for (Long positionId : ids) {
            if (positionIds.contains(positionId)) continue;
            ArrayList<String> errorInfo = new ArrayList<String>();
            errorInfo.add(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionAPIService_4", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
            errorInfoMap.put(String.valueOf(positionId), errorInfo);
        }
        return errorInfoMap;
    }

    private String checkPosition(DynamicObject position, String serviceType, Map<Long, DynamicObject> posMap) {
        StringBuilder errorMsg = new StringBuilder();
        if (position.getLong("id") == 0L) {
            errorMsg.append(ResManager.loadKDString((String)"\u5c97\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PositionAPIService_1", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        if (ADD_POSITION.equals(serviceType) && position.get("adminorg") == null) {
            errorMsg.append(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u884c\u653f\u7ec4\u7ec7\u201d\u3002", (String)"PositionAPIService_2", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        if (posMap != null && posMap.get(position.getLong("id")) == null) {
            errorMsg.append(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528\u3002", (String)"PositionAPIService_3", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        return errorMsg.toString();
    }

    private void copyChangeField(DynamicObject fromDyn, DynamicObject toDyn) {
        List dirtyProperties = fromDyn.getDataEntityState().GetDirtyProperties();
        for (IDataEntityProperty dirtyPropertie : dirtyProperties) {
            String fieldName = dirtyPropertie.getName();
            toDyn.set(fieldName, fromDyn.get(fieldName));
        }
    }

    private Map<Long, DynamicObject> getPositionById(List<Long> posIds) {
        HRBaseServiceHelper positionhr = new HRBaseServiceHelper("hbpm_positionhr");
        QFilter idFilter = new QFilter("boid", "in", posIds);
        QFilter versionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject[] positionByIds = positionhr.loadDynamicObjectArray(new QFilter[]{idFilter, versionFilter, enableFilter});
        HashMap<Long, DynamicObject> posMap = new HashMap<Long, DynamicObject>(positionByIds.length);
        for (DynamicObject positionById : positionByIds) {
            posMap.put(positionById.getLong("id"), positionById);
        }
        return posMap;
    }

    private Map<String, Object> buildResult(OperationResult opResult, Map<String, List<String>> errorInfoMap) {
        if (errorInfoMap == null) {
            errorInfoMap = new HashMap<String, List<String>>();
        }
        List validateErrors = opResult.getValidateResult().getValidateErrors();
        for (ValidateResult validateError : validateErrors) {
            List allErrorInfo = validateError.getAllErrorInfo();
            for (OperateErrorInfo opErrorInfo : allErrorInfo) {
                Long pkId = (Long)opErrorInfo.getPkValue();
                this.addErrorInfoMsg(errorInfoMap, this.getPositionNumber(pkId), opErrorInfo.getMessage());
            }
        }
        return this.buildResult(opResult.getMessage(), errorInfoMap);
    }

    private Map<String, Object> buildResult(String msg, Map<String, List<String>> errorInfoMap) {
        if (errorInfoMap.size() == 0) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("message", "success");
            result.put("data", "success");
            result.put("errorCode", "success");
            return result;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("message", msg);
        result.put("data", errorInfoMap);
        result.put("errorCode", "fail");
        return result;
    }

    private void initIdNumberMap(DynamicObject[] positions) {
        this.idNumberMap = new HashMap<Long, String>(positions.length);
        for (DynamicObject position : positions) {
            this.idNumberMap.put(position.getLong("id"), position.getString("number"));
        }
    }

    private void changeJobLevelAndGradeScm(DynamicObject[] positions) {
        if (PositionUtils.isArrayEmpty((Object[])positions).booleanValue()) {
            return;
        }
        ArrayList<Long> jobLevelScmIds = new ArrayList<Long>();
        ArrayList<Long> jobGradeScmIds = new ArrayList<Long>();
        for (DynamicObject position : positions) {
            long jobLevelScmId = position.getLong("joblevelscm.id");
            long jobGradeScmId = position.getLong("jobgradescm.id");
            if (jobLevelScmId != 0L) {
                jobLevelScmIds.add(jobLevelScmId);
            }
            if (jobGradeScmId == 0L) continue;
            jobGradeScmIds.add(jobGradeScmId);
        }
        Map<Long, DynamicObject> jobLevelScmMap = this.queryJobLevelOrGradeScm(jobLevelScmIds, "hbjm_joblevelscmhr");
        Map<Long, DynamicObject> jobGradeScmMap = this.queryJobLevelOrGradeScm(jobGradeScmIds, "hbjm_jobgradescmhr");
        for (DynamicObject position : positions) {
            long jobLevelScmId = position.getLong("joblevelscm.id");
            long jobGradeScmId = position.getLong("jobgradescm.id");
            if (jobLevelScmId != 0L) {
                position.set("joblevelscm", (Object)jobLevelScmMap.get(jobLevelScmId));
            }
            if (jobGradeScmId == 0L) continue;
            position.set("jobgradescm", (Object)jobGradeScmMap.get(jobGradeScmId));
        }
    }

    private String getPositionNumber(Long positionId) {
        return this.idNumberMap.get(positionId);
    }

    private Map<String, Object> buildErroResult(String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("message", msg);
        result.put("data", null);
        result.put("errorCode", "fail");
        return result;
    }

    private OperationResult callOp(String opKey, DynamicObject[] positions) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        return opImpl.localInvokeOperation(opKey, positions, operateOption);
    }

    private void removeNoChangeData(List<DynamicObject> changePositions) {
        if (CollectionUtils.isEmpty(changePositions)) {
            return;
        }
        CompareDiffApiInputParam param = new CompareDiffApiInputParam();
        param.setEntityNumber("hbpm_positionhr");
        param.setDynamicObjects(changePositions.toArray(new DynamicObject[0]));
        param.setIgnoreFields(IGNORE_FIELDS);
        CompareDiffController diffController = new CompareDiffController();
        HrApiResponse noChangeData = diffController.isNewData(param);
        if (noChangeData.isSuccess()) {
            return;
        }
        List diffApiOutPutParams = (List)noChangeData.getData();
        if (diffApiOutPutParams == null || diffApiOutPutParams.size() == 0) {
            return;
        }
        ArrayList<DynamicObject> noChangePositions = new ArrayList<DynamicObject>(diffApiOutPutParams.size());
        for (CompareDiffApiOutPutParam diffApiOutPutParam : diffApiOutPutParams) {
            noChangePositions.add(diffApiOutPutParam.getDyOriginal());
        }
        changePositions.removeAll(noChangePositions);
    }

    private List<DynamicObject> buildPositionInits(List<DynamicObject> changePositions) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_position_api");
        ArrayList<DynamicObject> positionInits = new ArrayList<DynamicObject>(changePositions.size());
        for (DynamicObject position : changePositions) {
            DynamicObject positionInit = new DynamicObject((DynamicObjectType)dataEntityType);
            HRDynamicObjectUtils.copy((DynamicObject)position, (DynamicObject)positionInit);
            positionInit.set("id", (Object)position.getLong("id"));
            this.addSystemField(positionInit, CHANGE_POSITION);
            positionInits.add(positionInit);
        }
        return positionInits;
    }

    private List<DynamicObject> buildPositions(List<DynamicObject> positions, Map<String, List<String>> errorInfoMap) {
        ArrayList<Long> posIds = new ArrayList<Long>(positions.size());
        for (DynamicObject position : positions) {
            posIds.add(position.getLong("id"));
        }
        Map<Long, DynamicObject> posMap = this.getPositionById(posIds);
        ArrayList<DynamicObject> changePositions = new ArrayList<DynamicObject>(positions.size());
        for (DynamicObject position : positions) {
            String errorMsg = this.checkPosition(position, CHANGE_POSITION, posMap);
            if (HRStringUtils.isEmpty((String)errorMsg)) {
                DynamicObject positionById = posMap.get(position.getLong("id"));
                this.copyChangeField(position, positionById);
                changePositions.add(positionById);
                continue;
            }
            this.addErrorInfoMsg(errorInfoMap, position.getString("number"), errorMsg);
        }
        return changePositions;
    }
}

