/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbpm.mservice;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbpm.mservice.api.IPositionListService;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import org.apache.commons.lang.ArrayUtils;

public class PositionListServiceImpl
implements IPositionListService {
    private static final String POSITIONCLASSIFY = "positionclassify";

    public Map<String, Object> queryPositiion(List<Long> jobIdList) {
        Object[] positonDyns;
        if (CollectionUtils.isEmpty(jobIdList)) {
            PositionListServiceImpl.buildSuccessResult(201, "jobid is empty", null);
        }
        if (ArrayUtils.isEmpty((Object[])(positonDyns = PositionQueryRepository.getInstance().queryPositionList(jobIdList)))) {
            return PositionListServiceImpl.buildSuccessResult(200, "", null);
        }
        ArrayList list = new ArrayList(positonDyns.length);
        for (Object positonDyn : positonDyns) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            positonDyn.getLong("id");
            map.put("adminorg", positonDyn.getLong("adminorg"));
            map.put("id", positonDyn.getLong("id"));
            map.put("number", positonDyn.getString("number"));
            map.put("name", positonDyn.getString("name"));
            map.put("parent", positonDyn.getLong("parent"));
            map.put(POSITIONCLASSIFY, positonDyn.getLong(POSITIONCLASSIFY));
            map.put("positiontype", positonDyn.getLong("positiontype"));
            map.put("highjoblevel", positonDyn.getLong("highjoblevel"));
            map.put("lowjoblevel", positonDyn.getLong("lowjoblevel"));
            map.put("highjobgrade", positonDyn.getLong("highjobgrade"));
            map.put("lowjobgrade", positonDyn.getLong("lowjobgrade"));
            map.put("enable", positonDyn.getString("enable"));
            map.put("status", positonDyn.getString("status"));
            map.put("isleader", positonDyn.getString("isleader"));
            map.put("deputytype", positonDyn.getLong("deputytype"));
            map.put("group", positonDyn.getLong("group"));
            map.put("job", positonDyn.getLong("job"));
            map.put("establishmentdate", positonDyn.getDate("establishmentdate"));
            list.add(map);
        }
        return PositionListServiceImpl.buildSuccessResult(200, "", list);
    }

    private static Map<String, Object> buildSuccessResult(int code, String ErrMsg, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", code);
        result.put("ErrMsg", ErrMsg);
        result.put("data", data);
        return result;
    }

    public Map<Long, Boolean> jobIsRefEnablePosition(List<Long> jobIdList) {
        DynamicObject[] positonDyns = PositionQueryRepository.getInstance().queryEnablePositionByJobId(jobIdList);
        List existEnablePosJobList = Arrays.stream(positonDyns).map(dyn -> dyn.getLong("job.id")).collect(Collectors.toList());
        HashMap result = Maps.newHashMapWithExpectedSize((int)jobIdList.size());
        for (long jobId : jobIdList) {
            result.put(jobId, existEnablePosJobList.contains(jobId));
        }
        return result;
    }
}

