/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbpm.mservice;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbpm.mservice.api.IPositionService;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ReportingrelationQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.StandardPositionRepository;
import kd.hrmp.hbpm.business.domain.repository.position.WorkRoleQueryRepository;
import kd.hrmp.hbpm.business.utils.JobLevelAndJobGradeUtil;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.business.utils.model.ReportHisLoopCheckEntity;

public class PositionServiceImpl
implements IPositionService {
    private static final Log LOGGER = LogFactory.getLog(PositionServiceImpl.class);

    public Map<String, Object> queryPosition(List<Long> positionIdList) {
        if (CollectionUtils.isEmpty(positionIdList)) {
            return PositionServiceImpl.buildSuccessResult(201, "positionids is empty", null);
        }
        DynamicObject[] positonDyns = PositionQueryRepository.getInstance().queryPositionInfo(positionIdList);
        HashMap relatedMap = Maps.newHashMapWithExpectedSize((int)positonDyns.length);
        Arrays.stream(positonDyns).forEach(dyn -> relatedMap.put(dyn.getLong("id"), dyn.getLong("workrole")));
        Collection workrolesIdList = relatedMap.values();
        List workRoleDyns = ReportingrelationQueryRepository.getInstance().queryReportRelationPartialInfo(workrolesIdList);
        Map<Long, List<Map<String, Object>>> workRolesMap = this.getWrokRolesMap(workRoleDyns);
        List<Map<String, Object>> maps = PositionServiceImpl.buildMap(positonDyns, workRolesMap, relatedMap, false);
        return PositionServiceImpl.buildSuccessResult(200, "", maps);
    }

    public Map<String, Object> queryJobLevelAndJobGradeByPositionIds(List<Long> positionIdList) {
        if (CollectionUtils.isEmpty(positionIdList)) {
            return PositionServiceImpl.buildSuccessResult(201, "positionids is empty", null);
        }
        if (positionIdList.size() > 2000) {
            return PositionServiceImpl.buildSuccessResult(202, "positionids is must be less than 2000", null);
        }
        DynamicObject[] positonDyns = PositionQueryRepository.getInstance().queryPositionJobLevelAndJobGrade(positionIdList);
        return JobLevelAndJobGradeUtil.queryStdPostionOrPositionLevelAndGrade((DynamicObject[])positonDyns);
    }

    private Map<Long, List<Map<String, Object>>> getWrokRolesMap(List<DynamicObject> workRoleDyns) {
        Map<Long, List<DynamicObject>> workRoleIdDynMap = workRoleDyns.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("role")));
        Set<Long> workRoleIdSet = workRoleIdDynMap.keySet();
        HashMap workRolesMap = Maps.newHashMapWithExpectedSize((int)workRoleIdSet.size());
        workRoleIdSet.stream().forEach(workRoleId -> {
            List workRoleDynList = (List)workRoleIdDynMap.get(workRoleId);
            ArrayList workRoleMapList = Lists.newArrayListWithExpectedSize((int)workRoleDynList.size());
            workRoleDynList.forEach(dyn -> {
                HashMap workRoleMap = Maps.newHashMap();
                workRoleMap.put("id", dyn.getLong("id"));
                workRoleMap.put("reportingtype", dyn.getLong("reportingtype"));
                workRoleMap.put("parent", dyn.getLong("parent"));
                workRoleMapList.add(workRoleMap);
            });
            workRolesMap.put(workRoleId, workRoleMapList);
        });
        return workRolesMap;
    }

    private static List<Map<String, Object>> buildMap(DynamicObject[] maindyns, Map<Long, List<Map<String, Object>>> workRolesMap, Map<Long, Long> relatedMap, boolean buildMapOnly) {
        if (PositionUtils.isArrayEmpty((Object[])maindyns).booleanValue()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList lists = Lists.newArrayListWithExpectedSize((int)maindyns.length);
        for (DynamicObject dyn : maindyns) {
            DataEntityPropertyCollection properties = dyn.getDataEntityType().getProperties();
            HashMap map = Maps.newHashMapWithExpectedSize((int)properties.size());
            for (IDataEntityProperty property : properties) {
                Object value = dyn.get(property);
                if (!buildMapOnly && property.getName().equals("id")) {
                    Long workRoldId = relatedMap.get(value);
                    map.put("reportRelation", workRolesMap.get(workRoldId));
                }
                if (!Objects.nonNull(value)) continue;
                map.put(property.getName(), value);
            }
            lists.add(map);
        }
        return lists;
    }

    private static Map<String, Object> buildSuccessResult(int code, String ErrMsg, Object data) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        result.put("code", code);
        result.put("ErrMsg", ErrMsg);
        result.put("data", data);
        return result;
    }

    public Map<String, Object> queryOrgLeaderPosition(List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return PositionServiceImpl.buildSuccessResult(201, "orgid is empty", null);
        }
        DynamicObject[] positonDyns = PositionQueryRepository.getInstance().queryOrgLeaderPosition(orgIds);
        return PositionServiceImpl.buildSuccessResult(200, "", PositionServiceImpl.buildMap(positonDyns, null, null, true));
    }

    public Map<String, Object> queryOrgLeaderPositionHis(List<Long> orgIds, Date date) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return PositionServiceImpl.buildSuccessResult(201, "orgid is empty", null);
        }
        if (date == null) {
            return PositionServiceImpl.buildSuccessResult(201, "date is empty", null);
        }
        if (HRDateTimeUtils.dayAfter((Date)date, (Date)new Date())) {
            return PositionServiceImpl.buildSuccessResult(201, "date cannot be greater than the current time", null);
        }
        DynamicObject[] positonDyns = PositionQueryRepository.getInstance().queryOrgLeaderPositionHis(orgIds, date);
        return PositionServiceImpl.buildSuccessResult(200, "", PositionServiceImpl.buildMap(positonDyns, null, null, true));
    }

    public Map<String, Object> queryPositionHis(List<Long> positionIdList, Date date) {
        String errMsg = this.checkParams(positionIdList, date = HRDateTimeUtils.truncateDate((Date)date));
        if (HRStringUtils.isNotEmpty((String)errMsg)) {
            return PositionServiceImpl.buildSuccessResult(201, errMsg, null);
        }
        List<Long> notExistIds = this.notExistIds(positionIdList);
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put("notexistIds", notExistIds);
        data.put("hisdata", null);
        ArrayList<Long> positionIds = new ArrayList<Long>(positionIdList);
        positionIds.removeAll(notExistIds);
        if (positionIds.size() > 0) {
            List<Map<String, Object>> hisdata = this.getPositionHis(positionIds, date);
            data.put("hisdata", hisdata);
        }
        return PositionServiceImpl.buildSuccessResult(200, "", data);
    }

    private String checkParams(List<Long> positionIdList, Date date) {
        if (CollectionUtils.isEmpty(positionIdList)) {
            return "positionid is empty";
        }
        if (positionIdList.size() > 500) {
            return "positionid cannot exceed 500";
        }
        if (date == null) {
            return "date is empty";
        }
        if (HRDateTimeUtils.dayAfter((Date)date, (Date)new Date())) {
            return "date cannot be greater than the current time";
        }
        return "";
    }

    private List<Long> notExistIds(List<Long> positionIdList) {
        ArrayList notExist = Lists.newArrayListWithExpectedSize((int)positionIdList.size());
        DynamicObject[] positonDyns = PositionQueryRepository.getInstance().queryPositionExist(positionIdList);
        List existBoidS = Arrays.stream(positonDyns).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        for (Long id : positionIdList) {
            if (existBoidS.contains(id)) continue;
            notExist.add(id);
        }
        return notExist;
    }

    private List<Map<String, Object>> getPositionHis(List<Long> positionIds, Date date) {
        DynamicObject[] positionhis = PositionQueryRepository.getInstance().queryPositionHisInfo(positionIds, date);
        ArrayList parentids = Lists.newArrayListWithExpectedSize((int)positionIds.size());
        ArrayList workroleids = Lists.newArrayListWithExpectedSize((int)positionIds.size());
        ArrayList orgIds = Lists.newArrayListWithExpectedSize((int)positionIds.size());
        ArrayList<String> jobFields = new ArrayList<String>(Arrays.asList("job", "job.jobseq", "job.jobfamily", "job.jobclass"));
        Map<String, String> jobMethodNameMap = this.initJobMethodNameMap();
        HashMap jobfieldParamsMap = Maps.newHashMapWithExpectedSize((int)(4 * positionIds.size()));
        for (DynamicObject position : positionhis) {
            long parentid = position.getLong("parent");
            parentids.add(parentid);
            long workrole = position.getLong("workrole");
            workroleids.add(workrole);
            long adminorg = position.getLong("adminorg");
            orgIds.add(adminorg);
            for (String jobField : jobFields) {
                this.initJobFieldParams(position, jobField, date, jobfieldParamsMap);
            }
        }
        Map<Long, Long> orghisMap = this.handleOrgHis(orgIds, date);
        Map<Long, Long> parenthisMap = this.handleParentPositionHis(parentids, date);
        Map<Long, List<Map<String, Object>>> relationhisMap = this.handleRelationHis(workroleids, date);
        Map<String, Map<Long, Map<String, Object>>> jobfieldhisAllMap = this.handleJobFieldHis(jobFields, jobfieldParamsMap, jobMethodNameMap);
        List<Map<String, Object>> positionMapList = PositionServiceImpl.buildMap(positionhis, null, null, true);
        for (Map<String, Object> positionMap : positionMapList) {
            positionMap.put("parentVid", parenthisMap.get(positionMap.get("parent")));
            positionMap.put("adminorgVid", orghisMap.get(positionMap.get("adminorg")));
            positionMap.put("reportRelation", relationhisMap.get(positionMap.get("workrole")));
            for (String jobField : jobFields) {
                Map<Long, Map<String, Object>> jobfieldhisMap = jobfieldhisAllMap.get(jobField);
                Map<String, Object> resultMap = jobfieldhisMap.get(positionMap.get(jobField));
                positionMap.put(jobField + "Vid", !CollectionUtils.isEmpty(resultMap) ? resultMap.get("id") : null);
                positionMap.put(jobField + "Vname", !CollectionUtils.isEmpty(resultMap) ? resultMap.get("name") : null);
                positionMap.put(jobField + "Vnumber", !CollectionUtils.isEmpty(resultMap) ? resultMap.get("number") : null);
            }
            positionMap.remove("workrole");
        }
        return positionMapList;
    }

    private void initJobFieldParams(DynamicObject position, String fieldName, Date date, Map<String, Map<String, Object>> jobfieldParamsMap) {
        List boidList;
        long fieldValue = position.getLong(fieldName);
        HashMap params = jobfieldParamsMap.get(fieldName);
        if (params == null) {
            params = Maps.newHashMapWithExpectedSize((int)2);
        }
        if ((boidList = (List)params.get("boidList")) == null) {
            boidList = Lists.newArrayListWithExpectedSize((int)100);
        }
        boidList.add(fieldValue);
        params.put("boidList", boidList);
        params.put("time", date);
        jobfieldParamsMap.put(fieldName, params);
    }

    private Map<String, String> initJobMethodNameMap() {
        HashMap jobFieldMethodName = Maps.newHashMapWithExpectedSize((int)4);
        jobFieldMethodName.put("job", "selectJobHisinfo");
        jobFieldMethodName.put("job.jobseq", "selectSeqHisinfo");
        jobFieldMethodName.put("job.jobfamily", "selectFamHisinfo");
        jobFieldMethodName.put("job.jobclass", "selectClassHisinfo");
        return jobFieldMethodName;
    }

    private Map<Long, Long> handleOrgHis(List<Long> orgIds, Date date) {
        Map orghis = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{orgIds, date});
        HashMap orghisMap = Maps.newHashMapWithExpectedSize((int)orgIds.size());
        if (orghis == null) {
            return orghisMap;
        }
        for (Map org : orghis.values()) {
            orghisMap.put((Long)org.get("id"), (Long)org.get("vid"));
        }
        return orghisMap;
    }

    private Map<Long, Long> handleParentPositionHis(List<Long> parentids, Date date) {
        DynamicObject[] parenthis = PositionQueryRepository.getInstance().queryPositionHisId(parentids, date);
        return Arrays.stream(parenthis).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getLong("id")));
    }

    private Map<Long, List<Map<String, Object>>> handleRelationHis(List<Long> workroleids, Date date) {
        DynamicObject[] relationhis = ReportingrelationQueryRepository.getInstance().queryRelationhis(workroleids, date);
        List parentroleids = Arrays.stream(relationhis).map(dy -> dy.getLong("parent")).collect(Collectors.toList());
        DynamicObject[] workrolehis = WorkRoleQueryRepository.getInstance().queryWorkroleHis(parentroleids, date);
        Map<Long, Long> workrolehisMap = Arrays.stream(workrolehis).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getLong("id")));
        List<Map<String, Object>> relaitionMapList = PositionServiceImpl.buildMap(relationhis, null, null, true);
        HashMap roleRelations = Maps.newHashMapWithExpectedSize((int)workroleids.size());
        for (Map<String, Object> relation : relaitionMapList) {
            long role = (Long)relation.get("role");
            relation.put("parentVid", workrolehisMap.get((Long)relation.get("parent")));
            List roleRelationList = (List)roleRelations.get(role);
            if (roleRelationList == null) {
                roleRelationList = Lists.newArrayListWithExpectedSize((int)4);
            }
            relation.remove("role");
            roleRelationList.add(relation);
            roleRelations.put(role, roleRelationList);
        }
        return roleRelations;
    }

    private Map<String, Map<Long, Map<String, Object>>> handleJobFieldHis(List<String> jobFields, Map<String, Map<String, Object>> jobfieldParamsMap, Map<String, String> jobMethodNameMap) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)jobFields.size());
        for (String jobField : jobFields) {
            List data;
            Map<String, Object> params = jobfieldParamsMap.get(jobField);
            Map jobFieldHisRes = Maps.newHashMapWithExpectedSize((int)8);
            if (params != null) {
                jobFieldHisRes = (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMHisVerService", (String)jobMethodNameMap.get(jobField), (Object[])new Object[]{params.get("boidList"), params.get("time")});
            }
            HashMap fieldhisMap = Maps.newHashMapWithExpectedSize((int)jobfieldParamsMap.size());
            if (jobFieldHisRes != null && HRStringUtils.equals((String)String.valueOf(jobFieldHisRes.get("code")), (String)"200") && (data = (List)jobFieldHisRes.get("data")) != null) {
                HashMap resultMap = Maps.newHashMapWithExpectedSize((int)8);
                for (Map map : data) {
                    resultMap.put("id", Long.valueOf((String)map.get("id")));
                    resultMap.put("name", map.get("name"));
                    resultMap.put("number", map.get("number"));
                    fieldhisMap.put((Long)map.get("boid"), resultMap);
                }
            }
            result.put(jobField, fieldhisMap);
        }
        return result;
    }

    public Map<String, Object> queryPositionByOrgIds(List<Long> orgIdList) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            return PositionServiceImpl.buildSuccessResult(201, "orgid is empty", null);
        }
        if (!this.checkListType(orgIdList, Long.class)) {
            return PositionServiceImpl.buildSuccessResult(201, "wrong parameter type", null);
        }
        DynamicObject[] positonDyns = PositionQueryRepository.getInstance().queryPositionByOrgIds(orgIdList);
        return PositionServiceImpl.buildSuccessResult(200, "", PositionServiceImpl.buildMap(positonDyns, null, null, true));
    }

    public Map<String, Object> queryPositionHisByOrgIds(List<Long> orgIdList, Date date) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            return PositionServiceImpl.buildSuccessResult(201, "orgid is empty", null);
        }
        if (date == null) {
            return PositionServiceImpl.buildSuccessResult(201, "date is empty", null);
        }
        if (!this.checkListType(orgIdList, Long.class)) {
            return PositionServiceImpl.buildSuccessResult(201, "wrong parameter type", null);
        }
        DynamicObject[] positonDyns = PositionQueryRepository.getInstance().queryPositionHisByOrgIds(orgIdList, date);
        return PositionServiceImpl.buildSuccessResult(200, "", PositionServiceImpl.buildMap(positonDyns, null, null, true));
    }

    public Map<String, Object> queryPositionHisByNumber(List<String> numberList, Date date) {
        if (CollectionUtils.isEmpty(numberList)) {
            return PositionServiceImpl.buildSuccessResult(201, "numberList is empty", null);
        }
        if (numberList.size() > 5000) {
            return PositionServiceImpl.buildSuccessResult(201, "numberList more than 5000", null);
        }
        Date searchDate = HRDateTimeUtils.truncateDate((Date)(date == null ? new Date() : date));
        DynamicObject[] dyArray = PositionQueryRepository.getInstance().queryPositionHisByNumbers(numberList, searchDate);
        DynamicObject[] dyFirstBsedArray = PositionQueryRepository.getInstance().queryPositionFirstBsedHisByNumbers(numberList);
        Map<Object, Object> idToFirstBsedMap = new HashMap(16);
        if (dyFirstBsedArray != null) {
            idToFirstBsedMap = Arrays.asList(dyFirstBsedArray).stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getDate("firstbsed")));
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)dyArray.length);
        for (DynamicObject dy2 : dyArray) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)8);
            map.put("boid", dy2.getLong("boid"));
            map.put("id", dy2.getLong("id"));
            map.put("number", dy2.getString("number"));
            map.put("name", dy2.getString("name"));
            map.put("enable", dy2.getString("enable"));
            map.put("firstbsed", idToFirstBsedMap.get(dy2.getLong("boid")));
            list.add(map);
        }
        return PositionServiceImpl.buildSuccessResult(200, "", list);
    }

    public Map<String, Object> queryPositionHisVersion(List<Long> boIdList, Date startDate, Date endDate) {
        if (CollectionUtils.isEmpty(boIdList) || Objects.isNull(startDate) || Objects.isNull(endDate)) {
            String msg = String.format(Locale.ROOT, "queryPositionHisVersion() params must be not empty, startDate: %s, endDate: %s, boIdList: %s, ", boIdList, startDate, endDate);
            LOGGER.info(msg);
            return PositionServiceImpl.buildSuccessResult(201, msg, null);
        }
        if (boIdList.size() > 2000) {
            return PositionServiceImpl.buildSuccessResult(201, "the data count > 2000", null);
        }
        if (HRDateTimeUtils.truncateDate((Date)startDate).after(HRDateTimeUtils.truncateDate((Date)endDate))) {
            return PositionServiceImpl.buildSuccessResult(201, "startDate must bu less than endDate", null);
        }
        LOGGER.info(String.format(Locale.ROOT, "queryPositionHisVersion() params startDate: %s, endDate: %s, boIdList: %s, ", boIdList, startDate, endDate));
        Object[] positionHisVersion = PositionQueryRepository.getInstance().queryPositionHisVersion(boIdList, startDate, endDate);
        if (PositionUtils.isArrayEmpty((Object[])positionHisVersion).booleanValue()) {
            return PositionServiceImpl.buildSuccessResult(201, "query data is empty", null);
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)positionHisVersion.length);
        for (Object dy : positionHisVersion) {
            HashMap<String, Object> map2 = new HashMap<String, Object>(16);
            map2.put("boid", dy.getLong("boid"));
            map2.put("id", dy.getLong("id"));
            map2.put("number", dy.getString("number"));
            map2.put("name", dy.getString("name"));
            map2.put("enable", dy.getString("enable"));
            map2.put("bsed", dy.getDate("bsed"));
            map2.put("bsled", dy.getDate("bsled"));
            list.add(map2);
        }
        Map<Long, List<Map>> result = list.stream().collect(Collectors.groupingBy(map -> (Long)map.get("boid")));
        return PositionServiceImpl.buildSuccessResult(200, "", result);
    }

    private boolean checkListType(List list, Class T) {
        String listjson = JSONArray.toJSONString((Object)list);
        JSONArray jsonArray = JSONArray.parseArray((String)listjson);
        try {
            jsonArray.toJavaList(T);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Map<String, Object> queryPositionHisByVid(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return PositionServiceImpl.buildSuccessResult(201, "id is empty", null);
        }
        if (idList.size() > 500) {
            return PositionServiceImpl.buildSuccessResult(202, "id cannot exceed 500", null);
        }
        DynamicObject[] positonDyns = PositionQueryRepository.getInstance().queryPositionsById(idList);
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        this.putNotExistIds(data, positonDyns, idList);
        if (positonDyns == null || positonDyns.length == 0) {
            return PositionServiceImpl.buildSuccessResult(200, "", data);
        }
        List<DynamicObject> hisdata = this.getPositionHisProp(positonDyns);
        data.put("hisdata", hisdata);
        return PositionServiceImpl.buildSuccessResult(200, "", data);
    }

    public Map<String, Object> queryPositionHisVersionInfo(List<Long> positionBoIdList, Date date) {
        if (CollectionUtils.isEmpty(positionBoIdList)) {
            return PositionServiceImpl.buildSuccessResult(201, "idList is empty", null);
        }
        if (Objects.isNull(date)) {
            date = new Date();
        }
        date = HRDateTimeUtils.truncateDate((Date)date);
        DynamicObject[] positionHisDyns = PositionQueryRepository.getInstance().queryPositionHisInfos(positionBoIdList, date);
        Map<Long, DynamicObject> positionBoIdVsDynMap = Arrays.stream(positionHisDyns).collect(Collectors.toMap(dyn -> dyn.getLong("boid"), dyn -> dyn));
        ArrayList list = Lists.newArrayListWithExpectedSize((int)positionBoIdList.size());
        for (Long positionBoId : positionBoIdList) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)8);
            map.put("boId", positionBoId);
            DynamicObject positionHisDyn = positionBoIdVsDynMap.get(positionBoId);
            if (Objects.isNull(positionHisDyn)) {
                map.put("flag", false);
            } else {
                map.put("flag", true);
                map.put("id", positionHisDyn.getLong("id"));
                map.put("name", positionHisDyn.getString("name"));
                map.put("number", positionHisDyn.getString("number"));
                map.put("workRoleId", positionHisDyn.getLong("workrole.id"));
                DynamicObject parentDyn = positionHisDyn.getDynamicObject("parent");
                if (Objects.nonNull(parentDyn)) {
                    map.put("parent", parentDyn.getLong("id"));
                    map.put("parentWorkRoleId", parentDyn.getLong("workrole.id"));
                }
            }
            list.add(map);
        }
        return PositionServiceImpl.buildSuccessResult(200, "", list);
    }

    public Map<String, Object> queryChildPositionAndWorkRole(List<Long> positionBoIdList, Date date, Long reportRelationTypeId) {
        if (CollectionUtils.isEmpty(positionBoIdList)) {
            return PositionServiceImpl.buildSuccessResult(201, "idList is empty", null);
        }
        if (Objects.isNull(date)) {
            date = HRDateTimeUtils.truncateDate((Date)new Date());
        }
        if (reportRelationTypeId == null || reportRelationTypeId == 0L) {
            reportRelationTypeId = 1010L;
        }
        DynamicObject[] positionDyns = PositionQueryRepository.getInstance().queryPositionHisInfo(positionBoIdList, date);
        List workroleIds = Arrays.stream(positionDyns).map(position -> position.getLong("workrole")).collect(Collectors.toList());
        DynamicObject[] reportRelationDyns = ReportingrelationQueryRepository.getInstance().queryChildWorkRole(workroleIds, date, reportRelationTypeId);
        List childWorkRoleIds = Arrays.stream(reportRelationDyns).map(reportRelation -> reportRelation.getLong("role")).collect(Collectors.toList());
        Map workRoleBoIdToChildWorkRoleBoIdMap = Arrays.stream(reportRelationDyns).collect(Collectors.groupingBy(positionDyn -> positionDyn.getLong("parent"), Collectors.mapping(positionDyn -> positionDyn.getLong("role"), Collectors.toSet())));
        DynamicObject[] childPositionDyns = PositionQueryRepository.getInstance().queryPositionHisInfoByWorkRole(childWorkRoleIds, date);
        Map<Long, DynamicObject> childWorkRoleIdToPosition = Arrays.stream(childPositionDyns).collect(Collectors.toMap(childPosition -> childPosition.getLong("workrole"), childPosition -> childPosition));
        DynamicObject[] childWorkRoleDyns = WorkRoleQueryRepository.getInstance().queryWorkroleHis(childWorkRoleIds, date);
        Map<Long, Long> childWorkRoleBoIdToFIdMap = Arrays.stream(childWorkRoleDyns).collect(Collectors.toMap(positionDyn -> positionDyn.getLong("boid"), positionDyn -> positionDyn.getLong("id")));
        HashMap result = Maps.newHashMapWithExpectedSize((int)positionDyns.length);
        for (DynamicObject positionDyn2 : positionDyns) {
            Set childWorkRoleBoIds;
            ArrayList<HashMap> dataList = (ArrayList<HashMap>)result.get(positionDyn2.getLong("boid"));
            if (dataList == null) {
                dataList = new ArrayList<HashMap>(10);
            }
            if ((childWorkRoleBoIds = workRoleBoIdToChildWorkRoleBoIdMap.get(positionDyn2.getLong("workrole"))) != null) {
                for (Long childWorkRoleBoId : childWorkRoleBoIds) {
                    DynamicObject childPostion = childWorkRoleIdToPosition.get(childWorkRoleBoId);
                    HashMap data = Maps.newHashMapWithExpectedSize((int)8);
                    data.put("positonBoId", childPostion.getLong("boid"));
                    data.put("positonFId", childPostion.getLong("id"));
                    Long workroleBoId = childPostion.getLong("workrole");
                    data.put("workroleBoId", workroleBoId);
                    data.put("workroleFId", childWorkRoleBoIdToFIdMap.get(workroleBoId));
                    dataList.add(data);
                }
            }
            result.put(positionDyn2.getLong("boid"), dataList);
        }
        return PositionServiceImpl.buildSuccessResult(200, "", result);
    }

    private void putNotExistIds(Map<String, Object> data, DynamicObject[] positonDyns, List<Long> idList) {
        if (positonDyns == null || positonDyns.length == 0) {
            data.put("notexistIds", idList);
            data.put("hisdata", null);
            return;
        }
        List existIds = Arrays.stream(positonDyns).map(pos -> pos.getLong("id")).collect(Collectors.toList());
        ArrayList<Long> idListTemp = new ArrayList<Long>(idList);
        idListTemp.removeAll(existIds);
        data.put("notexistIds", idListTemp);
    }

    private List<DynamicObject> getPositionHisProp(DynamicObject[] positonDyns) {
        List posList = (List)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hbjm", (String)"IHBJMForPosHisService", (String)"setPositionJobHisInfo", (Object[])new Object[]{Arrays.asList(positonDyns)});
        this.handleOrgHis(posList);
        this.handleParentPositionHis(posList);
        return posList;
    }

    private void handleParentPositionHis(List<DynamicObject> posList) {
        ArrayList parentIds = Lists.newArrayListWithExpectedSize((int)posList.size());
        for (DynamicObject dyn2 : posList) {
            long parentId = dyn2.getLong("parent.id");
            if (parentId == 0L) continue;
            parentIds.add(parentId);
        }
        DynamicObject[] parenthis = PositionQueryRepository.getInstance().queryPositionHisId((List)parentIds);
        Map<Object, Object> boidToHisListMap = Maps.newHashMapWithExpectedSize((int)parenthis.length);
        if (parenthis.length > 0) {
            boidToHisListMap = Arrays.stream(parenthis).collect(Collectors.groupingBy(dyn -> dyn.getLong("boid")));
        }
        for (DynamicObject dyn3 : posList) {
            Date bsed = dyn3.getDate("bsed");
            this.handleHisCoverCurrent(boidToHisListMap, dyn3, "parent", bsed);
        }
    }

    private void handleOrgHis(List<DynamicObject> posList) {
        List orgIds = posList.stream().map(pos -> pos.getLong("adminorg.id")).collect(Collectors.toList());
        DynamicObject[] adminOrgHis = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"getAdminOrgHisByBoids", (Object[])new Object[]{orgIds});
        Map<Object, Object> boidToHisListMap = Maps.newHashMapWithExpectedSize((int)adminOrgHis.length);
        if (adminOrgHis.length > 0) {
            boidToHisListMap = Arrays.stream(adminOrgHis).collect(Collectors.groupingBy(dyn -> dyn.getLong("boid")));
        }
        for (DynamicObject dyn2 : posList) {
            Date bsed = dyn2.getDate("bsed");
            this.handleHisCoverCurrent(boidToHisListMap, dyn2, "adminorg", bsed);
        }
    }

    private void handleHisCoverCurrent(Map<Long, List<DynamicObject>> basedataBoIdDynMap, DynamicObject dyn, String basedataName, Date bsed) {
        DynamicObject currentData = dyn.getDynamicObject(basedataName);
        dyn.set(basedataName, null);
        if (bsed == null) {
            return;
        }
        if (currentData == null) {
            return;
        }
        long currentDataId = currentData.getLong("id");
        List<DynamicObject> hisDataList = basedataBoIdDynMap.get(currentDataId);
        if (hisDataList == null) {
            return;
        }
        for (DynamicObject hisData : hisDataList) {
            Date hisBsed = hisData.getDate("bsed");
            Date hisBsled = hisData.getDate("bsled");
            if (hisBsed == null || hisBsled == null || !bsed.after(hisBsed) || !bsed.before(hisBsled)) continue;
            dyn.set(basedataName, (Object)hisData);
            break;
        }
    }

    public Map<String, Object> queryJobLevelGradeRangeAndScmByPositionVersion(List<Long> boidList, Date bsed) {
        return this.queryJobLevelGradeRangeAndScm("hbpm_positionhr", boidList, bsed);
    }

    public Map<String, Object> queryJobLevelGradeRangeAndScm(String entityName, List<Long> boidList, Date bsed) {
        LOGGER.info("start queryJobLevelGradeRangeAndScmByPositionVersion:{}, {}, {}", new Object[]{boidList, bsed, entityName});
        if (CollectionUtils.isEmpty(boidList)) {
            return PositionServiceImpl.buildSuccessResult(201, ResManager.loadKDString((String)"id\u4e0d\u80fd\u4e3a\u7a7a", (String)"PositionServiceImpl_0", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), null);
        }
        HashMap data = new HashMap();
        List<DynamicObject> effetivePositionList = this.getEffectVersionByPositionBoidAndBsed(entityName, boidList, bsed);
        Set haveVersionBoidList = effetivePositionList.stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toSet());
        for (Long boid : boidList) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (haveVersionBoidList.contains(boid)) continue;
            map.put("info", ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5f53\u5929\u6ca1\u6709\u7248\u672c\u4fe1\u606f\u3002", (String)"PositionServiceImpl_1", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
            data.put(boid, map);
        }
        List<Map<String, Long>> rangs = this.assembleInvokeJobParams(effetivePositionList);
        LOGGER.info("invoke getJobGradeAndLevelRange params:{}", rangs);
        if (rangs.size() > 0) {
            Map jobresult = (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMJobLevelGradeService", (String)"getJobGradeAndLevelRange", (Object[])new Object[]{rangs});
            LOGGER.info("invoke getJobGradeAndLevelRange result:{}", (Object)jobresult);
            String msg = ResManager.loadKDString((String)"\u8c03\u7528\u804c\u4f4d\u63a5\u53e3\u83b7\u53d6\u804c\u7ea7/\u804c\u7b49\u4fe1\u606f\u5931\u8d25\u3002", (String)"PositionServiceImpl_2", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]);
            if (jobresult == null || (Integer)jobresult.get("code") != 200) {
                return PositionServiceImpl.buildSuccessResult(201, msg, null);
            }
            if (jobresult.get("data") == null) {
                return PositionServiceImpl.buildSuccessResult(201, msg, null);
            }
            List jobDataList = (List)jobresult.get("data");
            for (Map jobData : jobDataList) {
                HashMap map = new HashMap();
                map.put("jobLevelData", jobData.get("jobLevelRang"));
                map.put("jobGradeData", jobData.get("jobGradeRang"));
                data.put((Long)jobData.get("businessID"), map);
            }
        }
        LOGGER.info("result queryJobLevelGradeRangeAndScmByPositionVersion:{}", data);
        LOGGER.info("end queryJobLevelGradeRangeAndScmByPositionVersion:{}", boidList);
        return PositionServiceImpl.buildSuccessResult(200, "", data);
    }

    private List<DynamicObject> getEffectVersionByPositionBoidAndBsed(String entityName, List<Long> positionBoidList, Date bsed) {
        if (bsed == null || HRDateTimeUtils.dayAfter((Date)HRDateTimeUtils.truncateDate((Date)bsed), (Date)HRDateTimeUtils.getNowDate())) {
            bsed = HRDateTimeUtils.getNowDate();
        }
        ArrayList<DynamicObject> effetivePositionList = new ArrayList<DynamicObject>();
        ArrayList<Long> toQueryEffectVersionBoIdList = new ArrayList<Long>();
        DynamicObject[] positions = HRStringUtils.equals((String)entityName, (String)"hbpm_positionhr") ? PositionQueryRepository.getInstance().queryHisVersionJobLevelAndJobGrade(positionBoidList, bsed) : StandardPositionRepository.getInstance().queryHisVersionJobLevelAndJobGrade(positionBoidList, bsed);
        for (DynamicObject position : positions) {
            if (HRStringUtils.equals((String)"0", (String)position.getString("datastatus"))) {
                toQueryEffectVersionBoIdList.add(position.getLong("boid"));
                continue;
            }
            effetivePositionList.add(position);
        }
        if (HRStringUtils.equals((String)entityName, (String)"hbpm_positionhr")) {
            DynamicObject[] reQueryPositions = PositionQueryRepository.getInstance().queryCurrentVersionJobLevelAndJobGrade(toQueryEffectVersionBoIdList);
            effetivePositionList.addAll(Arrays.asList(reQueryPositions));
        }
        return effetivePositionList;
    }

    private List<Map<String, Long>> assembleInvokeJobParams(List<DynamicObject> positionList) {
        ArrayList rangs = Lists.newArrayListWithExpectedSize((int)positionList.size());
        for (DynamicObject position : positionList) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("businessID", position.getLong("boid"));
            map.put("lowjoblevel", position.getLong("lowjoblevel.id"));
            map.put("highjoblevel", position.getLong("highjoblevel.id"));
            map.put("lowjobgrade", position.getLong("lowjobgrade.id"));
            map.put("highjobgrade", position.getLong("highjobgrade.id"));
            rangs.add(map);
        }
        return rangs;
    }

    public Map<String, Object> queryAllChildPositionHis(List<Long> positionIdList, Date date, boolean containsDarkpos) {
        String errMsg;
        Date now = HRDateTimeUtils.getNowDate();
        if (date == null) {
            date = now;
        }
        if (HRStringUtils.isNotEmpty((String)(errMsg = this.checkParams(positionIdList, date = HRDateTimeUtils.truncateDate((Date)date))))) {
            return PositionServiceImpl.buildSuccessResult(201, errMsg, null);
        }
        DynamicObject[] positions = PositionQueryRepository.getInstance().queryPositionFileds("id, boid, workrole.id", positionIdList);
        Map relationMap = ReportingrelationQueryRepository.getInstance().queryPosHisEnableAdminRelByTimeRange(date, date, Collections.singletonList("1010"));
        HashMap posToChildRoleListMap = new HashMap(positions.length);
        ArrayList allChildRoleList = new ArrayList(relationMap.size());
        for (DynamicObject pos : positions) {
            long boid = pos.getLong("boid");
            long parent = pos.getLong("workrole.id");
            ArrayList childRoleIdList = new ArrayList();
            relationMap.forEach((role, relationList) -> {
                ReportHisLoopCheckEntity entity = (ReportHisLoopCheckEntity)relationList.get(0);
                HashSet<Long> checkedSet = new HashSet<Long>();
                if (this.findChild(entity, parent, entity.getParent(), relationMap, checkedSet)) {
                    childRoleIdList.add(role);
                }
            });
            posToChildRoleListMap.put(boid, childRoleIdList);
            allChildRoleList.addAll(childRoleIdList);
        }
        DynamicObject[] childPosArr = PositionQueryRepository.getInstance().queryPositionByWorkRole(allChildRoleList, containsDarkpos);
        Map<Long, DynamicObject> roleToPosMap = Arrays.stream(childPosArr).collect(Collectors.toMap(dyn -> dyn.getLong("workrole"), dyn -> dyn));
        HashMap data = new HashMap();
        for (long posId : positionIdList) {
            List childRoleList = (List)posToChildRoleListMap.get(posId);
            ArrayList childDataList = new ArrayList();
            if (childRoleList == null) {
                data.put(posId, childDataList);
                continue;
            }
            for (Long roleId : childRoleList) {
                DynamicObject childPosDyn = roleToPosMap.get(roleId);
                if (childPosDyn == null) continue;
                HashMap<String, Object> childPosData = new HashMap<String, Object>(16);
                childPosData.put("boid", childPosDyn.getLong("boid"));
                childPosData.put("parent", childPosDyn.getLong("parent"));
                childPosData.put("workrole", childPosDyn.getLong("workrole"));
                childPosData.put("number", childPosDyn.getString("number"));
                childPosData.put("name", childPosDyn.getString("name"));
                childDataList.add(childPosData);
            }
            data.put(posId, childDataList);
        }
        return PositionServiceImpl.buildSuccessResult(200, "", data);
    }

    private boolean isSameType(ReportHisLoopCheckEntity original, ReportHisLoopCheckEntity entity) {
        return HRStringUtils.equals((String)original.getReportingtype(), (String)entity.getReportingtype());
    }

    private boolean isSameTime(ReportHisLoopCheckEntity original, ReportHisLoopCheckEntity entity) {
        boolean bsledLargeThanOriginalBsed = !HRDateTimeUtils.dayAfter((Date)HRDateTimeUtils.truncateDate((Date)original.getBsed()), (Date)HRDateTimeUtils.truncateDate((Date)entity.getBsled()));
        boolean bsedLessThanOriginalBlsed = !HRDateTimeUtils.dayAfter((Date)HRDateTimeUtils.truncateDate((Date)entity.getBsed()), (Date)HRDateTimeUtils.truncateDate((Date)original.getBsled()));
        return bsledLargeThanOriginalBsed && bsedLessThanOriginalBlsed;
    }

    private boolean findChild(ReportHisLoopCheckEntity original, long parent, long temp, Map<Long, List<ReportHisLoopCheckEntity>> roleToReportListMap, Set<Long> checkedSet) {
        if (temp == 0L) {
            return Boolean.FALSE;
        }
        if (temp == parent) {
            return Boolean.TRUE;
        }
        while (Objects.nonNull(roleToReportListMap.get(temp))) {
            boolean ischanged = false;
            List<ReportHisLoopCheckEntity> reports = roleToReportListMap.get(temp);
            for (ReportHisLoopCheckEntity entity : reports) {
                if (!this.isSameType(original, entity) || !this.isSameTime(original, entity)) continue;
                if (entity.getParent() == parent) {
                    return Boolean.TRUE;
                }
                if (entity.getParent() == original.getRole()) {
                    return Boolean.FALSE;
                }
                if (!checkedSet.add(temp)) {
                    return Boolean.FALSE;
                }
                temp = entity.getParent();
                ischanged = Boolean.TRUE;
                if (!this.findChild(original, parent, temp, roleToReportListMap, checkedSet)) continue;
                return Boolean.TRUE;
            }
            if (ischanged) continue;
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Map<String, Object> queryPositionById(List<Long> positionIdList) {
        if (CollectionUtils.isEmpty(positionIdList)) {
            return PositionServiceImpl.buildSuccessResult(201, "positionids is empty", null);
        }
        DynamicObject[] positonDyns = PositionQueryRepository.getInstance().queryPositionInfoById(positionIdList);
        List<Map<String, Object>> maps = PositionServiceImpl.buildMap(positonDyns, null, null, true);
        return PositionServiceImpl.buildSuccessResult(200, "", maps);
    }
}

