/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbpm.mservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbpm.mservice.api.IProjectRoleService;
import kd.hrmp.hbpm.business.application.impl.projectrole.ProjectRoleApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.ReportingRelationServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.projectrole.IProjectRoleApplication;
import kd.hrmp.hbpm.business.domain.repository.position.CommonQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ProjectRoleQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ReportingrelationQueryRepository;
import kd.hrmp.hbpm.business.service.projectrole.ProjRoleChangeEvent;
import kd.hrmp.hbpm.business.utils.DynamicObjectLogHelper;
import kd.hrmp.hbpm.business.utils.LogHelper;
import kd.hrmp.hbpm.business.utils.PRJRoleUtils;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;

public class ProjectRoleServiceImpl
implements IProjectRoleService,
HisFieldNameConstants,
ProjectRoleConstants {
    private static final Log logger = LogFactory.getLog(ProjectRoleServiceImpl.class);
    IProjectRoleApplication projectRoleApplication = ProjectRoleApplicationImpl.getInstance();
    HRBaseServiceHelper projectRoleHelper = new HRBaseServiceHelper("hbpm_projectroles");
    private static final Log LOG = LogFactory.getLog(ProjectRoleServiceImpl.class);
    final String CHECK_TIME = "checkTime";
    final String PROJECT_ROLE_ID = "projectRoleId";

    public Map<String, Object> queryProjectRoleByProjectTeam(List<Long> projectTeamIdList, Date effDt) {
        ApiResult apiResult;
        LOG.info(String.format("queryProjectRoleByProjectTeam request param. projectTeamIdList : %s, effDt : %s", projectTeamIdList, effDt));
        DynamicObject[] dynamicObjects = new DynamicObject[]{};
        try {
            if (CollectionUtils.isEmpty(projectTeamIdList) || effDt == null) {
                ApiResult apiResult2 = ApiResult.fail((String)"null or empty param not allowed", (String)"201");
                return ApiResult.toMap((ApiResult)apiResult2);
            }
            dynamicObjects = ProjectRoleQueryRepository.getInstance().queryByProjectTeamByRPC(projectTeamIdList);
            apiResult = ApiResult.success((Object)dynamicObjects);
            apiResult.setData((Object)dynamicObjects);
            LOG.info("queryProjectRoleByProjectTeam success");
        }
        catch (Exception e) {
            apiResult = ApiResult.fail((String)"server error", (String)"500");
            LOG.error(String.format("queryProjectRoleByProjectTeam error: %s", e));
        }
        LOG.info(String.format("queryProjectRoleByProjectTeam response param. success : %s, project role id (not boid): %s", apiResult.getSuccess(), Arrays.stream(dynamicObjects).map(dy -> dy.getLong("id")).collect(Collectors.toList())));
        return ApiResult.toMap((ApiResult)apiResult);
    }

    public Map<String, Object> addProjectRole(List<DynamicObject> projectRoleList) {
        ApiResult apiResult;
        this.logProjectRole(projectRoleList, "addProjectRole");
        try {
            if (CollectionUtils.isEmpty(projectRoleList)) {
                ApiResult apiResult2 = ApiResult.fail((String)"null or empty param not allowed", (String)"201");
                return ApiResult.toMap((ApiResult)apiResult2);
            }
            String name = projectRoleList.get(0).getDataEntityType().getName();
            if (!"hbpm_projectroles".equals(name)) {
                ApiResult apiResult3 = ApiResult.fail((String)"metadata type incorrect", (String)"202");
                return ApiResult.toMap((ApiResult)apiResult3);
            }
            HisResponse hisResponse = this.projectRoleApplication.saveProjectRoles(projectRoleList);
            ProjRoleChangeEvent.getInstance().handleProRoleEventByHisResponse(hisResponse, PR_CHANGE_SCENE_ADD, PR_CHANGE_TYPE_ADD, CHANGE_OPERATE_NEW, 0L);
            apiResult = ApiResult.success((Object)"success");
            LOG.info("addProjectRole success");
        }
        catch (Exception e) {
            apiResult = ApiResult.fail((String)"server error", (String)"500");
            LOG.error(String.format("addProjectRole error: %s", e));
        }
        return ApiResult.toMap((ApiResult)apiResult);
    }

    public Map<String, Object> changeProjectRoleStatus(String opType, List<Long> projectRoleIdList, Date effDt) {
        ApiResult apiResult;
        LOG.info(String.format("changeProjectRoleStatus request param. opType: %s, projectRoleIdList: %s, effDt: %s", opType, projectRoleIdList, effDt));
        try {
            if (CollectionUtils.isEmpty(projectRoleIdList)) {
                ApiResult apiResult2 = ApiResult.fail((String)"null or empty param not allowed", (String)"201");
                return ApiResult.toMap((ApiResult)apiResult2);
            }
            if (!"0".equals(opType)) {
                ApiResult apiResult3 = ApiResult.fail((String)"unsupported operation type", (String)"202");
                return ApiResult.toMap((ApiResult)apiResult3);
            }
            List<DynamicObject> projectRoleList = this.getProjectRole4Disable(projectRoleIdList, effDt);
            WorkRoleNewHisUtils.setNewId(projectRoleList);
            HisResponse hisResponse = this.projectRoleApplication.disableProjectRoles(projectRoleList);
            ProjRoleChangeEvent.handleChangeEvent((HisResponse)hisResponse, (long)CHANGE_TYPE_DISABLE, (long)CHANGE_OPERATE_DISABLE, (Long)PR_CHANGE_SCENE_DISABLE, (Long)0L);
            OperationResult operationResult = new OperationResult();
            if (operationResult.isSuccess()) {
                apiResult = ApiResult.success((Object)"success");
                LOG.info("changeProjectRoleStatus success");
            } else {
                apiResult = ApiResult.fail((String)"fail", (String)"210");
                LOG.error(String.format("changeProjectRoleStatus operation fail: %s", operationResult));
            }
        }
        catch (Exception e) {
            apiResult = ApiResult.fail((String)"server error", (String)"500");
            LOG.error(String.format("changeProjectRoleStatus error: %s", e));
        }
        return ApiResult.toMap((ApiResult)apiResult);
    }

    public Map<String, Object> changeProjectRoleOrg(List<DynamicObject> projectTeamList) {
        ApiResult apiResult;
        Throwable throwable;
        TXHandle txHandle;
        block17: {
            Map map;
            block18: {
                block19: {
                    txHandle = TX.requiresNew();
                    throwable = null;
                    if (!CollectionUtils.isEmpty(projectTeamList)) break block17;
                    LogHelper.infoIfEnable((Log)LOG, () -> "changeProjectRoleByProjectTeam success with empty params");
                    map = ApiResult.toMap((ApiResult)ApiResult.success(null));
                    if (txHandle == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                txHandle.close();
            }
            return map;
        }
        try {
            try {
                HisResponse response = this.projectRoleApplication.changeProjectRoleByProjectTeam(projectTeamList);
                apiResult = !"200".equals(response.getCode()) ? ApiResult.fail((String)"his save fail") : ApiResult.success(null);
                boolean sucess = apiResult.getSuccess();
                LogHelper.infoIfEnable((Log)LOG, () -> String.format("changeProjectRoleByProjectTeam success: %s", sucess));
            }
            catch (Exception e) {
                txHandle.markRollback();
                apiResult = ApiResult.fail((String)"server error");
                LOG.error(String.format("changeProjectRoleStatus error: %s", e));
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (txHandle != null) {
                if (throwable != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
        return ApiResult.toMap((ApiResult)apiResult);
    }

    private List<DynamicObject> getProjectRole4Disable(List<Long> projectRoleIdList, Date effDt) {
        DynamicObject[] ProjectRoles = CommonQueryRepository.getInstance().loadDyById("hbpm_projectroles", new HashSet<Long>(projectRoleIdList));
        List projectRoleList = WorkRoleNewHisUtils.getDy4ChgProp(Arrays.asList(ProjectRoles));
        for (DynamicObject projectRole : projectRoleList) {
            projectRole.set("bsed", (Object)effDt);
            projectRole.set("enable", (Object)"0");
        }
        return projectRoleList;
    }

    private void logProjectRole(List<DynamicObject> projectRoleList, String keyString) {
        if (CollectionUtils.isEmpty(projectRoleList)) {
            LOG.info(String.format("%s request param. projectRoleList : %s", keyString, projectRoleList));
        } else {
            List result = DynamicObjectLogHelper.convertDynamicObject2Map(projectRoleList, (String[])new String[]{"id", "number", "isdutypers", "superroles", "projteam", "bsed", "bsled"});
            LOG.info(String.format("%s request param. projectRoleList : %s", keyString, result));
        }
    }

    public List<Map<String, Object>> getInfoByIdAndTime(List<Map<String, Object>> list) {
        Set ids = list.stream().map(s -> s.get("projectRoleId")).collect(Collectors.toSet());
        QFilter idFilter = new QFilter("boid", "in", ids);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_projectroles");
        String select = String.join((CharSequence)",", "boid", "bsed", "bsled", "enable");
        QFilter notCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"0");
        DynamicObject[] projects = helper.queryOriginalArray(select, new QFilter[]{idFilter, notCurrentVersion, Q_FILTER_HIS_DATA_STATUS});
        ArrayList<Map<String, Object>> projectRetList = new ArrayList<Map<String, Object>>();
        list.forEach(s -> {
            Date checkTime = (Date)s.get("checkTime");
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            DynamicObject object = null;
            for (DynamicObject f : projects) {
                if (!s.get("projectRoleId").equals(f.getLong("boid")) || checkTime.before(f.getDate("bsed")) || f.getDate("bsled").before(checkTime)) continue;
                object = f;
                break;
            }
            if (object != null) {
                map.put("projectRoleId", object.getLong("boid"));
                map.put("projectRoleEnableStatus", object.getString("enable"));
                map.put("startDate", object.getDate("bsed"));
                map.put("endDate", object.getDate("bsled"));
                map.put("checkTime", s.get("checkTime"));
                map.put("msgCode", 200);
                map.put("msgInfo", "success");
                projectRetList.add(map);
            }
        });
        return projectRetList;
    }

    public List<Map<String, String>> getCountByProjectId(List<Long> projectGroupIds, Date queryDate) {
        QFilter qFilterIsNotCurrentVersion = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter idFilter = new QFilter("projteam.id", "in", projectGroupIds);
        QFilter effDateFilter = new QFilter("bsed", "<=", (Object)queryDate).and(new QFilter("bsled", ">=", (Object)queryDate));
        String select = String.join((CharSequence)",", "projteam.id", "isdutypers", "name");
        DynamicObject[] projectRoles = this.projectRoleHelper.queryOriginalArray(select, new QFilter[]{idFilter, qFilterIsNotCurrentVersion, effDateFilter, Q_FILTER_HIS_DATA_STATUS, Q_FILTER_ENABLE});
        Map<Long, Long> projIdCountMap = Arrays.stream(projectRoles).collect(Collectors.groupingBy(s -> s.getLong("projteam.id"), Collectors.counting()));
        Map<Long, String> projIdNameMap = Arrays.stream(projectRoles).filter(s -> s.getBoolean("isdutypers")).collect(Collectors.groupingBy(s -> s.getLong("projteam.id"), Collectors.mapping(m -> m.getString("name"), Collectors.joining(","))));
        ArrayList<Map<String, String>> retList = new ArrayList<Map<String, String>>();
        projIdCountMap.keySet().forEach(s -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("projectGroupId", s.toString());
            map.put("roleCount", ((Long)projIdCountMap.get(s)).toString());
            map.put("mainHeadRole", (String)projIdNameMap.get(s));
            retList.add(map);
        });
        return retList;
    }

    public Boolean changeParentRole(List<Map<String, Long>> list) {
        ArrayList hisRetDataList = new ArrayList(16);
        try (TXHandle txHandle = TX.requiresNew();){
            Map<String, Long> roleMap = list.get(0);
            Long projectId = roleMap.get("projectId");
            Long newParentId = roleMap.get("newParentId");
            Date now = new Date();
            HRBaseServiceHelper workRoleHelper = new HRBaseServiceHelper("hbpm_workroleshr");
            QFilter prjFilter = new QFilter("adminorg", "=", (Object)newParentId);
            QFilter dutyFilter = new QFilter("mainpeoincharge", "=", (Object)"1");
            DynamicObject[] projectRole = workRoleHelper.queryOriginalArray("id", new QFilter[]{prjFilter, dutyFilter, FILTER_IS_CURRENT_VERSION, Q_FILTER_ENABLE});
            if (projectRole.length != 1) {
                Boolean bl = false;
                return bl;
            }
            ArrayList newDyList = Lists.newArrayListWithExpectedSize((int)list.size());
            HRBaseServiceHelper projectRoleHelper = new HRBaseServiceHelper("hbpm_projectroles");
            QFilter idFilter = new QFilter("projteam", "=", (Object)projectId).and(FILTER_IS_CURRENT_VERSION);
            idFilter.and(new QFilter("isdutypers", "=", (Object)true));
            DynamicObject dbObject = projectRoleHelper.loadDynamicObject(idFilter);
            if (dbObject == null) {
                Boolean bl = false;
                return bl;
            }
            try {
                DynamicObject newDy = projectRoleHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)dbObject, (DynamicObject)newDy);
                newDy.set("superroles", (Object)projectRole[0].getLong("id"));
                newDy.set("superroles_id", (Object)projectRole[0].getLong("id"));
                newDy.set("id", (Object)ORM.create().genLongId("hbpm_projectroles"));
                newDy.set("bsed", (Object)now);
                newDy.set("createtime", (Object)now);
                newDyList.add(newDy);
                HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
                hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
                hisVersionParamBo.setEntityNumber("hbpm_projectroles");
                hisVersionParamBo.setAtomicTrans(false);
                hisVersionParamBo.setHisDyns(newDyList.toArray(new DynamicObject[0]));
                HisResponse hisResponse = HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
                List<Long> boIds = Collections.singletonList(newDy.getLong("boid"));
                DynamicObject[] administrativeRelations = ReportingrelationQueryRepository.getInstance().queryAdministrativeRelationByDutyRoleIds(boIds);
                DynamicObject adRelation = administrativeRelations[0];
                adRelation.set("parent", (Object)newDy.getLong("superroles"));
                adRelation.set("parent_id", (Object)newDy.getLong("superroles"));
                ReportingRelationServiceApplicationImpl reportingRelationServiceApplication = new ReportingRelationServiceApplicationImpl();
                reportingRelationServiceApplication.changeReportRelationsProp("2", Collections.singletonList(adRelation));
                DynamicObject[] newDynamicObjects = ((VersionChangeRespData)hisResponse.getData()).getNewDynamicObjects();
                Arrays.stream(newDynamicObjects).filter(dyn -> !dyn.getBoolean("iscurrentversion")).forEach(s -> {
                    s.set("changetype", (Object)1020L);
                    hisRetDataList.add(s);
                });
                ProjRoleChangeEvent.handleChangeEvent((HisResponse)hisResponse, (long)CHANGE_TYPE_INFO, (long)CHANGE_OPERATE_INFO, (Long)PR_CHANGE_SCENE_UPDATE, (Long)0L);
            }
            catch (Exception e) {
                txHandle.markRollback();
                LOG.error(String.format("changeParentRole error: %s", e));
                Boolean bl = false;
                return bl;
            }
        }
        ArrayList msgMapList = new ArrayList(16);
        PRJRoleUtils.assemblyProRoleMsgParams(hisRetDataList, msgMapList);
        PRJRoleUtils.proRoleUpSendMsg(msgMapList, null);
        return true;
    }

    public HrApiResponse<Object> getProRoleVersionInfo(Long curProRoleId, Long oldMainDutyVid) {
        logger.info("ProjectRoleServiceImpl.getProRoleVersionInfo curProRoleId={},oldMainDutyVid={}", (Object)curProRoleId, (Object)oldMainDutyVid);
        Map dataMap = null;
        try {
            dataMap = ProjectRoleApplicationImpl.getInstance().getProRoleVersionInfoByVid(curProRoleId, oldMainDutyVid);
        }
        catch (KDBizException e) {
            logger.error("ProjectRoleServiceImpl.getProRoleVersionInfo is exception", (Throwable)e);
            return HrApiResponse.fail((String)"500", (String)e.getMessage());
        }
        return HrApiResponse.success((Object)dataMap);
    }
}

