/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbpm.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedata.service.BaseDataServiceImpl;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbpm.mservice.PositionServiceImpl;
import kd.hr.hbpm.mservice.api.IStandardPositionQueryService;
import kd.hrmp.hbpm.business.application.impl.position.StandardPositionApplicationImpl;
import kd.hrmp.hbpm.business.domain.mservice.HaosMServiceHelper;
import kd.hrmp.hbpm.business.domain.repository.position.MserviceQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.StandardPositionRepository;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.common.model.stdpos.QueryHisByOrgParam;
import kd.hrmp.hbpm.common.model.stdpos.QueryHisByOrgResult;
import kd.hrmp.hbpm.common.model.stdpos.StdPosAndOrg;
import kd.hrmp.hbpm.common.model.stdpos.ValidStdPosAndOrgAndDateParam;
import kd.hrmp.hbpm.common.model.stdpos.ValidStdPosAndOrgAndDateResult;

public class StandardPositionQueryServiceImpl
implements IStandardPositionQueryService {
    private static Log LOGGER = LogFactory.getLog(StandardPositionQueryServiceImpl.class);

    public Map<String, Object> queryStandardPosition(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Input parameter information is empty.", null);
        }
        Object[] dynamicObjects = StandardPositionRepository.getInstance().querySPHis(ids);
        if (PositionUtils.isArrayEmpty((Object[])dynamicObjects).booleanValue()) {
            return PositionUtils.buildSuccessResult((int)201, (String)"No data found.", null);
        }
        ArrayList results = new ArrayList(dynamicObjects.length);
        Arrays.stream(dynamicObjects).forEach(dy -> {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("id", dy.getLong("id"));
            map.put("boid", dy.getLong("boid"));
            map.put("number", dy.getString("number"));
            map.put("name", dy.getString("name"));
            map.put("positiontype.name", dy.getString("positiontype.name"));
            map.put("positiontype.number", dy.getString("positiontype.number"));
            map.put("job", dy.getLong("job.id"));
            map.put("job.name", dy.getString("job.name"));
            map.put("highjoblevel.id", dy.getLong("highjoblevel.id"));
            map.put("lowjoblevel.id", dy.getLong("lowjoblevel.id"));
            map.put("highjobgrade.id", dy.getLong("highjobgrade.id"));
            map.put("lowjobgrade.id", dy.getLong("lowjobgrade.id"));
            if (!CollectionUtils.isEmpty((Collection)dy.getDynamicObjectCollection("entryentity"))) {
                Map<Long, Boolean> entryentitymap = dy.getDynamicObjectCollection("entryentity").stream().collect(Collectors.toMap(entry -> entry.getLong("adminorg.id"), entry -> entry.getBoolean("iscontainsu"), (v1, v2) -> v2));
                map.put("entryentity", entryentitymap);
            }
            results.add(map);
        });
        return PositionUtils.buildSuccessResult((int)200, (String)"", results);
    }

    public Map<String, Object> queryStandardPositionDynamicObject(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Input parameter information is empty.", null);
        }
        Object[] dynamicObjects = StandardPositionRepository.getInstance().querySPHis(ids);
        if (PositionUtils.isArrayEmpty((Object[])dynamicObjects).booleanValue()) {
            return PositionUtils.buildSuccessResult((int)201, (String)"No data found.", null);
        }
        return PositionUtils.buildSuccessResult((int)200, (String)"", (Object)dynamicObjects);
    }

    public Map<String, Object> queryStandardPositionChange(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Input parameter information is empty.", null);
        }
        Object[] dynamicObjects = StandardPositionRepository.getInstance().querySPHis(ids);
        if (PositionUtils.isArrayEmpty((Object[])dynamicObjects).booleanValue()) {
            return PositionUtils.buildSuccessResult((int)201, (String)"No data found.", null);
        }
        List boids = Arrays.stream(dynamicObjects).map(data -> data.getLong("boid")).collect(Collectors.toList());
        Object[] boDatas = StandardPositionRepository.getInstance().queryHisByBoids(boids);
        if (PositionUtils.isArrayEmpty((Object[])boDatas).booleanValue()) {
            return PositionUtils.buildSuccessResult((int)201, (String)"No data found.", null);
        }
        Map<Long, List<DynamicObject>> datamap = Arrays.stream(boDatas).collect(Collectors.groupingBy(data -> data.getLong("boid")));
        HashMap returndata = new HashMap(dynamicObjects.length);
        for (Object data2 : dynamicObjects) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            map.put("after", data2);
            Date bsed = data2.getDate("bsed");
            List<DynamicObject> bodatas = datamap.get(data2.getLong("boid"));
            if (!ObjectUtils.isEmpty(bodatas)) {
                for (DynamicObject bodata : bodatas) {
                    Date bsed_bo = bodata.getDate("bsed");
                    if (!bsed_bo.before(bsed) && (bsed_bo.after(bsed) || bodata.getLong("id") >= data2.getLong("id"))) continue;
                    map.put("before", bodata);
                    break;
                }
            }
            returndata.put(data2.getLong("id"), map);
        }
        return PositionUtils.buildSuccessResult((int)200, (String)"", returndata);
    }

    public Map<String, Object> queryStandardPosition(List<Long> ids, Date date) {
        if (CollectionUtils.isEmpty(ids)) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Input parameter information is empty.", null);
        }
        if (ids.size() > 500) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Query of more than 500 pieces of data is not supported.", null);
        }
        Object[] dynamicObjects = StandardPositionRepository.getInstance().querySPHis(ids, date);
        if (PositionUtils.isArrayEmpty((Object[])dynamicObjects).booleanValue()) {
            return PositionUtils.buildSuccessResult((int)201, (String)"No data found.", null);
        }
        List<Map<String, Object>> jobGradeAndLevelRange = this.getJobGradeAndLevelRange((DynamicObject[])dynamicObjects);
        HashMap jobGradeRange = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        HashMap jobLevelRange = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        if (!CollectionUtils.isEmpty(jobGradeAndLevelRange)) {
            this.handleJobGradeAndLevelRange(jobGradeAndLevelRange, jobGradeRange, jobLevelRange);
        }
        ArrayList results = new ArrayList(dynamicObjects.length);
        Arrays.stream(dynamicObjects).forEach(dy -> {
            HashMap<String, Object> map = new HashMap<String, Object>(32);
            map.put("id", dy.getLong("id"));
            map.put("boid", dy.getLong("boid"));
            map.put("number", dy.getString("number"));
            map.put("name", dy.getString("name"));
            map.put("orgdesignbu.id", dy.getLong("orgdesignbu.id"));
            map.put("orgdesignbu.name", dy.getString("orgdesignbu.name"));
            map.put("positiontype.id", dy.getLong("positiontype.id"));
            map.put("positiontype.name", dy.getString("positiontype.name"));
            map.put("positionclassify.id", dy.getLong("positionclassify.id"));
            map.put("positionclassify.name", dy.getString("positionclassify.name"));
            map.put("jobscm.id", dy.getLong("jobscm.id"));
            map.put("jobscm.name", dy.getString("jobscm.name"));
            map.put("job.id", dy.getLong("job.id"));
            map.put("job.name", dy.getString("job.name"));
            map.put("job.number", dy.getString("job.number"));
            map.put("description", dy.getString("description"));
            long highJobLevel = dy.getLong("highjoblevel.id");
            long lowJobLevel = dy.getLong("lowjoblevel.id");
            long highJobGrade = dy.getLong("highjobgrade.id");
            long lowJobGrade = dy.getLong("lowjobgrade.id");
            map.put("highjoblevel.id", highJobLevel);
            map.put("highjoblevel.name", dy.getString("highjoblevel.name"));
            map.put("lowjoblevel.id", lowJobLevel);
            map.put("lowjoblevel.name", dy.getString("lowjoblevel.name"));
            map.put("highjobgrade.id", highJobGrade);
            map.put("highjobgrade.name", dy.getString("highjobgrade.name"));
            map.put("lowjobgrade.id", lowJobGrade);
            map.put("lowjobgrade.name", dy.getString("lowjobgrade.name"));
            Map<String, Object> jobLevelMap = this.getJobGradeAndLevelMap(lowJobLevel, highJobLevel, jobLevelRange);
            this.fillResultMap(jobLevelMap, map, "joblevelscm.id", "joblevelrange");
            Map<String, Object> jobGradeMap = this.getJobGradeAndLevelMap(lowJobGrade, highJobGrade, jobGradeRange);
            this.fillResultMap(jobGradeMap, map, "jobgradescm.id", "jobgraderange");
            results.add(map);
        });
        return PositionUtils.buildSuccessResult((int)200, (String)"", results);
    }

    public Map<String, Object> queryStdPositionByNumber(List<String> numbers, Date date) {
        if (CollectionUtils.isEmpty(numbers)) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Input parameter information is empty.", null);
        }
        if (numbers.size() > 5000) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Query of more than 5000 pieces of data is not supported.", null);
        }
        Date searchDate = HRDateTimeUtils.truncateDate((Date)(date == null ? new Date() : date));
        Object[] dynamicObjects = StandardPositionRepository.getInstance().queryStdPositionByNumber(numbers, searchDate);
        DynamicObject[] dyFirstBsedArray = StandardPositionRepository.getInstance().queryStdPositionFirstBsedByNumbers(numbers);
        Map<Object, Object> idToFirstBsedMap = new HashMap(16);
        if (dyFirstBsedArray != null) {
            idToFirstBsedMap = Arrays.asList(dyFirstBsedArray).stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getDate("firstbsed")));
        }
        if (PositionUtils.isArrayEmpty((Object[])dynamicObjects).booleanValue()) {
            return PositionUtils.buildSuccessResult((int)201, (String)"No data found.", null);
        }
        ArrayList results = new ArrayList(dynamicObjects.length);
        for (Object dy2 : dynamicObjects) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("id", dy2.getLong("id"));
            map.put("boid", dy2.getLong("boid"));
            map.put("number", dy2.getString("number"));
            map.put("name", dy2.getString("name"));
            map.put("enable", dy2.getString("enable"));
            map.put("datastatus", dy2.getString("datastatus"));
            map.put("firstbsed", idToFirstBsedMap.get(dy2.getLong("boid")));
            results.add(map);
        }
        return PositionUtils.buildSuccessResult((int)200, (String)"", results);
    }

    public Map<String, Object> queryAllUnDarkStandardPositionByJobIds(List<Long> jobIds) {
        if (CollectionUtils.isEmpty(jobIds)) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Input parameter information is empty.", null);
        }
        Object[] dynamicObjects = StandardPositionRepository.getInstance().queryAllUnDarkStandardPositionByJobIds(jobIds);
        if (PositionUtils.isArrayEmpty((Object[])dynamicObjects).booleanValue()) {
            return PositionUtils.buildSuccessResult((int)201, (String)"No data found.", null);
        }
        ArrayList results = new ArrayList(dynamicObjects.length);
        Arrays.stream(dynamicObjects).forEach(dy -> {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("id", dy.getLong("id"));
            map.put("boid", dy.getLong("boid"));
            map.put("number", dy.getString("number"));
            map.put("name", dy.getString("name"));
            map.put("enable", dy.getString("enable"));
            map.put("datastatus", dy.getString("datastatus"));
            map.put("job.id", dy.getLong("job.id"));
            results.add(map);
        });
        return PositionUtils.buildSuccessResult((int)200, (String)"", results);
    }

    public Map<String, Object> queryStandardPositionHisByVid(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return PositionUtils.buildSuccessResult((int)201, (String)"id is empty", null);
        }
        if (idList.size() > 500) {
            return PositionUtils.buildSuccessResult((int)202, (String)"id cannot exceed 500", null);
        }
        DynamicObject[] positonDyns = StandardPositionRepository.getInstance().queryStdPositionById(idList);
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        this.putNotExistIds(data, positonDyns, idList);
        if (positonDyns == null || positonDyns.length == 0) {
            return PositionUtils.buildSuccessResult((int)200, (String)"", (Object)data);
        }
        List<DynamicObject> hisdata = this.getPositionHisProp(positonDyns);
        data.put("hisdata", hisdata);
        return PositionUtils.buildSuccessResult((int)200, (String)"", (Object)data);
    }

    public Map<String, Object> queryStandardPositionByOrg(List<Long> orgIdList) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Input parameter orgIdList is empty.", null);
        }
        if (orgIdList.size() > 5000) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Query of more than 5000 pieces of data is not supported.", null);
        }
        StandardPositionApplicationImpl standardPositionService = new StandardPositionApplicationImpl();
        List results = standardPositionService.queryStandardPositionByOrg(orgIdList);
        return PositionUtils.buildSuccessResult((int)200, (String)"", (Object)results);
    }

    public Map<String, Object> valideStandardPositionAndOrg(List<Map<String, Long>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Input parameter list is empty.", null);
        }
        if (list.size() > 5000) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Query of more than 5000 pieces of data is not supported.", null);
        }
        StandardPositionApplicationImpl standardPositionService = new StandardPositionApplicationImpl();
        List results = standardPositionService.valideStandardPositionAndOrg(list);
        return PositionUtils.buildSuccessResult((int)200, (String)"", (Object)results);
    }

    private void putNotExistIds(Map<String, Object> data, DynamicObject[] positonDyns, List<Long> idList) {
        if (positonDyns == null || positonDyns.length == 0) {
            data.put("notexistIds", idList);
            data.put("hisdata", null);
            return;
        }
        List existIds = Arrays.stream(positonDyns).map(pos -> pos.getLong("id")).collect(Collectors.toList());
        ArrayList<Long> idListTemp = new ArrayList<Long>(idList);
        idListTemp.removeAll(existIds);
        data.put("notexistIds", idListTemp);
    }

    private List<DynamicObject> getPositionHisProp(DynamicObject[] positonDyns) {
        List posList = (List)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hbjm", (String)"IHBJMForPosHisService", (String)"setPositionJobHisInfo", (Object[])new Object[]{Arrays.asList(positonDyns)});
        return posList;
    }

    private List<Map<String, Object>> getJobGradeAndLevelRange(DynamicObject[] dynamicObjects) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        if (PositionUtils.isArrayEmpty((Object[])dynamicObjects).booleanValue()) {
            return result;
        }
        ArrayList jobGradeAndLevelRangeBo = Lists.newArrayListWithCapacity((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap jobGradeAndLevelMap = Maps.newHashMapWithExpectedSize((int)8);
            jobGradeAndLevelMap.put("lowjobgrade", dynamicObject.getLong("lowjobgrade.id"));
            jobGradeAndLevelMap.put("highjobgrade", dynamicObject.getLong("highjobgrade.id"));
            jobGradeAndLevelMap.put("lowjoblevel", dynamicObject.getLong("lowjoblevel.id"));
            jobGradeAndLevelMap.put("highjoblevel", dynamicObject.getLong("highjoblevel.id"));
            jobGradeAndLevelRangeBo.add(jobGradeAndLevelMap);
        }
        Map jobGradeAndLevelRange = MserviceQueryRepository.getInstance().getJobGradeAndLevelRange((List)jobGradeAndLevelRangeBo);
        if (CollectionUtils.isEmpty((Map)jobGradeAndLevelRange)) {
            return result;
        }
        return (List)jobGradeAndLevelRange.get("data");
    }

    private void handleJobGradeAndLevelRange(List<Map<String, Object>> jobGradeAndLevelRange, Map<String, Map<String, Object>> jobGradeRange, Map<String, Map<String, Object>> jobLevelRange) {
        if (!CollectionUtils.isEmpty(jobGradeAndLevelRange)) {
            for (Map<String, Object> jobGradeAndLevelMap : jobGradeAndLevelRange) {
                if (!this.checkCommonEnable(jobGradeAndLevelMap)) continue;
                Long lowJobGrade = (Long)jobGradeAndLevelMap.get("lowjobgrade");
                Long highJobGrade = (Long)jobGradeAndLevelMap.get("highjobgrade");
                Long lowJobLevel = (Long)jobGradeAndLevelMap.get("lowjoblevel");
                Long highJobLevel = (Long)jobGradeAndLevelMap.get("highjoblevel");
                if (this.checkRangeIsEmpty(lowJobGrade, highJobGrade)) {
                    jobGradeRange.put(this.getKey(lowJobGrade, highJobGrade), jobGradeAndLevelMap.get("jobGradeRang") != null ? (Map)jobGradeAndLevelMap.get("jobGradeRang") : null);
                }
                if (!this.checkRangeIsEmpty(lowJobLevel, highJobLevel)) continue;
                jobLevelRange.put(this.getKey(lowJobLevel, highJobLevel), jobGradeAndLevelMap.get("jobLevelRang") != null ? (Map)jobGradeAndLevelMap.get("jobLevelRang") : null);
            }
        }
    }

    private Map<String, Object> getJobGradeAndLevelMap(Long low, Long high, Map<String, Map<String, Object>> jobGradeAndLevenRange) {
        Map<Object, Object> jobGradeAndLevelMap = Maps.newHashMapWithExpectedSize((int)8);
        if (this.checkRangeIsEmpty(low, high)) {
            jobGradeAndLevelMap = jobGradeAndLevenRange.get(this.getKey(low, high));
        }
        return jobGradeAndLevelMap;
    }

    private boolean checkCommonEnable(Map<String, Object> jobGradeAndLevelMap) {
        return !CollectionUtils.isEmpty(jobGradeAndLevelMap);
    }

    private boolean checkRangeIsEmpty(Long low, Long high) {
        boolean result = false;
        if (low != null && low > 0L && high != null && high > 0L) {
            result = true;
        }
        return result;
    }

    private String getKey(Long low, Long high) {
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(low));
        stringBuilder.append("_");
        stringBuilder.append(String.valueOf(high));
        return stringBuilder.toString();
    }

    private void fillResultMap(Map<String, Object> jobLevelAndGradeMap, Map<String, Object> map, String fieldOne, String fieldTwo) {
        Long scmId = null;
        List rangeList = null;
        if (!CollectionUtils.isEmpty(jobLevelAndGradeMap)) {
            if (jobLevelAndGradeMap.get("id") != null) {
                scmId = (Long)jobLevelAndGradeMap.get("id");
            }
            if (jobLevelAndGradeMap.get("ranges") != null) {
                rangeList = (List)jobLevelAndGradeMap.get("ranges");
            }
        }
        map.put(fieldOne, scmId);
        map.put(fieldTwo, rangeList);
    }

    public Map<String, Object> queryJobLevelGradeRangeAndScmByStdPositionVersion(List<Long> boidList, Date bsed) {
        PositionServiceImpl positionService = new PositionServiceImpl();
        return positionService.queryJobLevelGradeRangeAndScm("hbpm_stposition", boidList, bsed);
    }

    public Map<String, Object> queryHisByOrg(Map<String, Object> inParam) {
        LOGGER.info("queryHisByOrg start with param:{}", inParam);
        try {
            this.checkAndSetDate(inParam);
            boolean isOrgNumber = this.checkOrg(inParam);
            Map<Object, Object> orgIdVsNumber = new HashMap();
            if (isOrgNumber) {
                List orgNumberList = ((Collection)inParam.get("orgNumbers")).stream().filter(Objects::nonNull).map(Object::toString).distinct().collect(Collectors.toList());
                Map maps = HaosMServiceHelper.haosBatchGetSupOrgTeamInfo(orgNumberList, (Date)HRDateTimeUtils.getNowDate());
                if (maps != null) {
                    List collect = maps.entrySet().stream().filter(Objects::nonNull).filter(entry -> Objects.nonNull(entry.getKey())).filter(entry -> Objects.nonNull(entry.getValue())).map(map -> Long.parseLong(((Object)((Map)map.getValue()).getOrDefault("id", 0L)).toString())).collect(Collectors.toList());
                    inParam.put("orgIds", collect);
                    orgIdVsNumber = maps.entrySet().stream().filter(Objects::nonNull).filter(entry -> Objects.nonNull(entry.getKey())).filter(entry -> Objects.nonNull(entry.getValue())).collect(Collectors.toMap(entry -> ((Object)((Map)entry.getValue()).getOrDefault("id", 0L)).toString(), Map.Entry::getKey));
                }
                LOGGER.info("queryHisByOrg after reset param:{}", inParam);
            }
            QueryHisByOrgParam queryHisByOrgParam = new QueryHisByOrgParam();
            queryHisByOrgParam.setDate((Date)inParam.get("date"));
            Collection orgIds = (Collection)inParam.get("orgIds");
            Set orgIdList = orgIds.stream().map(id -> id == null ? 0L : Long.parseLong(id.toString())).collect(Collectors.toSet());
            queryHisByOrgParam.setOrgIds(orgIdList);
            StandardPositionApplicationImpl standardPositionApplication = new StandardPositionApplicationImpl();
            QueryHisByOrgResult queryHisByOrgResult = standardPositionApplication.queryHisByOrg(queryHisByOrgParam);
            Map orgIdVsStdPos = queryHisByOrgResult.getOrgIdVsStdPosList();
            Map<Object, Object> data = new HashMap();
            if (orgIdVsStdPos != null) {
                for (Map.Entry entry2 : orgIdVsStdPos.entrySet()) {
                    Long orgId = (Long)entry2.getKey();
                    List stdPosDyList = (List)entry2.getValue();
                    List stdPosMapList = stdPosDyList.stream().map(stdPosDy -> {
                        HashMap<String, String> stdPosMap = new HashMap<String, String>();
                        stdPosMap.put("id", stdPosDy.getString("id"));
                        stdPosMap.put("name", stdPosDy.getString("name"));
                        stdPosMap.put("number", stdPosDy.getString("number"));
                        stdPosMap.put("typeId", stdPosDy.getString("positiontype.id"));
                        stdPosMap.put("createorgId", stdPosDy.getString("createorg.id"));
                        return stdPosMap;
                    }).collect(Collectors.toList());
                    data.put(orgId.toString(), stdPosMapList);
                }
            }
            if (isOrgNumber) {
                HashMap finalOrgIdVsNumber = orgIdVsNumber;
                data = data.entrySet().stream().collect(Collectors.toMap(entry -> finalOrgIdVsNumber.getOrDefault(entry.getKey(), ""), Map.Entry::getValue, (val, val2) -> val));
            }
            LOGGER.info("queryHisByOrg end with param:{}", data);
            return PositionUtils.buildSuccessResult((int)200, (String)"", data);
        }
        catch (Exception ex) {
            LOGGER.error("queryHisByOrg end with param", (Throwable)ex);
            return PositionUtils.buildSuccessResult((int)500, (String)ex.getMessage(), null);
        }
    }

    private boolean checkOrg(Map<String, Object> inParam) {
        Object orgIds = inParam.get("orgIds");
        Object orgNumbers = inParam.get("orgNumbers");
        if (orgIds == null && orgNumbers == null) {
            LOGGER.error("queryChargeTag, orgIds and orgNumbers are null");
            throw new KDBizException("queryChargeTag, orgIds and orgNumbers are null");
        }
        return orgIds == null;
    }

    private void checkAndSetDate(Map<String, Object> inParam) {
        Object date = inParam.get("date");
        if (date instanceof String) {
            try {
                inParam.put("date", HRDateTimeUtils.parseDate((String)date.toString()));
            }
            catch (ParseException e) {
                LOGGER.error("queryChargeTag, parse date error", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        if (date == null) {
            inParam.put("date", HRDateTimeUtils.getNowDate());
        }
        if (HRDateTimeUtils.dayAfter((Date)((Date)inParam.get("date")), (Date)HRDateTimeUtils.getNowDate())) {
            throw new KDBizException("date can't be future");
        }
    }

    public Map<String, Object> validStandardPositionAndOrgAndDate(Long[] orgIds, Long[] stdPosIds, String[] orgNumbers, String[] stdPosNumbers, Date date) {
        LOGGER.info("validStandardPositionAndOrgAndDate start with orgIds: {}, stdPosIds: {}, orgNumbers: {}, stdPosNumbers: {}, date: {}", new Object[]{orgIds, stdPosIds, orgNumbers, stdPosNumbers, date});
        try {
            if (date == null) {
                date = HRDateTimeUtils.getNowDate();
            }
            if (HRDateTimeUtils.dayAfter((Date)date, (Date)HRDateTimeUtils.getNowDate())) {
                throw new KDBizException("date can't be future");
            }
            if (orgIds == null && orgNumbers == null) {
                LOGGER.error("validStandardPositionAndOrgAndDate, orgIds and orgNumbers are null");
                throw new KDBizException("validStandardPositionAndOrgAndDate, orgIds and orgNumbers are null");
            }
            if (stdPosIds == null && stdPosNumbers == null) {
                LOGGER.error("validStandardPositionAndOrgAndDate, stdPosIds and stdPosNumbers are null");
                throw new KDBizException("validStandardPositionAndOrgAndDate, stdPosIds and stdPosNumbers are null");
            }
            if ((orgIds != null ? orgIds.length : orgNumbers.length) != (stdPosIds != null ? stdPosIds.length : stdPosNumbers.length)) {
                LOGGER.error("validStandardPositionAndOrgAndDate, stdPos' size not equals and org's size");
                throw new KDBizException("validStandardPositionAndOrgAndDate, stdPos' size not equals and org's size");
            }
            ValidStdPosAndOrgAndDateParam validStdPosAndOrgAndDateParam = new ValidStdPosAndOrgAndDateParam();
            ValidStandardPositionAndOrgAndDateTempData tempData = this.getStdPosAndOrgList(orgIds, stdPosIds, orgNumbers, stdPosNumbers);
            validStdPosAndOrgAndDateParam.setStdPosAndOrgList(tempData.stdPosAndOrgList);
            validStdPosAndOrgAndDateParam.setDate(date);
            StandardPositionApplicationImpl standardPositionApplication = new StandardPositionApplicationImpl();
            ValidStdPosAndOrgAndDateResult validStdPosAndOrgAndDateResult = standardPositionApplication.validStandardPositionAndOrgAndDate(validStdPosAndOrgAndDateParam);
            Map stdAndPosVsCheckResult = validStdPosAndOrgAndDateResult.getStdAndPosVsCheckResult();
            List checkResult = stdAndPosVsCheckResult.entrySet().stream().map(entry -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                StdPosAndOrg stdPosAndOrg = (StdPosAndOrg)entry.getKey();
                if (tempData.stdPosIsID) {
                    map.put("standardPositionId", stdPosAndOrg.getStdPos());
                } else {
                    map.put("standardPositionNumber", tempData.stdPosIdVsNumber.getOrDefault(stdPosAndOrg.getStdPos(), ""));
                }
                if (tempData.orgIsID) {
                    map.put("orgId", stdPosAndOrg.getOrg());
                } else {
                    map.put("orgNumber", tempData.orgIdVsNumber.getOrDefault(stdPosAndOrg.getOrg(), ""));
                }
                map.put("valide", (Boolean)entry.getValue() != false ? "1" : "0");
                return map;
            }).collect(Collectors.toList());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("date", validStdPosAndOrgAndDateResult.getDate());
            data.put("checkResult", checkResult);
            Map result = PositionUtils.buildSuccessResult((int)200, (String)"", data);
            LOGGER.info("validStandardPositionAndOrgAndDate end with param:{}", (Object)result);
            return result;
        }
        catch (Exception ex) {
            LOGGER.error("validStandardPositionAndOrgAndDate error", (Throwable)ex);
            return PositionUtils.buildSuccessResult((int)500, (String)ex.getMessage(), null);
        }
    }

    private ValidStandardPositionAndOrgAndDateTempData getStdPosAndOrgList(Long[] orgIds, Long[] stdPosIds, String[] orgNumbers, String[] stdPosNumbers) {
        ValidStandardPositionAndOrgAndDateTempData tempData = new ValidStandardPositionAndOrgAndDateTempData();
        if (orgIds == null) {
            tempData.orgIsID = false;
            List orgNumberList = Arrays.stream(orgNumbers).filter(Objects::nonNull).map(Object::toString).distinct().collect(Collectors.toList());
            Map maps = HaosMServiceHelper.haosBatchGetSupOrgTeamInfo(orgNumberList, (Date)HRDateTimeUtils.getNowDate());
            tempData.orgIdVsNumber = maps != null ? maps.entrySet().stream().filter(Objects::nonNull).filter(entry -> Objects.nonNull(entry.getKey())).filter(entry -> Objects.nonNull(entry.getValue())).collect(Collectors.toMap(map -> Long.parseLong(((Object)((Map)map.getValue()).getOrDefault("id", 0L)).toString()), map -> ((Map)map.getValue()).getOrDefault("number", "").toString())) : Collections.emptyMap();
            Map<String, Long> orgNumberVsID = tempData.orgIdVsNumber.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            orgIds = (Long[])Arrays.stream(orgNumbers).map(number -> orgNumberVsID.getOrDefault(number, 0L)).toArray(Long[]::new);
        } else {
            tempData.orgIsID = true;
        }
        if (stdPosIds == null) {
            tempData.stdPosIsID = false;
            DynamicObject[] currentStdPoss = StandardPositionRepository.getInstance().queryCurrentStdPositionByNumbers("id, number", Arrays.asList(stdPosNumbers));
            tempData.stdPosIdVsNumber = Arrays.stream(currentStdPoss).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("number")));
            Map<String, Long> stdPosNumberVsID = tempData.stdPosIdVsNumber.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            stdPosIds = (Long[])Arrays.stream(stdPosNumbers).map(number -> stdPosNumberVsID.getOrDefault(number, 0L)).toArray(Long[]::new);
        } else {
            tempData.stdPosIsID = true;
        }
        tempData.stdPosAndOrgList = new ArrayList<StdPosAndOrg>(orgIds.length);
        for (int i = 0; i < orgIds.length; ++i) {
            StdPosAndOrg stdPosAndOrg = new StdPosAndOrg();
            stdPosAndOrg.setOrg(orgIds[i].longValue());
            stdPosAndOrg.setStdPos(stdPosIds[i].longValue());
            tempData.stdPosAndOrgList.add(stdPosAndOrg);
        }
        return tempData;
    }

    public List<Long> getStdPosIdsByUseorgIdList(List<Long> useorgIdList) {
        DynamicObject[] stdpos;
        QFilter permFilter = new BaseDataServiceImpl().getBaseDataFilter("hbpm_stposition", useorgIdList, true);
        if (permFilter == null) {
            permFilter = new QFilter("ctrlstrategy", "=", (Object)"5");
            permFilter.and(new QFilter("status", "=", (Object)"C"));
        }
        if ((stdpos = StandardPositionRepository.getInstance().getStdPosIdByPermFilter(permFilter)).length == 0) {
            return new ArrayList<Long>();
        }
        return Arrays.stream(stdpos).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
    }

    public Map<String, Object> queryStandardPositionContainsVersionsByOrg(List<Long> orgIdList) {
        if (CollectionUtils.isEmpty(orgIdList)) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Input parameter orgIdList is empty.", null);
        }
        StandardPositionApplicationImpl standardPositionService = new StandardPositionApplicationImpl();
        List results = standardPositionService.queryStandardPositionContainsHisByOrg(orgIdList, true);
        return PositionUtils.buildSuccessResult((int)200, (String)"", (Object)results);
    }

    public Map<String, Object> queryStandardPositionById(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Input parameter information is empty.", null);
        }
        if (ids.size() > 500) {
            return PositionUtils.buildSuccessResult((int)201, (String)"Query of more than 500 pieces of data is not supported.", null);
        }
        Object[] dynamicObjects = StandardPositionRepository.getInstance().querySPHisById(ids);
        if (PositionUtils.isArrayEmpty((Object[])dynamicObjects).booleanValue()) {
            return PositionUtils.buildSuccessResult((int)201, (String)"No data found.", null);
        }
        List<Map<String, Object>> jobGradeAndLevelRange = this.getJobGradeAndLevelRange((DynamicObject[])dynamicObjects);
        HashMap jobGradeRange = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        HashMap jobLevelRange = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        if (!CollectionUtils.isEmpty(jobGradeAndLevelRange)) {
            this.handleJobGradeAndLevelRange(jobGradeAndLevelRange, jobGradeRange, jobLevelRange);
        }
        ArrayList results = new ArrayList(dynamicObjects.length);
        Arrays.stream(dynamicObjects).forEach(dy -> {
            HashMap<String, Object> map = new HashMap<String, Object>(32);
            map.put("id", dy.getLong("id"));
            map.put("boid", dy.getLong("boid"));
            map.put("number", dy.getString("number"));
            map.put("name", dy.getString("name"));
            map.put("orgdesignbu.id", dy.getLong("orgdesignbu.id"));
            map.put("orgdesignbu.name", dy.getString("orgdesignbu.name"));
            map.put("positiontype.id", dy.getLong("positiontype.id"));
            map.put("positiontype.name", dy.getString("positiontype.name"));
            map.put("positionclassify.id", dy.getLong("positionclassify.id"));
            map.put("positionclassify.name", dy.getString("positionclassify.name"));
            map.put("jobscm.id", dy.getLong("jobscm.id"));
            map.put("jobscm.name", dy.getString("jobscm.name"));
            map.put("job.id", dy.getLong("job.id"));
            map.put("job.name", dy.getString("job.name"));
            map.put("job.number", dy.getString("job.number"));
            map.put("description", dy.getString("description"));
            long highJobLevel = dy.getLong("highjoblevel.id");
            long lowJobLevel = dy.getLong("lowjoblevel.id");
            long highJobGrade = dy.getLong("highjobgrade.id");
            long lowJobGrade = dy.getLong("lowjobgrade.id");
            map.put("highjoblevel.id", highJobLevel);
            map.put("highjoblevel.name", dy.getString("highjoblevel.name"));
            map.put("lowjoblevel.id", lowJobLevel);
            map.put("lowjoblevel.name", dy.getString("lowjoblevel.name"));
            map.put("highjobgrade.id", highJobGrade);
            map.put("highjobgrade.name", dy.getString("highjobgrade.name"));
            map.put("lowjobgrade.id", lowJobGrade);
            map.put("lowjobgrade.name", dy.getString("lowjobgrade.name"));
            Map<String, Object> jobLevelMap = this.getJobGradeAndLevelMap(lowJobLevel, highJobLevel, jobLevelRange);
            this.fillResultMap(jobLevelMap, map, "joblevelscm.id", "joblevelrange");
            Map<String, Object> jobGradeMap = this.getJobGradeAndLevelMap(lowJobGrade, highJobGrade, jobGradeRange);
            this.fillResultMap(jobGradeMap, map, "jobgradescm.id", "jobgraderange");
            results.add(map);
        });
        return PositionUtils.buildSuccessResult((int)200, (String)"", results);
    }

    static class ValidStandardPositionAndOrgAndDateTempData {
        List<StdPosAndOrg> stdPosAndOrgList;
        boolean orgIsID = false;
        boolean stdPosIsID = false;
        Map<Long, String> orgIdVsNumber;
        Map<Long, String> stdPosIdVsNumber;

        ValidStandardPositionAndOrgAndDateTempData() {
        }
    }
}

