/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbpm.mservice.openapi.controller.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbpm.mservice.openapi.model.position.HRCustomApiBaseResultModel;
import kd.hr.hbpm.mservice.openapi.model.position.HRCustomApiResultModel;
import kd.hr.hbpm.mservice.openapi.model.position.PositionSaveParamModel;
import kd.hr.hbpm.mservice.openapi.model.position.PositionUpdateParamModel;
import kd.hr.hbpm.mservice.openapi.util.ModelToListMapUtil;
import kd.hrmp.hbpm.business.utils.PositionJobRangeServiceHelper;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.business.utils.translate.DynamicObjectTranslator;
import kd.hrmp.hbpm.business.utils.translate.TranslateResult;

@ApiController(value="hbpm", desc="\u5c97\u4f4d\u4e3b\u6570\u636e\u63a5\u53e3")
@ApiMapping(value="/openapi/position")
public class PositionController
implements Serializable {
    private static final long serialVersionUID = 2961489890105868432L;
    private static final Log LOG = LogFactory.getLog(PositionController.class);

    @ApiPostMapping(value="/create")
    public CustomApiResult<HRCustomApiResultModel> savePosition(@ApiParam(value="positionModelParamList") @Valid @ApiParam(value="positionModelParamList") @Valid List<PositionSaveParamModel> positionParamModelList) {
        Optional<Tuple<String, String>> preValidator = this.preSaveValidator(positionParamModelList);
        if (preValidator.isPresent()) {
            return CustomApiResult.fail((String)((String)preValidator.get().item1), (String)((String)preValidator.get().item2));
        }
        try {
            ModelToListMapUtil<PositionSaveParamModel> modelToMap = new ModelToListMapUtil<PositionSaveParamModel>(positionParamModelList, PositionSaveParamModel.class);
            DynamicObjectTranslator translator = new DynamicObjectTranslator(positionParamModelList, "hbpm_position_api", PositionSaveParamModel.class, modelToMap.convert());
            List translateResults = translator.translate();
            this.fillMemoryParent(translateResults);
            this.fillLevelAndGradeRange(translateResults);
            List<DynamicObject> positionDataList = translateResults.stream().filter(dy -> dy.isSuccess()).map(dy -> dy.getDynamicObject()).collect(Collectors.toList());
            this.initPositionData(positionDataList);
            OperationResult opResult = this.callOp("save_api", positionDataList.toArray(new DynamicObject[0]));
            Map<Long, List<String>> validateResult = this.getValidateResult(opResult);
            int failCount = 0;
            HRCustomApiResultModel customApiResultModel = new HRCustomApiResultModel();
            ArrayList dataResult = Lists.newArrayListWithExpectedSize((int)translateResults.size());
            for (int i = 0; i < translateResults.size(); ++i) {
                TranslateResult translateResult = (TranslateResult)translateResults.get(i);
                HRCustomApiBaseResultModel customApiBaseResultModel = this.dealResultModel(translateResult.getDynamicObject(), validateResult, translateResult.getErrorMsg());
                customApiBaseResultModel.setBillIndex(i);
                customApiBaseResultModel.setType("create");
                if (!customApiBaseResultModel.getBillStatus().booleanValue()) {
                    ++failCount;
                }
                dataResult.add(customApiBaseResultModel);
            }
            customApiResultModel.setFailCount(failCount);
            customApiResultModel.setSuccessCount(translateResults.size() - failCount);
            customApiResultModel.setResult(dataResult);
            return CustomApiResult.success((Object)customApiResultModel);
        }
        catch (Exception exception) {
            LOG.error("positionController create", (Throwable)exception);
            return CustomApiResult.fail((String)"10001", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionController_2", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
    }

    @ApiPostMapping(value="/update")
    public CustomApiResult<HRCustomApiResultModel> updatePosition(@ApiParam(value="positionParamModelList") @Valid @ApiParam(value="positionParamModelList") @Valid List<PositionUpdateParamModel> positionParamModelList) {
        Optional<Tuple<String, String>> preValidator = this.preUpdateValidator(positionParamModelList);
        if (preValidator.isPresent()) {
            return CustomApiResult.fail((String)((String)preValidator.get().item1), (String)((String)preValidator.get().item2));
        }
        try {
            ModelToListMapUtil<PositionUpdateParamModel> modelToMap = new ModelToListMapUtil<PositionUpdateParamModel>(positionParamModelList, PositionUpdateParamModel.class);
            DynamicObjectTranslator translator = new DynamicObjectTranslator(positionParamModelList, "hbpm_position_api", PositionUpdateParamModel.class, modelToMap.convert());
            List translateResults = translator.translate();
            Map<String, DynamicObject> positionInfoFromDB = this.queryPositionInfoFromDB(positionParamModelList);
            this.fillPositionInfo(translateResults, positionInfoFromDB);
            this.updateLevelAndGradeRange(translateResults);
            List<DynamicObject> positionDataList = translateResults.stream().filter(dy -> dy.isSuccess()).map(dy -> dy.getDynamicObject()).collect(Collectors.toList());
            OperationResult opResult = this.callOp("change_api", positionDataList.toArray(new DynamicObject[0]));
            Map<Long, List<String>> validateResult = this.getValidateResult(opResult);
            int failCount = 0;
            HRCustomApiResultModel customApiResultModel = new HRCustomApiResultModel();
            ArrayList dataResult = Lists.newArrayListWithExpectedSize((int)translateResults.size());
            for (int i = 0; i < translateResults.size(); ++i) {
                TranslateResult translateResult = (TranslateResult)translateResults.get(i);
                HRCustomApiBaseResultModel customApiBaseResultModel = this.dealResultModel(translateResult.getDynamicObject(), validateResult, translateResult.getErrorMsg());
                customApiBaseResultModel.setBillIndex(i);
                customApiBaseResultModel.setType("update");
                if (!customApiBaseResultModel.getBillStatus().booleanValue()) {
                    ++failCount;
                }
                dataResult.add(customApiBaseResultModel);
            }
            customApiResultModel.setFailCount(failCount);
            customApiResultModel.setSuccessCount(translateResults.size() - failCount);
            customApiResultModel.setResult(dataResult);
            return CustomApiResult.success((Object)customApiResultModel);
        }
        catch (Exception exception) {
            LOG.error("positionController update", (Throwable)exception);
            return CustomApiResult.fail((String)"10001", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionController_2", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
    }

    @ApiPostMapping(value="/enable")
    public CustomApiResult<HRCustomApiResultModel> enablePosition(@ApiParam(value="ids", required=true) @Valid @ApiParam(value="ids", required=true) @Valid Long[] ids) {
        if (ids.length > 500) {
            return CustomApiResult.fail((String)"10002", (String)ResManager.loadKDString((String)"\u4e00\u6b21\u8bf7\u6c42\u6700\u591a\u53ea\u80fd\u540c\u6b65500\u6761\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_0", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        try {
            DynamicObject[] positions = this.queryPositionsById(ids);
            OperationResult opResult = this.callOp("enable_api", positions);
            Map<Long, List<String>> errorMessage = this.buildErrorResult(ids, positions, opResult);
            return CustomApiResult.success((Object)this.buildResponse(ids, errorMessage, "enable"));
        }
        catch (Exception exception) {
            LOG.error("positionController enable", (Throwable)exception);
            return CustomApiResult.fail((String)"10001", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionController_2", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
    }

    @ApiPostMapping(value="/disable")
    public CustomApiResult<HRCustomApiResultModel> disablePosition(@ApiParam(value="ids", required=true) @Valid @ApiParam(value="ids", required=true) @Valid Long[] ids) {
        if (ids.length > 500) {
            return CustomApiResult.fail((String)"10002", (String)ResManager.loadKDString((String)"\u4e00\u6b21\u8bf7\u6c42\u6700\u591a\u53ea\u80fd\u540c\u6b65500\u6761\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_0", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
        try {
            DynamicObject[] positions = this.queryPositionsById(ids);
            OperationResult opResult = this.callOp("disable_api", positions);
            Map<Long, List<String>> errorMessage = this.buildErrorResult(ids, positions, opResult);
            return CustomApiResult.success((Object)this.buildResponse(ids, errorMessage, "disable"));
        }
        catch (Exception exception) {
            LOG.error("positionController disable", (Throwable)exception);
            return CustomApiResult.fail((String)"10001", (String)ResManager.loadKDString((String)"\u7cfb\u7edf\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PositionController_2", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]));
        }
    }

    private void fillPositionInfo(List<TranslateResult<PositionUpdateParamModel>> translateResults, Map<String, DynamicObject> positionInfoFromDB) {
        for (TranslateResult<PositionUpdateParamModel> translateResult : translateResults) {
            DynamicObject parent;
            PositionUpdateParamModel originalModel = (PositionUpdateParamModel)translateResult.getOriginalModel();
            DynamicObject positionFromDB = positionInfoFromDB.get(originalModel.getNumber());
            ArrayList<String> errorMsg = translateResult.getErrorMsg();
            if (HRObjectUtils.isEmpty((Object)positionFromDB)) {
                if (CollectionUtils.isEmpty((Collection)errorMsg)) {
                    errorMsg = new ArrayList<String>();
                    translateResult.setErrorMsg(errorMsg);
                }
                errorMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_4", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                translateResult.setSuccess(false);
                continue;
            }
            DynamicObject newPosition = translateResult.getDynamicObject();
            if (HRStringUtils.isNotEmpty((String)originalModel.getParent()) && HRObjectUtils.isEmpty((Object)(parent = newPosition.getDynamicObject("parent")))) {
                if (CollectionUtils.isEmpty(errorMsg)) {
                    errorMsg = new ArrayList();
                    translateResult.setErrorMsg(errorMsg);
                }
                errorMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u503c\u201c%2$s\u201d\u67e5\u8be2\u7ed3\u679c\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_3", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), "parent", originalModel.getParent()));
                translateResult.setSuccess(false);
                continue;
            }
            translateResult.setDynamicObject(this.buildPositions(newPosition, positionFromDB));
        }
    }

    private DynamicObject buildPositions(DynamicObject fromDyn, DynamicObject toDyn) {
        List dirtyProperties = fromDyn.getDataEntityState().GetDirtyProperties();
        for (IDataEntityProperty dirtyPropertie : dirtyProperties) {
            String fieldName = dirtyPropertie.getName();
            toDyn.set(fieldName, fromDyn.get(fieldName));
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_position_api");
        DynamicObject changePosition = new DynamicObject((DynamicObjectType)dataEntityType);
        HRDynamicObjectUtils.copy((DynamicObject)toDyn, (DynamicObject)changePosition);
        changePosition.set("id", (Object)toDyn.getLong("boid"));
        return changePosition;
    }

    private void fillMemoryParent(List<TranslateResult<PositionSaveParamModel>> translateResults) {
        List translateSuccessResult = translateResults.stream().filter(translateResult -> translateResult.isSuccess()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(translateSuccessResult)) {
            return;
        }
        Map<String, DynamicObject> translateDynamicObjectMap = translateSuccessResult.stream().map(result -> result.getDynamicObject()).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (v1, v2) -> v1));
        for (TranslateResult translateResult2 : translateSuccessResult) {
            DynamicObject bizData;
            PositionSaveParamModel originalModel = (PositionSaveParamModel)translateResult2.getOriginalModel();
            if (HRStringUtils.isEmpty((String)originalModel.getParent()) || HRStringUtils.isNotEmpty((String)(bizData = translateResult2.getDynamicObject()).getString("parent"))) continue;
            DynamicObject memoryParent = translateDynamicObjectMap.get(originalModel.getParent());
            if (HRObjectUtils.isEmpty((Object)memoryParent)) {
                translateResult2.setSuccess(false);
                ArrayList<String> errorMsg = translateResult2.getErrorMsg();
                if (CollectionUtils.isEmpty((Collection)errorMsg)) {
                    errorMsg = new ArrayList<String>();
                    translateResult2.setErrorMsg(errorMsg);
                }
                errorMsg.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u503c\u201c%2$s\u201d\u67e5\u8be2\u7ed3\u679c\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_3", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), "parent", originalModel.getParent()));
                continue;
            }
            bizData.set("parent", (Object)memoryParent);
        }
    }

    private void fillLevelAndGradeRange(List<TranslateResult<PositionSaveParamModel>> translateResults) {
        HashSet<Long> jobScmIds = new HashSet<Long>();
        HashSet<Long> jobIds = new HashSet<Long>();
        HashSet<Long> jobFamilyIds = new HashSet<Long>();
        translateResults.stream().forEach(translateResult -> this.handleJobInfo(translateResult.getDynamicObject(), jobScmIds, jobIds, jobFamilyIds));
        PositionJobRangeServiceHelper positionJobRangeServiceHelper = this.initPositionJobRangeServiceHelper(jobScmIds, jobIds, jobFamilyIds);
        for (TranslateResult<PositionSaveParamModel> translateResult2 : translateResults) {
            Map levelAndGradeRange;
            List<String> errorMsg;
            String highGradeText;
            String lowGradeText;
            String highLevelText;
            PositionSaveParamModel originalModel = (PositionSaveParamModel)translateResult2.getOriginalModel();
            DynamicObject position = translateResult2.getDynamicObject();
            String lowLevelText = originalModel.getLowjobleveltext();
            if (!positionJobRangeServiceHelper.isFillLevelGradeRange(lowLevelText, highLevelText = originalModel.getHighjobleveltext(), lowGradeText = originalModel.getLowjobgradetext(), highGradeText = originalModel.getHighjobgradetext()) || CollectionUtils.isEmpty(errorMsg = this.buildLevelGradeRange(lowLevelText, highLevelText, lowGradeText, highGradeText, position, levelAndGradeRange = positionJobRangeServiceHelper.getLevelAndGradeRange(position.getDynamicObject("joblevelscm"), position.getDynamicObject("jobgradescm"), position.getDynamicObject("job"), position.getDynamicObject("jobscm"))))) continue;
            translateResult2.setSuccess(false);
            if (!CollectionUtils.isEmpty((Collection)translateResult2.getErrorMsg())) {
                errorMsg.addAll(translateResult2.getErrorMsg());
            }
            translateResult2.setErrorMsg(errorMsg);
        }
    }

    private void updateLevelAndGradeRange(List<TranslateResult<PositionUpdateParamModel>> translateResults) {
        HashSet<Long> jobScmIds = new HashSet<Long>();
        HashSet<Long> jobIds = new HashSet<Long>();
        HashSet<Long> jobFamilyIds = new HashSet<Long>();
        translateResults.stream().forEach(translateResult -> this.handleJobInfo(translateResult.getDynamicObject(), jobScmIds, jobIds, jobFamilyIds));
        PositionJobRangeServiceHelper positionJobRangeServiceHelper = this.initPositionJobRangeServiceHelper(jobScmIds, jobIds, jobFamilyIds);
        for (TranslateResult<PositionUpdateParamModel> translateResult2 : translateResults) {
            String highGradeText;
            String lowGradeText;
            String highLevelText;
            PositionUpdateParamModel originalModel = (PositionUpdateParamModel)translateResult2.getOriginalModel();
            DynamicObject position = translateResult2.getDynamicObject();
            String lowLevelText = originalModel.getLowjobleveltext();
            if (!positionJobRangeServiceHelper.isFillLevelGradeRange(lowLevelText, highLevelText = originalModel.getHighjobleveltext(), lowGradeText = originalModel.getLowjobgradetext(), highGradeText = originalModel.getHighjobgradetext())) {
                if (lowLevelText != null || highLevelText != null) {
                    position.set("lowjoblevel", null);
                    position.set("highjoblevel", null);
                }
                if (lowGradeText == null && highGradeText == null) continue;
                position.set("lowjobgrade", null);
                position.set("highjobgrade", null);
                continue;
            }
            Map levelAndGradeRange = positionJobRangeServiceHelper.getLevelAndGradeRange(position.getDynamicObject("joblevelscm"), position.getDynamicObject("jobgradescm"), position.getDynamicObject("job"), position.getDynamicObject("jobscm"));
            List<String> errorMsg = this.buildLevelGradeRange(lowLevelText, highLevelText, lowGradeText, highGradeText, position, levelAndGradeRange);
            if (CollectionUtils.isEmpty(errorMsg)) continue;
            translateResult2.setSuccess(false);
            if (!CollectionUtils.isEmpty((Collection)translateResult2.getErrorMsg())) {
                errorMsg.addAll(translateResult2.getErrorMsg());
            }
            translateResult2.setErrorMsg(errorMsg);
        }
    }

    private List<String> buildLevelGradeRange(String lowLevelText, String highLevelText, String lowGradeText, String highGradeText, DynamicObject position, Map<String, List<DynamicObject>> levelAndGradeRange) {
        Map<String, DynamicObject> numberToDyMap;
        ArrayList<String> result = new ArrayList<String>(4);
        if (HRStringUtils.isNotEmpty((String)lowLevelText) || HRStringUtils.isNotEmpty((String)highLevelText)) {
            List<DynamicObject> jobLevelScmRanges;
            if (HRStringUtils.isEmpty((String)lowLevelText)) {
                lowLevelText = highLevelText;
            }
            if (HRStringUtils.isEmpty((String)highLevelText)) {
                highLevelText = lowLevelText;
            }
            if (CollectionUtils.isEmpty(jobLevelScmRanges = levelAndGradeRange.get("joblevelscm"))) {
                result.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7ea7\u201d\u201c\u6700\u9ad8\u804c\u7ea7\u201d\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_9", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                LOG.info("the validates from PositionController buildLevelGradeRange");
            } else {
                numberToDyMap = jobLevelScmRanges.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (v1, v2) -> v1));
                DynamicObject lowLevel = numberToDyMap.get(lowLevelText);
                DynamicObject highLevel = numberToDyMap.get(highLevelText);
                if (HRObjectUtils.isEmpty((Object)lowLevel)) {
                    result.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7ea7\u201d\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_5", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                    LOG.info("the validates from PositionController buildLevelGradeRange");
                } else {
                    position.set("lowjoblevel", (Object)lowLevel);
                }
                if (HRObjectUtils.isEmpty((Object)highLevel)) {
                    result.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u6700\u9ad8\u804c\u7ea7\u201d\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_6", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                    LOG.info("the validates from PositionController buildLevelGradeRange");
                } else {
                    position.set("highjoblevel", (Object)highLevel);
                }
            }
        }
        if (HRStringUtils.isNotEmpty((String)lowGradeText) || HRStringUtils.isNotEmpty((String)highGradeText)) {
            List<DynamicObject> jobGradeScmRanges;
            if (HRStringUtils.isEmpty((String)lowGradeText)) {
                lowGradeText = highGradeText;
            }
            if (HRStringUtils.isEmpty((String)highGradeText)) {
                highGradeText = lowGradeText;
            }
            if (CollectionUtils.isEmpty(jobGradeScmRanges = levelAndGradeRange.get("jobgradescm"))) {
                result.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7b49\u201d\u201c\u6700\u9ad8\u804c\u7b49\u201d\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_10", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                LOG.info("the validates from PositionController buildLevelGradeRange");
            } else {
                numberToDyMap = jobGradeScmRanges.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (v1, v2) -> v1));
                DynamicObject lowGrade = numberToDyMap.get(lowGradeText);
                DynamicObject highGrade = numberToDyMap.get(highGradeText);
                if (HRObjectUtils.isEmpty((Object)lowGrade)) {
                    result.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u6700\u4f4e\u804c\u7b49\u201d\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_7", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                    LOG.info("the validates from PositionController buildLevelGradeRange");
                } else {
                    position.set("lowjobgrade", (Object)lowGrade);
                }
                if (HRObjectUtils.isEmpty((Object)highGrade)) {
                    result.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u6700\u9ad8\u804c\u7b49\u201d\u65e0\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_8", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
                    LOG.info("the validates from PositionController buildLevelGradeRange");
                } else {
                    position.set("highjobgrade", (Object)highGrade);
                }
            }
        }
        return result;
    }

    private PositionJobRangeServiceHelper initPositionJobRangeServiceHelper(Set<Long> jobScmIds, Set<Long> jobIds, Set<Long> jobFamilyIds) {
        PositionJobRangeServiceHelper positionJobRangeServiceHelper = new PositionJobRangeServiceHelper();
        positionJobRangeServiceHelper.initData(jobScmIds, jobIds, jobFamilyIds);
        return positionJobRangeServiceHelper;
    }

    private void handleJobInfo(DynamicObject position, Set<Long> jobScmIds, Set<Long> jobIds, Set<Long> jobFamilyIds) {
        DynamicObject job;
        if (HRObjectUtils.isEmpty((Object)position)) {
            return;
        }
        long jobScmId = position.getLong("jobscm.id");
        if (jobScmId != 0L) {
            jobScmIds.add(jobScmId);
        }
        if (HRObjectUtils.isEmpty((Object)(job = position.getDynamicObject("job")))) {
            return;
        }
        jobIds.add(job.getLong("id"));
        long jobFamilyId = job.getLong("jobfamily.id");
        if (jobFamilyId != 0L) {
            jobFamilyIds.add(jobFamilyId);
        }
    }

    private void initPositionData(List<DynamicObject> positionDataList) {
        if (HRObjectUtils.isEmpty(positionDataList)) {
            return;
        }
        for (DynamicObject positionInfo : positionDataList) {
            positionInfo.set("changetype", (Object)1010L);
            positionInfo.set("initstatus", (Object)"2");
            positionInfo.set("initdatasource", (Object)"0");
            if (positionInfo.get("establishmentdate") == null) {
                positionInfo.set("establishmentdate", (Object)positionInfo.getDate("bsed"));
            }
            if (HRObjectUtils.isEmpty((Object)positionInfo.getDynamicObject("org")) && !HRObjectUtils.isEmpty((Object)positionInfo.getDynamicObject("adminorg"))) {
                positionInfo.set("org", (Object)positionInfo.getDynamicObject("adminorg").getDynamicObject("org"));
            }
            if (positionInfo.get("enable") != null) continue;
            positionInfo.set("enable", (Object)"1");
        }
    }

    private Optional<Tuple<String, String>> preSaveValidator(List<PositionSaveParamModel> positionParamModelList) {
        if (positionParamModelList.size() > 500) {
            return Optional.of(Tuple.create((Object)"10002", (Object)ResManager.loadKDString((String)"\u4e00\u6b21\u8bf7\u6c42\u6700\u591a\u53ea\u80fd\u540c\u6b65500\u6761\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_0", (String)"hrmp-hbpm-mservice", (Object[])new Object[0])));
        }
        ArrayList positionNumbers = Lists.newArrayListWithExpectedSize((int)positionParamModelList.size());
        for (PositionSaveParamModel positionParamModel : positionParamModelList) {
            if (positionNumbers.contains(positionParamModel.getNumber())) {
                return Optional.of(Tuple.create((Object)"10003", (Object)String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_1", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), positionParamModel.getNumber())));
            }
            positionNumbers.add(positionParamModel.getNumber());
        }
        return Optional.empty();
    }

    private Optional<Tuple<String, String>> preUpdateValidator(List<PositionUpdateParamModel> positionParamModelList) {
        if (positionParamModelList.size() > 500) {
            return Optional.of(Tuple.create((Object)"10002", (Object)ResManager.loadKDString((String)"\u4e00\u6b21\u8bf7\u6c42\u6700\u591a\u53ea\u80fd\u540c\u6b65500\u6761\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_0", (String)"hrmp-hbpm-mservice", (Object[])new Object[0])));
        }
        ArrayList positionNumbers = Lists.newArrayListWithExpectedSize((int)positionParamModelList.size());
        for (PositionUpdateParamModel positionParamModel : positionParamModelList) {
            if (positionNumbers.contains(positionParamModel.getNumber())) {
                return Optional.of(Tuple.create((Object)"10003", (Object)String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_1", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), positionParamModel.getNumber())));
            }
            positionNumbers.add(positionParamModel.getNumber());
        }
        return Optional.empty();
    }

    private OperationResult callOp(String opKey, DynamicObject[] positions) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        return opImpl.localInvokeOperation(opKey, positions, operateOption);
    }

    private Map<Long, List<String>> buildErrorResult(Long[] ids, DynamicObject[] positions, OperationResult opResult) {
        Map<Long, List<String>> errorMessage = this.getValidateResult(opResult);
        Map<Object, Object> positionMap = Maps.newHashMapWithExpectedSize((int)8);
        if (!PositionUtils.isArrayEmpty((Object[])positions).booleanValue()) {
            positionMap = Arrays.stream(positions).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v1));
        }
        for (Long id : ids) {
            DynamicObject position = (DynamicObject)positionMap.get(id);
            if (!HRObjectUtils.isEmpty((Object)position)) continue;
            List errorResult = errorMessage.computeIfAbsent(id, v -> new ArrayList());
            errorResult.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PositionController_4", (String)"hrmp-hbpm-mservice", (Object[])new Object[0]), new Object[0]));
        }
        return errorMessage;
    }

    private Map<Long, List<String>> getValidateResult(OperationResult opResult) {
        HashMap<Long, List<String>> errorMessage = new HashMap<Long, List<String>>();
        List validateErrors = opResult.getValidateResult().getValidateErrors();
        if (CollectionUtils.isEmpty((Collection)validateErrors)) {
            return errorMessage;
        }
        for (ValidateResult validateError : validateErrors) {
            List allErrorInfo = validateError.getAllErrorInfo();
            for (OperateErrorInfo opErrorInfo : allErrorInfo) {
                Long pkId = (Long)opErrorInfo.getPkValue();
                List errorMessageInfo = errorMessage.computeIfAbsent(pkId, v -> new ArrayList());
                errorMessageInfo.add(opErrorInfo.getMessage());
            }
        }
        return errorMessage;
    }

    private HRCustomApiBaseResultModel dealResultModel(DynamicObject position, Map<Long, List<String>> validateResult, List<String> errorMsg) {
        HRCustomApiBaseResultModel customApiBaseResultModel = new HRCustomApiBaseResultModel();
        customApiBaseResultModel.setId(position.getLong("id"));
        customApiBaseResultModel.setNumber(position.getString("number"));
        HashMap keys = Maps.newHashMapWithExpectedSize((int)4);
        keys.put("number", position.getString("number"));
        customApiBaseResultModel.setKeys(keys);
        List<String> validateError = validateResult.get(position.getLong("id"));
        if (CollectionUtils.isEmpty(validateError) && CollectionUtils.isEmpty(errorMsg)) {
            customApiBaseResultModel.setBillStatus(true);
            return customApiBaseResultModel;
        }
        if (!CollectionUtils.isEmpty(validateError)) {
            if (!CollectionUtils.isEmpty(errorMsg)) {
                validateError.addAll(errorMsg);
            }
            customApiBaseResultModel.setErrors(validateError);
        } else {
            customApiBaseResultModel.setErrors(errorMsg);
        }
        customApiBaseResultModel.setBillStatus(false);
        return customApiBaseResultModel;
    }

    private HRCustomApiResultModel buildResponse(Long[] ids, Map<Long, List<String>> errorMessage, String type) {
        HRCustomApiResultModel customApiResultModel = new HRCustomApiResultModel();
        ArrayList resultData = Lists.newArrayListWithExpectedSize((int)ids.length);
        int failCount = 0;
        for (int i = 0; i < ids.length; ++i) {
            HRCustomApiBaseResultModel customApiBaseResultModel = new HRCustomApiBaseResultModel();
            customApiBaseResultModel.setId(ids[i]);
            HashMap keys = Maps.newHashMapWithExpectedSize((int)4);
            keys.put("id", ids[i]);
            customApiBaseResultModel.setKeys(keys);
            customApiBaseResultModel.setType(type);
            List<String> errors = errorMessage.get(ids[i]);
            if (CollectionUtils.isEmpty(errors)) {
                customApiBaseResultModel.setBillStatus(true);
            } else {
                customApiBaseResultModel.setErrors(errors);
                customApiBaseResultModel.setBillStatus(false);
                ++failCount;
            }
            resultData.add(customApiBaseResultModel);
        }
        customApiResultModel.setResult(resultData);
        customApiResultModel.setFailCount(failCount);
        customApiResultModel.setSuccessCount(ids.length - failCount);
        return customApiResultModel;
    }

    private Map<String, DynamicObject> queryPositionInfoFromDB(List<PositionUpdateParamModel> positionParamModelList) {
        Map<Object, Object> positionInfoFromDB = Maps.newHashMapWithExpectedSize((int)positionParamModelList.size());
        List<String> positionNumberList = positionParamModelList.stream().map(positionParamModel -> positionParamModel.getNumber()).collect(Collectors.toList());
        Object[] positionInfo = this.queryPositionInfoByNumber(positionNumberList);
        if (PositionUtils.isArrayEmpty((Object[])positionInfo).booleanValue()) {
            return positionInfoFromDB;
        }
        positionInfoFromDB = Arrays.stream(positionInfo).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (v1, v2) -> v1));
        return positionInfoFromDB;
    }

    private DynamicObject[] queryPositionsById(Long[] ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_position_api");
        QFilter idFilter = new QFilter("id", "in", (Object)ids);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    private DynamicObject[] queryPositionInfoByNumber(List<String> numbers) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_position_api");
        QFilter numberFilter = new QFilter("number", "in", numbers);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter excludeStand = new QFilter("createmode", "!=", (Object)"3");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{numberFilter, isCurrentFilter, initStatusFilter, excludeStand});
    }
}

