/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbpm.mservice.openapi.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.hbpm.mservice.openapi.model.position.MultiLangModel;

public class ModelToListMapUtil<T> {
    private static final Log LOG = LogFactory.getLog(ModelToListMapUtil.class);
    private final List<T> models;
    private final Class<?> clazz;

    public ModelToListMapUtil(List<T> models, Class<?> clazz) {
        this.models = models;
        this.clazz = clazz;
    }

    private <T> Map<String, Object> convertToMap(Class<?> clazz, T obj) throws IllegalAccessException {
        Field[] fields;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", null);
        for (Field field : fields = clazz.getDeclaredFields()) {
            Class<Object> type;
            if (field.isSynthetic()) continue;
            ReflectionUtils.makeAccessible((Field)field);
            if ("ext".equals(field.getName())) {
                Object extMap;
                type = field.getType();
                if (!type.isAssignableFrom(Map.class) || (extMap = field.get(obj)) == null) continue;
                Map castMap = (Map)extMap;
                castMap.forEach((key, value) -> result.put((String)key, value));
                continue;
            }
            type = field.getType();
            if (type.isAssignableFrom(MultiLangModel.class)) {
                Object mulMap = field.get(obj);
                if (mulMap == null) continue;
                MultiLangModel model = (MultiLangModel)mulMap;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("zh_CN", model.getZh_CN());
                map.put("zh_TW", model.getZh_TW());
                map.put("en_US", model.getEn_US());
                result.put(field.getName(), map);
                continue;
            }
            if ("serialVersionUID".equals(field.getName())) continue;
            result.put(field.getName(), field.get(obj));
        }
        return result;
    }

    public List<Map<String, Object>> convert() {
        ArrayList<Map<String, Object>> objects = new ArrayList<Map<String, Object>>();
        try {
            for (int idx = 0; idx < this.models.size(); ++idx) {
                T obj = this.models.get(idx);
                objects.add(this.convertToMap(this.clazz, obj));
            }
        }
        catch (Exception ex) {
            LOG.error("DynamicObjectTranslator convertToMap error", (Throwable)ex);
            throw new IllegalArgumentException("convert to map error", ex);
        }
        return objects;
    }
}

