/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.api.HisBatchDiscardApiBo;
import kd.hr.hbp.business.domain.model.newhismodel.api.HisDiscardApiBo;
import kd.hr.hbp.business.domain.model.newhismodel.task.HisSynDataStatusServicerHelper;
import kd.hr.hbp.business.domain.model.newhismodel.task.HisSyncStatusEntityDataBo;
import kd.hr.hbp.business.domain.repository.HisSyncDataStatusRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.application.impl.position.DarkPositionApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.DutyWorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.ReportingRelationServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.WorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.position.IDarkPositionApplication;
import kd.hrmp.hbpm.business.application.position.IPositionServiceApplication;
import kd.hrmp.hbpm.business.application.workrole.IDutyWorkRoleServiceApplication;
import kd.hrmp.hbpm.business.application.workrole.IReportingRelationServiceApplication;
import kd.hrmp.hbpm.business.application.workrole.IWorkRoleServiceApplication;
import kd.hrmp.hbpm.business.domain.repository.position.DutyWorkRoleQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionChangeEventQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ReportingrelationQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.WorkRoleQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeEventServiceImpl;
import kd.hrmp.hbpm.business.domain.service.impl.position.PositionServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.ChangeEventService;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.business.domain.service.position.IPositionService;
import kd.hrmp.hbpm.business.service.position.PositionServiceHelper;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.business.utils.model.ReportHisLoopCheckEntity;
import kd.hrmp.hbpm.common.constants.EffectiveStatusEnum;
import kd.hrmp.hbpm.common.constants.StandardPositionConstants;

public abstract class AbstractPositionServiceApplication
implements IPositionServiceApplication {
    private static final Log logger = LogFactory.getLog(AbstractPositionServiceApplication.class);
    public IDutyWorkRoleServiceApplication dutyWorkRoleServiceApplication = new DutyWorkRoleServiceApplicationImpl();
    public IWorkRoleServiceApplication workRoleServiceApplication = new WorkRoleServiceApplicationImpl();
    public IPositionService positionService = new PositionServiceImpl();
    public IReportingRelationServiceApplication reportingRelationServiceApplication = new ReportingRelationServiceApplicationImpl();
    public IDarkPositionApplication darkPositionApplication = new DarkPositionApplicationImpl();
    public ChangeEventService changeEventService = new ChangeEventServiceImpl();

    @Override
    public Map<String, Object> savePosition(List<DynamicObject> positions, Map<String, DynamicObjectCollection> reportRelationEntryEntity) {
        List<DynamicObject> newDutyRole = this.dutyWorkRoleServiceApplication.createNewDutyRole(positions);
        List<DynamicObject> newWorkRole = this.workRoleServiceApplication.createNewWorkRole(positions, newDutyRole);
        Map<Long, DynamicObject> workRoleMap = PositionUtils.listToMap(newWorkRole, "position.id");
        this.positionFillWorkRole(positions, workRoleMap);
        DynamicObject[] hisVersions = this.positionService.batchSave(positions.toArray(new DynamicObject[0]));
        this.reportingRelationServiceApplication.createNewReportRelationAndSysReportRel(positions, reportRelationEntryEntity, newWorkRole);
        ArrayList<DynamicObject> enabledHisVersions = new ArrayList<DynamicObject>(hisVersions.length);
        ArrayList<DynamicObject> disabledHisVersions = new ArrayList<DynamicObject>(hisVersions.length);
        for (DynamicObject hisVersion : hisVersions) {
            if ("1".equals(hisVersion.getString("enable"))) {
                enabledHisVersions.add(hisVersion);
                continue;
            }
            if (!"0".equals(hisVersion.getString("enable"))) continue;
            disabledHisVersions.add(hisVersion);
        }
        if (!enabledHisVersions.isEmpty()) {
            this.handleChangeEvent(null, enabledHisVersions.toArray(new DynamicObject[enabledHisVersions.size()]), 1010L, 1010L, true);
        }
        if (!disabledHisVersions.isEmpty()) {
            this.handleChangeEvent(null, disabledHisVersions.toArray(new DynamicObject[disabledHisVersions.size()]), 1010L, 1010L, false);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        result.put("workRoleMap", workRoleMap);
        result.put("hisVersions", Arrays.asList(hisVersions));
        return result;
    }

    @Override
    public DynamicObject[] changePosition(List<DynamicObject> positions, boolean isSendMsg) {
        this.preHandlePosition(positions);
        DynamicObject[] positionHisVersions = this.getPositionHisVersions(positions);
        DynamicObject[] hisVersions = this.unifyChangePosition(positions, positionHisVersions, isSendMsg);
        return hisVersions;
    }

    private DynamicObject[] unifyChangePosition(List<DynamicObject> positions, DynamicObject[] positionHisVersions, boolean isSendMsg) {
        this.workRoleServiceApplication.updateWorkRole(positions);
        this.dutyWorkRoleServiceApplication.updateDutyRole(positions);
        this.reportingRelationServiceApplication.updateSysReportRel(positions, this.getEffectiveStatus());
        DynamicObject[] hisVersions = this.positionService.batchChange(positions.toArray(new DynamicObject[0]));
        this.handleChangeEvent(positionHisVersions, hisVersions, 1020L, 1020L, isSendMsg);
        return hisVersions;
    }

    @Override
    public List<DynamicObject> integrationChangePosition(List<DynamicObject> positions) {
        this.preHandlePosition(positions);
        Map<Long, DynamicObject> positionIdMap = positions.stream().collect(Collectors.toMap(pos -> pos.getLong("boid"), pos -> pos));
        ArrayList<DynamicObject> preEnableAndCurEnablePosList = new ArrayList<DynamicObject>(positions.size());
        ArrayList<DynamicObject> preEnableAndCurDisablePosList = new ArrayList<DynamicObject>(positions.size());
        ArrayList<DynamicObject> preDisableAndCurEnablePosList = new ArrayList<DynamicObject>(positions.size());
        ArrayList<DynamicObject> preDisableAndCurDisablePosList = new ArrayList<DynamicObject>(positions.size());
        DynamicObject[] positionHisVersions = this.getPositionHisVersions(positions);
        ArrayList preEnableAndCurEnablePosHisList = Lists.newArrayListWithExpectedSize((int)positionHisVersions.length);
        ArrayList preEnableAndCurDisablePosHisList = Lists.newArrayListWithExpectedSize((int)positionHisVersions.length);
        ArrayList preDisableAndCurEnablePosHisList = Lists.newArrayListWithExpectedSize((int)positionHisVersions.length);
        ArrayList preDisableAndCurDisablePosHisList = Lists.newArrayListWithExpectedSize((int)positionHisVersions.length);
        for (DynamicObject positionHisVersion : positionHisVersions) {
            DynamicObject curPos = positionIdMap.get(positionHisVersion.getLong("boid"));
            if ("1".equals(positionHisVersion.getString("enable")) && "1".equals(curPos.getString("enable"))) {
                preEnableAndCurEnablePosList.add(curPos);
                preEnableAndCurEnablePosHisList.add(positionHisVersion);
                continue;
            }
            if ("1".equals(positionHisVersion.getString("enable")) && "0".equals(curPos.getString("enable"))) {
                preEnableAndCurDisablePosList.add(curPos);
                preEnableAndCurDisablePosHisList.add(positionHisVersion);
                continue;
            }
            if ("0".equals(positionHisVersion.getString("enable")) && "1".equals(curPos.getString("enable"))) {
                preDisableAndCurEnablePosList.add(curPos);
                preDisableAndCurEnablePosHisList.add(positionHisVersion);
                continue;
            }
            if (!"0".equals(positionHisVersion.getString("enable")) || !"0".equals(curPos.getString("enable"))) continue;
            preDisableAndCurDisablePosList.add(curPos);
            preDisableAndCurDisablePosHisList.add(positionHisVersion);
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(positions.size());
        DarkPositionApplicationImpl darkPositionApplication = new DarkPositionApplicationImpl();
        this.handelPreEnableAndCurEnablePos(preEnableAndCurEnablePosList, preEnableAndCurEnablePosHisList.toArray(new DynamicObject[0]), result, darkPositionApplication);
        this.handelPreEnableAndCurDisablePos(preEnableAndCurDisablePosList, preEnableAndCurDisablePosHisList.toArray(new DynamicObject[0]), result);
        this.handelPreDisableAndCurEnablePos(preDisableAndCurEnablePosList, preDisableAndCurEnablePosHisList.toArray(new DynamicObject[0]), result, darkPositionApplication);
        this.handelPreDisableAndCurDisablePos(preDisableAndCurDisablePosList, preDisableAndCurDisablePosHisList.toArray(new DynamicObject[0]), result);
        return result;
    }

    private void handelPreDisableAndCurDisablePos(List<DynamicObject> preDisableAndCurDisablePosList, DynamicObject[] preDisableAndCurDisablePosHiss, List<DynamicObject> result) {
        if (!preDisableAndCurDisablePosList.isEmpty()) {
            DynamicObject[] hisVersions = this.unifyChangePosition(preDisableAndCurDisablePosList, preDisableAndCurDisablePosHiss, false);
            result.addAll(Arrays.asList(hisVersions));
        }
    }

    private void handelPreDisableAndCurEnablePos(List<DynamicObject> preDisableAndCurEnablePosList, DynamicObject[] preDisableAndCurEnablePosHiss, List<DynamicObject> result, IDarkPositionApplication darkPositionApplication) {
        if (!preDisableAndCurEnablePosList.isEmpty()) {
            DynamicObject[] hisVersions = this.unifyChangePosition(preDisableAndCurEnablePosList, preDisableAndCurEnablePosHiss, true);
            result.addAll(Arrays.asList(hisVersions));
            HashSet<Long> mainDutyPosToOrgIds = new HashSet<Long>(preDisableAndCurEnablePosList.size());
            for (DynamicObject preDisableAndCurEnablePos : preDisableAndCurEnablePosList) {
                if (!preDisableAndCurEnablePos.getString("isleader").equals("1")) continue;
                mainDutyPosToOrgIds.add(preDisableAndCurEnablePos.getLong("adminorg.id"));
            }
            darkPositionApplication.fixDarkPositionRelation(mainDutyPosToOrgIds);
        }
    }

    private void handelPreEnableAndCurDisablePos(List<DynamicObject> preEnableAndCurDisablePosList, DynamicObject[] preEnableAndCurDisablePosHiss, List<DynamicObject> result) {
        if (!preEnableAndCurDisablePosList.isEmpty()) {
            DynamicObject[] hisVersions = this.unifyChangePosition(preEnableAndCurDisablePosList, preEnableAndCurDisablePosHiss, true);
            result.addAll(Arrays.asList(hisVersions));
            Map<Long, DynamicObject> preEnableAndCurDisablePosIdMap = preEnableAndCurDisablePosList.stream().collect(Collectors.toMap(pos -> pos.getLong("boid"), pos -> pos));
            ArrayList<DynamicObject> mainDutyPositions = new ArrayList<DynamicObject>(preEnableAndCurDisablePosList.size());
            for (DynamicObject preEnableAndCurDisablePosHis : preEnableAndCurDisablePosHiss) {
                DynamicObject preEnableAndCurDisablePosCur = preEnableAndCurDisablePosIdMap.get(preEnableAndCurDisablePosHis.getLong("boid"));
                if (!"1".equals(preEnableAndCurDisablePosHis.getString("isleader")) || !"2".equals(preEnableAndCurDisablePosCur.getString("isleader"))) continue;
                mainDutyPositions.add(preEnableAndCurDisablePosCur);
            }
            this.disableReportRelationsAndClearDarkPosRelations(mainDutyPositions.toArray(new DynamicObject[0]));
        }
    }

    private void handelPreEnableAndCurEnablePos(List<DynamicObject> preEnableAndCurEnablePosList, DynamicObject[] preEnableAndCurEnablePosHiss, List<DynamicObject> result, IDarkPositionApplication darkPositionApplication) {
        if (!preEnableAndCurEnablePosList.isEmpty()) {
            DynamicObject[] hisVersions = this.unifyChangePosition(preEnableAndCurEnablePosList, preEnableAndCurEnablePosHiss, true);
            List<DynamicObject> hisVersionList = Arrays.asList(hisVersions);
            result.addAll(hisVersionList);
            darkPositionApplication.maintainDarkPositionRelation(hisVersionList, true, true);
        }
    }

    @Override
    public DynamicObject[] changeMainPosition(List<DynamicObject> positions, boolean isSendMsg, boolean isChangeEvent) {
        this.preHandlePosition(positions);
        DynamicObject[] positionHisVersions = this.getPositionHisVersions(positions);
        DynamicObject[] hisVersions = this.positionService.batchChange(positions.toArray(new DynamicObject[0]));
        if (isChangeEvent) {
            this.handleChangeEvent(positionHisVersions, hisVersions, 1020L, 1020L, isSendMsg);
        }
        return hisVersions;
    }

    @Override
    public DynamicObject[] changePositionOrg(List<DynamicObject> positions, boolean isSendMsg, boolean isChangeEvent) {
        if (positions.isEmpty()) {
            return new DynamicObject[0];
        }
        DynamicObject[] positionHisVersions = this.getPositionHisVersions(positions);
        this.workRoleServiceApplication.updateWorkRole(positions);
        this.dutyWorkRoleServiceApplication.updateDutyRole(positions);
        DynamicObject[] hisVersions = this.positionService.batchChange(positions.toArray(new DynamicObject[0]));
        if (isChangeEvent) {
            this.handleChangeEvent(positionHisVersions, hisVersions, 1020L, 1020L, isSendMsg);
        }
        return hisVersions;
    }

    @Override
    public void changePositionRelation(List<DynamicObject> positions, Map<String, DynamicObjectCollection> reportRelationEntryEntity, boolean saveEvent) {
        this.reportingRelationServiceApplication.updateReportRelation(positions, reportRelationEntryEntity);
        if (saveEvent) {
            this.handleChangeEvent(null, positions.toArray(new DynamicObject[0]), 1020L, 1030L, true);
        }
    }

    @Override
    public void changePositionEnable(DynamicObject[] positions, String operateType) {
        if ("0".equals(operateType)) {
            this.positionDisable(positions);
        } else if ("1".equals(operateType)) {
            this.positionEnable(positions);
        }
    }

    @Override
    public void deletePosition(DynamicObject[] positions) {
        if (PositionUtils.isArrayEmpty(positions).booleanValue()) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(positions.length);
        ArrayList<Long> workRoleIds = new ArrayList<Long>(positions.length);
        for (DynamicObject position2 : positions) {
            ids.add(position2.getLong("id"));
            workRoleIds.add(position2.getLong("workrole.id"));
        }
        this.positionService.batchDeleted(ids);
        this.dutyWorkRoleServiceApplication.deleteDutyRoles(ids);
        this.workRoleServiceApplication.deleteWorkRoles(workRoleIds);
        this.reportingRelationServiceApplication.deleteAllReportingRelationByWorkRoles(workRoleIds);
        DynamicObject[] positionVersions = PositionQueryRepository.getInstance().queryPositionVersionByBoId(ids);
        List positionVersionIds = Arrays.stream(positionVersions).map(position -> position.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper positionBillServiceHelper = new HRBaseServiceHelper("homs_positionbill");
        QFilter idFilter = new QFilter("hisnewversion", "in", positionVersionIds);
        positionBillServiceHelper.deleteByFilter(new QFilter[]{idFilter});
    }

    protected abstract EffectiveStatusEnum getEffectiveStatus();

    protected void preHandlePosition(List<DynamicObject> positions) {
    }

    protected DynamicObject[] getPositionHisVersions(List<DynamicObject> positions) {
        return null;
    }

    private void savePositionBill(DynamicObject[] positionBills) {
        HRBaseServiceHelper positionBillServiceHelper = new HRBaseServiceHelper("homs_positionbill");
        positionBillServiceHelper.save(positionBills);
    }

    private void positionDisable(DynamicObject[] positions) {
        if (!ObjectUtils.isEmpty((Object[])positions)) {
            List<Long> idList = Arrays.stream(positions).map(position -> position.getLong("id")).collect(Collectors.toList());
            QFilter idFilter = new QFilter("id", "in", idList);
            HRBaseServiceHelper positionHepler = new HRBaseServiceHelper("hbpm_positionhr");
            positions = positionHepler.loadDynamicObjectArray(new QFilter[]{idFilter});
            PositionServiceImpl positionService = new PositionServiceImpl();
            DynamicObject[] newDynamicObjects = positionService.batchEnableOrDisable(positions, "disable");
            List<DynamicObject> positionBills = PositionServiceHelper.transferPositionToPositionBill(Arrays.asList(newDynamicObjects));
            this.savePositionBill(positionBills.toArray(new DynamicObject[0]));
            List<DynamicObject> workRoleIdList = Arrays.stream(positions).map(dyn -> dyn.getDynamicObject("workrole")).collect(Collectors.toList());
            this.workRoleServiceApplication.enableOrDisableRoles("disable", workRoleIdList);
            DynamicObject[] dutyWorkRoleDyns = DutyWorkRoleQueryRepository.getInstance().queryDutyWorkRoleByIds(idList);
            this.dutyWorkRoleServiceApplication.enableOrDisableDutyRoles(Arrays.asList(dutyWorkRoleDyns), "disable");
            this.disableReportRelationsAndClearDarkPosRelations(positions);
            this.handleChangeEvent(this.getPositionHisVersions(Arrays.asList(positions)), newDynamicObjects, 1030L, 1040L, true);
        }
    }

    private void disableReportRelationsAndClearDarkPosRelations(DynamicObject[] positions) {
        ArrayList<Long> workRoleIds = new ArrayList<Long>(positions.length);
        ArrayList<Long> mainDutyPositionBoIds = new ArrayList<Long>(positions.length);
        HashSet<Long> mainDutyPosToOrgIds = new HashSet<Long>(positions.length);
        HashMap<Long, DynamicObject> mainDutyPosition = new HashMap<Long, DynamicObject>(positions.length);
        for (DynamicObject position : positions) {
            workRoleIds.add(position.getLong("workrole.id"));
            if (!position.getString("isleader").equals("1")) continue;
            mainDutyPositionBoIds.add(position.getLong("boid"));
            mainDutyPosToOrgIds.add(position.getLong("adminorg.id"));
            mainDutyPosition.put(position.getLong("boid"), position);
        }
        List<DynamicObject> darkPositions = PositionQueryRepository.getInstance().queryDarkPositionByPositionBoIds(mainDutyPositionBoIds);
        List<Long> darkPosWorkRoleIds = darkPositions.stream().map(dyn -> dyn.getLong("workrole.id")).collect(Collectors.toList());
        List<DynamicObject> darkReportRelations = ReportingrelationQueryRepository.getInstance().queryReportRelationPartialInfo(darkPosWorkRoleIds);
        List<DynamicObject> reportRelation = ReportingrelationQueryRepository.getInstance().queryAllDisableReportRelationAboutDownByIds(workRoleIds);
        Map<Long, DynamicObject> reportRelationIdMap = reportRelation.stream().collect(Collectors.toMap(rep -> rep.getLong("id"), rep -> rep));
        if (reportRelationIdMap.size() != 0) {
            if (!Objects.isNull(darkReportRelations) && darkReportRelations.size() != 0) {
                for (DynamicObject darkReportRelation : darkReportRelations) {
                    reportRelationIdMap.remove(darkReportRelation.getLong("id"));
                }
            }
            if (!reportRelationIdMap.values().isEmpty()) {
                this.reportingRelationServiceApplication.enableOrDisableReportRelations(new ArrayList<DynamicObject>(reportRelationIdMap.values()), "disable");
            }
        }
        this.darkPositionApplication.clearDarkPositionRelation(mainDutyPosToOrgIds, mainDutyPosition, darkPositions);
    }

    private void positionEnable(DynamicObject[] positions) {
        if (!ObjectUtils.isEmpty((Object[])positions)) {
            List<Long> idList = Arrays.stream(positions).map(position -> position.getLong("id")).collect(Collectors.toList());
            QFilter idFilter = new QFilter("id", "in", idList);
            HRBaseServiceHelper positionHepler = new HRBaseServiceHelper("hbpm_positionhr");
            positions = positionHepler.loadDynamicObjectArray(new QFilter[]{idFilter});
            PositionServiceImpl positionService = new PositionServiceImpl();
            DynamicObject[] newDynamicObjects = positionService.batchEnableOrDisable(positions, "enable");
            List<DynamicObject> positionBills = PositionServiceHelper.transferPositionToPositionBill(Arrays.asList(newDynamicObjects));
            this.savePositionBill(positionBills.toArray(new DynamicObject[0]));
            List<DynamicObject> workRoleIdList = Arrays.stream(positions).map(dyn -> dyn.getDynamicObject("workrole")).collect(Collectors.toList());
            workRoleIdList.forEach(workRole -> workRole.set("bsed", (Object)new Date()));
            this.workRoleServiceApplication.enableOrDisableRoles("enable", workRoleIdList);
            DynamicObject[] dutyWorkRoleDyns = DutyWorkRoleQueryRepository.getInstance().queryDutyWorkRoleByIds(idList);
            Arrays.stream(dutyWorkRoleDyns).forEach(dutyWorkRole -> dutyWorkRole.set("bsed", (Object)new Date()));
            this.dutyWorkRoleServiceApplication.enableOrDisableDutyRoles(Arrays.asList(dutyWorkRoleDyns), "enable");
            List<DynamicObject> reportRelation = this.getNeedToEnableReportRelation(positions);
            if (reportRelation.size() != 0) {
                reportRelation.forEach(report -> report.set("bsed", (Object)new Date()));
                this.reportingRelationServiceApplication.enableOrDisableReportRelations(reportRelation, "enable");
            }
            HashSet<Long> mainDutyPosToOrgIds = new HashSet<Long>(positions.length);
            for (DynamicObject position2 : positions) {
                if (!position2.getString("isleader").equals("1")) continue;
                mainDutyPosToOrgIds.add(position2.getLong("adminorg.id"));
            }
            this.darkPositionApplication.fixDarkPositionRelation(mainDutyPosToOrgIds);
            this.handleChangeEvent(this.getPositionHisVersions(Arrays.asList(positions)), newDynamicObjects, 1020L, 1070L, true);
        }
    }

    private List<DynamicObject> getNeedToEnableReportRelation(DynamicObject[] positions) {
        List<DynamicObject> upReportRelation = this.getUpReportRelation(positions);
        List<DynamicObject> downReportRelation = this.getDownReportRelation(positions);
        ArrayList reportRelation = Lists.newArrayListWithExpectedSize((int)positions.length);
        reportRelation.addAll(upReportRelation);
        reportRelation.addAll(downReportRelation);
        return reportRelation;
    }

    private List<DynamicObject> getUpReportRelation(DynamicObject[] positions) {
        List<Long> haveParentWorkRoleIds = Arrays.stream(positions).filter(pos -> pos.getDynamicObject("parent") != null).map(pos -> pos.getLong("workrole.id")).collect(Collectors.toList());
        List<DynamicObject> reportRelation = ReportingrelationQueryRepository.getInstance().queryAllDisableAdministrativeUpRelationByIds(haveParentWorkRoleIds);
        return reportRelation;
    }

    public Map<Long, List<ReportHisLoopCheckEntity>> getDownReportRelationMap(DynamicObject[] positions) {
        List<DynamicObject> relations = this.getDownReportRelation(positions);
        HashMap map = Maps.newHashMapWithExpectedSize((int)relations.size());
        for (DynamicObject relation : relations) {
            ReportHisLoopCheckEntity entity = new ReportHisLoopCheckEntity();
            entity.setRole(relation.getLong("role.id"));
            entity.setParent(relation.getLong("parent.id"));
            entity.setBsed(relation.getDate("bsed"));
            entity.setBsled(relation.getDate("bsled"));
            entity.setReportingtype(relation.getString("reportingtype.id"));
            ArrayList<ReportHisLoopCheckEntity> list = (ArrayList<ReportHisLoopCheckEntity>)map.get(entity.getRole());
            if (list == null) {
                list = new ArrayList<ReportHisLoopCheckEntity>();
            }
            list.add(entity);
            map.put(entity.getRole(), list);
        }
        return map;
    }

    private List<DynamicObject> getDownReportRelation(DynamicObject[] positions) {
        List<Long> allWorkRoleIds = Arrays.stream(positions).map(pos -> pos.getLong("workrole.id")).collect(Collectors.toList());
        List<DynamicObject> downReportRelation = ReportingrelationQueryRepository.getInstance().queryAllDisableAdministrativeDownRelationByIds(allWorkRoleIds);
        List downPosIds = downReportRelation.stream().map(rel -> rel.getDynamicObject("role").getLong("position.id")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", downPosIds);
        HRBaseServiceHelper positionHepler = new HRBaseServiceHelper("hbpm_positionhr");
        DynamicObject[] downPositions = positionHepler.query("id,parent,workrole", new QFilter[]{idFilter});
        ArrayList needRemovRelation = Lists.newArrayListWithExpectedSize((int)downReportRelation.size());
        List haveNoParentWorkRoleIds = Arrays.stream(downPositions).filter(pos -> pos.getDynamicObject("parent") == null).map(pos -> pos.getLong("workrole.id")).collect(Collectors.toList());
        for (DynamicObject rel2 : downReportRelation) {
            if (!haveNoParentWorkRoleIds.contains(rel2.getLong("role.id"))) continue;
            needRemovRelation.add(rel2);
        }
        downReportRelation.removeAll(needRemovRelation);
        return downReportRelation;
    }

    public void handleChangeEvent(DynamicObject[] beforeData, DynamicObject[] afterData, long changeOperation, long changeScene, boolean isSendMsg) {
        boolean isInitSource = false;
        if (!ArrayUtils.isEmpty((Object[])afterData)) {
            String changeTypeField = afterData[0].get("changetype") instanceof DynamicObject ? "changetype.id" : "changetype";
            long changeType = afterData[0].getLong(changeTypeField);
            isInitSource = changeType == 1050L;
            PositionChangeEventQueryRepository instance = PositionChangeEventQueryRepository.getInstance();
            DynamicObject changeOperationDy = instance.queryChangeOperation(changeOperation);
            DynamicObject changeSceneDy = isInitSource ? instance.queryChangeScene(1050L) : instance.queryChangeScene(changeScene);
            DynamicObject changeTypeDy = instance.queryChangeType(changeType);
            for (DynamicObject position : afterData) {
                if (position.getDynamicObject("changescene") != null && position.getDynamicObject("changetype") != null && position.getDynamicObject("changeoperate") != null) continue;
                position.set("changeoperate", (Object)changeOperationDy);
                position.set("changescene", (Object)changeSceneDy);
                position.set("changetype", (Object)changeTypeDy);
            }
        }
        this.changeEventService.handleChangeEvent("10", beforeData, afterData, null, isInitSource, isSendMsg);
    }

    private void positionFillWorkRole(List<DynamicObject> positions, Map<Long, DynamicObject> workRoleMap) {
        if (CollectionUtils.isEmpty(positions)) {
            return;
        }
        if (CollectionUtils.isEmpty(workRoleMap)) {
            return;
        }
        positions.stream().forEach(position -> {
            DynamicObject workRole = (DynamicObject)workRoleMap.get(position.getLong("id"));
            position.set("workrole", (Object)workRole.getLong("id"));
        });
    }

    @Override
    public void revisePosition(DynamicObject[] positions) {
        this.setReviseChangeFieldValue(positions);
        List<DynamicObject> positionList = Arrays.asList(positions);
        this.workRoleServiceApplication.updateWorkRole(positionList);
        this.dutyWorkRoleServiceApplication.updateDutyRole(positionList);
        this.reportingRelationServiceApplication.batchReviseSysReportRel(positionList);
        this.positionService.batchChange(positions);
    }

    private void setReviseChangeFieldValue(DynamicObject[] hisVersionPositions) {
        PositionChangeEventQueryRepository instance = PositionChangeEventQueryRepository.getInstance();
        DynamicObject changeOperationDy = instance.queryChangeOperation(1040L);
        DynamicObject changeSceneDy = instance.queryChangeScene(1080L);
        DynamicObject changeTypeDy = instance.queryChangeType(1060L);
        for (DynamicObject position : hisVersionPositions) {
            position.set("changeoperate", (Object)changeOperationDy);
            position.set("changescene", (Object)changeSceneDy);
            position.set("changetype", (Object)changeTypeDy);
        }
    }

    private void batchDiscardBoData(String entityNumber, Set<Long> boidSet) {
        if (CollectionUtils.isEmpty(boidSet)) {
            return;
        }
        HisBatchDiscardApiBo discardApiBo = new HisBatchDiscardApiBo();
        ArrayList hisDiscardApiBoList = Lists.newArrayList();
        HisDiscardApiBo hisDiscardApiBo = new HisDiscardApiBo();
        hisDiscardApiBo.setEntityNumber(entityNumber);
        hisDiscardApiBo.setBoIdSet(boidSet);
        hisDiscardApiBoList.add(hisDiscardApiBo);
        discardApiBo.setHisDiscardApiBoList((List)hisDiscardApiBoList);
        HisModelController.getInstance().batchDiscardBoData(discardApiBo);
    }

    private void batchDiscardFuturePositionData(DynamicObject[] positions, boolean forModify) {
        Set<Long> positionIds = Arrays.stream(positions).map(dyn -> dyn.getLong("boid")).collect(Collectors.toSet());
        Set<Long> workRoleIds = Arrays.stream(positions).map(dyn -> dyn.getLong("workrole.id")).collect(Collectors.toSet());
        List<DynamicObject> reportRelations = ReportingrelationQueryRepository.getInstance().queryAllDisableReportRelationAboutDownByIds(new ArrayList<Long>(workRoleIds));
        Set<Long> relationIds = reportRelations.stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toSet());
        this.batchDiscardBoData("hbpm_positionhr", positionIds);
        this.batchDiscardBoData("hbpm_workroleshr", workRoleIds);
        this.batchDiscardBoData("hbpm_dutyworkroles", positionIds);
        if (!forModify) {
            this.batchDiscardBoData("hbpm_reportingrelation", relationIds);
        }
    }

    @Override
    public void positionFutureEffect(DynamicObject[] futureVersions) {
        if (futureVersions == null || futureVersions.length == 0) {
            return;
        }
        List<Long> boids = Arrays.stream(futureVersions).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        DynamicObject[] positions = PositionQueryRepository.getInstance().queryPositionsById(boids);
        List<Long> positionIds = Arrays.stream(positions).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        List<Long> workRoleIds = Arrays.stream(positions).map(dyn -> dyn.getLong("workrole.id")).collect(Collectors.toList());
        List<DynamicObject> reportRelations = ReportingrelationQueryRepository.getInstance().queryAllDisableReportRelationAboutDownByIds(new ArrayList<Long>(workRoleIds));
        List<Long> relationIds = reportRelations.stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        HisSyncStatusEntityDataBo posData = this.futureVersionEffect("hbpm_positionhr", positionIds);
        this.futureVersionEffect("hbpm_workroleshr", workRoleIds);
        this.futureVersionEffect("hbpm_dutyworkroles", positionIds);
        this.futureVersionEffect("hbpm_reportingrelation", relationIds);
        if (posData != null && posData.getBoIds() != null && posData.getBoIds().size() > 0) {
            this.businessAfterSavePosition(posData.getBoIds(), futureVersions);
        }
    }

    @Override
    public void positionFutureRevoke(List<Long> boids, boolean forModify) {
        Date date2999 = new HisEffDateCommonService().getDate2999(null);
        DynamicObject[] positions = PositionQueryRepository.getInstance().queryPositionsById(boids);
        ArrayList tochangeList = Lists.newArrayListWithExpectedSize((int)positions.length);
        ArrayList todiscardList = Lists.newArrayListWithExpectedSize((int)positions.length);
        for (DynamicObject position : positions) {
            String datastatus = position.getString("datastatus");
            if (HRStringUtils.equals((String)datastatus, (String)"0")) {
                todiscardList.add(position);
                continue;
            }
            if (!HRStringUtils.equals((String)datastatus, (String)"1")) continue;
            position.set("bsled", (Object)date2999);
            tochangeList.add(position);
        }
        this.revokeVersion(tochangeList);
        this.revokeBO(todiscardList, forModify);
    }

    private void revokeVersion(List<DynamicObject> revokeList) {
        if (CollectionUtils.isEmpty(revokeList)) {
            return;
        }
        this.workRoleServiceApplication.updateWorkRole(revokeList);
        this.dutyWorkRoleServiceApplication.updateDutyRole(revokeList);
        this.reportingRelationServiceApplication.updateSysReportRel(revokeList, EffectiveStatusEnum.CurrentEffective);
        this.positionService.batchChange(revokeList.toArray(new DynamicObject[0]));
    }

    private void revokeBO(List<DynamicObject> revokeList, boolean forModify) {
        if (CollectionUtils.isEmpty(revokeList)) {
            return;
        }
        this.batchDiscardFuturePositionData(revokeList.toArray(new DynamicObject[0]), forModify);
    }

    private HisSyncStatusEntityDataBo futureVersionEffect(String entityNumber, List<Long> toEffectBoId) {
        List allFutureBoList = HisSyncDataStatusRepository.getInstance().getNeedSyncVersion(new HRBaseServiceHelper(entityNumber));
        allFutureBoList.removeAll(toEffectBoId);
        return HisSynDataStatusServicerHelper.processData((String)entityNumber, (List)allFutureBoList, new HashMap());
    }

    private void businessAfterSavePosition(List<Long> successBoIdList, DynamicObject[] futureVersions) {
        ArrayList beforeVidList = Lists.newArrayListWithExpectedSize((int)futureVersions.length);
        ArrayList afterVidList = Lists.newArrayListWithExpectedSize((int)futureVersions.length);
        ArrayList addVidList = Lists.newArrayListWithExpectedSize((int)futureVersions.length);
        for (DynamicObject pos : futureVersions) {
            long boid = pos.getLong("boid");
            long id = pos.getLong("id");
            if (!successBoIdList.contains(boid)) continue;
            DynamicObject changetype = pos.getDynamicObject("changetype");
            long oldId = pos.getLong("sourcevid");
            if (changetype != null && changetype.getLong("id") == 1010L) {
                addVidList.add(id);
            } else if (oldId != 0L) {
                beforeVidList.add(pos.getLong("sourcevid"));
            }
            afterVidList.add(id);
        }
        DynamicObject[] beforeData = PositionQueryRepository.getInstance().queryPositionsById(beforeVidList);
        DynamicObject[] afterData = PositionQueryRepository.getInstance().queryPositionsById(afterVidList);
        this.setFutureEffectChangeProp(afterData);
        ChangeEventServiceImpl changeEventService = new ChangeEventServiceImpl();
        changeEventService.handleChangeEvent("10", beforeData, afterData, null, false, true);
        ArrayList addData = Lists.newArrayListWithExpectedSize((int)addVidList.size());
        ArrayList updateData = Lists.newArrayListWithExpectedSize((int)afterData.length);
        for (DynamicObject dyn : afterData) {
            long id = dyn.getLong("id");
            if (addVidList.contains(id)) {
                addData.add(dyn);
                continue;
            }
            updateData.add(dyn);
        }
        this.darkPositionApplication.maintainDarkPositionRelation(addData, false, false);
        this.darkPositionApplication.maintainDarkPositionRelation(updateData, true, false);
    }

    @Override
    public void setFutureEffectChangeProp(DynamicObject[] position) {
        PositionChangeEventQueryRepository instance = PositionChangeEventQueryRepository.getInstance();
        DynamicObject operationAdd = instance.queryChangeOperation(1010L);
        DynamicObject sceneAdd = instance.queryChangeScene(1010L);
        DynamicObject typeAdd = instance.queryChangeType(1010L);
        DynamicObject operationUpdate = instance.queryChangeOperation(1020L);
        DynamicObject sceneUpdate = instance.queryChangeScene(1020L);
        DynamicObject typeUpdate = instance.queryChangeType(1020L);
        for (DynamicObject pos : position) {
            DynamicObject changetype = pos.getDynamicObject("changetype");
            if (changetype != null && changetype.getLong("id") == 1010L) {
                pos.set("changeoperate", (Object)operationAdd);
                pos.set("changescene", (Object)sceneAdd);
                pos.set("changetype", (Object)typeAdd);
                continue;
            }
            pos.set("changeoperate", (Object)operationUpdate);
            pos.set("changescene", (Object)sceneUpdate);
            pos.set("changetype", (Object)typeUpdate);
        }
    }

    @Override
    public void setMustInputFieldDefaultValue(DynamicObject[] positions) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positiontype");
        DynamicObject positionType = serviceHelper.loadSingle((Object)StandardPositionConstants.POSITION_TYPE_JOB);
        for (DynamicObject position : positions) {
            if (position.containsProperty("issensitive") && HRStringUtils.isEmpty((String)position.getString("issensitive"))) {
                position.set("issensitive", (Object)0);
            }
            if (position.containsProperty("isleader") && HRStringUtils.isEmpty((String)position.getString("isleader"))) {
                position.set("isleader", (Object)2);
            }
            if (!position.containsProperty("positiontype") || position.get("positiontype") != null) continue;
            position.set("positiontype", (Object)positionType);
        }
    }

    @Override
    public void syncPlatFormPosition(DynamicObject[] positions, boolean isReQueryAllField) {
        logger.info("position_syncPlatFormPosition");
        if (positions == null || positions.length == 0) {
            return;
        }
        List<DynamicObject> positionList = this.sortFromHighToLow(positions);
        int size = isReQueryAllField ? 500 : 5000;
        List positionListList = Lists.partition(positionList, (int)size);
        for (List list : positionListList) {
            DynamicObject[] afterPositionDys = isReQueryAllField ? PositionQueryRepository.getInstance().queryPositionsById(list.stream().map(pos -> pos.getLong("boid")).collect(Collectors.toList())) : list.toArray(new DynamicObject[0]);
            IBosPositionService.getInstance().addWaitSyncLogs(null, afterPositionDys);
            IBosPositionService.getInstance().commonSyncPositions();
        }
        logger.info("position_syncPlatFormPosition_end");
    }

    private List<DynamicObject> sortFromHighToLow(DynamicObject[] positions) {
        HashMap posIdToDataMap = Maps.newHashMapWithExpectedSize((int)positions.length);
        HashMap posIdToParentMap = Maps.newHashMapWithExpectedSize((int)positions.length);
        for (DynamicObject pos : positions) {
            posIdToParentMap.put(pos.getLong("boid"), pos.getLong("parent.id"));
            posIdToDataMap.put(pos.getLong("boid"), pos);
        }
        ArrayList sortDataList = Lists.newArrayListWithExpectedSize((int)positions.length);
        for (DynamicObject pos : positions) {
            long posId = pos.getLong("boid");
            this.addDataFromHighToLow(posId, posIdToParentMap, posIdToDataMap, sortDataList);
        }
        return sortDataList;
    }

    private void addDataFromHighToLow(long posId, Map<Long, Long> posParentBoIdMap, Map<Long, DynamicObject> posIdToDataMap, List<DynamicObject> sortDataList) {
        DynamicObject data = posIdToDataMap.get(posId);
        Long parent = posParentBoIdMap.get(posId);
        if (parent == null || parent == 0L) {
            if (!sortDataList.contains(data)) {
                sortDataList.add(data);
            }
            return;
        }
        DynamicObject parentData = posIdToDataMap.get(parent);
        if (parentData == null || sortDataList.contains(parentData)) {
            if (!sortDataList.contains(data)) {
                sortDataList.add(data);
            }
            return;
        }
        this.addDataFromHighToLow(parent, posParentBoIdMap, posIdToDataMap, sortDataList);
        if (!sortDataList.contains(data)) {
            sortDataList.add(data);
        }
    }

    @Override
    public void modifyInitingPosData(List<DynamicObject> positions) {
        if (CollectionUtils.isEmpty(positions)) {
            return;
        }
        HashMap roleIdToNameMap = Maps.newHashMapWithExpectedSize((int)positions.size());
        HashMap posIdToNameMap = Maps.newHashMapWithExpectedSize((int)positions.size());
        ArrayList workroleIdList = Lists.newArrayListWithExpectedSize((int)positions.size());
        ArrayList positionIdList = Lists.newArrayListWithExpectedSize((int)positions.size());
        for (DynamicObject pos : positions) {
            String name = pos.getString("name");
            long workroleId = pos.getLong("workrole.id");
            long boid = pos.getLong("boid");
            roleIdToNameMap.put(workroleId, name);
            posIdToNameMap.put(boid, name);
            workroleIdList.add(workroleId);
            positionIdList.add(boid);
        }
        DynamicObject[] workroles = WorkRoleQueryRepository.getInstance().queryInitWorkRole(workroleIdList);
        DynamicObject[] dutyWorkRoles = DutyWorkRoleQueryRepository.getInstance().queryInitDutyWorkRole(positionIdList);
        Arrays.stream(workroles).forEach(dynamicObject -> dynamicObject.set("name", roleIdToNameMap.get(dynamicObject.getLong("boid"))));
        Arrays.stream(dutyWorkRoles).forEach(dynamicObject -> dynamicObject.set("name", posIdToNameMap.get(dynamicObject.getLong("boid"))));
        this.modifyData("hbpm_positionhr", positions.toArray(new DynamicObject[0]));
        this.modifyData("hbpm_workroleshr", workroles);
        this.modifyData("hbpm_dutyworkroles", dutyWorkRoles);
    }

    private void modifyData(String entityNumber, DynamicObject[] dyns) {
        if (ArrayUtils.isEmpty((Object[])dyns)) {
            return;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        hrBaseServiceHelper.save(dyns);
    }
}

