/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.application.impl.workrole.DutyWorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.ReportingRelationServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.WorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.position.IDarkPositionApplication;
import kd.hrmp.hbpm.business.application.workrole.IDutyWorkRoleServiceApplication;
import kd.hrmp.hbpm.business.application.workrole.IReportingRelationServiceApplication;
import kd.hrmp.hbpm.business.application.workrole.IWorkRoleServiceApplication;
import kd.hrmp.hbpm.business.domain.mservice.HaosMServiceHelper;
import kd.hrmp.hbpm.business.domain.repository.position.MserviceQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.PositionServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IPositionService;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.common.constants.EffectiveStatusEnum;

public class DarkPositionApplicationImpl
implements IDarkPositionApplication {
    private static final Log LOGGER = LogFactory.getLog(DarkPositionApplicationImpl.class);
    private Date date2999 = HisEffDateCommonService.getInstance().getDate2999(null);
    public IDutyWorkRoleServiceApplication dutyWorkRoleServiceApplication = new DutyWorkRoleServiceApplicationImpl();
    public IWorkRoleServiceApplication workRoleServiceApplication = new WorkRoleServiceApplicationImpl();
    public IPositionService positionService = new PositionServiceImpl();
    public IReportingRelationServiceApplication reportingRelationServiceApplication = new ReportingRelationServiceApplicationImpl();

    @Override
    public void disableDarkPosition(List<Long> darkPositionIds) {
        DynamicObject[] positions = this.queryDarkPositions(darkPositionIds);
        DynamicObject[] darkPositions = this.filterDisableDarkPositions(positions);
        if (!PositionUtils.isArrayEmpty(darkPositions).booleanValue()) {
            try (TXHandle required = TX.required();){
                try {
                    List<DynamicObject> deleteDarkPositions = Arrays.stream(darkPositions).filter(darkPosition -> HRStringUtils.equals((String)"10", (String)darkPosition.getString("enable"))).collect(Collectors.toList());
                    List<DynamicObject> disableDarkPositions = Arrays.stream(darkPositions).filter(darkPosition -> HRStringUtils.equals((String)"1", (String)darkPosition.getString("enable"))).collect(Collectors.toList());
                    this.deleteDarkPosition(deleteDarkPositions);
                    this.changeEnableStatus(disableDarkPositions, "disable");
                }
                catch (Exception ex) {
                    required.markRollback();
                    LOGGER.info(ex.getMessage());
                    throw ex;
                }
            }
        }
    }

    @Override
    public void enableDarkPosition(List<Long> darkPositionIds) {
        DynamicObject[] positions = this.queryDarkPositions(darkPositionIds);
        DynamicObject[] darkPositions = this.filterEnableDarkPositions(positions);
        if (!PositionUtils.isArrayEmpty(darkPositions).booleanValue()) {
            try (TXHandle required = TX.required();){
                try {
                    this.changeEnableStatus(Arrays.asList(darkPositions), "enable");
                }
                catch (Exception ex) {
                    required.markRollback();
                    LOGGER.info(ex.getMessage());
                    throw ex;
                }
            }
        }
    }

    @Override
    public void disableDarkPosition(DynamicObject[] darkPositions) {
        if (!PositionUtils.isArrayEmpty(darkPositions).booleanValue()) {
            try (TXHandle required = TX.required();){
                try {
                    List<DynamicObject> deleteDarkPositions = Arrays.stream(darkPositions).filter(darkPosition -> HRStringUtils.equals((String)"10", (String)darkPosition.getString("enable"))).collect(Collectors.toList());
                    List<DynamicObject> disableDarkPositions = Arrays.stream(darkPositions).filter(darkPosition -> HRStringUtils.equals((String)"1", (String)darkPosition.getString("enable"))).collect(Collectors.toList());
                    this.deleteDarkPosition(deleteDarkPositions);
                    this.changeEnableStatus(disableDarkPositions, "disable");
                }
                catch (Exception ex) {
                    required.markRollback();
                    LOGGER.info(ex.getMessage());
                    throw ex;
                }
            }
        }
    }

    @Override
    public void enableDarkPosition(DynamicObject[] darkPositions) {
        if (!PositionUtils.isArrayEmpty(darkPositions).booleanValue()) {
            try (TXHandle required = TX.required();){
                try {
                    this.changeEnableStatus(Arrays.asList(darkPositions), "enable");
                }
                catch (Exception ex) {
                    required.markRollback();
                    LOGGER.info(ex.getMessage());
                    throw ex;
                }
            }
        }
    }

    @Override
    public void deleteDarkPosition(List<DynamicObject> darkPositions) {
        if (CollectionUtils.isEmpty(darkPositions)) {
            return;
        }
        List<Long> ids = darkPositions.stream().map(darkPosition -> darkPosition.getLong("id")).collect(Collectors.toList());
        List<Long> workRoleIds = darkPositions.stream().map(darkPosition -> darkPosition.getLong("workrole.id")).collect(Collectors.toList());
        this.positionService.batchDeleted(ids);
        this.dutyWorkRoleServiceApplication.deleteDutyRoles(ids);
        this.workRoleServiceApplication.deleteWorkRoles(workRoleIds);
        this.reportingRelationServiceApplication.deleteAllReportingRelationByWorkRoles(workRoleIds);
    }

    @Override
    public void updateDarkPosition(List<DynamicObject> darkPositions) {
        if (CollectionUtils.isEmpty(darkPositions)) {
            return;
        }
        this.workRoleServiceApplication.updateWorkRole(darkPositions);
        this.dutyWorkRoleServiceApplication.updateDutyRole(darkPositions);
        this.reportingRelationServiceApplication.updateSysReportRel(darkPositions, EffectiveStatusEnum.CurrentEffective);
        this.positionService.batchChange(darkPositions.toArray(new DynamicObject[0]));
    }

    @Override
    public void maintainDarkPositionRelation(List<DynamicObject> positions, boolean operationChange, boolean handleMemery) {
        HashMap<String, Comparable<Long>> param;
        List<DynamicObject> needChangeDarkPositions;
        if (CollectionUtils.isEmpty(positions = positions.stream().filter(dyn -> HRStringUtils.equals((String)"1", (String)dyn.getString("datastatus"))).collect(Collectors.toList()))) {
            return;
        }
        ArrayList noMainDutyPositions = Lists.newArrayListWithExpectedSize((int)positions.size());
        ArrayList mainDutyPositions = Lists.newArrayListWithExpectedSize((int)positions.size());
        if (operationChange) {
            Map<Long, DynamicObject> positionIdDynMap = positions.stream().collect(Collectors.toMap(dyn -> dyn.getLong("boid"), dyn -> dyn, (v1, v2) -> v1));
            ArrayList<Long> positionSourceVids = new ArrayList<Long>(positionIdDynMap.size());
            HashMap<Long, Date> boIdAndBSedMap = new HashMap<Long, Date>(positionIdDynMap.size());
            for (DynamicObject pos2 : positionIdDynMap.values()) {
                if (pos2.getLong("sourcevid") != 0L) {
                    positionSourceVids.add(pos2.getLong("sourcevid"));
                    continue;
                }
                boIdAndBSedMap.put(pos2.getLong("boid"), pos2.getDate("bsed"));
            }
            DynamicObject[] prePositionFromDB = PositionQueryRepository.getInstance().queryPositionInfoBySourceVid(positionSourceVids);
            Map<Long, DynamicObject> donePrePositionIdDynFromDBMap = Arrays.asList(prePositionFromDB).stream().collect(Collectors.toMap(pos -> pos.getLong("boid"), pos -> pos));
            Iterator noPrePositionIdDynFromDBMap = PositionQueryRepository.getInstance().queryPositionHisVersionBSled(boIdAndBSedMap);
            HashMap<Long, DynamicObject> prePositionIdDynFromDBMap = new HashMap<Long, DynamicObject>(16);
            if (donePrePositionIdDynFromDBMap != null) {
                prePositionIdDynFromDBMap.putAll(donePrePositionIdDynFromDBMap);
            }
            if (noPrePositionIdDynFromDBMap != null) {
                prePositionIdDynFromDBMap.putAll((Map<Long, DynamicObject>)((Object)noPrePositionIdDynFromDBMap));
            }
            ArrayList<DynamicObject> needChangePositions = new ArrayList<DynamicObject>(positions.size());
            for (Map.Entry<Long, DynamicObject> positionIdDyn : positionIdDynMap.entrySet()) {
                DynamicObject noPrePositionIdDynFromDB;
                DynamicObject donePrePositionIdDynFromDB;
                DynamicObject prePositionIdDynFromDB = (DynamicObject)prePositionIdDynFromDBMap.get(positionIdDyn.getKey());
                if (prePositionIdDynFromDB == null) continue;
                if (donePrePositionIdDynFromDBMap != null && (donePrePositionIdDynFromDB = donePrePositionIdDynFromDBMap.get(prePositionIdDynFromDB.getLong("boid"))) != null && this.date2999.equals(positionIdDyn.getValue().getDate("bsled"))) {
                    needChangePositions.add(positionIdDyn.getValue());
                    this.judgeIsLeader(noMainDutyPositions, mainDutyPositions, positionIdDyn, prePositionIdDynFromDB);
                }
                if (noPrePositionIdDynFromDBMap == null || (noPrePositionIdDynFromDB = (DynamicObject)noPrePositionIdDynFromDBMap.get(prePositionIdDynFromDB.getLong("boid"))) == null || !noPrePositionIdDynFromDB.getString("datastatus").equals("1")) continue;
                needChangePositions.add(positionIdDyn.getValue());
                this.judgeIsLeader(noMainDutyPositions, mainDutyPositions, positionIdDyn, prePositionIdDynFromDB);
            }
            positions = needChangePositions;
        } else {
            positions = positions.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(p -> p.getLong("boid")))), ArrayList::new));
        }
        Set<Long> orgIds = this.getPositionAdminOrgIds(positions);
        HashMap<Long, DynamicObject> noMainDutyPositionIdDynMap = new HashMap(noMainDutyPositions.size());
        if (!noMainDutyPositions.isEmpty()) {
            noMainDutyPositionIdDynMap = this.getNoMainDutyPositionIds(noMainDutyPositions);
        }
        Map<Object, Object> orgPositionsFromMemory = Maps.newHashMapWithExpectedSize((int)positions.size());
        if (handleMemery) {
            orgPositionsFromMemory = this.getOrgIdToPositions(positions);
        }
        if (!CollectionUtils.isEmpty(needChangeDarkPositions = this.getNeedChangeDarkPositions(orgIds, noMainDutyPositionIdDynMap, orgPositionsFromMemory))) {
            this.updateDarkPosition(needChangeDarkPositions);
        }
        ArrayList params = new ArrayList(noMainDutyPositions.size() + mainDutyPositions.size());
        if (!noMainDutyPositions.isEmpty()) {
            for (DynamicObject noMainDutyPosition : noMainDutyPositions) {
                param = new HashMap<String, Comparable<Long>>(16);
                param.put("positionId", Long.valueOf(noMainDutyPosition.getLong("boid")));
                param.put("effdt", noMainDutyPosition.getDate("bsed"));
                param.put("isleader", Boolean.valueOf(false));
                params.add(param);
            }
        }
        if (!mainDutyPositions.isEmpty()) {
            for (DynamicObject mainDutyPosition : mainDutyPositions) {
                param = new HashMap(16);
                param.put("positionId", Long.valueOf(mainDutyPosition.getLong("boid")));
                param.put("effdt", mainDutyPosition.getDate("bsed"));
                param.put("isleader", Boolean.valueOf(true));
                params.add(param);
            }
        }
        LOGGER.info("invoke mservice setChargePersonByPosition and params is {}", params);
        try {
            HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIChargeService", (String)"setChargePersonByPosition", (Object[])new Object[]{params});
        }
        catch (Exception ignored) {
            LOGGER.info("setChargePersonByPosition_error");
        }
    }

    private void judgeIsLeader(List<DynamicObject> noMainDutyPositions, List<DynamicObject> mainDutyPositions, Map.Entry<Long, DynamicObject> positionIdDyn, DynamicObject prePositionIdDynFromDB) {
        String isLeader;
        String isLeaderDB = prePositionIdDynFromDB.getString("isleader");
        if (!isLeaderDB.equals(isLeader = positionIdDyn.getValue().getString("isleader"))) {
            if (isLeader.equals("2")) {
                noMainDutyPositions.add(positionIdDyn.getValue());
            } else if (isLeader.equals("1")) {
                mainDutyPositions.add(positionIdDyn.getValue());
            }
        }
    }

    @Override
    public void clearDarkPositionRelation(Set<Long> orgIds, Map<Long, DynamicObject> mainDutyPosition, List<DynamicObject> darkPositions) {
        if (orgIds == null || orgIds.isEmpty()) {
            return;
        }
        Map<Long, List<DynamicObject>> orgUnderMainDutyPositionMap = this.getOrgUnderMainDutyPositions(orgIds, null);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        for (DynamicObject darkPosition : darkPositions) {
            List<Object> orgUnderMainDutyPositions = new ArrayList(10);
            if ("1".equals(darkPosition.getString("isleader"))) {
                Long darkPositionParentId = darkPosition.getLong("parent.id");
                DynamicObject darkPositionParent = mainDutyPosition.get(darkPositionParentId);
                if (darkPositionParent != null) {
                    orgUnderMainDutyPositions = orgUnderMainDutyPositionMap.get(darkPositionParent.getLong("adminorg.id"));
                }
            } else {
                orgUnderMainDutyPositions = orgUnderMainDutyPositionMap.get(darkPosition.getLong("adminorg.id"));
            }
            darkPosition.set("bsed", (Object)new Date());
            if (!CollectionUtils.isEmpty(orgUnderMainDutyPositions) && orgUnderMainDutyPositions.size() == 1) {
                darkPosition.set("parent", orgUnderMainDutyPositions.get(0));
                darkPosition.set("parent.id", (Object)((DynamicObject)orgUnderMainDutyPositions.get(0)).getLong("boid"));
                darkPosition.set("parent_id", (Object)((DynamicObject)orgUnderMainDutyPositions.get(0)).getLong("boid"));
                continue;
            }
            darkPosition.set("parent", null);
        }
        result.addAll(darkPositions);
        this.handleDiscreteDarkPos(result, null, new ArrayList<Long>(orgIds), orgUnderMainDutyPositionMap);
        this.handleSubOrgMainDutyPos(orgIds, orgUnderMainDutyPositionMap, null, result);
        this.updateDarkPosition(result);
    }

    @Override
    public void fixDarkPositionRelation(Set<Long> orgIds) {
        if (orgIds == null || orgIds.isEmpty()) {
            return;
        }
        Map<Long, List<DynamicObject>> orgUnderMainDutyPositionMap = this.getOrgUnderMainDutyPositions(orgIds, null);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        this.handleDiscreteDarkPos(result, null, new ArrayList<Long>(orgIds), orgUnderMainDutyPositionMap);
        this.handleSubOrgMainDutyPos(orgIds, orgUnderMainDutyPositionMap, null, result);
        this.updateDarkPosition(result);
    }

    private Set<Long> getPositionAdminOrgIds(List<DynamicObject> positions) {
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }
        return positions.stream().map(dynamicObject -> dynamicObject.getLong("adminorg.id")).collect(Collectors.toSet());
    }

    private Map<Long, DynamicObject> getNoMainDutyPositionIds(List<DynamicObject> positions) {
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }
        return positions.stream().collect(Collectors.toMap(position -> position.getLong("boid"), position -> position));
    }

    private Map<Long, List<DynamicObject>> getOrgIdToPositions(List<DynamicObject> positions) {
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }
        HashMap<Long, List<DynamicObject>> orgPositionsFromMemory = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject position : positions) {
            List mainDutyPositions = orgPositionsFromMemory.computeIfAbsent(position.getLong("adminorg.id"), k -> new ArrayList());
            mainDutyPositions.add(position);
        }
        return orgPositionsFromMemory;
    }

    private List<DynamicObject> getNeedChangeDarkPositions(Set<Long> orgIds, Map<Long, DynamicObject> noMainDutyPositionIdDynMap, Map<Long, List<DynamicObject>> orgPositionsFromMemory) {
        if (orgIds == null || orgIds.isEmpty()) {
            return null;
        }
        Map<Long, List<DynamicObject>> orgUnderMainDutyPositionMap = this.getOrgUnderMainDutyPositions(orgIds, orgPositionsFromMemory);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        if (noMainDutyPositionIdDynMap != null && noMainDutyPositionIdDynMap.size() != 0) {
            List<DynamicObject> darkPositions = PositionQueryRepository.getInstance().queryDarkPositionByPositionBoIds(new ArrayList<Long>(noMainDutyPositionIdDynMap.keySet()));
            for (DynamicObject darkPosition : darkPositions) {
                List<Object> orgUnderMainDutyPositions = new ArrayList(10);
                if ("1".equals(darkPosition.getString("isleader"))) {
                    DynamicObject parentPos = darkPosition.getDynamicObject("parent");
                    if (parentPos != null) {
                        orgUnderMainDutyPositions = orgUnderMainDutyPositionMap.get(parentPos.getLong("adminorg.id"));
                    }
                } else {
                    orgUnderMainDutyPositions = orgUnderMainDutyPositionMap.get(darkPosition.getLong("adminorg.id"));
                }
                DynamicObject noMainDutyPosition = noMainDutyPositionIdDynMap.get(darkPosition.getLong("parent.id"));
                if (noMainDutyPosition != null) {
                    this.compareDateAndSet(darkPosition, noMainDutyPosition);
                }
                if (!CollectionUtils.isEmpty(orgUnderMainDutyPositions) && orgUnderMainDutyPositions.size() == 1) {
                    darkPosition.set("parent", orgUnderMainDutyPositions.get(0));
                    darkPosition.set("parent.id", (Object)((DynamicObject)orgUnderMainDutyPositions.get(0)).getLong("boid"));
                    darkPosition.set("parent_id", (Object)((DynamicObject)orgUnderMainDutyPositions.get(0)).getLong("boid"));
                    continue;
                }
                darkPosition.set("parent", null);
            }
            result.addAll(darkPositions);
        }
        this.handleDiscreteDarkPos(result, null, new ArrayList<Long>(orgIds), orgUnderMainDutyPositionMap);
        this.handleSubOrgMainDutyPos(orgIds, orgUnderMainDutyPositionMap, null, result);
        return result;
    }

    private void handleDiscreteDarkPos(List<DynamicObject> result, List<DynamicObject> discreteDarkPositionsInMemory, List<Long> orgIds, Map<Long, List<DynamicObject>> orgUnderMainDutyPositionMap) {
        Map<Long, List<DynamicObject>> orgIdToDarkPositionMap = PositionQueryRepository.getInstance().queryDarkPositionByAdminOrgBoId(orgIds);
        Map<Object, Object> orgIdToDiscreteDarkPositionMap = new HashMap(16);
        if (discreteDarkPositionsInMemory != null && !discreteDarkPositionsInMemory.isEmpty()) {
            orgIdToDiscreteDarkPositionMap = discreteDarkPositionsInMemory.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("adminorg.id")));
        }
        for (Map.Entry<Long, List<DynamicObject>> entry : orgUnderMainDutyPositionMap.entrySet()) {
            Long orgId = entry.getKey();
            List<DynamicObject> mainDutyPositions = entry.getValue();
            Map<Object, Object> mainDutyPositionIdMap = Maps.newHashMapWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty(mainDutyPositions)) {
                mainDutyPositionIdMap = mainDutyPositions.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("id")));
            }
            List<DynamicObject> orgIdToDarkPositions = orgIdToDarkPositionMap.get(orgId);
            List orgIdToDiscreteDarkPositions = (List)orgIdToDiscreteDarkPositionMap.get(orgId);
            Map<Object, Object> orgIdToDiscreteDarkPositionIdMap = Maps.newHashMapWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty((Collection)orgIdToDiscreteDarkPositions)) {
                orgIdToDiscreteDarkPositionIdMap = orgIdToDiscreteDarkPositions.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("id")));
            }
            if (!CollectionUtils.isEmpty(orgIdToDarkPositions)) {
                for (DynamicObject darkPosition : orgIdToDarkPositions) {
                    if (mainDutyPositionIdMap.containsKey(darkPosition.getLong("id")) || orgIdToDiscreteDarkPositionIdMap.containsKey(darkPosition.getLong("id")) || CollectionUtils.isEmpty(mainDutyPositions) || mainDutyPositions.size() != 1) continue;
                    this.compareDateAndSet(darkPosition, mainDutyPositions.get(0));
                    darkPosition.set("parent", (Object)mainDutyPositions.get(0));
                    darkPosition.set("parent.id", (Object)mainDutyPositions.get(0).getLong("boid"));
                    darkPosition.set("parent_id", (Object)mainDutyPositions.get(0).getLong("boid"));
                    result.add(darkPosition);
                }
            }
            if (CollectionUtils.isEmpty((Collection)orgIdToDiscreteDarkPositions)) continue;
            for (DynamicObject darkPosition : orgIdToDiscreteDarkPositions) {
                if (!CollectionUtils.isEmpty(mainDutyPositions) && mainDutyPositions.size() == 1) {
                    this.compareDateAndSet(darkPosition, mainDutyPositions.get(0));
                    darkPosition.set("parent", (Object)mainDutyPositions.get(0));
                    darkPosition.set("parent.id", (Object)mainDutyPositions.get(0).getLong("boid"));
                    darkPosition.set("parent_id", (Object)mainDutyPositions.get(0).getLong("boid"));
                }
                result.add(darkPosition);
            }
        }
    }

    private void handleDiscreteDarkPosV2(List<DynamicObject> result, List<Long> orgIds, List<DynamicObject> mainDutyPositions) {
        Map<Long, List<DynamicObject>> orgIdToDarkPositionMap = PositionQueryRepository.getInstance().queryDarkPositionByAdminOrgBoId(orgIds);
        for (Map.Entry<Long, List<DynamicObject>> orgDarkPositions : orgIdToDarkPositionMap.entrySet()) {
            for (DynamicObject orgDarkPosition : orgDarkPositions.getValue()) {
                this.compareDateAndSet(orgDarkPosition, mainDutyPositions.get(0));
                orgDarkPosition.set("parent", (Object)mainDutyPositions.get(0));
                orgDarkPosition.set("parent.id", (Object)mainDutyPositions.get(0).getLong("boid"));
                orgDarkPosition.set("parent_id", (Object)mainDutyPositions.get(0).getLong("boid"));
                result.add(orgDarkPosition);
            }
        }
    }

    private void handleSubOrgMainDutyPos(Set<Long> orgIds, Map<Long, List<DynamicObject>> orgUnderMainDutyPositionMap, DynamicObject[] subMainDutyDarkPositionsInMemory, List<DynamicObject> result) {
        List<Map<String, Long>> subOrgList = MserviceQueryRepository.getInstance().querySubOrgBylevel(new ArrayList<Long>(orgIds), new Date(), 1);
        Map<Long, Long> subOrgToOrgMap = subOrgList.stream().collect(Collectors.toMap(subOrg -> (Long)subOrg.get("orgId"), subOrg -> (Long)subOrg.get("parentOrgId")));
        Map<Long, List<DynamicObject>> suborgToMainDutyDarkPositionMap = PositionQueryRepository.getInstance().queryMainDutyDarkPositionByAdminOrgBoId(subOrgToOrgMap.keySet(), true);
        if (subMainDutyDarkPositionsInMemory != null) {
            for (DynamicObject subMainDutyDarkPosition : subMainDutyDarkPositionsInMemory) {
                Long parentOrgId = subOrgToOrgMap.get(subMainDutyDarkPosition.getLong("adminorg.id"));
                List<DynamicObject> mainDutyPositions = orgUnderMainDutyPositionMap.get(parentOrgId);
                if (!CollectionUtils.isEmpty(mainDutyPositions) && mainDutyPositions.size() == 1) {
                    this.compareDateAndSet(subMainDutyDarkPosition, mainDutyPositions.get(0));
                    subMainDutyDarkPosition.set("parent", (Object)mainDutyPositions.get(0));
                    subMainDutyDarkPosition.set("parent.id", (Object)mainDutyPositions.get(0).getLong("boid"));
                    subMainDutyDarkPosition.set("parent_id", (Object)mainDutyPositions.get(0).getLong("boid"));
                }
                result.add(subMainDutyDarkPosition);
            }
        }
        for (Map.Entry entry : suborgToMainDutyDarkPositionMap.entrySet()) {
            Long parentOrgId = subOrgToOrgMap.get(entry.getKey());
            List<DynamicObject> mainDutyPositions = orgUnderMainDutyPositionMap.get(parentOrgId);
            if (CollectionUtils.isEmpty(mainDutyPositions) || mainDutyPositions.size() != 1) continue;
            for (DynamicObject suborgMainDutyDarkPosition : (List)entry.getValue()) {
                this.compareDateAndSet(suborgMainDutyDarkPosition, mainDutyPositions.get(0));
                suborgMainDutyDarkPosition.set("parent", (Object)mainDutyPositions.get(0));
                suborgMainDutyDarkPosition.set("parent.id", (Object)mainDutyPositions.get(0).getLong("boid"));
                suborgMainDutyDarkPosition.set("parent_id", (Object)mainDutyPositions.get(0).getLong("boid"));
                result.add(suborgMainDutyDarkPosition);
            }
        }
    }

    private void handleSubOrgMainDutyPosV2(Set<Long> orgIds, List<DynamicObject> mainDutyPositions, List<DynamicObject> result) {
        List<Map<String, Long>> subOrgList = MserviceQueryRepository.getInstance().querySubOrgBylevel(new ArrayList<Long>(orgIds), new Date(), 1);
        Map<Long, Long> subOrgToOrgMap = subOrgList.stream().collect(Collectors.toMap(subOrg -> (Long)subOrg.get("orgId"), subOrg -> (Long)subOrg.get("parentOrgId")));
        Map<Long, List<DynamicObject>> suborgToMainDutyDarkPositionMap = PositionQueryRepository.getInstance().queryMainDutyDarkPositionByAdminOrgBoId(subOrgToOrgMap.keySet(), true);
        for (Map.Entry<Long, List<DynamicObject>> suborgMainDutyDarkPositions : suborgToMainDutyDarkPositionMap.entrySet()) {
            for (DynamicObject suborgMainDutyDarkPosition : suborgMainDutyDarkPositions.getValue()) {
                if (mainDutyPositions.get(0).getLong("boid") == suborgMainDutyDarkPosition.getLong("boid")) continue;
                this.compareDateAndSet(suborgMainDutyDarkPosition, mainDutyPositions.get(0));
                suborgMainDutyDarkPosition.set("parent", (Object)mainDutyPositions.get(0));
                suborgMainDutyDarkPosition.set("parent.id", (Object)mainDutyPositions.get(0).getLong("boid"));
                suborgMainDutyDarkPosition.set("parent_id", (Object)mainDutyPositions.get(0).getLong("boid"));
                result.add(suborgMainDutyDarkPosition);
            }
        }
    }

    private void compareDateAndSet(DynamicObject targetPosition, DynamicObject originPosition) {
        Date targetPositionBsed;
        Date originPositionBsed = originPosition.getDate("bsed");
        Date besd = originPositionBsed.after(targetPositionBsed = targetPosition.getDate("bsed")) ? originPositionBsed : targetPositionBsed;
        targetPosition.set("bsed", (Object)besd);
    }

    private Map<Long, List<DynamicObject>> getOrgUnderMainDutyPositions(Set<Long> orgIds, Map<Long, List<DynamicObject>> orgPositionsFromMemory) {
        if (orgIds == null || orgIds.isEmpty()) {
            return new HashMap<Long, List<DynamicObject>>(16);
        }
        HashMap orgUnderMainDutyPositions = Maps.newHashMapWithExpectedSize((int)orgIds.size());
        Map<Long, List<DynamicObject>> orgMainDutyPositionsFromDB = PositionQueryRepository.getInstance().queryMainDutyPositionByAdminOrgBoId(orgIds);
        if (orgPositionsFromMemory == null || orgPositionsFromMemory.isEmpty()) {
            if (CollectionUtils.isEmpty(orgMainDutyPositionsFromDB)) {
                return new HashMap<Long, List<DynamicObject>>(16);
            }
            return orgMainDutyPositionsFromDB;
        }
        for (Long orgId : orgIds) {
            List<DynamicObject> mainDutyPositionsFromDB;
            List<DynamicObject> positionsFromMemory = orgPositionsFromMemory.get(orgId);
            List<DynamicObject> orgMainDutyPositions = this.getOrgMainDutyPositions(positionsFromMemory, mainDutyPositionsFromDB = orgMainDutyPositionsFromDB.get(orgId));
            if (CollectionUtils.isEmpty(orgMainDutyPositions)) continue;
            orgUnderMainDutyPositions.put(orgId, orgMainDutyPositions);
        }
        return orgUnderMainDutyPositions;
    }

    private List<DynamicObject> getOrgMainDutyPositions(List<DynamicObject> positionsFromMemory, List<DynamicObject> mainDutyPositionsFromDB) {
        if (CollectionUtils.isEmpty(positionsFromMemory)) {
            return mainDutyPositionsFromDB;
        }
        if (CollectionUtils.isEmpty(mainDutyPositionsFromDB)) {
            return positionsFromMemory.stream().filter(position -> "1".equals(position.getString("isleader"))).collect(Collectors.toList());
        }
        HashMap<Long, DynamicObject> boIdToPosMap = new HashMap<Long, DynamicObject>(mainDutyPositionsFromDB.size());
        for (DynamicObject mainDutyPosition : mainDutyPositionsFromDB) {
            boIdToPosMap.put(mainDutyPosition.getLong("boid"), mainDutyPosition);
        }
        for (DynamicObject memoryPos : positionsFromMemory) {
            if (!"1".equals(memoryPos.getString("isleader"))) continue;
            boIdToPosMap.put(memoryPos.getLong("boid"), memoryPos);
        }
        return new ArrayList<DynamicObject>(boIdToPosMap.values());
    }

    /*
     * WARNING - void declaration
     */
    private void changeEnableStatus(List<DynamicObject> darkPositions, String enable) {
        if (CollectionUtils.isEmpty(darkPositions)) {
            return;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        Date now = new Date();
        ArrayList<DynamicObject> mianDutyDarkPositions = new ArrayList<DynamicObject>(darkPositions.size());
        ArrayList<DynamicObject> noDutyDarkPositions = new ArrayList<DynamicObject>(darkPositions.size());
        ArrayList<Long> orgIds = new ArrayList<Long>(darkPositions.size());
        ArrayList<Long> mainDutyOrgIds = new ArrayList<Long>(darkPositions.size());
        ArrayList<Long> mainDutyPosIds = new ArrayList<Long>(darkPositions.size());
        for (DynamicObject dynamicObject : darkPositions) {
            if ("1".equals(dynamicObject.getString("isleader"))) {
                mianDutyDarkPositions.add(dynamicObject);
                mainDutyPosIds.add(dynamicObject.getLong("id"));
                mainDutyOrgIds.add(dynamicObject.getLong("adminorg.id"));
            } else if ("2".equals(dynamicObject.getString("isleader"))) {
                noDutyDarkPositions.add(dynamicObject);
            }
            orgIds.add(dynamicObject.getLong("adminorg.id"));
        }
        Map<Long, List<DynamicObject>> orgUnderMainDutyPositionMap = this.getOrgUnderMainDutyPositions(new HashSet<Long>(orgIds), Maps.newHashMapWithExpectedSize((int)8));
        if ("enable".equals(enable)) {
            for (DynamicObject dynamicObject : mianDutyDarkPositions) {
                List<DynamicObject> orgUnderMainDutyPositions = orgUnderMainDutyPositionMap.get(dynamicObject.getLong("adminorg.id"));
                if (orgUnderMainDutyPositions == null) {
                    orgUnderMainDutyPositions = new ArrayList<DynamicObject>(10);
                    orgUnderMainDutyPositions.add(dynamicObject);
                    orgUnderMainDutyPositionMap.put(dynamicObject.getLong("adminorg.id"), orgUnderMainDutyPositions);
                    continue;
                }
                orgUnderMainDutyPositions.add(dynamicObject);
            }
            HashMap<Long, Long> hashMap = new HashMap<Long, Long>(mainDutyOrgIds.size());
            Map<String, Map<String, Object>> map = HaosMServiceHelper.haosAdminOrgStructQuery(mainDutyOrgIds, new Date(), false);
            for (Map.Entry entry : map.entrySet()) {
                Map adminOrgStructValue = (Map)entry.getValue();
                hashMap.put((Long)adminOrgStructValue.get("boid"), (Long)adminOrgStructValue.get("parentorg"));
            }
            Map<Long, List<DynamicObject>> parentOrgUnderMainDutyPositionMap = this.getOrgUnderMainDutyPositions(new HashSet<Long>(hashMap.values()), Maps.newHashMapWithExpectedSize((int)8));
            for (DynamicObject mianDutyDarkPosition : mianDutyDarkPositions) {
                mianDutyDarkPosition.set("changetype", (Object)1020L);
                mianDutyDarkPosition.set("enable", (Object)"1");
                mianDutyDarkPosition.set("enabler", (Object)RequestContext.get().getCurrUserId());
                mianDutyDarkPosition.set("enabledate", (Object)now);
                mianDutyDarkPosition.set("bsed", (Object)now);
                List<DynamicObject> parentOrgUnderMainDutyPositions = parentOrgUnderMainDutyPositionMap.get(hashMap.get(mianDutyDarkPosition.getLong("adminorg.id")));
                if (!CollectionUtils.isEmpty(parentOrgUnderMainDutyPositions) && parentOrgUnderMainDutyPositions.size() == 1) {
                    this.compareDateAndSet(mianDutyDarkPosition, parentOrgUnderMainDutyPositions.get(0));
                    mianDutyDarkPosition.set("parent", (Object)parentOrgUnderMainDutyPositions.get(0));
                    mianDutyDarkPosition.set("parent.id", (Object)parentOrgUnderMainDutyPositions.get(0).getLong("boid"));
                    mianDutyDarkPosition.set("parent_id", (Object)parentOrgUnderMainDutyPositions.get(0).getLong("boid"));
                }
                result.add(mianDutyDarkPosition);
            }
            for (DynamicObject darkPosition : noDutyDarkPositions) {
                darkPosition.set("changetype", (Object)1020L);
                darkPosition.set("enable", (Object)"1");
                darkPosition.set("enabler", (Object)RequestContext.get().getCurrUserId());
                darkPosition.set("enabledate", (Object)now);
                darkPosition.set("bsed", (Object)now);
            }
            this.handleDiscreteDarkPos(result, noDutyDarkPositions, orgIds, orgUnderMainDutyPositionMap);
            this.handleSubOrgMainDutyPos(new HashSet<Long>(orgIds), orgUnderMainDutyPositionMap, null, result);
        } else if ("disable".equals(enable)) {
            DynamicObject[] dynamicObjectArray;
            void var14_33;
            DynamicObject[] dynamicObjectArray2;
            for (DynamicObject dynamicObject : darkPositions) {
                dynamicObject.set("changetype", (Object)1020L);
                dynamicObject.set("enable", (Object)"0");
                dynamicObject.set("disabler", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("disabledate", (Object)now);
                dynamicObject.set("bsed", (Object)now);
                dynamicObject.set("parent", null);
                result.add(dynamicObject);
            }
            for (DynamicObject dynamicObject : mianDutyDarkPositions) {
                List<DynamicObject> orgUnderMainDutyPositions = orgUnderMainDutyPositionMap.get(dynamicObject.getLong("adminorg.id"));
                if (CollectionUtils.isEmpty(orgUnderMainDutyPositions)) continue;
                Iterator<DynamicObject> iterator = orgUnderMainDutyPositions.iterator();
                while (iterator.hasNext()) {
                    DynamicObject orgUnderMainDutyPosition = iterator.next();
                    if (orgUnderMainDutyPosition.getLong("id") != dynamicObject.getLong("id")) continue;
                    iterator.remove();
                }
            }
            DynamicObject[] dynamicObjectArray3 = dynamicObjectArray2 = PositionQueryRepository.getInstance().querySubDarkPositions(mainDutyPosIds);
            int n = dynamicObjectArray3.length;
            boolean bl = false;
            while (var14_33 < n) {
                DynamicObject subDarkPosition = dynamicObjectArray3[var14_33];
                subDarkPosition.set("bsed", (Object)now);
                subDarkPosition.set("parent", null);
                ++var14_33;
            }
            this.handleDiscreteDarkPos(result, Arrays.asList(dynamicObjectArray2), orgIds, orgUnderMainDutyPositionMap);
            for (DynamicObject subMainDutyDarkPosition : dynamicObjectArray = PositionQueryRepository.getInstance().querySubMainDutyDarkPositions(mainDutyPosIds)) {
                subMainDutyDarkPosition.set("bsed", (Object)now);
                subMainDutyDarkPosition.set("parent", null);
            }
            this.handleSubOrgMainDutyPos(new HashSet<Long>(orgIds), orgUnderMainDutyPositionMap, dynamicObjectArray, result);
        }
        this.updateDarkPosition(result);
    }

    private DynamicObject[] queryDarkPositions(List<Long> darkPositionIds) {
        if (CollectionUtils.isEmpty(darkPositionIds)) {
            return null;
        }
        return PositionQueryRepository.getInstance().queryDarkPositionById(darkPositionIds);
    }

    private DynamicObject[] filterDisableDarkPositions(DynamicObject[] darkPositions) {
        if (PositionUtils.isArrayEmpty(darkPositions).booleanValue()) {
            return darkPositions;
        }
        return (DynamicObject[])Arrays.stream(darkPositions).filter(darkPosition -> !HRStringUtils.equals((String)"0", (String)darkPosition.getString("enable"))).toArray(DynamicObject[]::new);
    }

    private DynamicObject[] filterEnableDarkPositions(DynamicObject[] darkPositions) {
        if (PositionUtils.isArrayEmpty(darkPositions).booleanValue()) {
            return darkPositions;
        }
        return (DynamicObject[])Arrays.stream(darkPositions).filter(darkPosition -> HRStringUtils.equals((String)"0", (String)darkPosition.getString("enable"))).toArray(DynamicObject[]::new);
    }

    @Override
    public void handleLeaderDardPositionUpReport(Long orgId, Date bsed) {
        try (TXHandle txHandle = TX.required();){
            Map<Long, List<DynamicObject>> orgToMainDutyDarkPositionMap = PositionQueryRepository.getInstance().queryMainDutyDarkPositionByAdminOrgBoId(Collections.singletonList(orgId), false);
            if (orgToMainDutyDarkPositionMap == null) {
                LOGGER.info("orgToMainDutyDarkPositionMap_isEmpty");
                return;
            }
            try {
                List<DynamicObject> mainDutyDarkPositionList = orgToMainDutyDarkPositionMap.getOrDefault(orgId, Lists.newArrayListWithExpectedSize((int)8));
                ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
                List<Long> orgIds = Collections.singletonList(orgId);
                HashMap<Long, Long> orgToParentOrgMap = new HashMap<Long, Long>(orgIds.size());
                Map<String, Map<String, Object>> adminOrgStructMap = HaosMServiceHelper.haosAdminOrgStructQuery(new ArrayList<Long>(orgIds), new Date(), false);
                for (Map.Entry<String, Map<String, Object>> adminOrgStruct : adminOrgStructMap.entrySet()) {
                    Map<String, Object> adminOrgStructValue = adminOrgStruct.getValue();
                    orgToParentOrgMap.put((Long)adminOrgStructValue.get("boid"), (Long)adminOrgStructValue.get("parentorg"));
                }
                Map<Long, List<DynamicObject>> parentOrgUnderMainDutyPositionMap = this.getOrgUnderMainDutyPositions(new HashSet<Long>(orgToParentOrgMap.values()), Maps.newHashMapWithExpectedSize((int)8));
                for (DynamicObject mianDutyDarkPosition : mainDutyDarkPositionList) {
                    List<DynamicObject> parentOrgUnderMainDutyPositions;
                    boolean changed = false;
                    if (mianDutyDarkPosition.getDynamicObject("parent") != null) {
                        mianDutyDarkPosition.set("parent", null);
                        changed = true;
                    }
                    if (bsed.after(mianDutyDarkPosition.getDate("bsed"))) {
                        mianDutyDarkPosition.set("bsed", (Object)bsed);
                    }
                    if (!CollectionUtils.isEmpty(parentOrgUnderMainDutyPositions = parentOrgUnderMainDutyPositionMap.get(orgToParentOrgMap.get(mianDutyDarkPosition.getLong("adminorg.id")))) && parentOrgUnderMainDutyPositions.size() == 1) {
                        this.compareDateAndSet(mianDutyDarkPosition, parentOrgUnderMainDutyPositions.get(0));
                        mianDutyDarkPosition.set("parent", (Object)parentOrgUnderMainDutyPositions.get(0));
                        mianDutyDarkPosition.set("parent.id", (Object)parentOrgUnderMainDutyPositions.get(0).getLong("boid"));
                        mianDutyDarkPosition.set("parent_id", (Object)parentOrgUnderMainDutyPositions.get(0).getLong("boid"));
                        changed = true;
                    }
                    if (!changed) continue;
                    result.add(mianDutyDarkPosition);
                }
                this.updateDarkPosition(result);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                LOGGER.info(ex.getMessage());
                throw ex;
            }
        }
    }

    @Override
    public void handleDarkPositionToBeLeader(Map<DynamicObject, Date> darkPositionMap) {
        if (darkPositionMap == null || darkPositionMap.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        Set<Long> orgIds = darkPositionMap.keySet().stream().map(pos -> pos.getLong("adminorg.id")).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> orgUnderMainDutyPositionMap = this.getOrgUnderMainDutyPositions(orgIds, Maps.newHashMapWithExpectedSize((int)8));
        for (Map.Entry<DynamicObject, Date> mianDutyDarkPositionEntry : darkPositionMap.entrySet()) {
            DynamicObject mianDutyDarkPosition = mianDutyDarkPositionEntry.getKey();
            List<DynamicObject> list = orgUnderMainDutyPositionMap.get(mianDutyDarkPosition.getLong("adminorg.id"));
            if (list == null) {
                ArrayList<Object> arrayList = new ArrayList<Object>(10);
                arrayList.add(mianDutyDarkPosition);
                orgUnderMainDutyPositionMap.put(mianDutyDarkPosition.getLong("adminorg.id"), arrayList);
                continue;
            }
            list.add(mianDutyDarkPosition);
        }
        HashMap<Long, Long> orgToParentOrgMap = new HashMap<Long, Long>(orgIds.size());
        Map<String, Map<String, Object>> adminOrgStructMap = HaosMServiceHelper.haosAdminOrgStructQuery(new ArrayList<Long>(orgIds), new Date(), false);
        for (Map.Entry entry : adminOrgStructMap.entrySet()) {
            Map adminOrgStructValue = (Map)entry.getValue();
            orgToParentOrgMap.put((Long)adminOrgStructValue.get("boid"), (Long)adminOrgStructValue.get("parentorg"));
        }
        Map<Long, List<DynamicObject>> parentOrgUnderMainDutyPositionMap = this.getOrgUnderMainDutyPositions(new HashSet<Long>(orgToParentOrgMap.values()), Maps.newHashMapWithExpectedSize((int)8));
        for (Map.Entry<DynamicObject, Date> mianDutyDarkPositionEntry : darkPositionMap.entrySet()) {
            List<DynamicObject> parentOrgUnderMainDutyPositions;
            DynamicObject mianDutyDarkPosition = mianDutyDarkPositionEntry.getKey();
            mianDutyDarkPosition.set("isleader", (Object)"1");
            mianDutyDarkPosition.set("parent", null);
            if (mianDutyDarkPositionEntry.getValue().after(mianDutyDarkPosition.getDate("bsed"))) {
                mianDutyDarkPosition.set("bsed", (Object)mianDutyDarkPositionEntry.getValue());
            }
            if (!CollectionUtils.isEmpty(parentOrgUnderMainDutyPositions = parentOrgUnderMainDutyPositionMap.get(orgToParentOrgMap.get(mianDutyDarkPosition.getLong("adminorg.id")))) && parentOrgUnderMainDutyPositions.size() == 1) {
                this.compareDateAndSet(mianDutyDarkPosition, parentOrgUnderMainDutyPositions.get(0));
                mianDutyDarkPosition.set("parent", (Object)parentOrgUnderMainDutyPositions.get(0));
                mianDutyDarkPosition.set("parent.id", (Object)parentOrgUnderMainDutyPositions.get(0).getLong("boid"));
                mianDutyDarkPosition.set("parent_id", (Object)parentOrgUnderMainDutyPositions.get(0).getLong("boid"));
            }
            result.add(mianDutyDarkPosition);
        }
        this.handleDiscreteDarkPos(result, null, new ArrayList<Long>(orgIds), orgUnderMainDutyPositionMap);
        this.handleSubOrgMainDutyPos(new HashSet<Long>(orgIds), orgUnderMainDutyPositionMap, null, result);
        this.updateDarkPosition(result);
    }

    @Override
    public void handleDarkPositionToBeLeaderV2(Map<DynamicObject, Date> darkPositionMap, long adminOrgId) {
        if (darkPositionMap == null || darkPositionMap.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        Set<Long> orgIds = Collections.singleton(adminOrgId);
        ArrayList<DynamicObject> mainDutyPositions = new ArrayList<DynamicObject>(darkPositionMap.size());
        for (Map.Entry<DynamicObject, Date> mianDutyDarkPositionEntry : darkPositionMap.entrySet()) {
            DynamicObject mianDutyDarkPosition = mianDutyDarkPositionEntry.getKey();
            if (mianDutyDarkPosition == null) continue;
            LOGGER.info("handleDarkPositionToBeLeaderV2#setisleader");
            mianDutyDarkPosition.set("isleader", (Object)"1");
            mianDutyDarkPosition.set("parent", null);
            mainDutyPositions.add(mianDutyDarkPosition);
            result.add(mianDutyDarkPosition);
        }
        LOGGER.info("handleDarkPositionToBeLeaderV2#adminOrgId={},mainDutyPositions={}", (Object)adminOrgId, (Object)SerializationUtils.toJsonString(mainDutyPositions));
        this.handleDiscreteDarkPosV2(result, new ArrayList<Long>(orgIds), mainDutyPositions);
        this.handleSubOrgMainDutyPosV2(new HashSet<Long>(orgIds), mainDutyPositions, result);
        LOGGER.info("handleDarkPositionToBeLeaderV2#adminOrgId={},result={}", (Object)adminOrgId, (Object)SerializationUtils.toJsonString(result));
        this.updateDarkPosition(result);
    }

    @Override
    public void cancelMainDutyDarkPosition(Map<DynamicObject, Date> darkPositionMap) {
        DynamicObject[] subMainDutyDarkPositions;
        DynamicObject[] subDarkPositions;
        if (darkPositionMap == null || darkPositionMap.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        HashMap<Long, DynamicObject> mainDutyDarkPositionMap = new HashMap<Long, DynamicObject>(darkPositionMap.size());
        Set<Long> orgIds = darkPositionMap.keySet().stream().map(pos -> pos.getLong("adminorg.id")).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> orgUnderMainDutyPositionMap = this.getOrgUnderMainDutyPositions(orgIds, Maps.newHashMapWithExpectedSize((int)8));
        for (Map.Entry<DynamicObject, Date> entry : darkPositionMap.entrySet()) {
            DynamicObject mianDutyDarkPosition = entry.getKey();
            List<DynamicObject> orgUnderMainDutyPositions = orgUnderMainDutyPositionMap.get(mianDutyDarkPosition.getLong("adminorg.id"));
            if (!CollectionUtils.isEmpty(orgUnderMainDutyPositions)) {
                Iterator<DynamicObject> iterator = orgUnderMainDutyPositions.iterator();
                while (iterator.hasNext()) {
                    DynamicObject orgUnderMainDutyPosition = iterator.next();
                    if (orgUnderMainDutyPosition.getLong("id") != mianDutyDarkPosition.getLong("id")) continue;
                    iterator.remove();
                }
            }
            mianDutyDarkPosition.set("isleader", (Object)"2");
            mianDutyDarkPosition.set("parent", null);
            if (entry.getValue().after(mianDutyDarkPosition.getDate("bsed"))) {
                mianDutyDarkPosition.set("bsed", (Object)entry.getValue());
            }
            mainDutyDarkPositionMap.put(mianDutyDarkPosition.getLong("id"), mianDutyDarkPosition);
        }
        for (DynamicObject subDarkPosition : subDarkPositions = PositionQueryRepository.getInstance().querySubDarkPositions(new ArrayList<Long>(mainDutyDarkPositionMap.keySet()))) {
            DynamicObject parentPosition = (DynamicObject)mainDutyDarkPositionMap.get(subDarkPosition.getLong("parent.id"));
            subDarkPosition.set("parent", null);
            if (!parentPosition.getDate("bsed").after(subDarkPosition.getDate("bsed"))) continue;
            subDarkPosition.set("bsed", (Object)parentPosition.getDate("bsed"));
        }
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(subDarkPositions.length);
        arrayList.addAll(Arrays.asList(subDarkPositions));
        arrayList.addAll(mainDutyDarkPositionMap.values());
        this.handleDiscreteDarkPos(result, arrayList, new ArrayList<Long>(orgIds), orgUnderMainDutyPositionMap);
        for (DynamicObject subMainDutyDarkPosition : subMainDutyDarkPositions = PositionQueryRepository.getInstance().querySubMainDutyDarkPositions(new ArrayList<Long>(mainDutyDarkPositionMap.keySet()))) {
            DynamicObject parentPosition = (DynamicObject)mainDutyDarkPositionMap.get(subMainDutyDarkPosition.getLong("parent.id"));
            subMainDutyDarkPosition.set("parent", null);
            if (!parentPosition.getDate("bsed").after(subMainDutyDarkPosition.getDate("bsed"))) continue;
            subMainDutyDarkPosition.set("bsed", (Object)parentPosition.getDate("bsed"));
        }
        this.handleSubOrgMainDutyPos(new HashSet<Long>(orgIds), orgUnderMainDutyPositionMap, subMainDutyDarkPositions, result);
        this.updateDarkPosition(result);
    }

    @Override
    public void cancelMainDutyDarkPositionV2(Map<DynamicObject, Date> darkPositionMap, long adminOrgId) {
        if (darkPositionMap == null || darkPositionMap.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        HashMap<Long, DynamicObject> mainDutyDarkPositionMap = new HashMap<Long, DynamicObject>(darkPositionMap.size());
        Set<Long> orgIds = Collections.singleton(adminOrgId);
        Map<Long, List<DynamicObject>> orgUnderMainDutyPositionMap = this.getOrgUnderMainDutyPositions(orgIds, Maps.newHashMapWithExpectedSize((int)8));
        for (Map.Entry<DynamicObject, Date> entry : darkPositionMap.entrySet()) {
            DynamicObject mianDutyDarkPosition = entry.getKey();
            LOGGER.info("cancelMainDutyDarkPositionV2#setisleader");
            mianDutyDarkPosition.set("isleader", (Object)"2");
            mianDutyDarkPosition.set("parent", null);
            mainDutyDarkPositionMap.put(mianDutyDarkPosition.getLong("id"), mianDutyDarkPosition);
            result.add(mianDutyDarkPosition);
        }
        LOGGER.info("cancelMainDutyDarkPositionV2#adminOrgId={},orgUnderMainDutyPositionMap.value={},mainDutyDarkPositionMap.keySet={}", new Object[]{adminOrgId, orgUnderMainDutyPositionMap.values(), SerializationUtils.toJsonString(mainDutyDarkPositionMap.keySet())});
        DynamicObject[] subDarkPositions = PositionQueryRepository.getInstance().querySubDarkPositions(new ArrayList<Long>(mainDutyDarkPositionMap.keySet()));
        LOGGER.info("cancelMainDutyDarkPositionV2#adminOrgId={},subDarkPositions.size={}", (Object)adminOrgId, (Object)subDarkPositions.length);
        for (DynamicObject subDarkPosition : subDarkPositions) {
            DynamicObject parentPosition = (DynamicObject)mainDutyDarkPositionMap.get(subDarkPosition.getLong("parent.id"));
            subDarkPosition.set("parent", null);
            if (!parentPosition.getDate("bsed").after(subDarkPosition.getDate("bsed"))) continue;
            subDarkPosition.set("bsed", (Object)parentPosition.getDate("bsed"));
        }
        if (orgUnderMainDutyPositionMap.size() == 1) {
            ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(subDarkPositions.length);
            arrayList.addAll(Arrays.asList(subDarkPositions));
            this.handleDiscreteDarkPos(result, arrayList, new ArrayList<Long>(orgIds), orgUnderMainDutyPositionMap);
        } else {
            result.addAll(Arrays.asList(subDarkPositions));
            LOGGER.info("cancelMainDutyDarkPositionV2#adminOrgId={},result.size={}", (Object)adminOrgId, (Object)result.size());
        }
        DynamicObject[] dynamicObjectArray = PositionQueryRepository.getInstance().querySubMainDutyDarkPositions(new ArrayList<Long>(mainDutyDarkPositionMap.keySet()));
        LOGGER.info("cancelMainDutyDarkPositionV2#adminOrgId={},subMainDutyDarkPositions.size={}", (Object)adminOrgId, (Object)dynamicObjectArray.length);
        for (DynamicObject subMainDutyDarkPosition : dynamicObjectArray) {
            DynamicObject parentPosition = (DynamicObject)mainDutyDarkPositionMap.get(subMainDutyDarkPosition.getLong("parent.id"));
            subMainDutyDarkPosition.set("parent", null);
            if (!parentPosition.getDate("bsed").after(subMainDutyDarkPosition.getDate("bsed"))) continue;
            subMainDutyDarkPosition.set("bsed", (Object)parentPosition.getDate("bsed"));
        }
        if (orgUnderMainDutyPositionMap.size() == 1) {
            this.handleSubOrgMainDutyPos(new HashSet<Long>(orgIds), orgUnderMainDutyPositionMap, dynamicObjectArray, result);
        } else {
            result.addAll(Arrays.asList(dynamicObjectArray));
        }
        this.updateDarkPosition(result);
    }

    public void disableRepeatDarkPos(List<Long> darkPositionIds) {
        if (CollectionUtils.isEmpty(darkPositionIds)) {
            return;
        }
        DynamicObject[] positions = this.queryDarkPositions(darkPositionIds);
        DynamicObject[] darkPositions = this.filterDisableDarkPositions(positions);
        if (!PositionUtils.isArrayEmpty(darkPositions).booleanValue()) {
            try (TXHandle required = TX.required();){
                try {
                    List<DynamicObject> deleteDarkPositions = Arrays.stream(darkPositions).filter(darkPosition -> HRStringUtils.equals((String)"10", (String)darkPosition.getString("enable"))).collect(Collectors.toList());
                    List<DynamicObject> disableDarkPositions = Arrays.stream(darkPositions).filter(darkPosition -> HRStringUtils.equals((String)"1", (String)darkPosition.getString("enable"))).collect(Collectors.toList());
                    this.deleteDarkPosition(deleteDarkPositions);
                    for (DynamicObject darkPosition2 : disableDarkPositions) {
                        darkPosition2.set("changetype", (Object)1020L);
                        darkPosition2.set("enable", (Object)"0");
                        darkPosition2.set("disabler", (Object)RequestContext.get().getCurrUserId());
                        darkPosition2.set("disabledate", (Object)darkPosition2.getDate("bsed"));
                        darkPosition2.set("parent", null);
                    }
                    this.updateDarkPosition(disableDarkPositions);
                }
                catch (Exception ex) {
                    required.markRollback();
                    LOGGER.info(ex.getMessage());
                    throw ex;
                }
            }
        }
    }
}

