/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.position;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.application.impl.position.StandardPositionApplicationImpl;
import kd.hrmp.hbpm.business.application.position.IInitPositionApplication;

public class InitPositionApplicationImpl
implements IInitPositionApplication {
    private static final Log logger = LogFactory.getLog(InitPositionApplicationImpl.class);

    @Override
    public Map<String, Object> refreshInitStatus(Map<String, Object> info) {
        logger.info("darkposition refresh param:{}", info);
        HashMap resultMap = new HashMap();
        String errorMsg = this.checkRequestParam(info);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            return this.buildSuccessResult(201, errorMsg, resultMap);
        }
        long initBatch = (Long)info.get("initbatch");
        String initStatus = (String)info.get("initstatus");
        if (initBatch == 0L) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u521d\u59cb\u5316\u6279\u6b21\u53f7\u201d\uff1b", (String)"InitPositionApplicationImpl_1", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            return this.buildSuccessResult(201, msg, resultMap);
        }
        if (!Arrays.asList("0", "1", "2").contains(initStatus)) {
            String msg = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u72b6\u6001\u503c\u4e0d\u5728\u6709\u6548\u8303\u56f4\u5185\uff1b", (String)"InitPositionApplicationImpl_2", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            return this.buildSuccessResult(201, msg, resultMap);
        }
        logger.info("darkposition refresh_start initbatch:{}, initstatus: {}", (Object)initBatch, (Object)initStatus);
        long startTime = System.currentTimeMillis();
        try (TXHandle required = TX.required();){
            try {
                this.updateInitStatusByInitBatch("hbpm_positionhr", initBatch, initStatus);
                this.updateInitStatusByInitBatch("hbpm_dutyworkroles", initBatch, initStatus);
                this.updateInitStatusByInitBatch("hbpm_workroleshr", initBatch, initStatus);
                this.updateInitStatusByInitBatch("hbpm_reportingrelation", initBatch, initStatus);
            }
            catch (Exception ex) {
                required.markRollback();
                logger.error((Throwable)ex);
                Map<String, Object> map = this.buildSuccessResult(201, ex.getMessage(), null);
                if (required != null) {
                    if (var10_10 != null) {
                        try {
                            required.close();
                        }
                        catch (Throwable throwable) {
                            var10_10.addSuppressed(throwable);
                        }
                    } else {
                        required.close();
                    }
                }
                return map;
            }
        }
        if (HRStringUtils.equals((String)initStatus, (String)"2")) {
            StandardPositionApplicationImpl standardPositionApplication = new StandardPositionApplicationImpl();
            standardPositionApplication.darkstandarpositioncreate(initBatch);
        }
        logger.info("darkposition refresh_end, initbatch:{},total cost time {} ms", (Object)initBatch, (Object)(System.currentTimeMillis() - startTime));
        return this.buildSuccessResult(200, "success", resultMap);
    }

    @Override
    public Map<String, Object> rollbackPosition(long initBatch) {
        logger.info("delete_start initbatch:{}", (Object)initBatch);
        long startTime = System.currentTimeMillis();
        if (initBatch == 0L) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u521d\u59cb\u5316\u6279\u6b21\u53f7\u201d\uff1b", (String)"InitPositionApplicationImpl_1", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            return this.buildSuccessResult(201, msg, initBatch);
        }
        boolean openNewTX = this.isOpenNewTX();
        if (openNewTX) {
            boolean positionDelFail = this.deleteDataByInitBatchInNewTX("hbpm_positionhr", initBatch);
            boolean workroleDelExFail = this.deleteDataByInitBatchInNewTX("hbpm_dutyworkroles", initBatch);
            boolean dutyworkroleDelFail = this.deleteDataByInitBatchInNewTX("hbpm_workroleshr", initBatch);
            boolean relationDelFail = this.deleteDataByInitBatchInNewTX("hbpm_reportingrelation", initBatch);
            if (positionDelFail || workroleDelExFail || dutyworkroleDelFail || relationDelFail) {
                return this.buildSuccessResult(201, "", null);
            }
        } else {
            logger.info("delete_start initbatch:{}", (Object)initBatch);
            try (TXHandle required = TX.requiresNew();){
                try {
                    this.deleteDataByInitBatch("hbpm_positionhr", initBatch);
                    this.deleteDataByInitBatch("hbpm_dutyworkroles", initBatch);
                    this.deleteDataByInitBatch("hbpm_workroleshr", initBatch);
                    this.deleteDataByInitBatch("hbpm_reportingrelation", initBatch);
                }
                catch (Exception ex) {
                    required.markRollback();
                    logger.error((Throwable)ex);
                    Map<String, Object> map = this.buildSuccessResult(201, ex.getMessage(), null);
                    if (required != null) {
                        if (var7_8 != null) {
                            try {
                                required.close();
                            }
                            catch (Throwable throwable) {
                                var7_8.addSuppressed(throwable);
                            }
                        } else {
                            required.close();
                        }
                    }
                    return map;
                }
            }
        }
        logger.info("delete_end, initbatch: {}, total cost time {} ms", (Object)initBatch, (Object)(System.currentTimeMillis() - startTime));
        return this.buildSuccessResult(200, "success", null);
    }

    private String checkRequestParam(Map<String, Object> info) {
        String errorMsg = "";
        if (info == null) {
            errorMsg = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"InitPositionApplicationImpl_3", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            return errorMsg;
        }
        if (!info.containsKey("initbatch")) {
            errorMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u521d\u59cb\u5316\u6279\u6b21\u53f7\u201d\uff1b", (String)"InitPositionApplicationImpl_1", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            return errorMsg;
        }
        if (!info.containsKey("initstatus")) {
            errorMsg = ResManager.loadKDString((String)"\u201c\u521d\u59cb\u5316\u72b6\u6001\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"InitPositionApplicationImpl_4", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            return errorMsg;
        }
        return null;
    }

    private Map<String, Object> buildSuccessResult(int code, String ErrMsg, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", code);
        result.put("ErrMsg", ErrMsg);
        result.put("data", data);
        return result;
    }

    private void updateInitStatusByInitBatch(String entityNumber, long initBatch, String initStatus) {
        logger.info("{} update_start initbatch:{}, initstatus: {}", new Object[]{entityNumber, initBatch, initStatus});
        long startTime = System.currentTimeMillis();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String dbRouteKey = dataEntityType.getDBRouteKey();
        String table = dataEntityType.getAlias();
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(initStatus);
        paramList.add(initBatch);
        String sql = "update " + table + " set finitstatus = ? WHERE finitbatch = ? ";
        HRDBUtil.update((DBRoute)new DBRoute(dbRouteKey), (String)sql, (Object[])paramList.toArray(new Object[]{paramList.size()}));
        logger.info("{} update_end, initbatch: {}, cost time {} ms", new Object[]{entityNumber, initBatch, System.currentTimeMillis() - startTime});
    }

    private boolean deleteDataByInitBatchInNewTX(String entityNumber, long initBatch) {
        logger.info("{} delete_start initbatch:{}", (Object)entityNumber, (Object)initBatch);
        long startTime = System.currentTimeMillis();
        try (TXHandle required = TX.requiresNew();){
            try {
                this.deleteDataByInitBatch(entityNumber, initBatch);
            }
            catch (Exception ex) {
                required.markRollback();
                logger.error((Throwable)ex);
                boolean bl = true;
                if (required != null) {
                    if (var7_5 != null) {
                        try {
                            required.close();
                        }
                        catch (Throwable throwable) {
                            var7_5.addSuppressed(throwable);
                        }
                    } else {
                        required.close();
                    }
                }
                return bl;
            }
        }
        logger.info("{} delete_end, initbatch: {}, cost time {} ms", new Object[]{entityNumber, initBatch, System.currentTimeMillis() - startTime});
        return false;
    }

    private void deleteDataByInitBatch(String entityNumber, long initBatch) {
        logger.info("{} delete_start initbatch:{}", (Object)entityNumber, (Object)initBatch);
        long startTime = System.currentTimeMillis();
        QFilter[] qFilters = new QFilter[]{new QFilter("initbatch", "=", (Object)initBatch)};
        HRBaseServiceHelper eventsumHelper = new HRBaseServiceHelper(entityNumber);
        eventsumHelper.deleteByFilter(qFilters);
        logger.info("{} delete_end, initbatch: {}, cost time {} ms", new Object[]{entityNumber, initBatch, System.currentTimeMillis() - startTime});
    }

    private boolean isOpenNewTX() {
        String param = System.getProperty("openNewTX");
        logger.info("isopenNewTX {}", (Object)param);
        return HRStringUtils.equals((String)"true", (String)param);
    }
}

