/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.position;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.position.IOrgPositionMessageApplication;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.service.position.PositionServiceHelper;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.business.utils.SystemParamHelper;

public class OrgPositionMessageApplicationImpl
implements IOrgPositionMessageApplication {
    private static final Log LOGGER = LogFactory.getLog(OrgPositionMessageApplicationImpl.class);
    private PositionServiceApplicationImpl positionServiceApplication = new PositionServiceApplicationImpl();

    @Override
    public void orgDisablePosition(List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        if (!SystemParamHelper.getOrgPositionDisableParameter()) {
            return;
        }
        DynamicObject[] positionInfos = PositionQueryRepository.getInstance().queryPositionInfoByOrgIds(orgIds);
        if (PositionUtils.isArrayEmpty(positionInfos).booleanValue()) {
            return;
        }
        DynamicObject[] positions = (DynamicObject[])Arrays.stream(positionInfos).filter(position -> !HRStringUtils.equals((String)"0", (String)position.getString("enable"))).toArray(DynamicObject[]::new);
        if (PositionUtils.isArrayEmpty(positions).booleanValue()) {
            return;
        }
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        try (TXHandle txHandle = TX.required();){
            try {
                DynamicObject[] deletePositions = (DynamicObject[])Arrays.stream(positions).filter(position -> HRStringUtils.equals((String)"10", (String)position.getString("enable"))).toArray(DynamicObject[]::new);
                DynamicObject[] disablePositions = (DynamicObject[])Arrays.stream(positions).filter(position -> HRStringUtils.equals((String)"1", (String)position.getString("enable"))).toArray(DynamicObject[]::new);
                this.positionServiceApplication.deletePosition(deletePositions);
                this.positionServiceApplication.changePositionEnable(disablePositions, "0");
            }
            catch (Exception ex) {
                txHandle.markRollback();
                changeMsgServiceImpl.clear();
                LOGGER.info(ex.getMessage());
                throw ex;
            }
        }
        changeMsgServiceImpl.sendMsg();
    }

    @Override
    public void orgChangePosition(List<Long> orgIds, String toBeDisable) {
        DynamicObject[] positions = PositionQueryRepository.getInstance().queryToBeDisablePosition(orgIds, toBeDisable);
        if (PositionUtils.isArrayEmpty(positions).booleanValue()) {
            return;
        }
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        try (TXHandle txHandle = TX.required();){
            try {
                for (DynamicObject position : positions) {
                    position.set("toBeDisable", (Object)toBeDisable);
                    position.set("changetype", (Object)1020L);
                    position.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
                }
                DynamicObject[] newDynamicObjects = this.positionServiceApplication.changeMainPosition(Arrays.asList(positions), false, true);
                List<DynamicObject> newPositionBills = PositionServiceHelper.transferPositionToPositionBill(Arrays.asList(newDynamicObjects));
                HRBaseServiceHelper positionBillServiceHelper = new HRBaseServiceHelper("homs_positionbill");
                positionBillServiceHelper.save(newPositionBills.toArray(new DynamicObject[0]));
            }
            catch (Exception ex) {
                txHandle.markRollback();
                changeMsgServiceImpl.clear();
                LOGGER.info(ex.getMessage());
                throw ex;
            }
        }
        changeMsgServiceImpl.sendMsg();
    }

    @Override
    public void positionChangeOrg(Long adminOrgId, Long orgId, Date bsed) {
        DynamicObject[] positions = PositionQueryRepository.getInstance().queryOrgPosition(adminOrgId, bsed);
        if (PositionUtils.isArrayEmpty(positions).booleanValue()) {
            return;
        }
        HRBaseServiceHelper bosOrgHelper = new HRBaseServiceHelper("bos_org");
        QFilter qFilter = new QFilter("id", "=", (Object)orgId);
        DynamicObject org = bosOrgHelper.loadDynamicObject(qFilter);
        Map<Long, List<DynamicObject>> boToHisMap = Arrays.stream(positions).collect(Collectors.groupingBy(pos -> pos.getLong("boid")));
        ArrayList<DynamicObject> enabledInitCompletePos = new ArrayList<DynamicObject>(positions.length);
        ArrayList<DynamicObject> disabledInitCompletePos = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> initCompleteDarkPos = new ArrayList<DynamicObject>(positions.length);
        ArrayList<Long> initCompletingBoids = new ArrayList<Long>(10);
        boToHisMap.forEach((boid, hisList) -> {
            for (DynamicObject position : hisList) {
                String datastatus = position.getString("datastatus");
                String enbale = position.getString("enable");
                String createmode = position.getString("createmode");
                Date pbsed = position.getDate("bsed");
                Date pbsled = position.getDate("bsled");
                String initstatus = position.getString("initstatus");
                position.set("org_id", (Object)orgId);
                position.set("org", (Object)org);
                position.set("changetype", (Object)1020L);
                position.set("sourcevid", (Object)position.getLong("id"));
                if (!HRDateTimeUtils.dayBefore((Date)pbsled, (Date)bsed) && !HRDateTimeUtils.dayAfter((Date)pbsed, (Date)bsed)) {
                    position.set("bsed", (Object)bsed);
                }
                if (!"2".equals(initstatus)) {
                    initCompletingBoids.add(position.getLong("boid"));
                    continue;
                }
                if ("3".equals(createmode)) {
                    initCompleteDarkPos.add(position);
                    continue;
                }
                if (HRStringUtils.equals((String)datastatus, (String)"1")) {
                    if ("1".equals(enbale)) {
                        enabledInitCompletePos.add(position);
                        continue;
                    }
                    disabledInitCompletePos.add(position);
                    continue;
                }
                initCompleteDarkPos.add(position);
            }
        });
        ChangeMsgServiceImpl changeMsgServiceImpl = new ChangeMsgServiceImpl();
        try (TXHandle txHandle = TX.required();){
            try {
                DynamicObject[] newEnabledInitCompletePos = this.positionServiceApplication.changePositionOrg(enabledInitCompletePos, true, true);
                DynamicObject[] newDisabledInitCompletePos = this.positionServiceApplication.changePositionOrg(disabledInitCompletePos, false, true);
                HRBaseServiceHelper positionBillServiceHelper = new HRBaseServiceHelper("homs_positionbill");
                ArrayList<DynamicObject> newPositionBills = new ArrayList<DynamicObject>(positions.length);
                newPositionBills.addAll(PositionServiceHelper.transferPositionToPositionBill(Arrays.asList(newEnabledInitCompletePos)));
                newPositionBills.addAll(PositionServiceHelper.transferPositionToPositionBill(Arrays.asList(newDisabledInitCompletePos)));
                positionBillServiceHelper.save(newPositionBills.toArray(new DynamicObject[0]));
                this.positionServiceApplication.changePositionOrg(initCompleteDarkPos, false, false);
                if (!initCompletingBoids.isEmpty()) {
                    DynamicObject[] initCompletingPos;
                    for (DynamicObject position : initCompletingPos = PositionQueryRepository.getInstance().queryInitCompletingPositionByBoId(initCompletingBoids)) {
                        position.set("org_id", (Object)orgId);
                        position.set("org", (Object)org);
                    }
                    HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positionhr");
                    serviceHelper.update(initCompletingPos);
                }
            }
            catch (Exception ex) {
                txHandle.markRollback();
                changeMsgServiceImpl.clear();
                LOGGER.info(ex.getMessage());
                throw ex;
            }
        }
        changeMsgServiceImpl.sendMsg();
    }
}

