/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.position;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.hrmp.hbpm.business.application.position.IPositionChangeDetailApplication;
import kd.hrmp.hbpm.business.domain.bo.position.ChangeDetailBo;
import kd.hrmp.hbpm.business.domain.repository.position.PositionChangeDetailRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.PositionChangeDetailDisplayServiceImpl;
import kd.hrmp.hbpm.business.domain.service.impl.position.ReportRelationChangeDetailDisplayServiceImpl;

public class PositionChangeDetailApplicationImpl
implements IPositionChangeDetailApplication {
    @Override
    public List<ChangeDetailBo> getChangeDetail(List<Long> detailIds) {
        if (detailIds == null || detailIds.size() <= 0) {
            return null;
        }
        DynamicObject[] detailInfos = PositionChangeDetailRepository.getInstance().getDetailInfoByIds(detailIds);
        if (detailInfos == null || detailInfos.length <= 0) {
            return null;
        }
        Map<Boolean, List<DynamicObject>> dataMap = Arrays.stream(detailInfos).collect(Collectors.groupingBy(data -> {
            String propKey = data.getString("propkey");
            return StringUtils.equals((CharSequence)"reportrelation", (CharSequence)propKey);
        }));
        PositionChangeDetailDisplayServiceImpl service = new PositionChangeDetailDisplayServiceImpl();
        List<ChangeDetailBo> positionChangeBos = service.buildChangeDetail(dataMap.get(Boolean.FALSE));
        ReportRelationChangeDetailDisplayServiceImpl reportRelationChangeService = new ReportRelationChangeDetailDisplayServiceImpl();
        List<ChangeDetailBo> reportRelationChangeBos = reportRelationChangeService.buildChangeDetail(dataMap.get(Boolean.TRUE));
        if (positionChangeBos == null) {
            return reportRelationChangeBos;
        }
        if (reportRelationChangeBos == null) {
            return positionChangeBos;
        }
        positionChangeBos.addAll(reportRelationChangeBos);
        return positionChangeBos;
    }
}

