/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.position;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionImptServiceApplication
extends PositionServiceApplicationImpl {
    private DynamicObject[] hisVersions;

    public PositionImptServiceApplication(DynamicObject[] hisVersions) {
        this.hisVersions = hisVersions;
    }

    @Override
    public Map<String, Object> savePosition(List<DynamicObject> positions, Map<String, DynamicObjectCollection> reportRelationEntryEntity) {
        List<DynamicObject> newDutyRole = this.dutyWorkRoleServiceApplication.createNewDutyRole(positions);
        List<DynamicObject> newWorkRole = this.workRoleServiceApplication.createNewWorkRole(positions, newDutyRole);
        Map<Long, DynamicObject> workRoleMap = PositionUtils.listToMap(newWorkRole, "position.id");
        this.handlePositionWorkRole(workRoleMap, positions);
        this.reportingRelationServiceApplication.createNewReportRelationAndSysReportRel(positions, reportRelationEntryEntity, newWorkRole);
        this.handleChangeEvent(null, this.hisVersions, 1010L, 1010L, true);
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        result.put("workRoleMap", workRoleMap);
        return result;
    }

    private void handlePositionWorkRole(Map<Long, DynamicObject> workRoleMap, List<DynamicObject> positions) {
        for (DynamicObject position : positions) {
            DynamicObject workRole = workRoleMap.get(position.getLong("id"));
            if (HRObjectUtils.isEmpty((Object)workRole)) continue;
            position.set("workrole", (Object)workRole.getLong("id"));
        }
    }

    public void modifyPosition(List<DynamicObject> positions) {
        this.workRoleServiceApplication.updateWorkRole(positions);
        this.dutyWorkRoleServiceApplication.updateDutyRole(positions);
        this.reportingRelationServiceApplication.updateSysReportRel(positions, this.getEffectiveStatus());
        this.handleChangeEvent(this.getPositionHisVersions(positions), this.hisVersions, 1020L, 1020L, true);
    }
}

