/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.position;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.position.IPositionInitServiceApplication;
import kd.hrmp.hbpm.business.domain.repository.position.CommonQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeEventServiceImpl;
import kd.hrmp.hbpm.business.domain.service.impl.position.PositionChangeDetailServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.ChangeEventService;
import kd.hrmp.hbpm.business.domain.service.position.IChangeDetailService;

public class PositionInitServiceApplication
implements IPositionInitServiceApplication {
    private static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"HBPMPositionInitServiceThreadpool", (int)1, (int)4);
    private static final Log LOG = LogFactory.getLog(PositionInitServiceApplication.class);
    private CommonQueryRepository commonQueryRepository = CommonQueryRepository.getInstance();
    private ChangeEventService changeEventService = new ChangeEventServiceImpl();
    private IChangeDetailService changeDetailService = new PositionChangeDetailServiceImpl();

    @Override
    public List<Long> changeInitStatus(long batchNumber, String sourceStatus, String targetStatus) {
        LOG.info("position changeInitStatus: batchnumber:{}, sourceStatus:{}, targetStatus:{}", new Object[]{batchNumber, sourceStatus, targetStatus});
        DynamicObject[] positions = this.changePositionStatus("hbpm_positionhr", batchNumber, sourceStatus, targetStatus);
        this.changeStatus("hbpm_workroleshr", batchNumber, sourceStatus, targetStatus);
        this.changeStatus("hbpm_dutyworkroles", batchNumber, sourceStatus, targetStatus);
        this.changeStatus("hbpm_reportingrelation", batchNumber, sourceStatus, targetStatus);
        this.changeStatus("hbpm_chgrecord", batchNumber, sourceStatus, targetStatus);
        if (HRStringUtils.equals((String)targetStatus, (String)"2")) {
            LOG.info("position_init_syncplatform_thread_start");
            threadPool.execute(() -> new PositionServiceApplicationImpl().syncPlatFormPosition(positions, false));
            LOG.info("position_init_syncplatform_thread_end");
        }
        List<Long> positionIdList = positions == null ? new ArrayList<Long>() : Arrays.stream(positions).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        return positionIdList;
    }

    @Override
    public List<Long> rollback(long batchNumber) {
        LOG.info("position changeInitStatus: batchnumber:{}", new Object[]{batchNumber});
        List<Long> positionIds = this.handleRollBack("hbpm_positionhr", batchNumber, true);
        this.handleRollBack("hbpm_workroleshr", batchNumber, false);
        this.handleRollBack("hbpm_dutyworkroles", batchNumber, false);
        this.handleRollBack("hbpm_reportingrelation", batchNumber, false);
        return positionIds;
    }

    public List<Long> changeStatus(String entityNumber, long batchNumber, String sourceStatus, String targetStatus) {
        Object[] dynamicObjects = this.commonQueryRepository.queryInitWaitChangeStatus(entityNumber, batchNumber, sourceStatus, targetStatus);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        hrBaseServiceHelper.save((DynamicObject[])dynamicObjects);
        return Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    public DynamicObject[] changePositionStatus(String entityNumber, long batchNumber, String sourceStatus, String targetStatus) {
        Object[] dynamicObjects = this.commonQueryRepository.queryInitWaitChangeStatus(entityNumber, batchNumber, sourceStatus, targetStatus);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return null;
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        hrBaseServiceHelper.save((DynamicObject[])dynamicObjects);
        return dynamicObjects;
    }

    public List<Long> handleRollBack(String entityNumber, long batchNumber, boolean isRollBackEvent) {
        DynamicObject[] dynamicObjects = this.commonQueryRepository.queryInitWaitRollBackIds(entityNumber, batchNumber);
        ArrayList boIdList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (boIdList.contains(dynamicObject.getLong("boid"))) continue;
            boIdList.add(dynamicObject.getLong("boid"));
        }
        if (!CollectionUtils.isEmpty((Collection)boIdList)) {
            this.deleteBo(entityNumber, boIdList);
        }
        if (isRollBackEvent) {
            this.changeEventService.delEvent(boIdList);
            this.changeDetailService.rollbackChangeDetailByBatchNumber(batchNumber);
        }
        return boIdList;
    }

    private void deleteBo(String entityNumber, List<Long> boIdList) {
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber(entityNumber);
        hisBaseBo.setBoIdList(boIdList);
        HisModelController.getInstance().deleteBo(hisBaseBo);
    }
}

