/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hbpm.business.application.impl.position.PositionServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.position.IPositionJobServiceApplication;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.PositionJobServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IPositionJobService;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionJobServiceApplicationImpl
implements IPositionJobServiceApplication {
    private static final Log LOGGER = LogFactory.getLog(PositionServiceApplicationImpl.class);
    private IPositionJobService positionJobService = PositionJobServiceImpl.getInstance();

    @Override
    public Map<Long, Map<String, Object>> queryPositionRefJobHisInfo(List<Long> positionBoIds, Date effectDate) {
        HashMap positionRefJobHisInfoMap = Maps.newHashMapWithExpectedSize((int)positionBoIds.size());
        DynamicObject[] positionHisInfo = PositionQueryRepository.getInstance().queryPositionHisInfo(positionBoIds, effectDate);
        if (PositionUtils.isArrayEmpty(positionHisInfo).booleanValue()) {
            return positionRefJobHisInfoMap;
        }
        ArrayList jobBoIds = Lists.newArrayListWithExpectedSize((int)positionHisInfo.length);
        ArrayList jobGradeBoIds = Lists.newArrayListWithExpectedSize((int)positionHisInfo.length);
        ArrayList jobLevelBoIds = Lists.newArrayListWithExpectedSize((int)positionHisInfo.length);
        this.getPositionJobInfo(positionHisInfo, jobBoIds, jobGradeBoIds, jobLevelBoIds);
        Map<Long, DynamicObject> jobHisAndRefHis = this.handJobInfo(jobBoIds, effectDate);
        Map<Long, Map<String, Object>> jobGradeHisInfo = this.handleGradeOrLevelInfo(this.positionJobService.queryGradeHisInfo(jobGradeBoIds, effectDate));
        Map<Long, Map<String, Object>> jobLevelHisInfo = this.handleGradeOrLevelInfo(this.positionJobService.queryLevelHisInfo(jobLevelBoIds, effectDate));
        this.handlePositionRefJobHisInfo(positionRefJobHisInfoMap, positionHisInfo, jobHisAndRefHis, jobGradeHisInfo, jobLevelHisInfo);
        return positionRefJobHisInfoMap;
    }

    private Map<Long, DynamicObject> handJobInfo(List<Long> jobBoIds, Date effectDate) {
        HashMap jobInfo = Maps.newHashMapWithExpectedSize((int)jobBoIds.size());
        List<Long> josHisIds = this.jobHisIds(jobBoIds, effectDate);
        DynamicObject[] jobHisAndRefHis = this.positionJobService.queryJobHisAndRefHis(josHisIds);
        if (PositionUtils.isArrayEmpty(jobHisAndRefHis).booleanValue()) {
            return jobInfo;
        }
        for (DynamicObject jobHisAndRef : jobHisAndRefHis) {
            jobInfo.put(jobHisAndRef.getLong("boid"), jobHisAndRef);
        }
        return jobInfo;
    }

    private List<Long> jobHisIds(List<Long> jobBoIds, Date effectDate) {
        ArrayList jobHisIds = Lists.newArrayListWithExpectedSize((int)jobBoIds.size());
        List<Map<String, Object>> jobHisInfos = this.positionJobService.queryJobHis(jobBoIds, effectDate);
        if (CollectionUtils.isEmpty(jobHisInfos)) {
            return jobHisIds;
        }
        jobHisInfos.stream().forEach(jobHisInfo -> jobHisIds.add(Long.parseLong((String)jobHisInfo.get("id"))));
        return jobHisIds;
    }

    private void getPositionJobInfo(DynamicObject[] positionHisInfos, List<Long> jobBoIds, List<Long> jobGradeBoIds, List<Long> jobLevelBoIds) {
        for (DynamicObject positionHisInfo : positionHisInfos) {
            long jobId = positionHisInfo.getLong("job");
            long lowJobLevelId = positionHisInfo.getLong("lowjoblevel");
            long highJobLevelId = positionHisInfo.getLong("highjoblevel");
            long lowJobGradeId = positionHisInfo.getLong("lowjobgrade");
            long highJobGradeId = positionHisInfo.getLong("highjobgrade");
            if (jobId != 0L) {
                jobBoIds.add(jobId);
            }
            if (lowJobGradeId != 0L) {
                jobGradeBoIds.add(lowJobGradeId);
            }
            if (highJobGradeId != 0L) {
                jobGradeBoIds.add(highJobGradeId);
            }
            if (lowJobLevelId != 0L) {
                jobLevelBoIds.add(lowJobLevelId);
            }
            if (highJobLevelId == 0L) continue;
            jobLevelBoIds.add(highJobLevelId);
        }
    }

    private Map<Long, Map<String, Object>> handleGradeOrLevelInfo(List<Map<String, Object>> jobGradeOrLevelHisInfo) {
        HashMap gradeOrLevelInfo = Maps.newHashMapWithExpectedSize((int)jobGradeOrLevelHisInfo.size());
        if (CollectionUtils.isEmpty(jobGradeOrLevelHisInfo)) {
            return gradeOrLevelInfo;
        }
        for (Map<String, Object> jobGradeOrLevel : jobGradeOrLevelHisInfo) {
            gradeOrLevelInfo.put((Long)jobGradeOrLevel.get("boid"), jobGradeOrLevel);
        }
        return gradeOrLevelInfo;
    }

    private void handlePositionRefJobHisInfo(Map<Long, Map<String, Object>> positionRefJobHisInfoMap, DynamicObject[] positionHisInfo, Map<Long, DynamicObject> jobHisAndRefHis, Map<Long, Map<String, Object>> jobGradeHisInfo, Map<Long, Map<String, Object>> jobLevelHisInfo) {
        for (DynamicObject dynamicObject : positionHisInfo) {
            HashMap positionJobHisInfo = Maps.newHashMapWithExpectedSize((int)positionHisInfo.length);
            positionRefJobHisInfoMap.put(dynamicObject.getLong("boid"), positionJobHisInfo);
            positionJobHisInfo.put("id", dynamicObject.getLong("id"));
            positionJobHisInfo.put("boid", dynamicObject.getLong("boid"));
            DynamicObject jobRefInfo = jobHisAndRefHis.get(dynamicObject.getLong("job"));
            positionJobHisInfo.put("jobinfo", this.transferDynamicObjectToMap(jobRefInfo, true));
            positionJobHisInfo.put("jobseq", this.transferDynamicObjectToMap(jobRefInfo != null ? jobRefInfo.getDynamicObject("jobseq") : null, false));
            positionJobHisInfo.put("jobfamily", this.transferDynamicObjectToMap(jobRefInfo != null ? jobRefInfo.getDynamicObject("jobfamily") : null, false));
            positionJobHisInfo.put("jobclass", this.transferDynamicObjectToMap(jobRefInfo != null ? jobRefInfo.getDynamicObject("jobclass") : null, false));
            positionJobHisInfo.put("lowjobgrade", jobGradeHisInfo.get(dynamicObject.getLong("lowjobgrade")));
            positionJobHisInfo.put("highjobgrade", jobGradeHisInfo.get(dynamicObject.getLong("highjobgrade")));
            positionJobHisInfo.put("lowjoblevel", jobLevelHisInfo.get(dynamicObject.getLong("lowjoblevel")));
            positionJobHisInfo.put("highjoblevel", jobLevelHisInfo.get(dynamicObject.getLong("highjoblevel")));
        }
    }

    private Map<String, Object> transferDynamicObjectToMap(DynamicObject dynamicObject, boolean isAllField) {
        if (HRObjectUtils.isEmpty((Object)dynamicObject)) {
            return null;
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        if (isAllField) {
            result.put("id", dynamicObject.getLong("id"));
            result.put("boid", dynamicObject.getLong("boid"));
        }
        result.put("number", dynamicObject.getString("number"));
        result.put("name", dynamicObject.getLocaleString("name"));
        return result;
    }
}

