/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.position;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbpm.business.application.impl.position.AbstractPositionServiceApplication;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.common.constants.EffectiveStatusEnum;

public class PositionServiceApplicationImpl
extends AbstractPositionServiceApplication {
    @Override
    protected EffectiveStatusEnum getEffectiveStatus() {
        return EffectiveStatusEnum.CurrentEffective;
    }

    @Override
    protected DynamicObject[] getPositionHisVersions(List<DynamicObject> positions) {
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }
        List<Long> idList = null;
        if (positions.get(0).getLong("sourcevid") != 0L) {
            idList = this.getIdList(positions);
        } else {
            HRBaseServiceHelper positionServiceHelper = new HRBaseServiceHelper("hbpm_positionhr");
            List boIds = positions.stream().map(position -> position.getLong("id")).collect(Collectors.toList());
            QFilter idQFilter = new QFilter("id", "in", boIds);
            DynamicObject[] dynamicObjects = positionServiceHelper.query("id, sourcevid", new QFilter[]{idQFilter});
            idList = this.getIdList(Arrays.asList(dynamicObjects));
            this.handleSourceId(positions, dynamicObjects);
        }
        return PositionQueryRepository.getInstance().queryPositionsById(idList);
    }

    private List<Long> getIdList(List<DynamicObject> positions) {
        return positions.stream().map(position -> position.getLong("sourcevid")).collect(Collectors.toList());
    }

    private void handleSourceId(List<DynamicObject> positions, DynamicObject[] hisPosition) {
        if (CollectionUtils.isEmpty(positions) || PositionUtils.isArrayEmpty(hisPosition).booleanValue()) {
            return;
        }
        Map<Long, Long> collect = Arrays.stream(hisPosition).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("sourcevid"), (v1, v2) -> v1));
        for (DynamicObject position : positions) {
            position.set("sourcevid", (Object)collect.get(position.getLong("id")));
        }
    }
}

