/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.application.impl.position.AbstractPositionServiceApplication;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.common.constants.EffectiveStatusEnum;

public class PreviousPositionServiceApplication
extends AbstractPositionServiceApplication {
    @Override
    protected EffectiveStatusEnum getEffectiveStatus() {
        return EffectiveStatusEnum.PreviousEffective;
    }

    @Override
    protected void preHandlePosition(List<DynamicObject> positions) {
        if (CollectionUtils.isEmpty(positions)) {
            return;
        }
        Map<Long, Date> boIdAndBSedMap = positions.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getDate("bsed")));
        Map<Long, DynamicObject> longDateMap = PositionQueryRepository.getInstance().queryPositionHisVersionBSled(boIdAndBSedMap);
        if (CollectionUtils.isEmpty(longDateMap)) {
            return;
        }
        for (DynamicObject position : positions) {
            DynamicObject prePosition = longDateMap.get(position.getLong("boid"));
            position.set("bsled", (Object)prePosition.getDate("bsled"));
            position.set("sourcevid", (Object)prePosition.getLong("id"));
            if (!HRStringUtils.equals((String)"2", (String)prePosition.getString("datastatus"))) continue;
            position.set("enable", (Object)prePosition.getString("enable"));
            position.set("parent", (Object)prePosition.getDynamicObject("parent"));
        }
    }

    @Override
    protected DynamicObject[] getPositionHisVersions(List<DynamicObject> positions) {
        if (CollectionUtils.isEmpty(positions)) {
            return null;
        }
        List<Long> boIdList = positions.stream().map(position -> position.getLong("id")).collect(Collectors.toList());
        DynamicObject[] positionVersions = PositionQueryRepository.getInstance().queryPositionVersionByBoId(boIdList);
        HashMap positionIdAndHisVersionMap = Maps.newHashMapWithExpectedSize((int)positionVersions.length);
        for (DynamicObject positionVersion : positionVersions) {
            List hisVersions = (List)positionIdAndHisVersionMap.get(positionVersion.getLong("boid"));
            if (CollectionUtils.isEmpty((Collection)hisVersions)) {
                hisVersions = Lists.newArrayListWithExpectedSize((int)16);
                positionIdAndHisVersionMap.put(positionVersion.getLong("boid"), hisVersions);
            }
            hisVersions.add(positionVersion);
        }
        ArrayList positionHisVersions = Lists.newArrayListWithExpectedSize((int)positions.size());
        for (DynamicObject position2 : positions) {
            List hisVersions = (List)positionIdAndHisVersionMap.get(position2.getLong("id"));
            if (CollectionUtils.isEmpty((Collection)hisVersions)) continue;
            Date bSed = position2.getDate("bsed");
            for (DynamicObject hisVersion : hisVersions) {
                Date startBSed = hisVersion.getDate("bsed");
                if (bSed.compareTo(startBSed) < 0 || !bSed.before(hisVersion.getDate("bsled"))) continue;
                positionHisVersions.add(hisVersion);
            }
        }
        return positionHisVersions.toArray(new DynamicObject[0]);
    }
}

