/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.application.impl.position.DarkPositionApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.DutyWorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.ReportingRelationServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.WorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.position.IStandardPositionApplication;
import kd.hrmp.hbpm.business.application.workrole.IReportingRelationServiceApplication;
import kd.hrmp.hbpm.business.domain.bo.common.MServiceBo;
import kd.hrmp.hbpm.business.domain.bo.standardposition.StandardPositionOrgBo;
import kd.hrmp.hbpm.business.domain.bo.standardposition.ValideStandardPositionAndOrgBo;
import kd.hrmp.hbpm.business.domain.mservice.HaosMServiceHelper;
import kd.hrmp.hbpm.business.domain.repository.position.MserviceQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.StandardPositionRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.PositionServiceImpl;
import kd.hrmp.hbpm.business.service.position.StandardPositionCommonService;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.business.utils.model.PersonSourceEntity;
import kd.hrmp.hbpm.common.constants.StandardPositionConstants;
import kd.hrmp.hbpm.common.model.stdpos.QueryHisByOrgParam;
import kd.hrmp.hbpm.common.model.stdpos.QueryHisByOrgResult;
import kd.hrmp.hbpm.common.model.stdpos.StdPosAndOrg;
import kd.hrmp.hbpm.common.model.stdpos.ValidStdPosAndOrgAndDateParam;
import kd.hrmp.hbpm.common.model.stdpos.ValidStdPosAndOrgAndDateResult;

public class StandardPositionApplicationImpl
implements IStandardPositionApplication {
    private static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"DarkStandardPositionCreateThreadpool", (int)1, (int)4);
    private static final Log logger = LogFactory.getLog(StandardPositionApplicationImpl.class);
    private static final String ORG_ERROR_MSG = "error";
    private static final String STANDARDPOSITION_ENTRY = "entryentity";
    private IReportingRelationServiceApplication reportingRelationServiceApplication = new ReportingRelationServiceApplicationImpl();
    private Map<String, Map<String, Object>> orgMap;
    private Map<Long, DynamicObject> standardPositionMap;
    private List<Long> toDisableDarkPos = Lists.newArrayListWithExpectedSize((int)8);
    private Map<String, DynamicObject[]> toCreateDarkStdPosJobInfos;

    @Override
    public Map<String, Object> addDarkPosition(List<Map<String, Object>> info) {
        logger.info(String.format("StandardPositionApplication2Impl addDarkPosition %s", info));
        List<PersonSourceEntity> sourceDatas = this.getInfoFromSourceMap(info, "standardposition", false);
        if (Objects.isNull(sourceDatas)) {
            String msg = ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1b", (String)"StandardPositionApplicationImpl_5", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            return this.buildSuccessResult(201, msg, PersonSourceEntity.toMap(sourceDatas));
        }
        List<PersonSourceEntity> successData = this.getSuccessData(sourceDatas);
        this.validate(successData, "standardposition");
        return this.saveDarkPos(sourceDatas, "standardposition", false);
    }

    @Override
    public Map<String, Object> disableDarkPosition(List<Map<String, Object>> info) {
        return this.batchEnAbleOrDisAblePosition("disable", info);
    }

    @Override
    public Map<String, Object> enableDarkPosition(List<Map<String, Object>> info) {
        return this.batchEnAbleOrDisAblePosition("enable", info);
    }

    @Override
    public Map<String, Object> addDarkPositionByJob(List<Map<String, Object>> info) {
        logger.info(String.format("StandardPositionApplication2Impl addDarkPositionByJob %s", info));
        List<PersonSourceEntity> sourceDatas = this.getInfoFromSourceMap(info, "job", false);
        if (Objects.isNull(sourceDatas)) {
            String msg = ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1b", (String)"StandardPositionApplicationImpl_5", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            return this.buildSuccessResult(201, msg, PersonSourceEntity.toMap(sourceDatas));
        }
        List<PersonSourceEntity> successData = this.getSuccessData(sourceDatas);
        this.validate(successData, "job");
        return this.saveDarkPos(sourceDatas, "job", false);
    }

    @Override
    public List<Map<String, Object>> queryStandardPositionByOrg(List<Long> orgIdList) {
        List<StandardPositionOrgBo> bos = this.queryStandardPositionBoByOrg(orgIdList, false);
        return StandardPositionOrgBo.toMap(bos);
    }

    @Override
    public List<Map<String, Object>> valideStandardPositionAndOrg(List<Map<String, Long>> list) {
        List<Long> orgIds;
        List<StandardPositionOrgBo> orgBos;
        if (list == null || list.size() <= 0) {
            return null;
        }
        List<ValideStandardPositionAndOrgBo> bos = ValideStandardPositionAndOrgBo.buildBos(list);
        ValideStandardPositionAndOrgBo.valideData(bos);
        List valideBos = bos.stream().filter(MServiceBo::isSuccess).collect(Collectors.toList());
        if (valideBos.size() > 0 && (orgBos = this.queryStandardPositionBoByOrg(orgIds = valideBos.stream().map(ValideStandardPositionAndOrgBo::getOrgId).collect(Collectors.toList()), false)) != null && orgBos.size() > 0) {
            Map<Long, StandardPositionOrgBo> infos = orgBos.stream().collect(Collectors.toMap(StandardPositionOrgBo::getOrgId, data -> data, (v1, v2) -> v2));
            for (ValideStandardPositionAndOrgBo valideBo : valideBos) {
                Set stadIds;
                List<DynamicObject> standardPositions;
                StandardPositionOrgBo standardPositionOrgBo = infos.get(valideBo.getOrgId());
                if (standardPositionOrgBo == null || (standardPositions = standardPositionOrgBo.getStandardPositions()) == null || standardPositions.size() <= 0 || !(stadIds = standardPositions.stream().map(data -> data.getLong("id")).collect(Collectors.toSet())).contains(valideBo.getStandardPositionId())) continue;
                valideBo.setValide(true);
            }
        }
        return ValideStandardPositionAndOrgBo.toMap(bos);
    }

    private void deleteDarkPosition(List<Long> ids, List<Long> removeWorkRoleIds) {
        PositionServiceImpl positionService = new PositionServiceImpl();
        WorkRoleServiceApplicationImpl workRoleApplication = new WorkRoleServiceApplicationImpl();
        DutyWorkRoleServiceApplicationImpl dutyWorkRoleApplication = new DutyWorkRoleServiceApplicationImpl();
        ReportingRelationServiceApplicationImpl reportingRelationApplication = new ReportingRelationServiceApplicationImpl();
        positionService.batchDeleted(ids);
        dutyWorkRoleApplication.deleteDutyRoles(ids);
        workRoleApplication.deleteWorkRoles(removeWorkRoleIds);
        reportingRelationApplication.deleteAllReportingRelationByWorkRoles(removeWorkRoleIds);
    }

    private Map<String, Object> batchEnAbleOrDisAblePosition(String enable, List<Map<String, Object>> info) {
        Map<String, Object> checkResult = this.checkAbleInfoParam(info);
        if (Objects.nonNull(checkResult)) {
            return checkResult;
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(info.size());
        DynamicObject[] positions = new DynamicObject[]{};
        try (TXHandle required = TX.required();){
            Stack<Boolean> stack = new Stack<Boolean>();
            positions = this.dealDarkPositionData(enable, info, result, stack);
            if (PositionUtils.isArrayEmpty(positions).booleanValue()) {
                int code = 200;
                if (stack.empty()) {
                    code = 201;
                }
                Map<String, Object> map = this.buildSuccessResult(code, "", result);
                return map;
            }
            try {
                DarkPositionApplicationImpl darkPositionApplication = new DarkPositionApplicationImpl();
                if ("enable".equals(enable)) {
                    darkPositionApplication.enableDarkPosition(positions);
                } else if ("disable".equals(enable)) {
                    darkPositionApplication.disableDarkPosition(positions);
                }
            }
            catch (Exception ex) {
                required.markRollback();
                logger.info(ex.getMessage());
                Arrays.stream(positions).forEach(dy -> result.add(this.buildResultMap(dy.getLong("id"), Boolean.FALSE, ex.getMessage())));
                Map<String, Object> map = this.buildSuccessResult(201, "", result);
                return map;
            }
        }
        Arrays.stream(positions).forEach(dy -> result.add(this.buildResultMap(dy.getLong("id"), Boolean.TRUE, "")));
        return this.buildSuccessResult(200, "", result);
    }

    private DynamicObject[] dealDarkPositionData(String enable, List<Map<String, Object>> info, List<Map<String, Object>> result, Stack<Boolean> stack) {
        List<Long> list = info.stream().map(map -> (Long)map.get("position")).collect(Collectors.toList());
        DynamicObject[] positions = PositionQueryRepository.getInstance().queryDarkPositionById(list);
        if (PositionUtils.isArrayEmpty(positions).booleanValue()) {
            list.forEach(id -> result.add(this.buildResultMap((Long)id, Boolean.FALSE, ResManager.loadKDString((String)"\u8be5\u5c97\u4f4dID\u4e0d\u5b58\u5728\u3002", (String)"StandardPositionApplicationImpl_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]))));
            return positions;
        }
        Map<Long, DynamicObject> collect = Arrays.stream(positions).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v1));
        if (HRStringUtils.equals((String)enable, (String)"enable")) {
            positions = this.sortPositionForEnAbleStatus(info, result, collect, stack);
        } else if (HRStringUtils.equals((String)enable, (String)"disable")) {
            positions = this.sortPositionForDisAbleStatus(info, result, collect, stack);
        }
        return positions;
    }

    private DynamicObject[] sortPositionForDisAbleStatus(List<Map<String, Object>> info, List<Map<String, Object>> result, Map<Long, DynamicObject> collect, Stack<Boolean> stack) {
        ArrayList lists = new ArrayList(collect.size());
        ArrayList<Long> removeIds = new ArrayList<Long>(collect.size());
        ArrayList<Long> removeWorkRoleIds = new ArrayList<Long>(collect.size());
        info.forEach(map -> {
            Long id = (Long)map.get("position");
            DynamicObject dy = (DynamicObject)collect.get(id);
            if (HRObjectUtils.isEmpty((Object)dy)) {
                result.add(this.buildResultMap(id, Boolean.FALSE, ResManager.loadKDString((String)"\u8be5\u5c97\u4f4dID\u4e0d\u5b58\u5728\u3002", (String)"StandardPositionApplicationImpl_0", (String)"hrmp-hbpm-business", (Object[])new Object[0])));
            } else {
                String enable = dy.getString("enable");
                if (HRStringUtils.equals((String)enable, (String)"10")) {
                    removeIds.add(id);
                    removeWorkRoleIds.add(dy.getLong("workrole.id"));
                    result.add(this.buildResultMap(id, Boolean.TRUE, ResManager.loadKDString((String)"\u8be5\u5c97\u4f4d\u662f\u201c\u5f85\u542f\u7528\u201d\u72b6\u6001\uff0c\u5df2\u5220\u9664\u3002", (String)"StandardPositionApplicationImpl_4", (String)"hrmp-hbpm-business", (Object[])new Object[0])));
                    if (stack.empty()) {
                        stack.push(Boolean.TRUE);
                    }
                } else if (HRStringUtils.equals((String)enable, (String)"0")) {
                    result.add(this.buildResultMap(id, Boolean.FALSE, ResManager.loadKDString((String)"\u8be5\u5c97\u4f4d\u662f\u201c\u5df2\u7981\u7528\u201d\u72b6\u6001\u3002", (String)"StandardPositionApplicationImpl_1", (String)"hrmp-hbpm-business", (Object[])new Object[0])));
                } else {
                    lists.add(dy);
                }
            }
        });
        if (removeIds.size() > 0) {
            this.deleteDarkPosition(removeIds, removeWorkRoleIds);
        }
        return lists.toArray(new DynamicObject[0]);
    }

    private DynamicObject[] sortPositionForEnAbleStatus(List<Map<String, Object>> info, List<Map<String, Object>> result, Map<Long, DynamicObject> collect, Stack<Boolean> stack) {
        ArrayList lists = new ArrayList(collect.size());
        info.forEach(map -> {
            Long id = (Long)map.get("position");
            DynamicObject dy = (DynamicObject)collect.get(id);
            if (HRObjectUtils.isEmpty((Object)dy)) {
                result.add(this.buildResultMap(id, Boolean.FALSE, ResManager.loadKDString((String)"\u8be5\u5c97\u4f4dID\u4e0d\u5b58\u5728\u3002", (String)"StandardPositionApplicationImpl_0", (String)"hrmp-hbpm-business", (Object[])new Object[0])));
            } else {
                String enable = dy.getString("enable");
                if (HRStringUtils.equals((String)enable, (String)"1")) {
                    result.add(this.buildResultMap(id, Boolean.FALSE, ResManager.loadKDString((String)"\u8be5\u5c97\u4f4d\u662f\u201c\u5df2\u542f\u7528\u201d\u72b6\u6001\u3002", (String)"StandardPositionApplicationImpl_3", (String)"hrmp-hbpm-business", (Object[])new Object[0])));
                } else {
                    lists.add(dy);
                }
            }
        });
        return lists.toArray(new DynamicObject[0]);
    }

    private Map<String, Object> checkAbleInfoParam(List<Map<String, Object>> info) {
        int size;
        if (Objects.isNull(info) || (size = info.size()) == 0) {
            String msg = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"InitPositionApplicationImpl_3", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            return this.buildSuccessResult(201, msg, null);
        }
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = info.get(i);
            Object positionId = map.get("position");
            if (PositionUtils.checkLongValue(positionId).booleanValue()) continue;
            String msg = ResManager.loadKDString((String)"\u201c\u5c97\u4f4d\u201d\u53c2\u6570\u9519\u8bef\uff1b", (String)"StandardPositionApplicationImpl_14", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            return this.buildSuccessResult(201, msg, null);
        }
        return null;
    }

    private void saveDarkPositionInfo(List<DynamicObject> positions) {
        DutyWorkRoleServiceApplicationImpl dutyWorkRoleServiceApplication = new DutyWorkRoleServiceApplicationImpl();
        List<DynamicObject> dutyWorkRoleList = dutyWorkRoleServiceApplication.createNewDutyRole(positions);
        WorkRoleServiceApplicationImpl workRoleServiceApplication = new WorkRoleServiceApplicationImpl();
        List<DynamicObject> newWorkRole = workRoleServiceApplication.createNewWorkRole(positions, dutyWorkRoleList);
        this.reportingRelationServiceApplication.createSysReportRel(newWorkRole);
        Map<Long, DynamicObject> workRoleMap = PositionUtils.listToMap(newWorkRole, "position.id");
        positions.forEach(dy -> {
            DynamicObject workRole = (DynamicObject)workRoleMap.get(dy.getLong("id"));
            dy.set("workrole", (Object)workRole.getLong("id"));
        });
        PositionServiceImpl positionService = new PositionServiceImpl();
        positionService.batchSave(positions.toArray(new DynamicObject[0]));
        this.updateDarkPosition(positions);
    }

    private void updateDarkPosition(List<DynamicObject> positions) {
        List<Long> positionIds = positions.stream().map(pos -> pos.getLong("id")).collect(Collectors.toList());
        DynamicObject[] positionFromDBs = PositionQueryRepository.getInstance().queryPositionsById(positionIds);
        List<Long> orgIds = Arrays.asList(positionFromDBs).stream().map(pos -> pos.getLong("adminorg.id")).collect(Collectors.toList());
        Map<Object, Object> orgUnderMainDutyPositionMap = new HashMap();
        DynamicObject[] orgUnderMainDutyPositions = PositionQueryRepository.getInstance().queryOrgPosition(orgIds);
        if (!PositionUtils.isArrayEmpty(orgUnderMainDutyPositions).booleanValue()) {
            orgUnderMainDutyPositionMap = Arrays.stream(orgUnderMainDutyPositions).collect(Collectors.groupingBy(position -> position.getLong("adminorg.id")));
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(positionFromDBs.length);
        for (DynamicObject darkPosition : positionFromDBs) {
            Date targetPositionBsed;
            List orgUnderMainDutyPositionList = (List)orgUnderMainDutyPositionMap.get(darkPosition.getLong("adminorg.id"));
            if (CollectionUtils.isEmpty((Collection)orgUnderMainDutyPositionList) || orgUnderMainDutyPositionList.size() != 1) continue;
            Date originPositionBsed = ((DynamicObject)orgUnderMainDutyPositionList.get(0)).getDate("bsed");
            Date besd = originPositionBsed.after(targetPositionBsed = darkPosition.getDate("bsed")) ? originPositionBsed : targetPositionBsed;
            darkPosition.set("bsed", (Object)besd);
            darkPosition.set("parent", orgUnderMainDutyPositionList.get(0));
            result.add(darkPosition);
        }
        DarkPositionApplicationImpl darkPositionApplication = new DarkPositionApplicationImpl();
        darkPositionApplication.updateDarkPosition(result);
    }

    private Map<String, Map<String, Object>> queryOrg(List<Long> orgList) {
        Map<String, Map<String, Object>> orgMap = MserviceQueryRepository.getInstance().queryOrg(orgList, PositionUtils.formatDate(new Date()));
        if (CollectionUtils.isEmpty(orgMap)) {
            return Maps.newHashMapWithExpectedSize((int)8);
        }
        if (!CollectionUtils.isEmpty(orgMap.get(ORG_ERROR_MSG))) {
            return Maps.newHashMapWithExpectedSize((int)8);
        }
        return orgMap;
    }

    private List<DynamicObject> buildDarkPositionInfo(List<PersonSourceEntity> canDealSourceData, boolean isInit) {
        this.dealHasDealPosition(canDealSourceData, isInit);
        List<PersonSourceEntity> successData = this.getSuccessData(canDealSourceData);
        if (ObjectUtils.isEmpty(successData)) {
            return Lists.newArrayListWithExpectedSize((int)8);
        }
        int size = successData.size();
        PositionQueryRepository instance = PositionQueryRepository.getInstance();
        List<DynamicObject> emptyDys = instance.generateEmptyPositions(size);
        long[] ids = ORM.create().genLongIds("hbpm_positionhr", size);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positiontype");
        DynamicObject positionType = serviceHelper.loadSingle((Object)StandardPositionConstants.POSITION_TYPE_JOB);
        for (int i = 0; i < size; ++i) {
            PersonSourceEntity personSourceEntity = successData.get(i);
            Date effect = personSourceEntity.getEffect();
            Date bsled = personSourceEntity.getBsled();
            Long stId = personSourceEntity.getStandardposition();
            Long initbatch = personSourceEntity.getInitBatch();
            DynamicObject dy = emptyDys.get(i);
            DynamicObject stdPositionDy = this.standardPositionMap.get(stId);
            Long org = personSourceEntity.getOrg();
            Map<String, Object> orgEntiy = this.orgMap.get(String.valueOf(org));
            Long id = ids[i];
            dy.set("id", (Object)id);
            dy.set("name", (Object)stdPositionDy.getString("name"));
            dy.set("stposition", (Object)stId);
            dy.set("number", (Object)("STP_" + id));
            dy.set("parent", null);
            dy.set("adminorg", (Object)org);
            dy.set("org", orgEntiy.get("org"));
            dy.set("establishmentdate", (Object)effect);
            dy.set("positiontype", stdPositionDy.get("positiontype"));
            if (dy.get("positiontype") == null) {
                dy.set("positiontype", (Object)positionType);
            }
            dy.set("positionclassify", stdPositionDy.get("positionclassify"));
            dy.set("createmode", (Object)"3");
            dy.set("issensitive", (Object)"0");
            dy.set("issyspreset", (Object)"0");
            dy.set("isleader", (Object)"2");
            dy.set("jobscm", stdPositionDy.get("jobscm"));
            dy.set("job", stdPositionDy.get("job"));
            dy.set("lowjoblevel", stdPositionDy.get("lowjoblevel"));
            dy.set("highjoblevel", stdPositionDy.get("highjoblevel"));
            dy.set("lowjobgrade", stdPositionDy.get("lowjobgrade"));
            dy.set("highjobgrade", stdPositionDy.get("highjobgrade"));
            dy.set("status", (Object)"C");
            dy.set("bsed", (Object)effect);
            Date formatDate = PositionUtils.formatDate(effect);
            Date blsedFormateDate = PositionUtils.formatDate(bsled);
            Date currentDate = PositionUtils.getCurrentDate();
            if (formatDate.after(currentDate)) {
                dy.set("bsed", (Object)currentDate);
                dy.set("enable", (Object)"1");
            } else if (blsedFormateDate.before(currentDate)) {
                dy.set("enable", (Object)"0");
            } else {
                dy.set("enable", (Object)"1");
            }
            dy.set("person", (Object)personSourceEntity.getUser());
            instance.setInitstatus(dy, isInit ? "0" : "2");
            dy.set("initbatch", (Object)initbatch);
            personSourceEntity.setPosition(id);
        }
        return emptyDys;
    }

    private List<DynamicObject> buildAndSaveDarkStandardPositionInfo(long initBatch, Map<String, DynamicObject[]> jobInfos, boolean notWriteData) {
        Object[] event_datas;
        Object[] bizEvent_datas;
        Object[] hisEvent_datas;
        if (ObjectUtils.isEmpty(jobInfos)) {
            return null;
        }
        DynamicObject[] datas = jobInfos.get("data");
        List<DynamicObject> standardPositionInfo = this.buildDarkStandardPositionInfo(initBatch, Arrays.asList(datas));
        if (notWriteData) {
            return standardPositionInfo;
        }
        if (standardPositionInfo != null && standardPositionInfo.size() > 0) {
            StandardPositionCommonService.batchHisVersionFirstChange(standardPositionInfo.toArray(new DynamicObject[0]));
        }
        if (!ObjectUtils.isEmpty((Object[])(hisEvent_datas = jobInfos.get("hisEvent")))) {
            StandardPositionCommonService.buildAndSaveStandardPositionHisEventInfo((DynamicObject[])hisEvent_datas);
        }
        if (!ObjectUtils.isEmpty((Object[])(bizEvent_datas = jobInfos.get("bizEvent")))) {
            StandardPositionCommonService.buildAndSaveStandardPositionBizEventInfo((DynamicObject[])bizEvent_datas);
        }
        if (!ObjectUtils.isEmpty((Object[])(event_datas = jobInfos.get("event")))) {
            StandardPositionCommonService.buildAndSaveStandardPositionEventInfo((DynamicObject[])event_datas);
        }
        return standardPositionInfo;
    }

    private List<DynamicObject> buildDarkStandardPositionInfo(long initBatch, List<DynamicObject> jobInfos) {
        int size = jobInfos.size();
        List<DynamicObject> emptyDys = StandardPositionRepository.getInstance().generateEmptyObject(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject job = jobInfos.get(i);
            DynamicObject std = emptyDys.get(i);
            StandardPositionCommonService.copyValueFromJobToStandardPosition(job, std);
            std.set("initbatch", (Object)initBatch);
        }
        return emptyDys;
    }

    private void dealStandardPositionSourceDatas(List<PersonSourceEntity> sourceDatas, List<DynamicObject> standardPositions, String type) {
        Map<Long, List<PersonSourceEntity>> map;
        String pkKey;
        if (ObjectUtils.isEmpty(sourceDatas)) {
            return;
        }
        if (HRStringUtils.equals((String)type, (String)"standardposition")) {
            pkKey = "id";
            map = sourceDatas.stream().collect(Collectors.groupingBy(PersonSourceEntity::getStandardposition));
        } else {
            pkKey = "job_id";
            map = sourceDatas.stream().collect(Collectors.groupingBy(PersonSourceEntity::getJob));
        }
        Map<Long, DynamicObject> standardpositionmap = standardPositions.stream().collect(Collectors.toMap(aa -> aa.getLong(pkKey), standardPosition -> standardPosition, (v1, v2) -> v2));
        for (Map.Entry<Long, List<PersonSourceEntity>> entry : map.entrySet()) {
            List<PersonSourceEntity> datas = entry.getValue();
            if (ObjectUtils.isEmpty(datas)) continue;
            DynamicObject standardPosition2 = standardpositionmap.get(entry.getKey());
            if (!ObjectUtils.isEmpty((Object)standardPosition2)) {
                for (PersonSourceEntity data : datas) {
                    data.setStandardposition(standardPosition2.getLong("boid"));
                }
                continue;
            }
            for (PersonSourceEntity data : datas) {
                data.setSuccess(false);
                String msg = ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u201c\u804c\u4f4d/\u6807\u51c6\u5c97\u4f4d\u201d\u6570\u636e\uff1b", (String)"StandardPositionApplicationImpl_16", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
                data.setErrorMsg(msg);
            }
        }
    }

    private void valideDateByStandardPosition(List<PersonSourceEntity> sourceDatas, List<DynamicObject> standardPositions) {
        if (ObjectUtils.isEmpty(sourceDatas) || ObjectUtils.isEmpty(standardPositions)) {
            return;
        }
        Map<Long, DynamicObject> map = standardPositions.stream().collect(Collectors.toMap(aa -> aa.getLong("id"), standardPosition -> standardPosition, (v1, v2) -> v2));
        for (PersonSourceEntity source : sourceDatas) {
            Long stdId = source.getStandardposition();
            DynamicObject standardDyn = map.get(stdId);
            if (ObjectUtils.isEmpty((Object)standardDyn)) continue;
            Date firstbsed = standardDyn.getDate("firstbsed");
            Date bsed_source = source.getEffect();
            if (!bsed_source.before(firstbsed)) continue;
            source.setSuccess(false);
            String msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u804c\u4f4d/\u6807\u51c6\u5c97\u4f4d\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\uff1b", (String)"StandardPositionApplicationImpl_18", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            source.setErrorMsg(msg);
        }
    }

    private List<PersonSourceEntity> getInfoFromSourceMap(List<Map<String, Object>> info, String type, boolean isInit) {
        int size;
        if (Objects.isNull(info) || (size = info.size()) == 0) {
            return null;
        }
        ArrayList<PersonSourceEntity> sourceDatas = new ArrayList<PersonSourceEntity>(size);
        for (int i = 0; i < size; ++i) {
            PersonSourceEntity personSourceEntity = new PersonSourceEntity();
            Map<String, Object> map = info.get(i);
            Object orgId = map.get("org");
            Object jobId = map.get("job");
            Object standardposition = map.get("standardposition");
            Object userId = map.get("user");
            Object effect = map.get("effect");
            Object bsled = map.get("bsled");
            long initBatch = (Long)map.getOrDefault("initbatch", 0L);
            StringBuilder errorMsg = new StringBuilder();
            boolean isSuccess = true;
            if (effect == null) {
                effect = PositionUtils.formatDate(new Date());
            }
            if (bsled == null) {
                bsled = PositionUtils.formatDate("2999-12-31");
            }
            if (!PositionUtils.checkLongValue(orgId).booleanValue() || !PositionUtils.checkLongValue(userId).booleanValue()) {
                errorMsg.append(ResManager.loadKDString((String)"\u201c\u7ec4\u7ec7\u201d\u6216\u201c\u4eba\u5458\u201d\u53c2\u6570\u9519\u8bef\uff1b", (String)"StandardPositionApplicationImpl_6", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                isSuccess = false;
            }
            if (HRStringUtils.isNotEmpty((String)type) && HRStringUtils.equals((String)type, (String)"job")) {
                if (!PositionUtils.checkLongValue(jobId).booleanValue()) {
                    errorMsg.append(ResManager.loadKDString((String)"\u201c\u804c\u4f4d\u201d\u53c2\u6570\u9519\u8bef\uff1b", (String)"StandardPositionApplicationImpl_7", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                    isSuccess = false;
                }
            } else if (!PositionUtils.checkLongValue(standardposition).booleanValue()) {
                errorMsg.append(ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d \u53c2\u6570\u9519\u8bef\uff1b", (String)"StandardPositionApplicationImpl_8", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                isSuccess = false;
            }
            if (isInit && initBatch == 0L) {
                errorMsg.append(ResManager.loadKDString((String)"\u201c\u521d\u59cb\u5316\u6279\u6b21\u53f7\u201d\u53c2\u6570\u9519\u8bef\uff1b", (String)"StandardPositionApplicationImpl_9", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                isSuccess = false;
            }
            if (!PositionUtils.checkDateValue(effect).booleanValue() || !PositionUtils.checkDateValue(bsled).booleanValue()) {
                errorMsg.append(ResManager.loadKDString((String)"\u201c\u751f\u6548\u65e5\u671f\u201d\u6216\u201c\u5931\u6548\u65e5\u671f\u201d\u53c2\u6570\u9519\u8bef\uff1b", (String)"StandardPositionApplicationImpl_10", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                isSuccess = false;
            } else {
                Date bsledFormatDate;
                Date effectFormatDate = PositionUtils.formatDate((Date)effect);
                if (effectFormatDate.after(bsledFormatDate = PositionUtils.formatDate((Date)bsled))) {
                    errorMsg.append(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5931\u6548\u65e5\u671f\uff1b", (String)"StandardPositionApplicationImpl_11", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                    isSuccess = false;
                }
            }
            if (!isSuccess) {
                personSourceEntity.setErrorMsg(errorMsg.toString());
            } else {
                personSourceEntity.setOrg((Long)orgId);
                personSourceEntity.setJob((Long)jobId);
                personSourceEntity.setUser((Long)userId);
                personSourceEntity.setEffect((Date)effect);
                personSourceEntity.setStandardposition((Long)standardposition);
                personSourceEntity.setBsled((Date)bsled);
                personSourceEntity.setInitBatch(initBatch);
            }
            personSourceEntity.setSuccess(isSuccess);
            sourceDatas.add(personSourceEntity);
        }
        return sourceDatas;
    }

    private void validePositionBsledDate(List<PersonSourceEntity> sourceDatas, Function<PersonSourceEntity, String> getKey) {
        if (ObjectUtils.isEmpty(sourceDatas)) {
            return;
        }
        Map<String, List<PersonSourceEntity>> sourceMap = sourceDatas.stream().collect(Collectors.groupingBy(data -> (String)getKey.apply((PersonSourceEntity)data)));
        Date currentDate = PositionUtils.formatDate(new Date());
        for (Map.Entry<String, List<PersonSourceEntity>> entry : sourceMap.entrySet()) {
            Date blsed_source;
            List<PersonSourceEntity> datas = entry.getValue();
            if (ObjectUtils.isEmpty(sourceDatas) || datas.size() <= 1) continue;
            int index = 0;
            for (PersonSourceEntity data2 : datas) {
                blsed_source = data2.getBsled();
                if (!blsed_source.before(currentDate)) {
                    ++index;
                }
                if (index <= 1) continue;
                break;
            }
            if (index <= true) continue;
            for (PersonSourceEntity data2 : datas) {
                blsed_source = data2.getBsled();
                if (blsed_source.before(currentDate)) continue;
                data2.setSuccess(false);
                data2.setErrorMsg(ResManager.loadKDString((String)"\u4e00\u4e2a\u4eba\u5458\u5728\u540c\u4e00\u4e2a\u90e8\u95e8\u540c\u4e00\u4e2a\u804c\u4f4d\u4e0b\u53ea\u80fd\u6709\u4e00\u6761\u751f\u6548\u7684\u6570\u636e\uff1b", (String)"StandardPositionApplicationImpl_12", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
        }
    }

    private void dealHasDealPosition(List<PersonSourceEntity> info, boolean isInit) {
        int size = info.size();
        ArrayList<Long> orgIds = new ArrayList<Long>(size);
        ArrayList<Long> userIds = new ArrayList<Long>(size);
        ArrayList<Long> standardIds = new ArrayList<Long>(size);
        info.forEach(value -> {
            orgIds.add(value.getOrg());
            userIds.add(value.getUser());
            standardIds.add(value.getStandardposition());
        });
        Object[] hasDealDarkPositions = PositionQueryRepository.getInstance().queryPositionByOrgAndUserAndStandardIds(orgIds, userIds, standardIds);
        if (ObjectUtils.isEmpty((Object[])hasDealDarkPositions)) {
            return;
        }
        Map<String, List<DynamicObject>> hasDealDarkPositionMap = Arrays.stream(hasDealDarkPositions).collect(Collectors.groupingBy(pos -> pos.getString("adminorg.id") + pos.getString("stposition.id") + pos.getString("person")));
        for (PersonSourceEntity personInfo : info) {
            Date personBsled;
            String happyKey = String.valueOf(personInfo.getOrg()) + String.valueOf(personInfo.getStandardposition()) + String.valueOf(personInfo.getUser());
            List<DynamicObject> posList = hasDealDarkPositionMap.get(happyKey);
            if (CollectionUtils.isEmpty(posList) || (personBsled = personInfo.getBsled()).before(new Date())) continue;
            if (isInit) {
                String msg = ResManager.loadKDString((String)"\u8be5\u4eba\u5458\u5728\u8be5\u90e8\u95e8\u7684\u804c\u4f4d\u6216\u6807\u5c97\u4e0b\u5df2\u6709\u751f\u6548\u4e2d\u7684\u6570\u636e\uff1b", (String)"StandardPositionApplicationImpl_13", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
                personInfo.setErrorMsg(msg);
                personInfo.setSuccess(false);
                continue;
            }
            this.toDisableDarkPos.addAll(posList.stream().map(pos -> pos.getLong("boid")).collect(Collectors.toList()));
        }
    }

    private List<StandardPositionOrgBo> queryStandardPositionBoByOrg(List<Long> orgIdList, boolean containsHis) {
        if (orgIdList == null || orgIdList.size() <= 0) {
            return null;
        }
        List<StandardPositionOrgBo> bos = StandardPositionOrgBo.buildBos(orgIdList);
        this.queryAndSetParentOrg(bos);
        ArrayList<Long> allSearchOrgIds = new ArrayList<Long>(16);
        bos.stream().forEach(data -> {
            allSearchOrgIds.add(data.getOrgId());
            List<Long> parentOrgs = data.getParentOrg();
            if (parentOrgs != null && parentOrgs.size() > 0) {
                allSearchOrgIds.addAll(parentOrgs);
            }
        });
        DynamicObject[] allStandardPositions = StandardPositionRepository.getInstance().queryStdPositionByOrg(allSearchOrgIds);
        Map<Long, List<DynamicObject>> boToDyns = null;
        if (containsHis) {
            List<Long> ids = Arrays.stream(allStandardPositions).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
            DynamicObject[] boDyns = StandardPositionRepository.getInstance().queryStdPositionVersionsByBo(ids);
            boToDyns = Arrays.stream(boDyns).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        }
        this.buildStandardPositionInfo(bos, allStandardPositions, boToDyns);
        return bos;
    }

    private void queryAndSetParentOrg(List<StandardPositionOrgBo> bos) {
        this.queryAndSetParentOrg(bos, new Date());
    }

    private void queryAndSetParentOrg(List<StandardPositionOrgBo> bos, Date date) {
        List<Long> orgIds = bos.stream().map(StandardPositionOrgBo::getOrgId).collect(Collectors.toList());
        List<Map<String, Object>> orgs = HaosMServiceHelper.haosBatchGetSupOrgTeamInfo(orgIds, date, StandardPositionOrgBo.ORGCOOPTYPE);
        if (orgs != null && orgs.size() > 0) {
            Map<Long, Long> orgAndParentOrgMap = orgs.stream().collect(Collectors.toMap(data -> (Long)data.get("orgTeamId"), da -> (Long)da.get("coopOrgTeamId"), (v1, v2) -> v2));
            for (StandardPositionOrgBo bo : bos) {
                HashSet<Long> set = new HashSet<Long>();
                this.setParentOrg(bo, bo.getOrgId(), orgAndParentOrgMap, set);
            }
        }
    }

    private void setParentOrg(StandardPositionOrgBo bo, Long orgId, Map<Long, Long> datasource, Set<Long> set) {
        if (datasource == null || datasource.size() <= 0 || orgId == null || orgId <= 0L) {
            return;
        }
        if (!set.add(orgId)) {
            logger.error("setParentOrg_worng ,ids contains a cycle=" + orgId);
            return;
        }
        Long parentOrg = datasource.get(orgId);
        if (parentOrg != null && parentOrg > 0L) {
            if (parentOrg.equals(orgId)) {
                logger.error("setParentOrg_worng ,id = parentid\u3002id=" + orgId);
                return;
            }
            List parentOrgs = Optional.ofNullable(bo.getParentOrg()).orElseGet(() -> new ArrayList());
            parentOrgs.add(parentOrg);
            bo.setParentOrg(parentOrgs);
            this.setParentOrg(bo, parentOrg, datasource, set);
        }
    }

    private void buildStandardPositionInfo(List<StandardPositionOrgBo> bos, DynamicObject[] allStandardPositions, Map<Long, List<DynamicObject>> boToDyns) {
        if (allStandardPositions != null && allStandardPositions.length > 0) {
            Set ignoreKeys = Stream.of(STANDARDPOSITION_ENTRY).collect(Collectors.toSet());
            for (DynamicObject dy : allStandardPositions) {
                DynamicObjectCollection orgs = dy.getDynamicObjectCollection(STANDARDPOSITION_ENTRY);
                if (orgs == null || orgs.size() <= 0) continue;
                Set supportOrgId = orgs.stream().map(data -> data.getLong("adminorg.id")).collect(Collectors.toSet());
                Set supportContainSubOrgId = orgs.stream().filter(data -> data.getBoolean("iscontainsu")).map(data -> data.getLong("adminorg.id")).collect(Collectors.toSet());
                for (StandardPositionOrgBo bo : bos) {
                    List<Long> parentOrg;
                    boolean exist = false;
                    if (supportOrgId.contains(bo.getOrgId())) {
                        exist = true;
                    } else if (supportContainSubOrgId.size() > 0 && (parentOrg = bo.getParentOrg()) != null && parentOrg.size() > 0) {
                        for (Long parentid : parentOrg) {
                            if (!supportContainSubOrgId.contains(parentid)) continue;
                            exist = true;
                            break;
                        }
                    }
                    if (!exist) continue;
                    List standardPositions = Optional.ofNullable(bo.getStandardPositions()).orElseGet(() -> new ArrayList());
                    if (boToDyns != null) {
                        long boid = dy.getLong("id");
                        List<DynamicObject> list = boToDyns.get(boid);
                        if (list == null) continue;
                        standardPositions.addAll(list);
                        bo.setStandardPositions(standardPositions);
                        bo.setExist(true);
                        continue;
                    }
                    DynamicObject newObject = new DynamicObject((DynamicObjectType)dy.getDataEntityType());
                    HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)newObject, ignoreKeys);
                    newObject.set("id", dy.get("id"));
                    standardPositions.add(newObject);
                    bo.setStandardPositions(standardPositions);
                    bo.setExist(true);
                }
            }
        }
    }

    @Override
    public Map<String, Object> initAddDarkPosition(List<Map<String, Object>> info) {
        logger.info(String.format("Init StandardPositionApplication2Impl addDarkPosition %s", info));
        List<PersonSourceEntity> sourceDatas = this.getInfoFromSourceMap(info, "standardposition", true);
        if (Objects.isNull(sourceDatas)) {
            String msg = ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1b", (String)"StandardPositionApplicationImpl_5", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            return this.buildSuccessResult(201, msg, PersonSourceEntity.toMap(sourceDatas));
        }
        List<PersonSourceEntity> successData = this.getSuccessData(sourceDatas);
        this.validate(successData, "standardposition");
        return this.saveDarkPos(sourceDatas, "standardposition", true);
    }

    @Override
    public Map<String, Object> initAddDarkPositionByJob(List<Map<String, Object>> info) {
        logger.info(String.format("init StandardPositionApplication2Impl addDarkPositionByJob %s", info));
        List<PersonSourceEntity> sourceDatas = this.getInfoFromSourceMap(info, "job", true);
        if (Objects.isNull(sourceDatas)) {
            String msg = ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1b", (String)"StandardPositionApplicationImpl_5", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            return this.buildSuccessResult(201, msg, PersonSourceEntity.toMap(sourceDatas));
        }
        List<PersonSourceEntity> successData = this.getSuccessData(sourceDatas);
        this.validate(successData, "job");
        return this.saveDarkPos(sourceDatas, "job", true);
    }

    private Map<String, Object> buildSuccessResult(int code, String ErrMsg, Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", code);
        result.put("ErrMsg", ErrMsg);
        result.put("data", data);
        return result;
    }

    private Map<String, Object> buildResultMap(Long id, Boolean success, String msg) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("position", id);
        result.put("state", success);
        result.put("ErrMsg", msg);
        return result;
    }

    public void buildAndSaveDarkStandPos(long initBatch) {
        logger.info("dark_stpos_create start {}", (Object)initBatch);
        long startTime = System.currentTimeMillis();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"hbpm_positionhr");
        String dbRouteKey = dataEntityType.getDBRouteKey();
        String table = dataEntityType.getAlias();
        ArrayList<Long> paramList = new ArrayList<Long>(1);
        paramList.add(initBatch);
        ArrayList<Long> jobIds = new ArrayList<Long>();
        String sql = "SELECT fstandardposid from " + table + " WHERE finitbatch = ? and fiscurrentversion = '1' and   fjobid != 0 and fstandardposid != 0 and fjobid = fstandardposid  group by fstandardposid ";
        try (DataSet rs = HRDBUtil.queryDataSet((String)"HbpmPositionQuery_getDarkStdposId", (DBRoute)new DBRoute(dbRouteKey), (String)sql, (Object[])paramList.toArray(new Object[]{paramList.size()}));){
            rs.forEach(data -> jobIds.add(data.getLong("fstandardposid")));
        }
        Object[] stdPositions = StandardPositionRepository.getInstance().queryAllDarkStandardIdsPositionByJobIds(jobIds);
        if (!ObjectUtils.isEmpty((Object[])stdPositions)) {
            Set hasStandardJobIds = Arrays.stream(stdPositions).map(data -> data.getLong("id")).collect(Collectors.toSet());
            jobIds.removeAll(hasStandardJobIds);
        }
        long time2 = System.currentTimeMillis();
        logger.info("dark_stpos_create query, dark_stpos size {} ,initbatch:{}, cost time {} ms", new Object[]{jobIds.size(), initBatch, time2 - startTime});
        List jobIdListGroup = Lists.partition(jobIds, (int)1000);
        for (List jobIdList : jobIdListGroup) {
            Map jobInfos = (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMService", (String)"getJobAndEvevtInfoByBoIds", (Object[])new Object[]{jobIdList});
            logger.info(String.format("refresh_init_StandardPositionApplication2Impl addDarkPositionByJob get jobInfos %s", jobInfos));
            this.buildAndSaveDarkStandardPositionInfo(initBatch, jobInfos, false);
        }
        logger.info("dark_stpos_create invoke_jobmservice, initbatch:{},cost time {} ms", (Object)initBatch, (Object)(System.currentTimeMillis() - time2));
        logger.info("dark_stpos_create end, initbatch:{}, total_cost time {} ms", (Object)initBatch, (Object)(System.currentTimeMillis() - startTime));
    }

    public void darkstandarpositioncreate(long initBatch) {
        logger.info("dark_stpos_create start_thread {}", (Object)initBatch);
        threadPool.execute(() -> this.buildAndSaveDarkStandPos(initBatch));
    }

    @Override
    public Map<String, Object> validateAddDarkPosition(List<Map<String, Object>> info) {
        logger.info(String.format("validte_StandardPositionApplication2Impl addDarkPosition %s", info));
        List<PersonSourceEntity> sourceDatas = this.getInfoFromSourceMap(info, "standardposition", false);
        if (Objects.isNull(sourceDatas)) {
            return this.buildSuccessResult(201, "all Input parameter information is error.", PersonSourceEntity.toMap(sourceDatas));
        }
        this.validate(sourceDatas, "standardposition");
        return this.buildSuccessResult(200, "", PersonSourceEntity.toMap(sourceDatas));
    }

    @Override
    public Map<String, Object> validateAddDarkPositionByJob(List<Map<String, Object>> info) {
        logger.info(String.format("validate_StandardPositionApplication2Impl addDarkPositionByJob %s", info));
        List<PersonSourceEntity> sourceDatas = this.getInfoFromSourceMap(info, "job", false);
        if (Objects.isNull(sourceDatas)) {
            return this.buildSuccessResult(201, "all Input parameter information is error.", PersonSourceEntity.toMap(sourceDatas));
        }
        this.validate(sourceDatas, "job");
        return this.buildSuccessResult(200, "", PersonSourceEntity.toMap(sourceDatas));
    }

    private void validate(List<PersonSourceEntity> sourceDatas, String type) {
        this.validePositionBsledDate(sourceDatas, data -> String.valueOf(data.getOrg()) + (HRStringUtils.equals((String)type, (String)"standardposition") ? data.getStandardposition() : data.getJob()) + data.getUser());
        List<PersonSourceEntity> successData = this.getSuccessData(sourceDatas);
        if (ObjectUtils.isEmpty(successData)) {
            return;
        }
        List<DynamicObject> standPosList = this.getStandPosByType(successData, type);
        this.dealStandardPositionSourceDatas(successData, standPosList, type);
        this.valideDateByStandardPosition(successData, standPosList);
        List<PersonSourceEntity> successDataAfterValidate = this.getSuccessData(successData);
        if (ObjectUtils.isEmpty(successDataAfterValidate)) {
            return;
        }
        List<Long> orgIds = successDataAfterValidate.stream().map(PersonSourceEntity::getOrg).collect(Collectors.toList());
        this.orgMap = this.queryOrg(orgIds);
        this.standardPositionMap = standPosList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (oldValue, newValue) -> oldValue));
        for (PersonSourceEntity personSourceEntity : successDataAfterValidate) {
            Long org;
            Map<String, Object> orgEntiy;
            Long stId = personSourceEntity.getStandardposition();
            DynamicObject stdPositionDy = this.standardPositionMap.get(stId);
            if (HRObjectUtils.isEmpty((Object)stdPositionDy)) {
                personSourceEntity.setSuccess(false);
                String msg = ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u201c\u804c\u4f4d/\u6807\u51c6\u5c97\u4f4d\u201d\u6570\u636e\uff1b", (String)"StandardPositionApplicationImpl_16", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
                personSourceEntity.setErrorMsg(msg);
            }
            if (!CollectionUtils.isEmpty(orgEntiy = this.orgMap.get(String.valueOf(org = personSourceEntity.getOrg())))) continue;
            personSourceEntity.setSuccess(false);
            String msg = ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u201c\u7ec4\u7ec7\u201d\u6570\u636e\uff1b", (String)"StandardPositionApplicationImpl_17", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            personSourceEntity.setErrorMsg(msg);
        }
    }

    private List<DynamicObject> getStandPosByType(List<PersonSourceEntity> canDealSourceData, String type) {
        List<DynamicObject> newStandardPositions;
        if (HRStringUtils.equals((String)type, (String)"standardposition")) {
            List<Long> ids = canDealSourceData.stream().map(PersonSourceEntity::getStandardposition).collect(Collectors.toList());
            DynamicObject[] stDys = StandardPositionRepository.getInstance().queryAllHasInitStandardPosition(ids);
            return Arrays.asList(stDys);
        }
        List<Long> jobIds = canDealSourceData.stream().map(PersonSourceEntity::getJob).collect(Collectors.toList());
        Object[] stdPositions = StandardPositionRepository.getInstance().queryAllDarkStandardPositionByJobIds(jobIds);
        List<Object> allStandardPosition = new ArrayList();
        if (!ObjectUtils.isEmpty((Object[])stdPositions)) {
            Set hasStandardJobIds = Arrays.stream(stdPositions).map(data -> data.getLong("job.id")).collect(Collectors.toSet());
            jobIds.removeAll(hasStandardJobIds);
            allStandardPosition = Arrays.asList(stdPositions);
            allStandardPosition = new ArrayList(allStandardPosition);
        }
        logger.info(String.format("StandardPositionApplication2Impl addDarkPositionByJob get jobids  %s", jobIds));
        if (!ObjectUtils.isEmpty(jobIds)) {
            this.toCreateDarkStdPosJobInfos = (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMService", (String)"getJobAndEvevtInfoByBoIds", (Object[])new Object[]{jobIds});
            logger.info(String.format("StandardPositionApplication2Impl addDarkPositionByJob get jobInfos %s", this.toCreateDarkStdPosJobInfos));
        }
        if (!ObjectUtils.isEmpty(this.toCreateDarkStdPosJobInfos) && !ObjectUtils.isEmpty(newStandardPositions = this.buildAndSaveDarkStandardPositionInfo(0L, this.toCreateDarkStdPosJobInfos, true))) {
            allStandardPosition.addAll(newStandardPositions);
        }
        return allStandardPosition;
    }

    private Map<String, Object> saveDarkPos(List<PersonSourceEntity> sourceDatas, String type, boolean isInit) {
        List<PersonSourceEntity> successDataAfterValidate = this.getSuccessData(sourceDatas);
        if (ObjectUtils.isEmpty(successDataAfterValidate)) {
            return this.buildSuccessResult(200, "", PersonSourceEntity.toMap(sourceDatas));
        }
        try (TXHandle required = TX.required();){
            try {
                List<DynamicObject> positions = this.buildDarkPositionInfo(successDataAfterValidate, isInit);
                if (!ObjectUtils.isEmpty(positions)) {
                    if (!isInit) {
                        new DarkPositionApplicationImpl().disableRepeatDarkPos(this.toDisableDarkPos);
                    }
                    this.saveDarkPositionInfo(positions);
                    Map<Long, DynamicObject> posMap = positions.stream().collect(Collectors.toMap(position -> position.getLong("id"), pos -> pos));
                    successDataAfterValidate.forEach(data -> {
                        Long id = data.getPosition();
                        DynamicObject position = (DynamicObject)posMap.get(id);
                        if (!Objects.isNull(position)) {
                            data.setWorkrole(position.getLong("workrole"));
                        }
                    });
                }
            }
            catch (Exception ex) {
                required.markRollback();
                logger.error((Throwable)ex);
                Map<String, Object> map = this.buildSuccessResult(201, ex.getMessage(), null);
                if (required != null) {
                    if (var6_6 != null) {
                        try {
                            required.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        required.close();
                    }
                }
                return map;
            }
        }
        if (HRStringUtils.equals((String)type, (String)"job") && !isInit) {
            threadPool.execute(() -> this.buildAndSaveDarkStandPos(this.toCreateDarkStdPosJobInfos));
        }
        return this.buildSuccessResult(200, "", PersonSourceEntity.toMap(sourceDatas));
    }

    private List<PersonSourceEntity> getSuccessData(List<PersonSourceEntity> sourceDatas) {
        return sourceDatas.stream().filter(PersonSourceEntity::isSuccess).collect(Collectors.toList());
    }

    private void buildAndSaveDarkStandPos(Map<String, DynamicObject[]> toCreateDarkStdPosJobInfos) {
        this.buildAndSaveDarkStandardPositionInfo(0L, toCreateDarkStdPosJobInfos, false);
    }

    @Override
    public QueryHisByOrgResult queryHisByOrg(QueryHisByOrgParam queryHisByOrgParam) {
        Collection orgIds = queryHisByOrgParam.getOrgIds();
        if (orgIds.size() == 0) {
            QueryHisByOrgResult queryHisByOrgResult = new QueryHisByOrgResult();
            queryHisByOrgResult.setOrgIdVsStdPosList(Collections.emptyMap());
            return queryHisByOrgResult;
        }
        Date date = queryHisByOrgParam.getDate();
        List<StandardPositionOrgBo> bos = StandardPositionOrgBo.buildBos(orgIds);
        this.queryAndSetParentOrg(bos, date);
        HashMap idVsParentOrgSet = new HashMap();
        ArrayList<Long> allSearchOrgIds = new ArrayList<Long>(16);
        bos.forEach(data -> {
            allSearchOrgIds.add(data.getOrgId());
            List<Long> parentOrgs = data.getParentOrg();
            if (parentOrgs != null && parentOrgs.size() > 0) {
                allSearchOrgIds.addAll(parentOrgs);
                idVsParentOrgSet.put(data.getOrgId(), new HashSet<Long>(parentOrgs));
            }
        });
        DynamicObject[] allStandardPositions = StandardPositionRepository.getInstance().queryHisStdPositionByOrg(allSearchOrgIds, date);
        Map<Long, List<DynamicObject>> orgIdVsStdPosDyList = Arrays.stream(allStandardPositions).collect(Collectors.groupingBy(stdPosDy -> stdPosDy.getLong("entryentity.adminorg.id")));
        Map<Long, List> result = orgIds.stream().collect(Collectors.toMap(orgId -> orgId, orgId -> {
            Set parentOrgIdSet = idVsParentOrgSet.getOrDefault(orgId, Collections.emptySet());
            List stdPosDyList = parentOrgIdSet.stream().map(parentOrgId -> orgIdVsStdPosDyList.getOrDefault(parentOrgId, Collections.emptyList())).flatMap(Collection::stream).filter(stdPosDy -> stdPosDy.getBoolean("entryentity.iscontainsu")).collect(Collectors.toList());
            stdPosDyList.addAll(orgIdVsStdPosDyList.getOrDefault(orgId, Collections.emptyList()));
            return stdPosDyList;
        }));
        QueryHisByOrgResult queryHisByOrgResult = new QueryHisByOrgResult();
        queryHisByOrgResult.setOrgIdVsStdPosList(result);
        return queryHisByOrgResult;
    }

    @Override
    public ValidStdPosAndOrgAndDateResult validStandardPositionAndOrgAndDate(ValidStdPosAndOrgAndDateParam validStdPosAndOrgAndDateParam) {
        List stdPosAndOrgList = validStdPosAndOrgAndDateParam.getStdPosAndOrgList();
        Date date = validStdPosAndOrgAndDateParam.getDate();
        Set orgIdSet = stdPosAndOrgList.stream().map(StdPosAndOrg::getOrg).collect(Collectors.toSet());
        QueryHisByOrgParam queryHisByOrgParam = new QueryHisByOrgParam();
        queryHisByOrgParam.setOrgIds(orgIdSet);
        queryHisByOrgParam.setDate(date);
        QueryHisByOrgResult queryHisByOrgResult = this.queryHisByOrg(queryHisByOrgParam);
        Map orgIdVsStdPosList = queryHisByOrgResult.getOrgIdVsStdPosList();
        Map<StdPosAndOrg, Boolean> StdPosVsMatchResult = stdPosAndOrgList.stream().collect(Collectors.toMap(stdPosAndOrg -> stdPosAndOrg, stdPosAndOrg -> {
            long org = stdPosAndOrg.getOrg();
            long stdPos = stdPosAndOrg.getStdPos();
            List stdPosDyList = orgIdVsStdPosList.getOrDefault(org, Collections.emptyList());
            return stdPosDyList.stream().anyMatch(stdPosDy -> stdPosDy.getLong("boid") == stdPos);
        }));
        ValidStdPosAndOrgAndDateResult validStdPosAndOrgAndDateResult = new ValidStdPosAndOrgAndDateResult();
        validStdPosAndOrgAndDateResult.setDate(date);
        validStdPosAndOrgAndDateResult.setStdAndPosVsCheckResult(StdPosVsMatchResult);
        return validStdPosAndOrgAndDateResult;
    }

    @Override
    public List<Map<String, Object>> queryStandardPositionContainsHisByOrg(List<Long> orgIdList, boolean containsHis) {
        List<StandardPositionOrgBo> bos = this.queryStandardPositionBoByOrg(orgIdList, containsHis);
        return StandardPositionOrgBo.toMap(bos);
    }
}

