/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.projectrole;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hrmp.hbpm.business.application.impl.workrole.DutyWorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.ReportingRelationServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.impl.workrole.WorkRoleServiceApplicationImpl;
import kd.hrmp.hbpm.business.application.projectrole.IProjectRoleApplication;
import kd.hrmp.hbpm.business.domain.repository.position.DutyWorkRoleQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ProjectRoleQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ReportingrelationQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.WorkRoleQueryRepository;
import kd.hrmp.hbpm.business.domain.service.impl.projectrole.ProRoleServiceImpl;
import kd.hrmp.hbpm.business.domain.service.impl.workrole.WorkRoleServiceImpl;
import kd.hrmp.hbpm.business.service.utils.DynamicObjectScale;
import kd.hrmp.hbpm.business.utils.DynamicObjectLogHelper;
import kd.hrmp.hbpm.business.utils.LocalDateRangeUtils;
import kd.hrmp.hbpm.business.utils.LogHelper;
import kd.hrmp.hbpm.business.utils.NewHisUtils;
import kd.hrmp.hbpm.business.utils.PRJRoleUtils;
import kd.hrmp.hbpm.business.utils.WorkRoleConverter;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;
import kd.hrmp.hbpm.common.constants.ProjectRoleConstants;
import kd.hrmp.hbpm.common.model.role.RelListsAfterCompareModel;
import kd.hrmp.hbpm.common.util.LocalDateRange;

public class ProjectRoleApplicationImpl
implements IProjectRoleApplication,
ProjectRoleConstants {
    private static final Log LOG = LogFactory.getLog(ProjectRoleApplicationImpl.class);
    private static final String CODE_SUCCESS = "200";
    private static final String[] LOG_FIELDS = new String[]{"id", "number", "isdutypers", "superroles", "projteam", "bsed", "bsled"};

    private ProjectRoleApplicationImpl() {
    }

    public static ProjectRoleApplicationImpl getInstance() {
        return ProjectRoleApplicationImplInstance.INSTANCE;
    }

    @Override
    public HisResponse<VersionChangeRespData> saveProjectRoles(List<DynamicObject> projectRoleList) {
        this.logProjectRole(projectRoleList, "saveProjectRoles");
        if (CollectionUtils.isEmpty(projectRoleList)) {
            return null;
        }
        Throwable throwable = null;
        try (TXHandle required = TX.required();){
            WorkRoleNewHisUtils.fillId(projectRoleList);
            HisResponse<VersionChangeRespData> response = NewHisUtils.saveHis(projectRoleList);
            if (!CODE_SUCCESS.equals(response.getCode())) {
                throw new KDBizException(response.getErrorMessage());
            }
            this.addDutyRoles(projectRoleList);
            this.addWorkRoles(projectRoleList);
            this.addAllReportingRelations(projectRoleList);
            HisResponse<VersionChangeRespData> hisResponse = response;
            return hisResponse;
        }
        catch (KDBizException e) {
            required.markRollback();
            LOG.error(String.format("saveProjectRoles fail. error: %s", new Object[]{e}));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return null;
    }

    @Override
    public HisResponse<VersionChangeRespData> disableProjectRoles(List<DynamicObject> projectRoleList) {
        this.logProjectRole(projectRoleList, "disableProjectRoles");
        if (CollectionUtils.isEmpty(projectRoleList)) {
            return null;
        }
        Throwable throwable = null;
        try (TXHandle required = TX.required();){
            HisResponse<VersionChangeRespData> response = NewHisUtils.saveHis(projectRoleList);
            if (!CODE_SUCCESS.equals(response.getCode())) {
                throw new KDBizException(response.getErrorMessage());
            }
            Date effDt = projectRoleList.get(0).getDate("bsed");
            List<Long> projectRoleBoIdList = projectRoleList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
            this.disableDutyRoles(projectRoleBoIdList, effDt, "disable");
            this.disableWorkRoles(projectRoleBoIdList, effDt, "disable");
            this.disableReportRelations(projectRoleBoIdList, effDt, "disable");
            HisResponse<VersionChangeRespData> hisResponse = response;
            return hisResponse;
        }
        catch (KDBizException e) {
            required.markRollback();
            LOG.error(String.format("disableProjectRoles fail. error: %s", new Object[]{e}));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return null;
    }

    @Override
    public HisResponse<VersionChangeRespData> enableProjectRoles(List<DynamicObject> projectRoleList) {
        this.logProjectRole(projectRoleList, "enableProjectRoles");
        if (CollectionUtils.isEmpty(projectRoleList)) {
            return null;
        }
        Throwable throwable = null;
        try (TXHandle required = TX.required();){
            HisResponse<VersionChangeRespData> response = NewHisUtils.saveHis(projectRoleList);
            if (!CODE_SUCCESS.equals(response.getCode())) {
                throw new KDBizException(response.getErrorMessage());
            }
            Date effDt = projectRoleList.get(0).getDate("bsed");
            List<Long> projectRoleBoIdList = projectRoleList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
            this.disableDutyRoles(projectRoleBoIdList, effDt, "enable");
            this.disableWorkRoles(projectRoleBoIdList, effDt, "enable");
            this.disableReportRelations(projectRoleBoIdList, effDt, "enable");
            HisResponse<VersionChangeRespData> hisResponse = response;
            return hisResponse;
        }
        catch (KDBizException e) {
            required.markRollback();
            LOG.error(String.format("enableProjectRoles fail. error: %s", new Object[]{e}));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return null;
    }

    @Override
    public HisResponse<VersionChangeRespData> changeProjectRolesOnlyADRelation(List<DynamicObject> projectRoleList) {
        this.logProjectRole(projectRoleList, "changeProjectRolesOnlyADRelation");
        if (CollectionUtils.isEmpty(projectRoleList)) {
            return null;
        }
        Throwable throwable = null;
        try (TXHandle required = TX.required();){
            List<DynamicObject> dy4ChgProp = WorkRoleNewHisUtils.getDy4ChgProp(projectRoleList);
            HisResponse<VersionChangeRespData> response = NewHisUtils.saveHis(dy4ChgProp);
            if (!CODE_SUCCESS.equals(response.getCode())) {
                throw new KDBizException(response.getErrorMessage());
            }
            this.changeDutyRoles(projectRoleList);
            this.changeWorkRoles(projectRoleList);
            this.changeAdministrativeReportingRelations(projectRoleList);
            HisResponse<VersionChangeRespData> hisResponse = response;
            return hisResponse;
        }
        catch (KDBizException e) {
            required.markRollback();
            LOG.error(String.format("changeProjectRolesOnlyADRelation fail. error: %s", new Object[]{e}));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return null;
    }

    private void changeDutyRoles(List<DynamicObject> newHisPRJRoleList) {
        List<Long> boIds = newHisPRJRoleList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        DynamicObject[] dutyWorkRoles = DutyWorkRoleQueryRepository.getInstance().queryDutyWorkRoleByIds(boIds);
        Map<Long, DynamicObject> boIdVsDutyRole = Arrays.stream(dutyWorkRoles).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        for (DynamicObject projectRole : newHisPRJRoleList) {
            DynamicObject dutyRole = boIdVsDutyRole.get(projectRole.getLong("boid"));
            PRJRoleUtils.changeDutyRoles(dutyRole, projectRole);
        }
        DutyWorkRoleServiceApplicationImpl dutyWorkRoleServiceApplication = new DutyWorkRoleServiceApplicationImpl();
        dutyWorkRoleServiceApplication.changeDutyRoles("2", Arrays.asList(dutyWorkRoles));
    }

    private void changeWorkRoles(List<DynamicObject> newHisPRJRoleList) {
        List<Long> boIds = newHisPRJRoleList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        DynamicObject[] WorkRoles = WorkRoleQueryRepository.getInstance().queryByDutyRoleIds(boIds);
        Map<Long, DynamicObject> boIdVsWorkRole = Arrays.stream(WorkRoles).collect(Collectors.toMap(dy -> WorkRoleNewHisUtils.smartGetId(dy, "position"), dy -> dy));
        ArrayList<DynamicObject> toSaveWorkRoleList = new ArrayList<DynamicObject>(newHisPRJRoleList.size());
        for (DynamicObject projectRole : newHisPRJRoleList) {
            DynamicObject workRole = boIdVsWorkRole.get(projectRole.getLong("boid"));
            DynamicObject newWorkRole = new DynamicObject(workRole.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)workRole, (DynamicObject)newWorkRole);
            PRJRoleUtils.changeWorkRoles(newWorkRole, projectRole);
            toSaveWorkRoleList.add(newWorkRole);
        }
        WorkRoleNewHisUtils.setPrefixNumber(toSaveWorkRoleList);
        WorkRoleServiceApplicationImpl dutyWorkRoleServiceApplication = new WorkRoleServiceApplicationImpl();
        dutyWorkRoleServiceApplication.changeWorkRolesProp("2", toSaveWorkRoleList);
    }

    private void changeAdministrativeReportingRelations(List<DynamicObject> newHisPRJRoleList) {
        List deleteReportList;
        ReportingRelationServiceApplicationImpl reportingRelationServiceApplication = new ReportingRelationServiceApplicationImpl();
        RelListsAfterCompareModel relListsAfterCompareModel = this.compareAndGetResult(newHisPRJRoleList);
        List changeReportList = relListsAfterCompareModel.getChangeReportList();
        if (!CollectionUtils.isEmpty((Collection)changeReportList)) {
            reportingRelationServiceApplication.changeReportRelationsProp("2", changeReportList);
        }
        if (!CollectionUtils.isEmpty((Collection)(deleteReportList = relListsAfterCompareModel.getDeleteReportList()))) {
            Date effectDate = ((DynamicObject)deleteReportList.get(0)).getDate("bsed");
            reportingRelationServiceApplication.enableOrDisableReportRelations(deleteReportList, "disable", effectDate);
        }
    }

    private RelListsAfterCompareModel compareAndGetResult(List<DynamicObject> newHisPRJRoleList) {
        List parentBoIds = newHisPRJRoleList.stream().map(dy -> WorkRoleNewHisUtils.smartGetId(dy, "superroles")).collect(Collectors.toList());
        List<Long> boIds = newHisPRJRoleList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        DynamicObject[] administrativeRelations = ReportingrelationQueryRepository.getInstance().queryAdministrativeRelationByDutyRoleIds(boIds);
        boIds.addAll(parentBoIds);
        RelListsAfterCompareModel relListsAfterCompareModel = new RelListsAfterCompareModel();
        Map<Long, DynamicObject> dutyRoleIdVsADRelation = Arrays.stream(administrativeRelations).collect(Collectors.toMap(dy -> dy.getLong("role.position.id"), dy -> dy, (relation1, relation2) -> {
            throw new RuntimeException(String.format("same duty work role map to multiple AD relations that effecting enabled, relation ids\uff1a%s, %s", relation1.getLong("role"), relation2.getLong("role")));
        }));
        for (DynamicObject PRJRole : newHisPRJRoleList) {
            DynamicObject dbAdministrativeRelation = dutyRoleIdVsADRelation.get(PRJRole.getLong("boid"));
            DynamicObject newAdministrativeRelation = PRJRoleUtils.createAdministrativeRelation4New(PRJRole);
            Object dbParent = dbAdministrativeRelation.get("parent");
            Object newParent = newAdministrativeRelation.get("parent");
            DynamicObjectScale dynamicObjectScale = new DynamicObjectScale(dbParent, newParent);
            int balance = dynamicObjectScale.balance();
            switch (balance) {
                case 0: 
                case 1: 
                case 2: {
                    PRJRoleUtils.changeAdministrativeRelation(dbAdministrativeRelation, PRJRole);
                    relListsAfterCompareModel.addChangeReportingRel(dbAdministrativeRelation);
                    break;
                }
                case -1: {
                    relListsAfterCompareModel.addDeleteReportingRel(dbAdministrativeRelation);
                    break;
                }
            }
        }
        return relListsAfterCompareModel;
    }

    private void addDutyRoles(List<DynamicObject> newPRJRoleList) {
        List<DynamicObject> dutyRoleList = newPRJRoleList.stream().map(PRJRoleUtils::createDutyRole4New).collect(Collectors.toList());
        DutyWorkRoleServiceApplicationImpl dutyWorkRoleServiceApplication = new DutyWorkRoleServiceApplicationImpl();
        dutyWorkRoleServiceApplication.addDutyRoles(dutyRoleList);
    }

    private void addWorkRoles(List<DynamicObject> newPRJRoleList) {
        List<DynamicObject> workRoleList = newPRJRoleList.stream().map(PRJRoleUtils::createWorkRole4New).collect(Collectors.toList());
        WorkRoleServiceApplicationImpl workRoleServiceApplication = new WorkRoleServiceApplicationImpl();
        workRoleServiceApplication.addWorkRoles(workRoleList);
    }

    private void addAllReportingRelations(List<DynamicObject> newPRJRoleList) {
        Set prjParentRoleBoIdSet = newPRJRoleList.stream().map(dy -> WorkRoleNewHisUtils.smartGetId(dy, "superroles")).collect(Collectors.toSet());
        Set prjRoleBoIdSet = newPRJRoleList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        prjRoleBoIdSet.addAll(prjParentRoleBoIdSet);
        WorkRoleConverter workRoleConverter = new WorkRoleConverter(new ArrayList<Long>(prjRoleBoIdSet));
        List<DynamicObject> administrativeRelationList = newPRJRoleList.stream().map(PRJRoleUtils::createAdministrativeRelation4New).collect(Collectors.toList());
        List nonAdministrativeRelationList = newPRJRoleList.stream().map(prjRole -> PRJRoleUtils.createNonAdministrativeRelation4New(prjRole, workRoleConverter)).reduce(new ArrayList(), (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        });
        ReportingRelationServiceApplicationImpl reportingRelationServiceApplication = new ReportingRelationServiceApplicationImpl();
        administrativeRelationList.addAll(nonAdministrativeRelationList);
        reportingRelationServiceApplication.addReportRelations(administrativeRelationList);
    }

    private void disableDutyRoles(List<Long> dutyRoleBoIdList, Date effDt, String enableState) {
        DynamicObject[] dutyRoles = DutyWorkRoleQueryRepository.getInstance().queryDutyWorkRoleByIds4Disable(dutyRoleBoIdList);
        Arrays.stream(dutyRoles).forEach(dy -> dy.set("bsed", (Object)effDt));
        DutyWorkRoleServiceApplicationImpl dutyWorkRoleServiceApplication = new DutyWorkRoleServiceApplicationImpl();
        dutyWorkRoleServiceApplication.enableOrDisableDutyRoles(Arrays.asList(dutyRoles), enableState, effDt);
    }

    private void disableWorkRoles(List<Long> dutyRoleBoIdList, Date effDt, String enableState) {
        DynamicObject[] workRoles = WorkRoleQueryRepository.getInstance().queryByDutyRoleIds4Disable(dutyRoleBoIdList);
        Arrays.stream(workRoles).forEach(dy -> dy.set("bsed", (Object)effDt));
        WorkRoleServiceApplicationImpl workRoleServiceApplication = new WorkRoleServiceApplicationImpl();
        workRoleServiceApplication.enableOrDisableRoles(enableState, Arrays.asList(workRoles), effDt);
    }

    private void disableReportRelations(List<Long> dutyRoleBoIdList, Date effDt, String enableState) {
        DynamicObject[] reportingRelations = ReportingrelationQueryRepository.getInstance().queryByDutyRoleIds4Disable(dutyRoleBoIdList);
        Arrays.stream(reportingRelations).forEach(dy -> dy.set("bsed", (Object)effDt));
        ReportingRelationServiceApplicationImpl reportingRelationServiceApplication = new ReportingRelationServiceApplicationImpl();
        reportingRelationServiceApplication.enableOrDisableReportRelations(Arrays.asList(reportingRelations), enableState, effDt);
    }

    private void logProjectRole(List<DynamicObject> projectRoleList, String keyString) {
        if (CollectionUtils.isEmpty(projectRoleList)) {
            LOG.info(String.format("%s request param. projectRoleList : %s", keyString, projectRoleList));
        } else {
            List<Map<String, String>> result = DynamicObjectLogHelper.convertDynamicObject2Map(projectRoleList, LOG_FIELDS);
            LOG.info(String.format("%s request param. projectRoleList : %s", keyString, result));
        }
    }

    @Override
    public HisResponse<VersionChangeRespData> changeProjectRoleByProjectTeam(List<DynamicObject> projectTeamList) {
        if (CollectionUtils.isEmpty(projectTeamList)) {
            LogHelper.infoIfEnable(LOG, () -> "changeProjectRoleByProjectTeam success with empty params");
            return new HisResponse();
        }
        LogHelper.infoIfEnable(LOG, () -> String.format("changeProjectRoleByProjectTeam start with %s", DynamicObjectLogHelper.convertDynamicObject2Map(projectTeamList, "id", "org", "bsed", "bsled")));
        Set<Long> prjTeamBoSet = projectTeamList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        Optional<Date> earliestBsedOpt = projectTeamList.stream().map(dy -> dy.getDate("bsed")).reduce((bsed, bsed2) -> bsed.before((Date)bsed2) ? bsed : bsed2);
        Date earliestBsed = earliestBsedOpt.get();
        DynamicObject[] hisPrjRole4PrjTeamParentChg = ProjectRoleQueryRepository.getInstance().queryByPrjTeamParentChg(prjTeamBoSet, earliestBsed);
        Map<Long, List<OrgChangeModel>> prjTeamBoVsPrjRoleList = Arrays.stream(hisPrjRole4PrjTeamParentChg).map(this::getOrgChangeModelByPrjRole).collect(Collectors.groupingBy(model -> model.prjTeamBo));
        Map<Long, List<OrgChangeModel>> prjTeamBoVsPrjTeamList = projectTeamList.stream().map(this::getOrgChangeModelByPrjTeam).collect(Collectors.groupingBy(model -> model.bo));
        List changedPrjRoleModelList = prjTeamBoVsPrjTeamList.entrySet().stream().flatMap(prjTeamBoVsPrjTeam -> {
            long prjTeamBo = (Long)prjTeamBoVsPrjTeam.getKey();
            List prjTeamList = (List)prjTeamBoVsPrjTeam.getValue();
            List prjRoleList = prjTeamBoVsPrjRoleList.getOrDefault(prjTeamBo, Collections.emptyList());
            return prjTeamList.stream().flatMap(prjTeamModel -> prjRoleList.stream().filter(prjRole -> prjRole.effectRange.overlaps(prjTeamModel.effectRange)).filter(prjRole -> prjRole.org != prjTeamModel.org).map(prjRoleModel -> this.copyAndSetModel((OrgChangeModel)prjTeamModel, (OrgChangeModel)prjRoleModel)));
        }).collect(Collectors.toList());
        if (changedPrjRoleModelList.size() == 0) {
            LogHelper.infoIfEnable(LOG, () -> "success with no prj role need to change");
            return new HisResponse();
        }
        Set<Long> prjRoleBoSet = changedPrjRoleModelList.stream().map(model -> model.id).collect(Collectors.toSet());
        DynamicObject[] hisPrjRoles = ProjectRoleQueryRepository.getInstance().loadById(prjRoleBoSet);
        Map<Long, DynamicObject> idVsPrjRoleDy = Arrays.stream(hisPrjRoles).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        List<DynamicObject> toBeChangedPrjRoleList = changedPrjRoleModelList.stream().map(prjRoleModel -> this.copyPrjRoleAndSetByModel(idVsPrjRoleDy, (OrgChangeModel)prjRoleModel)).collect(Collectors.toList());
        HisResponse<VersionChangeRespData> response = NewHisUtils.saveHis(toBeChangedPrjRoleList);
        this.changeWorkRolesMultiVersion(toBeChangedPrjRoleList);
        LogHelper.infoIfEnable(LOG, () -> String.format("success with response code: %s, message: %s", response.getCode(), response.getErrorMessage()));
        return response;
    }

    private OrgChangeModel copyAndSetModel(OrgChangeModel prjTeamModel, OrgChangeModel prjRoleModel) {
        OrgChangeModel orgChangeModel = new OrgChangeModel();
        orgChangeModel.effectRange = prjRoleModel.effectRange.intersection(prjTeamModel.effectRange);
        orgChangeModel.prjTeamBo = prjRoleModel.prjTeamBo;
        orgChangeModel.id = prjRoleModel.id;
        orgChangeModel.bo = prjRoleModel.bo;
        orgChangeModel.org = prjTeamModel.org;
        return orgChangeModel;
    }

    private void changeWorkRolesMultiVersion(List<DynamicObject> toBeChangedPrjRoleList) {
        Set<Long> boIds = toBeChangedPrjRoleList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
        List<Date> dateList = toBeChangedPrjRoleList.stream().map(dy -> dy.getDate("bsed")).collect(Collectors.toList());
        Date minDate = LocalDateRangeUtils.getMinDate(dateList);
        DynamicObject[] WorkRoles = WorkRoleQueryRepository.getInstance().queryByDutyRoleHisByDutyRoleIds(boIds, minDate);
        Map<Long, List<DynamicObject>> boIdVsWorkRoleList = Arrays.stream(WorkRoles).collect(Collectors.groupingBy(dy -> WorkRoleNewHisUtils.smartGetId(dy, "position")));
        ArrayList<DynamicObject> toSaveWorkRoleList = new ArrayList<DynamicObject>(toBeChangedPrjRoleList.size());
        for (DynamicObject projectRole : toBeChangedPrjRoleList) {
            List workRoleList = boIdVsWorkRoleList.getOrDefault(projectRole.getLong("boid"), Collections.emptyList());
            LocalDateRange projectRoleEffectRange = LocalDateRangeUtils.getEffectRange(projectRole);
            Object org = projectRole.get("org");
            workRoleList.stream().filter(workRole -> LocalDateRangeUtils.getEffectRange(workRole).overlaps(projectRoleEffectRange)).map(workRole -> {
                DynamicObject newWorkRole = new DynamicObject(workRole.getDynamicObjectType());
                HRDynamicObjectUtils.copy((DynamicObject)workRole, (DynamicObject)newWorkRole);
                newWorkRole.set("org", org);
                LocalDateRangeUtils.setEffectRange(newWorkRole, LocalDateRangeUtils.getEffectRange(workRole).intersection(projectRoleEffectRange));
                return newWorkRole;
            }).forEach(toSaveWorkRoleList::add);
        }
        WorkRoleNewHisUtils.setNewId(toSaveWorkRoleList);
        NewHisUtils.saveHis(toSaveWorkRoleList);
    }

    private DynamicObject copyPrjRoleAndSetByModel(Map<Long, DynamicObject> idVsPrjRoleDy, OrgChangeModel prjRoleModel) {
        DynamicObject hisPrjRoleDy = idVsPrjRoleDy.get(prjRoleModel.id);
        DynamicObject copy = new DynamicObject(hisPrjRoleDy.getDynamicObjectType());
        HRDynamicObjectUtils.copy((DynamicObject)hisPrjRoleDy, (DynamicObject)copy);
        LocalDateRangeUtils.setEffectRange(copy, prjRoleModel.effectRange);
        DynamicObjectType bos_org = EntityMetadataCache.getSubDataEntityType((String)"bos_org", Collections.singletonList("id"));
        DynamicObject org = new DynamicObject(bos_org);
        org.set("id", (Object)prjRoleModel.org);
        copy.set("org", (Object)org);
        return copy;
    }

    private OrgChangeModel getOrgChangeModelByPrjTeam(DynamicObject prjTeam) {
        OrgChangeModel orgChangeModel = new OrgChangeModel();
        orgChangeModel.id = prjTeam.getLong("id");
        orgChangeModel.bo = prjTeam.getLong("boid");
        orgChangeModel.org = prjTeam.getLong("org.id");
        orgChangeModel.effectRange = LocalDateRangeUtils.getEffectRange(prjTeam);
        return orgChangeModel;
    }

    private OrgChangeModel getOrgChangeModelByPrjRole(DynamicObject prjRole) {
        OrgChangeModel orgChangeModel = new OrgChangeModel();
        orgChangeModel.id = prjRole.getLong("id");
        orgChangeModel.bo = prjRole.getLong("boid");
        orgChangeModel.prjTeamBo = prjRole.getLong("projteam.id");
        orgChangeModel.org = prjRole.getLong("org.id");
        orgChangeModel.effectRange = LocalDateRangeUtils.getEffectRange(prjRole);
        return orgChangeModel;
    }

    @Override
    public boolean isHadDisableData(List<Long> idList, String entityNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        qFilter.and(new QFilter("enable", "=", (Object)"0"));
        QFilter idFilter = new QFilter("id", "in", idList);
        return serviceHelper.isExists(new QFilter[]{qFilter, idFilter});
    }

    @Override
    public Map<Long, Map<String, Map<String, Object>>> getProRoleVersionInfoByVid(Long curProRoleId, Long oldMainDutyVid) {
        if (curProRoleId == null) {
            throw new KDBizException("curProRoleId param is null!");
        }
        HashMap<Long, Map<String, Map<String, Object>>> dataMap = new HashMap<Long, Map<String, Map<String, Object>>>(2);
        HashSet<Long> idSet = new HashSet<Long>(8);
        idSet.add(curProRoleId);
        idSet.add(oldMainDutyVid);
        ProRoleServiceImpl proRoleInstance = ProRoleServiceImpl.getInstance();
        DynamicObject[] proRoleVersionDynArr = proRoleInstance.getProRoleVersionInfoByVidSet(idSet);
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        this.setFieldMap(fieldMap);
        HashSet<Long> beforeVidSet = new HashSet<Long>(8);
        this.assemblyProRoleBaseInfo(dataMap, proRoleVersionDynArr, fieldMap, beforeVidSet, "after");
        DynamicObject[] beforeProRoleDynArr = proRoleInstance.getProRoleVersionInfoByVidSet(beforeVidSet);
        this.assemblyProRoleBaseInfo(dataMap, beforeProRoleDynArr, fieldMap, null, "before");
        LOG.info("ProjectRoleApplicationImpl.getProRoleVersionInfoByVid,dataMap={}", (Object)SerializationUtils.toJsonString(dataMap));
        return dataMap;
    }

    private void assemblyProRoleBaseInfo(Map<Long, Map<String, Map<String, Object>>> dataMap, DynamicObject[] proRoleVersionDynArr, Map<String, String> fieldMap, Set<Long> beforeVidSet, String versionKey) {
        HashSet<Long> dutyBoIdSet = new HashSet<Long>(2);
        for (DynamicObject proRoleDyn : proRoleVersionDynArr) {
            Map<String, Map<String, Object>> versionDataMap = dataMap.get(proRoleDyn.getLong("boid"));
            if (versionDataMap == null) {
                versionDataMap = new HashMap<String, Map<String, Object>>(16);
            }
            versionDataMap.putIfAbsent("after", new HashMap(16));
            versionDataMap.putIfAbsent("before", new HashMap(16));
            Map<String, Object> dataInfoMap = versionDataMap.get(versionKey);
            if (dataInfoMap == null) continue;
            dutyBoIdSet.add(proRoleDyn.getLong("boid"));
            HRDynamicObjectUtils.assemblyDynToMap((DynamicObject)proRoleDyn, dataInfoMap, fieldMap);
            if (beforeVidSet != null) {
                beforeVidSet.add(proRoleDyn.getLong("sourcevid"));
            }
            dataMap.put(proRoleDyn.getLong("boid"), versionDataMap);
        }
        DynamicObject[] workRoleDynByArr = WorkRoleServiceImpl.getInstance().getWorkRoleDynByDutyBoId(new ArrayList<Long>(dutyBoIdSet));
        HashSet<Long> tempBoIdSet = new HashSet<Long>(8);
        if (workRoleDynByArr != null) {
            for (DynamicObject workRoleDyn : workRoleDynByArr) {
                if (workRoleDyn.getBoolean("iscurrentversion")) continue;
                Long boId = workRoleDyn.getLong("position.id");
                Map<String, Map<String, Object>> dataInfoMap = dataMap.get(workRoleDyn.getLong("position.id"));
                Date workRoleEffDate = HRDateTimeUtils.truncateDate((Date)workRoleDyn.getDate("bsed"));
                Date bsLedDate = HRDateTimeUtils.truncateDate((Date)workRoleDyn.getDate("bsled"));
                Map<String, Object> dataVersionMap = dataInfoMap.get(versionKey);
                Date versionEffDate = (Date)dataVersionMap.get("bsed");
                if (!versionEffDate.before(bsLedDate) || versionEffDate.before(workRoleEffDate) || !tempBoIdSet.add(boId)) continue;
                dataVersionMap.put("workRoleVid", workRoleDyn.getLong("id"));
            }
        }
    }

    private void setFieldMap(Map<String, String> fieldMap) {
        fieldMap.put("id", "id");
        fieldMap.put("boid", "boId");
        fieldMap.put("bsed", "bsed");
        fieldMap.put("name", "name");
        fieldMap.put("isdutypers", "isDutyPer");
        fieldMap.put("bsed", "bsed");
    }

    static class OrgChangeModel {
        long id;
        long bo;
        long org;
        long prjTeamBo;
        LocalDateRange effectRange;

        OrgChangeModel() {
        }
    }

    private static class ProjectRoleApplicationImplInstance {
        private static ProjectRoleApplicationImpl INSTANCE = new ProjectRoleApplicationImpl();

        private ProjectRoleApplicationImplInstance() {
        }
    }
}

