/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.workrole;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hrmp.hbpm.business.application.workrole.IDutyWorkRoleServiceApplication;
import kd.hrmp.hbpm.business.domain.repository.position.DutyWorkRoleQueryRepository;
import kd.hrmp.hbpm.business.service.workroles.DutyRolesApiServiceHelper;
import kd.hrmp.hbpm.common.constants.PositionConstants;

public class DutyWorkRoleServiceApplicationImpl
implements IDutyWorkRoleServiceApplication {
    @Override
    public List<DynamicObject> createNewDutyRole(List<DynamicObject> positions) {
        List<DynamicObject> dutyRoleFromPosition = this.createDutyRoleFromPosition(positions);
        this.addDutyRoles(dutyRoleFromPosition);
        return dutyRoleFromPosition;
    }

    @Override
    public List<DynamicObject> updateDutyRole(List<DynamicObject> positions) {
        List<DynamicObject> dutyRole = this.updateDutyRoleFromPosition(positions);
        this.changeDutyRoles("1", dutyRole);
        return dutyRole;
    }

    @Override
    public void addDutyRoles(List<DynamicObject> dutyWorkRoleList) {
        ApiResult apiResult = DutyRolesApiServiceHelper.addDutyRoles(dutyWorkRoleList);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public void changeDutyRoles(String opType, List<DynamicObject> dutyRoles) {
        ApiResult apiResult = DutyRolesApiServiceHelper.changeDutyRolesProp(opType, dutyRoles);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public void deleteDutyRoles(List<Long> roleIds) {
        ApiResult apiResult = DutyRolesApiServiceHelper.deleteDutyRoles(roleIds);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public void enableOrDisableDutyRoles(List<DynamicObject> dutyRolesList, String enable) {
        ApiResult apiResult = DutyRolesApiServiceHelper.changeDutyWorkStatus(enable, dutyRolesList);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public void enableOrDisableDutyRoles(List<DynamicObject> dutyRolesList, String enable, Date effectDate) {
        ApiResult apiResult = DutyRolesApiServiceHelper.changeDutyWorkStatus(enable, dutyRolesList, effectDate);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    public List<DynamicObject> createDutyRoleFromPosition(List<DynamicObject> positions) {
        ArrayList dutyWorkRoleList = Lists.newArrayListWithExpectedSize((int)positions.size());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_dutyworkroles");
        positions.stream().forEach(position -> {
            DynamicObject dutyWorkRole = new DynamicObject((DynamicObjectType)dataEntityType);
            dutyWorkRole.set("id", (Object)position.getLong("id"));
            dutyWorkRole.set("name", (Object)position.getString("name"));
            dutyWorkRole.set("number", (Object)position.getString("number"));
            dutyWorkRole.set("teamtype", (Object)PositionConstants.ORGTEAM_TEAMTYPE_POSITION);
            dutyWorkRole.set("orgtype", (Object)PositionConstants.ORGTEAM_TEAMTYPE_POSITION);
            dutyWorkRole.set("enable", (Object)position.getString("enable"));
            dutyWorkRole.set("initstatus", (Object)position.getString("initstatus"));
            dutyWorkRole.set("initdatasource", (Object)position.getString("initdatasource"));
            dutyWorkRole.set("initbatch", (Object)position.getLong("initbatch"));
            dutyWorkRole.set("bsed", (Object)position.getDate("bsed"));
            dutyWorkRoleList.add(dutyWorkRole);
        });
        return dutyWorkRoleList;
    }

    private List<DynamicObject> updateDutyRoleFromPosition(List<DynamicObject> positions) {
        ArrayList dutyWorkRoleList = Lists.newArrayListWithExpectedSize((int)positions.size());
        List<Long> positionIds = positions.stream().map(position -> position.getLong("boid")).collect(Collectors.toList());
        Map<Long, DynamicObject> dutyWorkRoles = DutyWorkRoleQueryRepository.getInstance().queryDutyWorkRoleToMap(positionIds);
        for (DynamicObject position2 : positions) {
            DynamicObject dutyWorkRoleDB = dutyWorkRoles.get(position2.getLong("boid"));
            DynamicObject dutyWorkRole = DutyWorkRoleQueryRepository.getInstance().getEmptyDyn();
            HRDynamicObjectUtils.copy((DynamicObject)dutyWorkRoleDB, (DynamicObject)dutyWorkRole);
            dutyWorkRole.set("name", (Object)position2.getString("name"));
            dutyWorkRole.set("number", (Object)position2.getString("number"));
            dutyWorkRole.set("enable", (Object)position2.getString("enable"));
            dutyWorkRole.set("bsed", (Object)position2.getDate("bsed"));
            dutyWorkRole.set("bsled", (Object)position2.getDate("bsled"));
            dutyWorkRoleList.add(dutyWorkRole);
        }
        return dutyWorkRoleList;
    }
}

