/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.workrole;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hbpm.business.application.workrole.IReportingRelationServiceApplication;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ReportingrelationQueryRepository;
import kd.hrmp.hbpm.business.service.workroles.ReportRelationApiServiceHelper;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;
import kd.hrmp.hbpm.common.constants.EffectiveStatusEnum;

public class ReportingRelationServiceApplicationImpl
implements IReportingRelationServiceApplication {
    @Override
    public List<DynamicObject> createSysReportRel(List<DynamicObject> newWorkRole) {
        List<DynamicObject> sysReportRelFromWorkRole = WorkRoleNewHisUtils.createSysReportRelFromWorkRole(newWorkRole);
        if (!CollectionUtils.isEmpty(sysReportRelFromWorkRole)) {
            this.addReportRelations(sysReportRelFromWorkRole);
        }
        return sysReportRelFromWorkRole;
    }

    @Override
    public List<DynamicObject> createNewReportRelationAndSysReportRel(List<DynamicObject> positions, Map<String, DynamicObjectCollection> reportRelationEntryEntity, List<DynamicObject> newWorkRole) {
        List<DynamicObject> sysReportRelFromWorkRole = WorkRoleNewHisUtils.createSysReportRelFromWorkRole(newWorkRole);
        List<DynamicObject> reportRelations = this.createReportRelations(positions, reportRelationEntryEntity);
        reportRelations.addAll(sysReportRelFromWorkRole);
        if (!CollectionUtils.isEmpty(reportRelations)) {
            this.addReportRelations(reportRelations);
        }
        return reportRelations;
    }

    @Override
    public void updateReportRelation(List<DynamicObject> positions, Map<String, DynamicObjectCollection> reportRelationEntryEntity) {
        ArrayList<DynamicObject> newReportRelations = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> modifyReportRelations = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> deleteReportRelations = new ArrayList<DynamicObject>();
        this.modifyReportRelationsByPositionBills(positions, reportRelationEntryEntity, newReportRelations, modifyReportRelations, deleteReportRelations);
        if (!CollectionUtils.isEmpty(newReportRelations)) {
            this.addReportRelations(newReportRelations);
        }
        if (!CollectionUtils.isEmpty(modifyReportRelations)) {
            this.changeReportRelationsProp("1", modifyReportRelations);
        }
        if (!CollectionUtils.isEmpty(deleteReportRelations)) {
            this.changeReportRelationsProp("1", deleteReportRelations);
        }
    }

    @Override
    public void updateSysReportRel(List<DynamicObject> positions, EffectiveStatusEnum effectiveStatusEnum) {
        ArrayList<DynamicObject> modifyReportRelations = new ArrayList<DynamicObject>();
        this.modifyRealReportRelations(positions, effectiveStatusEnum, modifyReportRelations);
        if (!CollectionUtils.isEmpty(modifyReportRelations)) {
            this.changeReportRelationsProp("2", modifyReportRelations);
        }
    }

    @Override
    public void reviseSysReportRel(DynamicObject position, Long oldParentRoleId) {
        ArrayList<DynamicObject> modifyReportRelations = new ArrayList<DynamicObject>();
        long roleId = position.getLong("workrole.id");
        DynamicObject roleRelation = ReportingrelationQueryRepository.getInstance().queryRelationBoIdByRole(roleId);
        HashMap relationMap = Maps.newHashMapWithExpectedSize((int)8);
        relationMap.put(roleId, roleRelation);
        this.reviseRealReportRelations(position, oldParentRoleId, modifyReportRelations, relationMap);
        if (!CollectionUtils.isEmpty(modifyReportRelations)) {
            this.changeReportRelationsProp("2", modifyReportRelations);
        }
    }

    @Override
    public void batchReviseSysReportRel(List<DynamicObject> positionList) {
        Map<Long, Date> boIdAndBSedMap = positionList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getDate("bsed")));
        Map<Long, DynamicObject> longDateMap = PositionQueryRepository.getInstance().queryPositionHisVersionBSled(boIdAndBSedMap);
        ArrayList<DynamicObject> modifyReportRelations = new ArrayList<DynamicObject>();
        List<Long> workRoleId = positionList.stream().map(position -> position.getLong("workrole.id")).collect(Collectors.toList());
        List<DynamicObject> reportRelations = ReportingrelationQueryRepository.getInstance().queryRealReportRelationByPositionIds(workRoleId);
        Map<Long, DynamicObject> relationMap = reportRelations.stream().collect(Collectors.toMap(dyn -> dyn.getLong("role.id"), dyn -> dyn));
        for (DynamicObject position2 : positionList) {
            long boid = position2.getLong("boid");
            DynamicObject preVersion = longDateMap.get(boid);
            if (preVersion == null) continue;
            long oldParentRoleId = preVersion.getLong("parent.workrole.id");
            this.reviseRealReportRelations(position2, oldParentRoleId, modifyReportRelations, relationMap);
        }
        if (!CollectionUtils.isEmpty(modifyReportRelations)) {
            this.changeReportRelationsProp("2", modifyReportRelations);
        }
    }

    @Override
    public void addReportRelations(List<DynamicObject> reportRelations) {
        ApiResult apiResult = ReportRelationApiServiceHelper.addReportRelations(reportRelations);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public void enableOrDisableReportRelations(List<DynamicObject> reportRelationIdList, String enable) {
        ApiResult apiResult = ReportRelationApiServiceHelper.changeReportRelationsStatus(enable, reportRelationIdList);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public void enableOrDisableReportRelations(List<DynamicObject> reportRelationIdList, String enable, Date effectDate) {
        ApiResult apiResult = ReportRelationApiServiceHelper.changeReportRelationsStatus(enable, reportRelationIdList, effectDate);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public void changeReportRelationsProp(String opType, List<DynamicObject> roles) {
        ApiResult apiResult = ReportRelationApiServiceHelper.changeReportRelationsProp(opType, roles);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public void deleteAllReportingRelationByWorkRoles(List<Long> workRoleIdList) {
        ApiResult apiResult = ReportRelationApiServiceHelper.deleteReportRelationsByWorkRole(workRoleIdList);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    public void modifyReportRelationsByPositionBills(List<DynamicObject> positions, Map<String, DynamicObjectCollection> reportRelationEntryEntity, List<DynamicObject> newReportRelations, List<DynamicObject> modifyReportRelations, List<DynamicObject> deleteReportRelations) {
        Map<Long, Map<Long, DynamicObject>> workRoleAndRelationsMap = this.getEffectiveRelationByBsed(positions);
        for (DynamicObject position : positions) {
            Long sourceWorkRole = position.getLong("workrole.id");
            Map<Long, DynamicObject> reportRelationForDB = workRoleAndRelationsMap.get(sourceWorkRole);
            ArrayList<Long> modifyIds = new ArrayList<Long>();
            this.handleReportRelation(reportRelationEntryEntity, position, newReportRelations, modifyReportRelations, reportRelationForDB, modifyIds, "boid");
            List<Object> collect = Lists.newArrayListWithExpectedSize((int)16);
            if (!CollectionUtils.isEmpty(reportRelationForDB)) {
                collect = reportRelationForDB.keySet().stream().filter(id -> !modifyIds.contains(id)).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty((Collection)collect)) continue;
            for (Long id2 : collect) {
                DynamicObject reportRelation = reportRelationForDB.get(id2);
                if (HRObjectUtils.isEmpty((Object)reportRelation)) continue;
                reportRelation.set("bsed", (Object)position.getDate("bsed"));
                reportRelation.set("enable", (Object)"0");
                deleteReportRelations.add(reportRelation);
            }
        }
    }

    private void modifyRealReportRelations(List<DynamicObject> positions, EffectiveStatusEnum effectiveStatusEnum, List<DynamicObject> modifyReportRelations) {
        if ((positions = positions.stream().filter(o -> this.ishisVersionChange((DynamicObject)o, effectiveStatusEnum)).collect(Collectors.toList())).size() == 0) {
            return;
        }
        List<Long> workRoleId = positions.stream().map(position -> position.getLong("workrole.id")).collect(Collectors.toList());
        List<DynamicObject> reportRelations = ReportingrelationQueryRepository.getInstance().queryRealReportRelationByPositionIds(workRoleId);
        Map<Long, DynamicObject> workRoleAndRelationsMap = reportRelations.stream().collect(Collectors.toMap(report -> report.getLong("role.id"), report -> report));
        ArrayList workRoles = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dynamicObject : positions) {
            DynamicObject report2 = workRoleAndRelationsMap.get(dynamicObject.getLong("workrole.id"));
            DynamicObject positionParent = dynamicObject.getDynamicObject("parent");
            if (ObjectUtils.isEmpty((Object)report2)) {
                if (ObjectUtils.isEmpty((Object)positionParent)) continue;
                workRoles.add(dynamicObject.getDynamicObject("workrole"));
                continue;
            }
            this.handleReportRelationEffectiveDate(report2, dynamicObject);
            if (ObjectUtils.isEmpty((Object)positionParent)) {
                report2.set("enable", (Object)"0");
            } else {
                if (positionParent.getLong("workrole.id") == report2.getLong("parent.id") && "1".equals(report2.getString("enable"))) {
                    if ("0".equals(dynamicObject.getString("enable"))) {
                        report2.set("enable", (Object)"0");
                    } else {
                        if (!HRDateTimeUtils.dayAfter((Date)dynamicObject.getDate("bsled"), (Date)report2.getDate("bsled"))) continue;
                        report2.set("bsled", (Object)dynamicObject.getDate("bsled"));
                    }
                }
                report2.set("parent", (Object)dynamicObject.getDynamicObject("parent").getDynamicObject("workrole"));
                report2.set("enable", (Object)dynamicObject.getString("enable"));
            }
            modifyReportRelations.add(report2);
        }
        if (!CollectionUtils.isEmpty((Collection)workRoles)) {
            modifyReportRelations.addAll(WorkRoleNewHisUtils.createSysReportRelFromWorkRole(workRoles));
        }
    }

    private boolean ishisVersionChange(DynamicObject position, EffectiveStatusEnum effectiveStatusEnum) {
        Date bsled = position.getDate("bsled");
        return bsled == null || !HRDateTimeUtils.dayBefore((Date)bsled, (Date)PositionUtils.getCurrentDate()) || effectiveStatusEnum != EffectiveStatusEnum.PreviousEffective;
    }

    private void reviseRealReportRelations(DynamicObject position, Long oldParentRoleId, List<DynamicObject> modifyReportRelations, Map<Long, DynamicObject> relationMap) {
        long roleId = position.getLong("workrole.id");
        DynamicObject roleRelation = relationMap.get(roleId);
        DynamicObject newParent = position.getDynamicObject("parent");
        if (this.isLongEmpty(oldParentRoleId) && ObjectUtils.isEmpty((Object)newParent)) {
            return;
        }
        DynamicObject newRelation = WorkRoleNewHisUtils.createSysReportRelFromWorkRoleForRevise(roleRelation, position.getDynamicObject("workrole"));
        modifyReportRelations.add(newRelation);
    }

    private boolean isLongEmpty(Long id) {
        return id == null || id == 0L;
    }

    public List<DynamicObject> createReportRelations(List<DynamicObject> positions, Map<String, DynamicObjectCollection> reportRelationEntryEntity) {
        ArrayList<DynamicObject> reportRelations = new ArrayList<DynamicObject>();
        if (CollectionUtils.isEmpty(reportRelationEntryEntity)) {
            return reportRelations;
        }
        positions.stream().forEach(position -> {
            DynamicObjectCollection entryEntity = (DynamicObjectCollection)reportRelationEntryEntity.get(position.getString("number"));
            if (entryEntity != null && entryEntity.size() > 0) {
                Long sourceWorkRole = position.getLong("workrole");
                for (DynamicObject entity : entryEntity) {
                    DynamicObject reportRelation = this.createNewReportRelation(entity, sourceWorkRole, (DynamicObject)position);
                    reportRelations.add(reportRelation);
                }
            }
        });
        return reportRelations;
    }

    private void handleReportRelation(Map<String, DynamicObjectCollection> reportRelationEntryEntity, DynamicObject position, List<DynamicObject> newReportRelations, List<DynamicObject> modifyReportRelations, Map<Long, DynamicObject> reportRelationForDB, List<Long> modifyIds, String bokey) {
        if (CollectionUtils.isEmpty(reportRelationEntryEntity)) {
            return;
        }
        DynamicObjectCollection entryEntity = reportRelationEntryEntity.get(position.getString("number"));
        for (DynamicObject entity : entryEntity) {
            long boid = entity.getLong(bokey);
            if (boid == 0L) {
                newReportRelations.add(this.createNewReportRelation(entity, position.getLong("workrole.id"), position));
                continue;
            }
            DynamicObject reportRelation = reportRelationForDB.get(boid);
            if (reportRelation == null) {
                newReportRelations.add(this.createNewReportRelation(entity, position.getLong("workrole.id"), position));
            } else {
                this.updateReportRelation(reportRelation, entity, position);
                modifyReportRelations.add(reportRelation);
            }
            modifyIds.add(boid);
        }
    }

    private DynamicObject createNewReportRelation(DynamicObject entity, Long sourceWorkRole, DynamicObject position) {
        DynamicObject reportRelation = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hbpm_reportingrelation"));
        reportRelation.set("id", (Object)PositionUtils.createId("hbpm_reportingrelation"));
        reportRelation.set("role", (Object)sourceWorkRole);
        reportRelation.set("sourcetype", (Object)1010L);
        reportRelation.set("reportingtype", (Object)entity.getDynamicObject("reporttype"));
        reportRelation.set("parent", (Object)entity.getDynamicObject("targetworkrole"));
        reportRelation.set("enable", (Object)position.getString("enable"));
        reportRelation.set("initstatus", (Object)position.getString("initstatus"));
        reportRelation.set("initdatasource", (Object)position.getString("initdatasource"));
        reportRelation.set("initbatch", (Object)position.getLong("initbatch"));
        this.handleReportRelationEffectiveDate(reportRelation, position);
        return reportRelation;
    }

    private void handleReportRelationEffectiveDate(DynamicObject reportRelation, DynamicObject position) {
        reportRelation.set("bsed", (Object)position.getDate("bsed"));
    }

    private void updateReportRelation(DynamicObject reportRelation, DynamicObject entity, DynamicObject position) {
        reportRelation.set("reportingtype", (Object)entity.getDynamicObject("reporttype"));
        reportRelation.set("parent", (Object)entity.getDynamicObject("targetworkrole"));
        this.handleReportRelationEffectiveDate(reportRelation, position);
    }

    private Map<Long, Map<Long, DynamicObject>> getEffectiveRelationByBsed(List<DynamicObject> positions) {
        List<Long> workRoleId = positions.stream().map(position -> position.getLong("workrole.id")).collect(Collectors.toList());
        List<DynamicObject> reportRelations = ReportingrelationQueryRepository.getInstance().queryPositionRelationhis(workRoleId);
        HashMap<Long, Map<Long, DynamicObject>> workRoleAndRelationsMap = new HashMap<Long, Map<Long, DynamicObject>>();
        Map<Long, Date> positionBsedMap = positions.stream().collect(Collectors.toMap(dyn -> dyn.getLong("workrole.id"), dyn -> dyn.getDate("bsed")));
        for (DynamicObject reportRelation : reportRelations) {
            Long roleId = reportRelation.getLong("role.id");
            Date bsled = reportRelation.getDate("bsled");
            Date posBsed = positionBsedMap.get(roleId);
            if (HRDateTimeUtils.dayAfter((Date)posBsed, (Date)bsled)) continue;
            HashMap<Long, DynamicObject> dynamicObjects = (HashMap<Long, DynamicObject>)workRoleAndRelationsMap.get(reportRelation.getLong("role.id"));
            if (CollectionUtils.isEmpty((Map)dynamicObjects)) {
                dynamicObjects = new HashMap<Long, DynamicObject>();
                dynamicObjects.put(reportRelation.getLong("boid"), reportRelation);
                workRoleAndRelationsMap.put(reportRelation.getLong("role.id"), dynamicObjects);
                continue;
            }
            dynamicObjects.put(reportRelation.getLong("boid"), reportRelation);
        }
        return workRoleAndRelationsMap;
    }

    @Override
    public void importRelation(List<DynamicObject> positions) {
        ArrayList<DynamicObject> newReportRelations = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> deleteReportRelations = new ArrayList<DynamicObject>();
        Map<Long, Map<Long, DynamicObject>> workRoleAndRelationsMap = this.getEffectiveRelationByBsed(positions);
        for (DynamicObject position : positions) {
            Long sourceWorkRole = position.getLong("workrole.id");
            Map<Long, DynamicObject> reportRelationForDB = workRoleAndRelationsMap.get(sourceWorkRole);
            DynamicObjectCollection entryEntity = position.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : entryEntity) {
                DynamicObject newRelation = this.createNewReportRelation(entity, position.getLong("workrole.id"), position);
                newReportRelations.add(newRelation);
                if (reportRelationForDB == null || reportRelationForDB.size() <= 0) continue;
                for (DynamicObject relationFromDB : reportRelationForDB.values()) {
                    if (relationFromDB.getLong("reportingtype.id") != newRelation.getLong("reportingtype.id")) continue;
                    relationFromDB.set("bsed", (Object)position.getDate("bsed"));
                    relationFromDB.set("enable", (Object)"0");
                    deleteReportRelations.add(relationFromDB);
                }
            }
        }
        if (!CollectionUtils.isEmpty(newReportRelations)) {
            this.addReportRelations(newReportRelations);
        }
        if (!CollectionUtils.isEmpty(deleteReportRelations)) {
            this.changeReportRelationsProp("1", deleteReportRelations);
        }
    }
}

