/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.application.impl.workrole;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.application.workrole.IWorkRoleServiceApplication;
import kd.hrmp.hbpm.business.domain.repository.position.WorkRoleQueryRepository;
import kd.hrmp.hbpm.business.service.position.PositionWorkRoleServiceHelper;
import kd.hrmp.hbpm.business.service.workroles.WorkRolesApiServiceHelper;
import kd.hrmp.hbpm.business.utils.PositionUtils;
import kd.hrmp.hbpm.business.utils.WorkRoleNewHisUtils;
import kd.hrmp.hbpm.common.constants.WorkRolesConstants;

public class WorkRoleServiceApplicationImpl
implements IWorkRoleServiceApplication {
    private static final int MAX_QUERY_COUNT = 30;

    @Override
    public List<DynamicObject> createNewWorkRole(List<DynamicObject> positions, List<DynamicObject> newDutyRole) {
        Map<Long, DynamicObject> dutyRoleMap = PositionUtils.listToMap(newDutyRole, "id");
        List<DynamicObject> newWorkRole = this.createWorkRoleFromPosition(positions, dutyRoleMap);
        this.addWorkRoles(newWorkRole);
        return newWorkRole;
    }

    @Override
    public List<DynamicObject> updateWorkRole(List<DynamicObject> positions) {
        List<DynamicObject> updateWorkRole = this.updateWorkRoleFromPosition(positions);
        this.changeWorkRolesProp("1", updateWorkRole);
        return updateWorkRole;
    }

    @Override
    public void addWorkRoles(List<DynamicObject> workRoles) {
        ApiResult apiResult = WorkRolesApiServiceHelper.addWorkRoles(workRoles);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public void enableOrDisableRoles(String enable, List<DynamicObject> workRoleIdList) {
        ApiResult apiResult = WorkRolesApiServiceHelper.changeWorkRolesStatus(enable, workRoleIdList);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public void enableOrDisableRoles(String enable, List<DynamicObject> workRoleIdList, Date effectDate) {
        ApiResult apiResult = WorkRolesApiServiceHelper.changeWorkRolesStatus(enable, workRoleIdList, effectDate);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public void changeWorkRolesProp(String opType, List<DynamicObject> roleList) {
        ApiResult apiResult = WorkRolesApiServiceHelper.changeWorkRolesProp(opType, roleList);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public void deleteWorkRoles(List<Long> roleIds) {
        ApiResult apiResult = WorkRolesApiServiceHelper.deleteWorkRoles(roleIds);
        if (!apiResult.getSuccess()) {
            throw new KDBizException(apiResult.getMessage());
        }
    }

    @Override
    public List<DynamicObject> queryAllParentRelations(Date date, List<Long> workroleIds, Long roletypeId) {
        ArrayList<Long> exsitWorkRoleIds = new ArrayList<Long>(workroleIds.size());
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(workroleIds.size());
        int count = 0;
        this.recurQueryParentRelations(date, workroleIds, roletypeId, exsitWorkRoleIds, result, count);
        return result;
    }

    public void recurQueryParentRelations(Date date, List<Long> workroleIds, Long roletypeId, List<Long> exsitWorkRoleIds, List<DynamicObject> result, int count) {
        if (count > 30) {
            return;
        }
        List<Long> needQueryWorkRoleIds = workroleIds.stream().filter(id -> exsitWorkRoleIds == null || !exsitWorkRoleIds.contains(id)).collect(Collectors.toList());
        Object[] relations = WorkRoleQueryRepository.getInstance().queryRelations(date, needQueryWorkRoleIds, roletypeId, qfilter -> {
            QFilter boidFilter = new QFilter("role", "in", (Object)workroleIds);
            qfilter.and(boidFilter);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            qfilter.and(enableFilter);
        });
        if (!ObjectUtils.isEmpty((Object[])relations)) {
            workroleIds.clear();
            Arrays.stream(relations).forEach(relation -> {
                result.add((DynamicObject)relation);
                if (relation.get("role.id") != null) {
                    exsitWorkRoleIds.add(relation.getLong("role.id"));
                }
                if (relation.get("parent.id") != null && relation.getLong("parent.id") != 0L) {
                    workroleIds.add(relation.getLong("parent.id"));
                }
            });
            this.recurQueryParentRelations(date, workroleIds, roletypeId, exsitWorkRoleIds, result, ++count);
        }
    }

    @Override
    public List<DynamicObject> queryAllChildRelations(Date date, List<Long> workroleIds, Long roletypeId) {
        ArrayList<Long> exsitWorkRoleIds = new ArrayList<Long>(workroleIds.size());
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(workroleIds.size());
        int count = 0;
        this.recurQueryChildRelations(date, workroleIds, roletypeId, exsitWorkRoleIds, result, count);
        return result;
    }

    public void recurQueryChildRelations(Date date, List<Long> workroleIds, Long roletypeId, List<Long> exsitWorkRoleIds, List<DynamicObject> result, int count) {
        if (count > 30) {
            return;
        }
        List<Long> needQueryWorkRoleIds = workroleIds.stream().filter(id -> exsitWorkRoleIds == null || !exsitWorkRoleIds.contains(id)).collect(Collectors.toList());
        Object[] relations = WorkRoleQueryRepository.getInstance().queryRelations(date, needQueryWorkRoleIds, roletypeId, qfilter -> {
            QFilter boidFilter = new QFilter("parent", "in", (Object)workroleIds);
            qfilter.and(boidFilter);
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            qfilter.and(enableFilter);
        });
        if (!ObjectUtils.isEmpty((Object[])relations)) {
            workroleIds.clear();
            Arrays.stream(relations).forEach(relation -> {
                result.add((DynamicObject)relation);
                if (relation.get("parent.id") != null) {
                    exsitWorkRoleIds.add(relation.getLong("parent.id"));
                }
                if (relation.get("role.id") != null && relation.getLong("role.id") != 0L) {
                    workroleIds.add(relation.getLong("role.id"));
                }
            });
            this.recurQueryChildRelations(date, workroleIds, roletypeId, exsitWorkRoleIds, result, ++count);
        }
    }

    public List<DynamicObject> createWorkRoleFromPosition(List<DynamicObject> positions, Map<Long, DynamicObject> dutyRoleMap) {
        ArrayList workRoleList = Lists.newArrayListWithExpectedSize((int)positions.size());
        HashMap positionToWorkRoleMap = Maps.newHashMapWithExpectedSize((int)positions.size());
        HashMap workRoleToParentPositionMap = Maps.newHashMapWithExpectedSize((int)16);
        positions.stream().forEach(position -> {
            DynamicObject workRole = this.emptyWorkRoleDynamicObject();
            workRole.set("id", (Object)PositionUtils.createId("hbpm_workroleshr"));
            workRole.set("number", (Object)position.getString("number"));
            workRole.set("name", (Object)position.getString("name"));
            workRole.set("adminorg", position.get("adminorg"));
            workRole.set("mainpeoincharge", (Object)position.getString("isleader"));
            workRole.set("enable", (Object)position.getString("enable"));
            workRole.set("status", (Object)"C");
            workRole.set("org", position.get("org"));
            DynamicObject roleType = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hbpm_roletype"));
            roleType.set("id", (Object)PositionWorkRoleServiceHelper.getRoleTypeInfo(position));
            workRole.set("roletype", (Object)roleType);
            DynamicObject parent = position.getDynamicObject("parent");
            if (!HRObjectUtils.isEmpty((Object)parent)) {
                if (!HRObjectUtils.isEmpty((Object)parent.getDynamicObject("workrole"))) {
                    workRole.set("parentrole", (Object)parent.getDynamicObject("workrole"));
                } else {
                    workRoleToParentPositionMap.put(workRole.getLong("id"), parent.getLong("id"));
                }
            }
            workRole.set("createtime", (Object)new Date());
            workRole.set("startdate", (Object)position.getDate("bsed"));
            if (HRStringUtils.equals((String)position.getString("createmode"), (String)"3")) {
                workRole.set("rolesourcetype", (Object)WorkRolesConstants.ROLE_SOURCE_TYPE_STDPOS);
            } else {
                workRole.set("rolesourcetype", (Object)WorkRolesConstants.ROLE_SOURCE_TYPE_POS);
            }
            workRole.set("teamtype", (Object)WorkRolesConstants.TEAM_TYPE_POS);
            workRole.set("orgtype", (Object)WorkRolesConstants.ORG_TYPE_POS);
            workRole.set("initstatus", (Object)position.getString("initstatus"));
            workRole.set("initdatasource", (Object)position.getString("initdatasource"));
            workRole.set("initbatch", (Object)position.getLong("initbatch"));
            workRole.set("position", dutyRoleMap.get(position.getLong("id")));
            workRole.set("bsed", (Object)position.getDate("bsed"));
            workRoleList.add(workRole);
            positionToWorkRoleMap.put(position.getLong("id"), workRole);
        });
        this.handleMemoryWorkRole(workRoleList, workRoleToParentPositionMap, positionToWorkRoleMap);
        return workRoleList;
    }

    private void handleMemoryWorkRole(List<DynamicObject> workRoleList, Map<Long, Long> workRoleToParentPositionMap, Map<Long, DynamicObject> positionToWorkRoleMap) {
        if (CollectionUtils.isEmpty(workRoleToParentPositionMap)) {
            return;
        }
        if (CollectionUtils.isEmpty(workRoleList)) {
            return;
        }
        for (DynamicObject workRole : workRoleList) {
            Long parentId = workRoleToParentPositionMap.get(workRole.getLong("id"));
            if (parentId == null || parentId == 0L) continue;
            workRole.set("parentrole", (Object)positionToWorkRoleMap.get(parentId));
        }
    }

    private List<DynamicObject> updateWorkRoleFromPosition(List<DynamicObject> positions) {
        ArrayList workRoles = Lists.newArrayListWithExpectedSize((int)positions.size());
        List<Long> workRoleId = positions.stream().map(position -> position.getLong("workrole.id")).collect(Collectors.toList());
        Map<Long, DynamicObject> workRoleMap = WorkRoleQueryRepository.getInstance().queryWorkRoleToMap(workRoleId);
        for (DynamicObject position2 : positions) {
            DynamicObject workRoleDB = workRoleMap.get(position2.getLong("workrole.id"));
            DynamicObject workRole = WorkRoleQueryRepository.getInstance().getEmptyDyn();
            HRDynamicObjectUtils.copy((DynamicObject)workRoleDB, (DynamicObject)workRole);
            workRole.set("id", (Object)position2.getLong("workrole.id"));
            workRole.set("number", (Object)position2.getString("number"));
            workRole.set("name", (Object)position2.getString("name"));
            workRole.set("adminorg", position2.get("adminorg"));
            workRole.set("mainpeoincharge", (Object)position2.getString("isleader"));
            DynamicObject roleType = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hbpm_roletype"));
            roleType.set("id", (Object)PositionWorkRoleServiceHelper.getRoleTypeInfo(position2));
            workRole.set("roletype", (Object)roleType);
            if (!ObjectUtils.isEmpty((Object)position2.getDynamicObject("parent"))) {
                workRole.set("parentrole", (Object)position2.getDynamicObject("parent").getDynamicObject("workrole"));
            } else {
                workRole.set("parentrole", null);
            }
            workRole.set("enable", (Object)position2.getString("enable"));
            workRole.set("bsed", (Object)position2.getDate("bsed"));
            workRole.set("bsled", (Object)position2.getDate("bsled"));
            workRoles.add(workRole);
            position2.set("workrole", (Object)workRole);
        }
        WorkRoleNewHisUtils.setPrefixNumber(workRoles);
        return workRoles;
    }

    private DynamicObject emptyWorkRoleDynamicObject() {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_workroleshr");
        return new DynamicObject((DynamicObjectType)dataEntityType);
    }
}

