/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class CommonQueryRepository {
    private CommonQueryRepository() {
    }

    public static CommonQueryRepository getInstance() {
        return CommonQueryInstance.INSTANCE;
    }

    public DynamicObject[] loadDynByEntityNumber(Set<Long> boidSet, String entityNumber) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityNumber);
        QFilter boidQFilter = new QFilter("boid", "in", boidSet);
        QFilter isCurrentQFiter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dyns = hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{boidQFilter, isCurrentQFiter});
        return dyns;
    }

    public DynamicObject[] loadDyById(String entityName, Set<Long> idSet) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        return hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", idSet)});
    }

    public DynamicObject[] loadColsInfoById(String entityName, Set<String> cols, Set<Long> idSet) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
        return hrBaseServiceHelper.query(StringUtils.join((Object[])cols.toArray(), (String)","), new QFilter[]{new QFilter("id", "in", idSet)});
    }

    public DynamicObject[] queryInitWaitRollBackIds(String entityNumber, long batchNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        return helper.queryOriginalArray("id, boid", new QFilter[]{new QFilter("initbatch", "=", (Object)batchNumber), new QFilter("initstatus", "!=", (Object)"2"), new QFilter("iscurrentversion", "=", (Object)"1")});
    }

    public DynamicObject[] queryInitWaitChangeStatus(String entityNumber, long batchNumber, String sourceStatus, String targetStatus) {
        DynamicObject[] dynamicObjects;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        for (DynamicObject dynamicObject : dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("initbatch", "=", (Object)batchNumber), new QFilter("initstatus", "=", (Object)sourceStatus)})) {
            dynamicObject.set("initstatus", (Object)targetStatus);
        }
        return dynamicObjects;
    }

    private static class CommonQueryInstance {
        private static CommonQueryRepository INSTANCE = new CommonQueryRepository();

        private CommonQueryInstance() {
        }
    }
}

