/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class DutyWorkRoleQueryRepository {
    private DutyWorkRoleQueryRepository() {
    }

    public static DutyWorkRoleQueryRepository getInstance() {
        return DutyWorkRoleQueryInstance.INSTANCE;
    }

    public Map<Long, DynamicObject> queryDutyWorkRoleToMap(List<Long> positionIds) {
        DynamicObject[] dutyWorkRoles = this.queryDutyWorkRoleByIds(positionIds);
        Map<Long, DynamicObject> dutyWorkRolesMap = Arrays.stream(dutyWorkRoles).collect(Collectors.toMap(dutyWorkRole -> dutyWorkRole.getLong("id"), dutyWorkRole -> dutyWorkRole));
        return dutyWorkRolesMap;
    }

    public DynamicObject[] queryDutyWorkRoleByIds(List<Long> positionIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_dutyworkroles");
        QFilter idFilter = new QFilter("id", "in", positionIds);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    public DynamicObject[] queryDutyWorkRoleByIds4Disable(List<Long> positionIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_dutyworkroles");
        QFilter idFilter = new QFilter("id", "in", positionIds);
        return serviceHelper.query("id,boid,bsed,bsled,eventid", new QFilter[]{idFilter});
    }

    public boolean isExistNotEnable(List<Long> idList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_dutyworkroles");
        QFilter idFilter = new QFilter("id", "in", idList).and(new QFilter("enable", "!=", (Object)"10"));
        return serviceHelper.isExists(idFilter);
    }

    public DynamicObject[] queryPositionHisVersion(Set<Long> boIds) {
        HRBaseServiceHelper dutyServiceHelper = new HRBaseServiceHelper("hbpm_dutyworkroles");
        QFilter[] qFilters = new QFilter[]{new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"}), new QFilter("boid", "in", boIds), new QFilter("iscurrentversion", "=", (Object)"0")};
        return dutyServiceHelper.queryOriginalArray("boid, bsed, id, bsled,datastatus", qFilters, "bsed desc");
    }

    public DynamicObject[] queryDutyWorkRoleByIdsAndStatus(List<Long> positionIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_dutyworkroles");
        QFilter idFilter = new QFilter("boid", "in", positionIds);
        return serviceHelper.query("id,boid,initstatus", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryDutyWorkRoleByIds(List<Long> positionIds, String selectProperties) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_dutyworkroles");
        QFilter idFilter = new QFilter("boid", "in", positionIds);
        return serviceHelper.queryOriginalArray(selectProperties, idFilter.toArray());
    }

    public void saveDutyWorkRole(DynamicObject[] dys) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_dutyworkroles");
        serviceHelper.save(dys);
    }

    public void deleteDutyWorkRolesByIds(Object[] pkIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_dutyworkroles");
        serviceHelper.delete(pkIds);
    }

    public DynamicObject getEmptyDyn() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_dutyworkroles");
        return serviceHelper.generateEmptyDynamicObject();
    }

    public DynamicObject[] queryInitDutyWorkRole(List<Long> boid) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_dutyworkroles");
        QFilter boidFilter = new QFilter("boid", "in", boid);
        QFilter initStatusFilter = new QFilter("initstatus", "in", (Object)new String[]{"0", "1"});
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{boidFilter, initStatusFilter, dataStatusFilter});
    }

    private static class DutyWorkRoleQueryInstance {
        private static DutyWorkRoleQueryRepository INSTANCE = new DutyWorkRoleQueryRepository();

        private DutyWorkRoleQueryInstance() {
        }
    }
}

