/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class HBPMMsgRepository {
    public static HBPMMsgRepository getInstance() {
        return HBPMMsgInstance.INSTANCE;
    }

    public void saveBatch(List<DynamicObject> dynamicObjects) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_changemsg");
        serviceHelper.save(dynamicObjects.toArray(new DynamicObject[0]));
    }

    public DynamicObject[] queryRetryMsgsById(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_changemsg");
        QFilter sendstateFilter = new QFilter("sendstate", "!=", (Object)"1");
        QFilter idsFilter = new QFilter("id", "in", ids);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{sendstateFilter, idsFilter});
    }

    public DynamicObject queryMsgById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_changemsg");
        QFilter idsFilter = new QFilter("id", "=", (Object)id);
        return serviceHelper.queryOne("id, number, name", new QFilter[]{idsFilter});
    }

    public DynamicObject[] querySyncData() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_changemsg");
        Date createtime = HRDateTimeUtils.addDay((Date)new Date(), (long)-14L);
        QFilter createtimeFilter = new QFilter("createtime", ">", (Object)createtime);
        QFilter sendstateFilter = new QFilter("sendstate", "=", (Object)"1");
        QFilter consumeFilter = new QFilter("entryentity.recstatus", "!=", (Object)"A");
        DynamicObject[] dyns = serviceHelper.queryOriginalArray("id", new QFilter[]{sendstateFilter, consumeFilter, createtimeFilter});
        if (dyns.length == 0) {
            return null;
        }
        List ids = Arrays.stream(dyns).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", ids)});
    }

    public DynamicObject[] querySendstateSyncData() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_changemsg");
        Date createtime = HRDateTimeUtils.addDay((Date)new Date(), (long)-3L);
        QFilter createtimeFilter = new QFilter("createtime", ">", (Object)createtime);
        QFilter sendstateFilter = new QFilter("sendstate", "=", (Object)"0");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{sendstateFilter, createtimeFilter});
    }

    private static class HBPMMsgInstance {
        private static HBPMMsgRepository INSTANCE = new HBPMMsgRepository();

        private HBPMMsgInstance() {
        }
    }
}

