/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class MserviceQueryRepository {
    private MserviceQueryRepository() {
    }

    public static MserviceQueryRepository getInstance() {
        return MserviceQueryInstance.INSTANCE;
    }

    public List<Map<String, Long>> queryAllSubOrg(List<Long> adminOrg, Date versionDate) {
        return (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"batchGetAllSubOrg", (Object[])new Object[]{adminOrg, versionDate});
    }

    public List<Map<String, Long>> querySubOrgBylevel(List<Long> adminOrg, Date versionDate, Integer level) {
        return (List)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"batchQuerySubOrg", (Object[])new Object[]{adminOrg, versionDate, level});
    }

    public Map<String, Map<String, Object>> queryOrg(List<Long> adminOrg, Date versionDate) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"adminOrgInfoQuery", (Object[])new Object[]{adminOrg, versionDate});
    }

    public Map<Long, Map<String, List<Long>>> queryPermission(Map<Long, Map<String, List<Long>>> bu) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMBuPermissionService", (String)"hasBuPermission", (Object[])new Object[]{bu});
    }

    public Map<Long, Map<Long, DynamicObject>> getJobLevelGrade(List<Long> scmLists, List<Long> jobFamilyLists) {
        Map<Object, Object> collects = Maps.newHashMap();
        if (!scmLists.isEmpty()) {
            DynamicObject[] defaultScm;
            DynamicObject[] dys;
            if (!jobFamilyLists.isEmpty() && !PositionUtils.isArrayEmpty(dys = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMService", (String)"getJobFamilyScmDyobjsByJobScmIdsAndJobFamilyIds", (Object[])new Object[]{scmLists, jobFamilyLists})).booleanValue()) {
                collects = Arrays.stream(dys).collect(Collectors.groupingBy(dy -> dy.getLong("jobscm.id"), Collectors.toMap(dy -> dy.getLong("jobfamily.id"), dy -> dy, (v1, v2) -> v1)));
            }
            if (!PositionUtils.isArrayEmpty(defaultScm = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMService", (String)"getJobScmByIds", (Object[])new Object[]{scmLists})).booleanValue()) {
                Map<Long, DynamicObject> collect = Arrays.stream(defaultScm).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
                for (Map.Entry<Long, DynamicObject> entry : collect.entrySet()) {
                    Long id = entry.getKey();
                    Map temp = (Map)collects.get(id);
                    if (Objects.isNull(temp)) {
                        temp = Maps.newHashMap();
                        collects.put(id, temp);
                    }
                    temp.put(id, entry.getValue());
                }
            }
        }
        return collects;
    }

    public Map<Long, DynamicObject> getJobLevelGradeRangeByJobIds(List<Long> jobIds) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMJobLevelGradeRangeService", (String)"getJobLevelGradeRangeInfo", (Object[])new Object[]{jobIds});
    }

    public Map<String, Object> getJobLevelGradeRangeInfo(List<Long> jobIds) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMJobLevelGradeService", (String)"getJobLevelGradeRangeInfo", (Object[])new Object[]{jobIds});
    }

    public Map<String, Object> getJobGradeAndLevelRange(List<Map<String, Long>> jobGradeAndLevelRangeBo) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMJobLevelGradeService", (String)"getJobGradeAndLevelRange", (Object[])new Object[]{jobGradeAndLevelRangeBo});
    }

    public Map<Long, Set<Long>> queryAllUsersByPosition(List<Long> positionIds) {
        Map allUsersOfPosition = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getAllUsersOfPosition", (Object[])new Object[]{"1", positionIds});
        return allUsersOfPosition;
    }

    private static class MserviceQueryInstance {
        private static MserviceQueryRepository INSTANCE = new MserviceQueryRepository();

        private MserviceQueryInstance() {
        }
    }
}

