/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionBillQueryRepository {
    private PositionBillQueryRepository() {
    }

    public static PositionBillQueryRepository getInstance() {
        return PositionBillQueryInstance.INSTANCE;
    }

    public DynamicObject queryPositionBillByPositionId(Long positionId) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(positionId);
        DynamicObject positionBill = null;
        Object[] positions = PositionQueryRepository.getInstance().queryPositionsById(ids);
        if (!ObjectUtils.isEmpty((Object[])positions)) {
            Object position = positions[0];
            long sourcevid = position.getLong("sourcevid");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_positionbill");
            QFilter idFilter = new QFilter("hisnewversion", "=", (Object)sourcevid);
            positionBill = serviceHelper.loadDynamicObject(new QFilter[]{idFilter});
        }
        return positionBill;
    }

    public DynamicObject findById(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("homs_positionbill");
        return serviceHelper.queryOne((Object)id);
    }

    public Map<String, Set<Long>> queryPositionByNumbers(List<String> numbers) {
        DynamicObject[] positions = this.queryPositionDataByNumbers(numbers);
        if (!PositionUtils.isArrayEmpty(positions).booleanValue()) {
            HashMap numberAndIdListMap = Maps.newHashMapWithExpectedSize((int)positions.length);
            for (DynamicObject position : positions) {
                Set idList = numberAndIdListMap.computeIfAbsent(position.getString("number"), k -> new LinkedHashSet());
                idList.add(position.getLong("boid"));
            }
            return numberAndIdListMap;
        }
        return null;
    }

    public DynamicObject[] queryPositionDataByNumbers(List<String> numbers) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positionhr");
        QFilter qFilter = new QFilter("number", "in", numbers);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        return serviceHelper.query("id,number,name, boid", new QFilter[]{qFilter, dataStatusFilter});
    }

    public DynamicObject queryWorkPlace(Long countryId, Long cityId) {
        DynamicObject workPlace = null;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_workplace");
        QFilter countryFilter = new QFilter("country", "=", (Object)countryId);
        QFilter cityFilter = new QFilter("city", "=", (Object)cityId);
        DynamicObject[] workPlaces = serviceHelper.queryOriginalArray("id", new QFilter[]{countryFilter, cityFilter});
        if (workPlaces != null && workPlaces.length == 1) {
            String selectProperties = "id,country,city";
            QFilter idFilter = new QFilter("id", "=", (Object)workPlaces[0].getLong("id"));
            workPlace = serviceHelper.queryOne(selectProperties, new QFilter[]{idFilter});
        }
        return workPlace;
    }

    private static class PositionBillQueryInstance {
        private static PositionBillQueryRepository INSTANCE = new PositionBillQueryRepository();

        private PositionBillQueryInstance() {
        }
    }
}

