/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class PositionChangeDetailRepository {
    private PositionChangeDetailRepository() {
    }

    public static PositionChangeDetailRepository getInstance() {
        return PositionChangeDetailRepositoryInstance.INSTANCE;
    }

    public DynamicObject[] getBaseInfoByPositionIds(List<Long> positionIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_chgrecord");
        QFilter idFilter = new QFilter("position", "in", positionIds);
        String selectProps = "id,position";
        return serviceHelper.query(selectProps, new QFilter[]{idFilter});
    }

    public DynamicObject[] getInfoByBatchNumber(long batchNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_chgrecord");
        QFilter idFilter = new QFilter("initbatch", "=", (Object)batchNumber);
        String selectProps = "id,evententry,evententry.detailentry";
        return serviceHelper.query(selectProps, new QFilter[]{idFilter});
    }

    public DynamicObject getEventInfoByEntryId(Object entryId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_chgrecordevt");
        QFilter idFilter = new QFilter("id", "=", entryId);
        String selectProps = "id,targetposition,hisposition,changedate";
        return serviceHelper.queryOne(selectProps, idFilter);
    }

    public DynamicObject[] getAllEventInfo() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_chgrecordevt");
        String selectProps = "id,targetposition,hisposition,changedate,event";
        QFilter idFilter = new QFilter("id", "!=", (Object)0);
        return serviceHelper.query(selectProps, new QFilter[]{idFilter});
    }

    public DynamicObject[] getDetailInfoByIds(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_chgrecorddetail");
        QFilter idFilter = new QFilter("id", "in", ids);
        String selectProps = "id,changentity,propkey,beforevalue,aftervalue,changeoperate,proptype,basedatapropcode";
        return serviceHelper.query(selectProps, new QFilter[]{idFilter});
    }

    public int deleteChgRecordByIds(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_chgrecord");
        QFilter idFilter = new QFilter("id", "in", ids);
        return serviceHelper.deleteByFilter(new QFilter[]{idFilter});
    }

    private static class PositionChangeDetailRepositoryInstance {
        private static PositionChangeDetailRepository INSTANCE = new PositionChangeDetailRepository();

        private PositionChangeDetailRepositoryInstance() {
        }
    }
}

