/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionQueryRepository {
    private HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positionhr");

    private PositionQueryRepository() {
    }

    public static PositionQueryRepository getInstance() {
        return PositionQueryInstance.INSTANCE;
    }

    public DynamicObject[] queryPositionsById(List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    public void deleteDarkPositionByIds(Object[] pkIds) {
        this.serviceHelper.delete(pkIds);
    }

    public DynamicObject[] queryFieldPositionsByIds(List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        String field = "id, boid, sourcevid, name, number, adminorg, adminorg.number, adminorg.name,parent, establishmentdate, positiontype, group, keyposition, positionclassify, countryregion, city, isleader, issensitive, deputytype, description, enable, posorientation, posduty, posstandard, diplomareq, agereq, knowledgereq, skillreq, abilityreq, experiencereq, orgdesignbu, jobscm, job.jobseq, job, job.jobfamily, job.jobclass, job.lowjoblevel, job.highjoblevel, job.lowjobgrade, job.highjobgrade, workrole, bsed";
        return this.serviceHelper.queryOriginalArray(field, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryPositionVersionByBoId(List<Long> boId) {
        QFilter idFilter = new QFilter("boid", "in", boId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, dataStatusFilter, isCurrentVersionFilter});
    }

    public Map<Long, DynamicObject> queryVersionIdAndPositionMap(List<Long> positionVersionIds) {
        DynamicObject[] positionVersions;
        HashMap versionIdAndPositionMap = Maps.newHashMapWithExpectedSize((int)positionVersionIds.size());
        for (DynamicObject positionVersion : positionVersions = this.queryPositionsById(positionVersionIds)) {
            versionIdAndPositionMap.put(positionVersion.getLong("id"), positionVersion);
        }
        return versionIdAndPositionMap;
    }

    public DynamicObject[] queryPositionInfo(List<Long> positionIdList) {
        QFilter idFilter = new QFilter("id", "in", positionIdList);
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        String field = "id, sourcevid, name, number, adminorg, parent, establishmentdate, positiontype, positiontype.ismanagetype,group, keyposition, positionclassify, countryregion, city, isleader, issensitive, deputytype, description, posorientation, posduty, posstandard, diplomareq, agereq, knowledgereq, skillreq, abilityreq, experiencereq, orgdesignbu, jobscm, job.jobseq, job, job.name,job.jobfamily, job.jobclass, lowjoblevel, highjoblevel, lowjobgrade, highjobgrade, workrole, bsed, bsled, highjoblevel.joblevelscm,highjobgrade.jobgradescm, firstbsed";
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return this.serviceHelper.queryOriginalArray(field, new QFilter[]{idFilter, iscurrentVersionFilter, initStatusFilter});
    }

    public DynamicObject[] queryPositionInfoById(List<Long> positionIdList) {
        QFilter idFilter = new QFilter("id", "in", positionIdList);
        String field = "id, sourcevid, name, number, adminorg, parent, establishmentdate, positiontype, positiontype.ismanagetype,group, keyposition, positionclassify, countryregion, city, isleader, issensitive, deputytype, description, posorientation, posduty, posstandard, diplomareq, agereq, knowledgereq, skillreq, abilityreq, experiencereq, orgdesignbu, jobscm, job.jobseq, job, job.name,job.jobfamily, job.jobclass, lowjoblevel, highjoblevel, lowjobgrade, highjobgrade, workrole, bsed, bsled, highjoblevel.joblevelscm,highjobgrade.jobgradescm, firstbsed";
        return this.serviceHelper.queryOriginalArray(field, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryPositionBaseInfo(List<Long> positionIdList) {
        QFilter idFilter = new QFilter("id", "in", positionIdList);
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        String field = "id,boid, sourcevid, name, number, adminorg, parent, establishmentdate, positiontype, isleader,  orgdesignbu, jobscm, job, lowjoblevel, highjoblevel, lowjobgrade, highjobgrade, workrole, bsed, bsled,firstbsed, iscurrentversion, enable, datastatus, status, initstatus";
        return this.serviceHelper.query(field, new QFilter[]{idFilter, iscurrentVersionFilter});
    }

    public DynamicObject[] queryPositionFileds(String selectFileds, List<Long> positionIdList) {
        QFilter idFilter = new QFilter("id", "in", positionIdList);
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return this.serviceHelper.query(selectFileds, new QFilter[]{initStatusFilter, idFilter, iscurrentVersionFilter});
    }

    public DynamicObject[] queryPositionInfoBySourceVid(List<Long> sourceVids) {
        QFilter idFilter = new QFilter("id", "in", sourceVids);
        String field = "id, sourcevid, boid, name, number, adminorg, parent, establishmentdate, positiontype, positiontype.ismanagetype,group, keyposition, positionclassify, countryregion, city, isleader, issensitive, deputytype, description, posorientation, posduty, posstandard, diplomareq, agereq, knowledgereq, skillreq, abilityreq, experiencereq, orgdesignbu, workrole, bsed, bsled";
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return this.serviceHelper.queryOriginalArray(field, new QFilter[]{idFilter, initStatusFilter});
    }

    public Map<Long, List<DynamicObject>> queryMainDutyPositionByAdminOrgBoId(Collection<Long> adminOrgBoIds) {
        HRBaseServiceHelper positionServiceHelper = new HRBaseServiceHelper("hbpm_positionhr");
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter datastatus = new QFilter("datastatus", "=", (Object)"1");
        QFilter idFilter = new QFilter("adminorg", "in", adminOrgBoIds);
        QFilter isLeader = new QFilter("isleader", "=", (Object)"1");
        QFilter initQFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter enabled = new QFilter("enable", "=", (Object)"1");
        return Arrays.stream(positionServiceHelper.loadDynamicObjectArray(new QFilter[]{currentFilter, idFilter, isLeader, initQFilter, enabled, datastatus})).collect(Collectors.groupingBy(dyn -> dyn.getLong("adminorg.id")));
    }

    public DynamicObject[] queryPositionJobLevelAndJobGrade(List<Long> positionIdList) {
        QFilter idFilter = new QFilter("id", "in", positionIdList);
        String field = "id, lowjoblevel, highjoblevel, lowjobgrade, highjobgrade";
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return this.serviceHelper.query(field, new QFilter[]{idFilter, initStatusFilter});
    }

    public DynamicObject[] queryPositionList(List<Long> jobIdList) {
        QFilter idFilter = new QFilter("job", "in", jobIdList);
        String field = "adminorg,id,number,name, parent, positionclassify,positiontype,highjoblevel,lowjoblevel,highjobgrade,lowjobgrade,enable,status, isleader,deputytype,group,job,establishmentdate";
        return this.serviceHelper.query(field, new QFilter[]{idFilter});
    }

    public List<DynamicObject> generateEmptyPositions(int size) {
        if (size <= 0) {
            return null;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_positionhr");
        ArrayList<DynamicObject> lists = new ArrayList<DynamicObject>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject dy = new DynamicObject((DynamicObjectType)dataEntityType);
            lists.add(dy);
        }
        return lists;
    }

    public void setInitstatus(DynamicObject dynamicObject, String status) {
        dynamicObject.set("initstatus", (Object)status);
    }

    public DynamicObject[] queryOrgPosition(List<Long> orgIds) {
        QFilter orgFilter = new QFilter("adminorg", "in", orgIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter datastatus = new QFilter("datastatus", "=", (Object)"1");
        QFilter isLeaderFilter = new QFilter("isleader", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return this.serviceHelper.query("id,adminorg,workrole,bsed,bsled", new QFilter[]{orgFilter, enableFilter, isCurrentFilter, isLeaderFilter, initStatusFilter, datastatus});
    }

    public DynamicObject[] queryOrgPosition(Long orgId, Date bsed) {
        QFilter orgFilter = new QFilter("adminorg", "=", (Object)orgId);
        QFilter bsedFilter = new QFilter("bsled", ">=", (Object)bsed);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter datastatus = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{orgFilter, bsedFilter, isCurrentFilter, datastatus});
    }

    public DynamicObject[] queryOrgPosition(Long orgId) {
        QFilter orgFilter = new QFilter("adminorg", "=", (Object)orgId);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{orgFilter, isCurrentFilter});
    }

    public DynamicObject[] queryInitCompletingPositionByBoId(List<Long> boId) {
        QFilter idFilter = new QFilter("boid", "in", boId);
        QFilter initStatusFilter = new QFilter("initstatus", "in", (Object)new String[]{"0", "1"});
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, initStatusFilter});
    }

    public DynamicObject[] queryOrgFirstPosition(Long orgId) {
        QFilter orgFilter = new QFilter("adminorg", "=", (Object)orgId);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        return this.serviceHelper.query("id,name,number,adminorg,workrole", new QFilter[]{orgFilter, isCurrentFilter, enableFilter, initStatusFilter});
    }

    public DynamicObject[] queryDarkPositionById(List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter DartFilter = new QFilter("createmode", "=", (Object)"3");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, isCurrentFilter, DartFilter});
    }

    public DynamicObject[] queryEnablePositionById(Collection<Long> ids) {
        QFilter idFilter = new QFilter("stposition", "in", ids);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "!=", (Object)"0");
        return this.serviceHelper.queryOriginalArray("stposition", new QFilter[]{idFilter, isCurrentFilter, enableFilter});
    }

    public DynamicObject[] queryOrgLeaderPosition(List<Long> orgIds) {
        QFilter orgFilter = new QFilter("adminorg", "in", orgIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter isLeaderFilter = new QFilter("isleader", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return this.serviceHelper.queryOriginalArray("id,adminorg.id,number,name,positionclassify,positiontype,highjoblevel,lowjoblevel,highjobgrade,lowjobgrade,deputytype,group,job,establishmentdate", new QFilter[]{orgFilter, enableFilter, isCurrentFilter, isLeaderFilter, initStatusFilter});
    }

    public DynamicObject[] queryOrgLeaderPositionHis(List<Long> orgIds, Date date) {
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter orgFilter = new QFilter("adminorg", "in", orgIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter isLeaderFilter = new QFilter("isleader", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return this.serviceHelper.queryOriginalArray("id,adminorg.id,name,boid", new QFilter[]{datastatusFilter, iscurrentVersionFilter, bsedFilter, bsledFilter, orgFilter, enableFilter, isLeaderFilter, initStatusFilter});
    }

    public DynamicObject[] queryPositionHisInfo(List<Long> positionIdList, Date date) {
        QFilter[] hisVersionQFilter = this.positionHisVersionQFilter(positionIdList, date);
        String field = "id, boid, number,name, adminorg, parent, establishmentdate, positiontype, positiontype.ismanagetype, group, keyposition, positionclassify, countryregion, city, workplace, isleader, issensitive, deputytype, description, posorientation, posduty, posstandard, diplomareq, agereq, knowledgereq, skillreq, abilityreq, experiencereq, orgdesignbu, jobscm, job,job.name, job.jobseq, job.jobfamily, job.jobclass, lowjoblevel, highjoblevel, lowjobgrade, highjobgrade, workrole";
        return this.serviceHelper.queryOriginalArray(field, hisVersionQFilter);
    }

    public DynamicObject[] queryPositionHisInfos(List<Long> positionIdList, Date date) {
        QFilter[] hisVersionQFilter = this.positionHisVersionQFilter(positionIdList, date);
        String field = "id, boid, number,name, parent, workrole";
        return this.serviceHelper.query(field, hisVersionQFilter);
    }

    public DynamicObject[] queryPositionHisId(List<Long> positionIdList, Date date) {
        QFilter[] hisVersionQFilter = this.positionHisVersionQFilter(positionIdList, date);
        String field = "id, boid";
        return this.serviceHelper.queryOriginalArray(field, hisVersionQFilter);
    }

    private QFilter[] positionHisVersionQFilter(List<Long> positionIdList, Date date) {
        QFilter boidFilter = new QFilter("boid", "in", positionIdList);
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter qFilter = boidFilter.and(datastatusFilter).and(iscurrentVersionFilter).and(initStatusFilter);
        if (date != null) {
            QFilter bsedFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)date));
            QFilter bsledFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)date));
            qFilter.and(bsedFilter).and(bsledFilter);
        }
        return new QFilter[]{qFilter};
    }

    public DynamicObject[] queryPositionHisId(List<Long> positionIdList) {
        QFilter[] hisVersionQFilter = this.positionHisVersionQFilter(positionIdList, null);
        String field = "id, boid, name, number, bsed, bsled";
        return this.serviceHelper.queryOriginalArray(field, hisVersionQFilter);
    }

    public DynamicObject[] queryPositionFId(List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        String field = "id, boid, name, number, bsed, bsled";
        return this.serviceHelper.queryOriginalArray(field, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryPositionExist(List<Long> positionIdList) {
        QFilter idFilter = new QFilter("boid", "in", positionIdList);
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        String field = "id, boid";
        return this.serviceHelper.queryOriginalArray(field, new QFilter[]{idFilter, iscurrentVersionFilter, initStatusFilter});
    }

    public Map<Long, DynamicObject> queryPositionHisVersionBSled(Map<Long, Date> boIdAndBSedMap) {
        DynamicObject[] dynamicObjects;
        if (CollectionUtils.isEmpty(boIdAndBSedMap)) {
            return null;
        }
        Set<Long> BoIdList = boIdAndBSedMap.keySet();
        HashMap queryPositionHisVersionBSled = Maps.newHashMapWithExpectedSize((int)BoIdList.size());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positionhr");
        for (DynamicObject positionHisVersion : dynamicObjects = serviceHelper.query("boid, bsed,id,bsled,parent,enable,datastatus,isleader", new QFilter[]{new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"}), new QFilter("boid", "in", BoIdList), new QFilter("iscurrentversion", "=", (Object)"0")}, "bsed desc")) {
            Date bsed = positionHisVersion.getDate("bsed");
            Long boid = positionHisVersion.getLong("boid");
            if (queryPositionHisVersionBSled.get(boid) != null || boIdAndBSedMap.get(boid).before(bsed)) continue;
            queryPositionHisVersionBSled.put(boid, positionHisVersion);
        }
        return queryPositionHisVersionBSled;
    }

    public DynamicObject[] queryPositionByOrgIds(List<Long> orgIdList) {
        QFilter orgIdFilter = new QFilter("adminorg", "in", orgIdList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter excludeStand = new QFilter("createmode", "!=", (Object)"3");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        String field = "adminorg,id, name, number,parent,positionclassify,positiontype,highjoblevel,lowjoblevel,highjobgrade,lowjobgrade,enable,status,isleader,deputytype,positiontype.ismanagetype,group,job,establishmentdate";
        return this.serviceHelper.queryOriginalArray(field, new QFilter[]{orgIdFilter, enableFilter, excludeStand, initStatusFilter, isCurrentFilter});
    }

    public DynamicObject[] queryPositionInfoByOrgIds(List<Long> orgIdList) {
        QFilter orgIdFilter = new QFilter("adminorg", "in", orgIdList);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter excludeStand = new QFilter("createmode", "!=", (Object)"3");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{orgIdFilter, isCurrentFilter, initStatusFilter, excludeStand});
    }

    public DynamicObject[] queryPositionHisByOrgIds(List<Long> orgIdList, Date date) {
        QFilter orgIdFilter = new QFilter("adminorg", "in", orgIdList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter excludeStand = new QFilter("createmode", "!=", (Object)"3");
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        String field = "adminorg,id, name, number,parent,positionclassify,positiontype,highjoblevel,lowjoblevel,highjobgrade,lowjobgrade,enable,status,isleader,deputytype,group,job,positiontype.ismanagetype,establishmentdate";
        return this.serviceHelper.queryOriginalArray(field, new QFilter[]{orgIdFilter, enableFilter, excludeStand, datastatusFilter, iscurrentVersionFilter, bsedFilter, bsledFilter, initStatusFilter});
    }

    public DynamicObject[] queryPositionHisByNumbers(List<String> numberList, Date date) {
        QFilter numberFilter = new QFilter("number", "in", numberList);
        return this.serviceHelper.query("boid,id,number,name,enable,firstbsed", new QFilter[]{numberFilter, this.commonHisFilter(date)});
    }

    public DynamicObject[] queryPositionFirstBsedHisByNumbers(List<String> numberList) {
        QFilter numberFilter = new QFilter("number", "in", numberList);
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        return this.serviceHelper.queryOriginalArray("id,boid,firstbsed", new QFilter[]{numberFilter, iscurrentVersionFilter, initStatusFilter, datastatusFilter});
    }

    private QFilter commonHisFilter(Date date) {
        return new QFilter("iscurrentversion", "=", (Object)"0").and("initstatus", "=", (Object)"2").and("bsed", "<=", (Object)date).and("bsled", ">=", (Object)date).and("datastatus", "in", (Object)new String[]{"1", "2", "0"});
    }

    public DynamicObject[] queryPositionByNumbers(Set<String> numbers) {
        QFilter numberFilter = new QFilter("number", "in", numbers);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        String field = "id, adminorg.id, name, number,positiontype.id, parent,parent.id, establishmentdate, bsed, firstbsed, boid";
        return this.serviceHelper.queryOriginalArray(field, new QFilter[]{numberFilter, isCurrentVersionFilter});
    }

    public DynamicObject queryBoIdById(Long id) {
        QFilter filter = new QFilter("id", "in", (Object)id);
        return this.serviceHelper.queryOriginalOne("id,boid", filter);
    }

    public DynamicObject[] queryPositionByOrgAndUserAndStandardIds(List<Long> orgIds, List<Long> userIds, List<Long> standardIds) {
        QFilter orgFilter = new QFilter("adminorg", "in", orgIds);
        QFilter standardFilter = new QFilter("stposition", "in", standardIds);
        standardFilter.and(new QFilter("createmode", "=", (Object)"3"));
        QFilter userFilter = new QFilter("person", "in", userIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return this.serviceHelper.query("boid,id,adminorg,number,name,enable,stposition,person,createmode,bsed,bsled", new QFilter[]{orgFilter, standardFilter, userFilter, iscurrentVersionFilter, enableFilter});
    }

    public DynamicObject[] queryPositionHisVersion(List<Long> positionBoIds, Date startDate, Date endDate) {
        QFilter idFilter = new QFilter("boid", "in", positionBoIds);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter dateFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)endDate)).and(new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)startDate)));
        return this.serviceHelper.query("boid,id,adminorg,number,name,enable,bsed,bsled", new QFilter[]{idFilter, currentFilter, dataStatusFilter, dateFilter});
    }

    public DynamicObject[] queryToBeDisablePosition(List<Long> orgIds, String toBeDisable) {
        QFilter orgFilter = new QFilter("adminorg", "in", orgIds);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter toBeDisableQFilter = new QFilter("toBeDisable", "!=", (Object)toBeDisable);
        QFilter initQFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter excludeStand = new QFilter("createmode", "!=", (Object)"3");
        QFilter enableFilter = new QFilter("enable", "!=", (Object)"0");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{orgFilter, currentFilter, toBeDisableQFilter, initQFilter, excludeStand, enableFilter});
    }

    public Map<Long, Integer> queryLowPositionCount(List<Long> positionBoIds, Date bsed) {
        HashMap lowPositionCountMap = Maps.newHashMapWithExpectedSize((int)positionBoIds.size());
        QFilter idFilter = new QFilter("parent", "in", positionBoIds);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter dateFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)bsed)).and(new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)bsed)));
        dateFilter.and("enable", "=", (Object)"1");
        DynamicObject[] result = this.serviceHelper.query("boid,id,adminorg,parent.id, number,name,enable,bsed,bsled", new QFilter[]{idFilter, currentFilter, dataStatusFilter, dateFilter});
        Map<Object, Object> lowPositionMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!PositionUtils.isArrayEmpty(result).booleanValue()) {
            lowPositionMap = Arrays.stream(result).collect(Collectors.groupingBy(map -> (Long)map.get("parent.id")));
        }
        for (Long positionBoId : positionBoIds) {
            List dynamicObjects = (List)lowPositionMap.get(positionBoId);
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                lowPositionCountMap.put(positionBoId, 0);
                continue;
            }
            lowPositionCountMap.put(positionBoId, dynamicObjects.size());
        }
        return lowPositionCountMap;
    }

    public int getAllEnablePositionCountByPerm(AuthorizedOrgResult permResult, HasPermOrgResult orgPermOrg) {
        QFilter rootFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter excludeStand = new QFilter("createmode", "!=", (Object)"3");
        QFilter initStatusFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter dataStatusFilter = new QFilter("datastatus", "not in", (Object)"-1");
        rootFilter.and(enableFilter).and(excludeStand).and(initStatusFilter).and(dataStatusFilter);
        if (!permResult.isHasAllOrgPerm()) {
            QFilter adminOrgFilter = new QFilter("adminorg", "in", (Object)permResult.getHasPermOrgs());
            rootFilter.and(adminOrgFilter);
        }
        if (!orgPermOrg.hasAllOrgPerm()) {
            QFilter orgFilter = new QFilter("org", "in", (Object)orgPermOrg.getHasPermOrgs());
            rootFilter.and(orgFilter);
        }
        return this.serviceHelper.count("hbpm_positionhr", rootFilter.toArray());
    }

    public Map<Long, List<DynamicObject>> queryDarkPositionByAdminOrgBoId(Collection<Long> adminOrgBoIds) {
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter idFilter = new QFilter("adminorg", "in", adminOrgBoIds);
        QFilter parentIdFilter = new QFilter("parent", "=", (Object)0L);
        QFilter ModeFilter = new QFilter("createmode", "=", (Object)"3");
        QFilter enabled = new QFilter("enable", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return Arrays.stream(this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, isCurrentFilter, ModeFilter, parentIdFilter, enabled, initStatusFilter})).collect(Collectors.groupingBy(dyn -> dyn.getLong("adminorg.id")));
    }

    public Map<Long, List<DynamicObject>> queryMainDutyDarkPositionByAdminOrgBoId(Collection<Long> adminOrgBoIds, boolean discrete) {
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter idFilter = new QFilter("adminorg", "in", adminOrgBoIds);
        QFilter isLeader = new QFilter("isleader", "=", (Object)"1");
        if (discrete) {
            isLeader.and(new QFilter("parent", "=", (Object)0L));
        }
        QFilter ModeFilter = new QFilter("createmode", "=", (Object)"3");
        QFilter enabled = new QFilter("enable", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return Arrays.stream(this.serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, isLeader, isCurrentFilter, ModeFilter, enabled, initStatusFilter})).collect(Collectors.groupingBy(dyn -> dyn.getLong("adminorg.id")));
    }

    public List<DynamicObject> queryDarkPositionByPositionBoIds(Collection<Long> positionBoIds) {
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter parentFilter = new QFilter("parent", "in", positionBoIds);
        QFilter ModeFilter = new QFilter("createmode", "=", (Object)"3");
        QFilter enabled = new QFilter("enable", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        DynamicObject[] dynamicObjects = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{parentFilter, isCurrentFilter, ModeFilter, enabled, initStatusFilter});
        return Arrays.stream(dynamicObjects).collect(Collectors.toList());
    }

    public DynamicObject[] querySubMainDutyDarkPositions(List<Long> positionIds) {
        QFilter positionQFilter = new QFilter("parent.id", "in", positionIds);
        QFilter isCurrentVersionQFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter isLeader = new QFilter("isleader", "=", (Object)"1");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter darkQFilter = new QFilter("createmode", "=", (Object)"3");
        QFilter initQFilter = new QFilter("initstatus", "=", (Object)"2");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{positionQFilter, isLeader, enableQFilter, darkQFilter, isCurrentVersionQFilter, initQFilter});
    }

    public DynamicObject[] querySubDarkPositions(List<Long> positionIds) {
        QFilter positionQFilter = new QFilter("parent.id", "in", positionIds);
        QFilter isCurrentVersionQFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter isLeader = new QFilter("isleader", "=", (Object)"2");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter darkQFilter = new QFilter("createmode", "=", (Object)"3");
        QFilter initQFilter = new QFilter("initstatus", "=", (Object)"2");
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{positionQFilter, isLeader, enableQFilter, darkQFilter, isCurrentVersionQFilter, initQFilter});
    }

    public DynamicObject[] querySubPositions(List<Long> positionIds) {
        QFilter positionQFilter = new QFilter("parent.id", "in", positionIds);
        QFilter isCurrentVersionQFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter darkQFilter = new QFilter("createmode", "!=", (Object)"3");
        QFilter initQFilter = new QFilter("initstatus", "=", (Object)"2");
        return this.serviceHelper.query("id, parent, datastatus", new QFilter[]{positionQFilter, enableQFilter, darkQFilter, isCurrentVersionQFilter, initQFilter});
    }

    public DynamicObject[] queryPositionsPropsByIds(String queryProps, Set<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        return this.serviceHelper.query(queryProps, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryPositionHisInfoByWorkRole(List<Long> workRoleIds, Date date) {
        QFilter workRoleFilter = new QFilter("workrole", "in", workRoleIds);
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter qFilter = workRoleFilter.and(datastatusFilter).and(iscurrentVersionFilter).and(initStatusFilter);
        if (date != null) {
            QFilter bsedFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)date));
            QFilter bsledFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)date));
            qFilter.and(bsedFilter).and(bsledFilter);
        }
        String field = "id, boid, number,name, adminorg, parent, establishmentdate, workrole";
        return this.serviceHelper.queryOriginalArray(field, new QFilter[]{qFilter});
    }

    public DynamicObject queryDataById(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return this.serviceHelper.loadDynamicObject(filter);
    }

    public DynamicObject[] queryPositionEnableEffectVersionByBoId(long boId, String selectFields) {
        QFilter idFilter = new QFilter("boid", "=", (Object)boId);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        return this.serviceHelper.query(selectFields, new QFilter[]{idFilter, dataStatusFilter, isCurrentVersionFilter}, "bsed desc");
    }

    public DynamicObject queryPositionVersionById(long id, String selectFields) {
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        return this.serviceHelper.queryOne(selectFields, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryPositionParentByIds(List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        return this.serviceHelper.queryOriginalArray("id,boid,parent", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryAllHisData(Long boId) {
        QFilter idFilter = new QFilter("boid", "=", (Object)boId);
        return this.serviceHelper.query("id,boid,establishmentdate,firstbsed", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryAllHisData(List<Long> boIdList) {
        QFilter idFilter = new QFilter("boid", "in", boIdList);
        return this.serviceHelper.query("id,boid,establishmentdate,firstbsed", new QFilter[]{idFilter});
    }

    public void saveData(DynamicObject[] dynamicObjects) {
        this.serviceHelper.save(dynamicObjects);
    }

    public DynamicObject[] queryPositionFutureVersion(List<Long> positionBoIds) {
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter boidFilter = new QFilter("boid", "in", positionBoIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"0");
        return this.serviceHelper.queryOriginalArray("boid,bsed", new QFilter[]{isCurrentFilter, boidFilter, dataStatusFilter});
    }

    public DynamicObject[] queryHisVersionJobLevelAndJobGrade(List<Long> positionIdList, Date date) {
        QFilter[] hisVersionQFilter = this.positionHisVersionQFilter(positionIdList, date);
        String field = "id, datastatus, boid, lowjoblevel.id, highjoblevel.id, lowjobgrade.id, highjobgrade.id";
        return this.serviceHelper.queryOriginalArray(field, hisVersionQFilter);
    }

    public DynamicObject[] queryCurrentVersionJobLevelAndJobGrade(List<Long> positionIdList) {
        QFilter boidFilter = new QFilter("boid", "in", positionIdList);
        QFilter datastatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter[] qFilter = new QFilter[]{boidFilter.and(datastatusFilter).and(iscurrentVersionFilter).and(initStatusFilter)};
        String field = "id, datastatus, boid, lowjoblevel.id, highjoblevel.id, lowjobgrade.id, highjobgrade.id";
        return this.serviceHelper.queryOriginalArray(field, qFilter);
    }

    public DynamicObject[] queryCurrentVersionPositionByOrgId(List<Long> orgIds) {
        QFilter tplFilter = new QFilter("org", "in", orgIds);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter enabled = new QFilter("enable", "=", (Object)"1");
        QFilter[] qFilter = new QFilter[]{tplFilter, isCurrentFilter, enabled};
        String field = "id,org,boid";
        return this.serviceHelper.queryOriginalArray(field, qFilter);
    }

    public DynamicObject[] queryEnableDarkPosByBoid(List<Long> positionIds) {
        QFilter positionQFilter = new QFilter("boid", "in", positionIds);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter darkQFilter = new QFilter("createmode", "=", (Object)"3");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        return this.serviceHelper.queryOriginalArray("boid", new QFilter[]{positionQFilter, enableQFilter, darkQFilter, isCurrentFilter});
    }

    public DynamicObject[] queryDarkPosFirstVersionByBoid(List<Long> positionIds) {
        QFilter positionQFilter = new QFilter("boid", "in", positionIds);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter darkQFilter = new QFilter("createmode", "=", (Object)"3");
        QFilter hisversionFilter = new QFilter("hisversion", "=", (Object)"V0001");
        QFilter sourceVidFilter = new QFilter("sourcevid", "=", (Object)0);
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{positionQFilter, isCurrentFilter, darkQFilter, hisversionFilter, sourceVidFilter});
    }

    public DynamicObject[] queryPositionByWorkRole(List<Long> workRoleIds, boolean containsDarkpos) {
        QFilter workRoleFilter = new QFilter("workrole", "in", workRoleIds);
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter qFilter = workRoleFilter.and(iscurrentVersionFilter).and(initStatusFilter);
        if (!containsDarkpos) {
            qFilter.and(new QFilter("createmode", "!=", (Object)"3"));
        }
        String field = "id, boid, number,name, parent, workrole";
        return this.serviceHelper.queryOriginalArray(field, new QFilter[]{qFilter});
    }

    public DynamicObject[] queryEnablePositionByJobId(List<Long> jobIdList) {
        QFilter idFilter = new QFilter("job", "in", jobIdList);
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter createmodeFilter = new QFilter("createmode", "!=", (Object)"3");
        String field = "id, job.id";
        return this.serviceHelper.query(field, new QFilter[]{idFilter, iscurrentVersionFilter, enableQFilter, createmodeFilter});
    }

    public List<Long> queryPositionIdByBills(DynamicObject[] positionBills) {
        List positionVidList = Arrays.stream(positionBills).map(positionBill -> positionBill.getLong("hisnewversion")).filter(vid -> vid != 0L).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(positionVidList)) {
            return Collections.emptyList();
        }
        QFilter filter = new QFilter("id", "in", positionVidList);
        DynamicObject[] positionVersionDys = this.serviceHelper.query("boid", filter.toArray());
        if (positionVersionDys.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(positionVersionDys).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
    }

    public DynamicObject[] queryCurEffectingPosition(List<Long> positionIds, String selectProperties) {
        QFilter boIdFilter = new QFilter("boid", "in", positionIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter effStartDatedFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.getNowDate());
        return this.serviceHelper.query(selectProperties, new QFilter[]{boIdFilter, dataStatusFilter, isCurrentVersionFilter, effStartDatedFilter});
    }

    public Set<String> getPositionAllFields() {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_positionhr");
        Map entityTypeMap = entityType.getAllEntities();
        return ((EntityType)entityTypeMap.get("hbpm_positionhr")).getFields().keySet();
    }

    public DynamicObject[] queryPositionByTplId(Set<Long> tplIdList) {
        QFilter tplFilter = new QFilter("positiontpl", "in", tplIdList);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter createmodeFilter = new QFilter("createmode", "!=", (Object)"3");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "0"});
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{tplFilter, isCurrentFilter, createmodeFilter, dataStatusFilter, initStatusFilter});
    }

    public DynamicObject[] queryInitPositionByTplId(Set<Long> tplIdList) {
        QFilter tplFilter = new QFilter("positiontpl", "in", tplIdList);
        QFilter createmodeFilter = new QFilter("createmode", "!=", (Object)"3");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "in", (Object)new String[]{"0", "1"});
        return this.serviceHelper.loadDynamicObjectArray(new QFilter[]{tplFilter, createmodeFilter, dataStatusFilter, initStatusFilter});
    }

    private static class PositionQueryInstance {
        private static PositionQueryRepository INSTANCE = new PositionQueryRepository();

        private PositionQueryInstance() {
        }
    }
}

