/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class PositionTplRepository {
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_positiontpl");

    public static PositionTplRepository getInstance() {
        return PositionTplRepositoryInstance.INSTANCE;
    }

    public DynamicObject[] queryPositionTplNameById(List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        return serviceHelper.query("name", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryPositionTplPosFieldById(List<Long> ids, Set<String> fields) {
        HashSet<String> queryFieldList = new HashSet<String>(Arrays.asList("id", "name", "number", "enable", "status"));
        queryFieldList.addAll(fields);
        String queryFields = Joiner.on((String)",").join(queryFieldList);
        QFilter idFilter = new QFilter("id", "in", ids);
        return serviceHelper.query(queryFields, new QFilter[]{idFilter});
    }

    public DynamicObject[] queryEnablePostplTypeByNameList(List<String> nameList, List<String> idList) {
        QFilter enalbe = new QFilter("enable", "=", (Object)"1");
        QFilter nameFilter = new QFilter("name", "in", nameList);
        QFilter idListFilter = new QFilter("id", "not in", idList);
        return serviceHelper.query("name,enable", new QFilter[]{enalbe.and(nameFilter).and(idListFilter)});
    }

    public DynamicObject[] queryPostplNameEnableById(List<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        return serviceHelper.query("name,enable", new QFilter[]{idFilter});
    }

    public boolean isExistEnableName(DynamicObject data) {
        String id = data.getString("id");
        QFilter enalbeFilter = new QFilter("enable", "=", (Object)"1");
        QFilter nameFilter = new QFilter("name", "=", (Object)data.getString("name"));
        QFilter filter = enalbeFilter.and(nameFilter);
        if (!HRStringUtils.isEmpty((String)id) && !HRStringUtils.equals((String)"0", (String)id)) {
            filter = new QFilter("id", "!=", data.getPkValue()).and(filter);
        }
        return serviceHelper.isExists(filter);
    }

    public DynamicObject[] queryPositionTplByBuIds(List<Long> orgIds) {
        QFilter idFilter = new QFilter("org", "in", orgIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        return serviceHelper.query("id,enable,org", new QFilter[]{idFilter, enableFilter, statusFilter});
    }

    public DynamicObject[] queryPositionTplByIds(List<Long> tplIds) {
        QFilter idFilter = new QFilter("id", "in", tplIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        return serviceHelper.query("id,enable,org,ablemodifyfield,fieldrange,enable", new QFilter[]{idFilter, enableFilter, statusFilter});
    }

    public DynamicObject[] queryDisablePositionTplByIds(List<Long> tplIds) {
        QFilter idFilter = new QFilter("id", "in", tplIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"0");
        return serviceHelper.query("id,enable,org,ablemodifyfield,fieldrange,enable", new QFilter[]{idFilter, enableFilter});
    }

    public DynamicObject[] queryDisablePositionTplByIds(Object[] tplIds) {
        QFilter idFilter = new QFilter("id", "in", (Object)tplIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"0");
        return serviceHelper.query("id,enable,org,ablemodifyfield,fieldrange,enable", new QFilter[]{idFilter, enableFilter});
    }

    public void update(List<DynamicObject> tpls) {
        serviceHelper.update(tpls.toArray(new DynamicObject[tpls.size()]));
    }

    public void update(DynamicObject[] tpls) {
        serviceHelper.update(tpls);
    }

    public DynamicObject[] queryUpgradeData() {
        QFilter qFilter = new QFilter("org", "=", null);
        QFilter orgQfilter = new QFilter("org", "=", (Object)0L);
        qFilter.or(orgQfilter);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public DynamicObject[] queryEnablePositionTplByName(List<String> tplNames) {
        QFilter qFilter = new QFilter("name", "in", tplNames);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return serviceHelper.query("id,number,org,status,issetscope,applicationscope.adminorg,applicationscope.containssubordinate", new QFilter[]{qFilter, enableFilter});
    }

    public DynamicObject[] queryEnablePositionTplByNumber(List<String> tplNumbers) {
        QFilter qFilter = new QFilter("number", "in", tplNumbers);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return serviceHelper.query("id,number,org,status,issetscope,applicationscope.adminorg,applicationscope.containssubordinate", new QFilter[]{qFilter, enableFilter});
    }

    public Set<String> getTplAllFields() {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_positiontpl");
        Map entityTypeMap = entityType.getAllEntities();
        return ((EntityType)entityTypeMap.get("hbpm_positiontpl")).getFields().keySet();
    }

    public DynamicObject[] queryPositionTplOrgId(long orgId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    private static class PositionTplRepositoryInstance {
        private static PositionTplRepository INSTANCE = new PositionTplRepository();

        private PositionTplRepositoryInstance() {
        }
    }
}

