/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;

public class ProjectRoleQueryRepository {
    public static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("hbpm_projectroles");

    private ProjectRoleQueryRepository() {
    }

    public static ProjectRoleQueryRepository getInstance() {
        return ProjectRoleQueryRepositoryInstance.INSTANCE;
    }

    public DynamicObject[] queryByProjectTeamByRPC(List<Long> projectGroupIdList) {
        QFilter hisDataFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter prjTeamFilter = new QFilter("projteam", "in", projectGroupIdList);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_projectroles");
        return serviceHelper.queryOriginalArray("id, boid, number, name, rolestype, isdutypers, projteam, superroles", new QFilter[]{prjTeamFilter, hisDataFilter, enableFilter});
    }

    public DynamicObject[] queryMainRoleByProjectTeam(List<Long> projectTeamIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_projectroles");
        QFilter projectTeamFilter = new QFilter("projteam", "in", projectTeamIdList);
        QFilter mainRoleFilter = new QFilter("isdutypers", "=", (Object)"1");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{projectTeamFilter, isCurrentVersionFilter, mainRoleFilter, enableFilter});
    }

    public DynamicObject[] querySubLevelNonSuperMainRoleByProjectTeam(List<Long> projectTeamIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_projectroles");
        QFilter projectTeamFilter = new QFilter("projteam.parentorg", "in", projectTeamIdList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter superFilter = new QFilter("superroles", "=", (Object)0);
        QFilter mainRoleFilter = new QFilter("isdutypers", "=", (Object)"1");
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{projectTeamFilter, isCurrentVersionFilter, enableFilter, superFilter, mainRoleFilter});
    }

    public DynamicObject[] queryBySuperRole(List<Long> roleIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_projectroles");
        QFilter superRileFilter = new QFilter("superroles", "in", roleIdList);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{superRileFilter, isCurrentVersionFilter, enableFilter});
    }

    public DynamicObject[] queryByPrjTeamParentChg(Set<Long> prjTeamBoSet, Date date) {
        QFilter prjTeamFilter = new QFilter("projteam", "in", prjTeamBoSet);
        QFilter hisDateFilter = this.createHisDateFilter(date);
        return HELPER.queryOriginalArray("id, boid, bsed, bsled, org.id, projteam.id", new QFilter[]{prjTeamFilter, this.createHisStatusFilter(), hisDateFilter});
    }

    public DynamicObject[] loadById(Set<Long> boSet) {
        QFilter idFilter = new QFilter("id", "in", boSet);
        return HELPER.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    public DynamicObject queryOriginalOneById(String selectFields, long id) {
        return HELPER.queryOriginalOne(selectFields, (Object)id);
    }

    public DynamicObject[] queryOriginalByNumber(String selectFields, Set<String> numberSet) {
        QFilter numberFilter = new QFilter("number", "in", numberSet);
        return HELPER.queryOriginalArray(selectFields, new QFilter[]{numberFilter});
    }

    private QFilter createHisStatusFilter() {
        return new QFilter("iscurrentversion", "=", (Object)"0").and("datastatus", "in", Arrays.asList(EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue()));
    }

    private QFilter createHisDateFilter(Date date) {
        return new QFilter("bsled", ">=", (Object)date);
    }

    private static class ProjectRoleQueryRepositoryInstance {
        private static ProjectRoleQueryRepository INSTANCE = new ProjectRoleQueryRepository();

        private ProjectRoleQueryRepositoryInstance() {
        }
    }
}

