/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hbpm.business.utils.model.ReportHisLoopCheckEntity;
import kd.hrmp.hbpm.common.constants.PositionConstants;

public class ReportingrelationQueryRepository {
    private ReportingrelationQueryRepository() {
    }

    public static ReportingrelationQueryRepository getInstance() {
        return ReportingrelationQueryInstance.INSTANCE;
    }

    public List<DynamicObject> queryReportRelationByWorkRoleIds(List<Long> workRoleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter idFilter = new QFilter("role", "in", workRoleIds);
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter qFilter = new QFilter("reportingtype.id", "!=", (Object)1010);
        QFilter enableFilter = new QFilter("enable", "!=", (Object)"0");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, curVersionFilter, qFilter, enableFilter});
        return Arrays.asList(dynamicObjects);
    }

    public List<DynamicObject> queryRealReportRelationByPositionIds(List<Long> workRoleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter idFilter = new QFilter("role", "in", workRoleIds);
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter qFilter = new QFilter("reportingtype.id", "=", (Object)1010);
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, curVersionFilter, qFilter});
        return Arrays.asList(dynamicObjects);
    }

    public DynamicObject queryRelationBoIdByRole(Long workRoleId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter idFilter = new QFilter("role", "=", (Object)workRoleId);
        QFilter qFilter = new QFilter("reportingtype.id", "=", (Object)1010);
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.loadDynamicObject(new QFilter[]{idFilter, qFilter, curVersionFilter});
    }

    public List<DynamicObject> queryAllDisableAdministrativeUpRelationByIds(List<Long> workRoleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter upFilter = new QFilter("role", "in", workRoleIds).and(new QFilter("parent.enable", "=", (Object)"1"));
        QFilter typeFilter = new QFilter("reportingtype", "=", (Object)1010L);
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{upFilter, typeFilter, curVersionFilter});
        return Arrays.asList(dynamicObjects);
    }

    public List<DynamicObject> queryAllDisableAdministrativeDownRelationByIds(List<Long> workRoleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter downFilter = new QFilter("parent", "in", workRoleIds).and(new QFilter("role.enable", "=", (Object)"1"));
        QFilter typeFilter = new QFilter("reportingtype", "=", (Object)1010L);
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{downFilter, typeFilter, curVersionFilter});
        return new ArrayList<DynamicObject>(Arrays.asList(dynamicObjects));
    }

    public List<DynamicObject> queryAllDisableReportRelationAboutDownByIds(List<Long> workRoleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter idFilter = new QFilter("role", "in", workRoleIds);
        idFilter.or(new QFilter("parent", "in", workRoleIds));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, enableFilter, curVersionFilter});
        return Arrays.asList(dynamicObjects);
    }

    public List<DynamicObject> queryReportRelationPartialInfo(Collection<Long> workRoleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter idFilter = new QFilter("role", "in", workRoleIds);
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id, role, reportingtype, parent", new QFilter[]{idFilter, curVersionFilter, initStatusFilter});
        return Arrays.asList(dynamicObjects);
    }

    public DynamicObject[] queryAdministrativeRelationByDutyRoleIds(List<Long> dutyRoleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter typeFilter = new QFilter("reportingtype", "=", (Object)1010L);
        QFilter dutyRoleFilter = new QFilter("role.position", "in", dutyRoleIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{dutyRoleFilter, curVersionFilter, typeFilter, enableFilter});
    }

    public DynamicObject[] queryNonAdministrativeRelationByDutyRoleIds(List<Long> dutyRoleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter typeFilter = new QFilter("reportingtype", "!=", (Object)1010L);
        QFilter dutyRoleFilter = new QFilter("role.position", "in", dutyRoleIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{dutyRoleFilter, curVersionFilter, typeFilter, enableFilter});
    }

    public DynamicObject[] queryNonAdministrativeRelationByDutyRoleIds4Page(List<Long> dutyRoleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter typeFilter = new QFilter("reportingtype", "!=", (Object)1010L);
        QFilter dutyRoleFilter = new QFilter("role.position", "in", dutyRoleIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.query("id,parent,reportingtype,bsed,bsled", new QFilter[]{dutyRoleFilter, curVersionFilter, typeFilter, enableFilter});
    }

    public DynamicObject[] queryByDutyRoleIds4Disable(List<Long> dutyRoleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter dutyRoleFilter = new QFilter("role.position", "in", dutyRoleIds);
        QFilter parentDutyRoleFilter = new QFilter("parent.position", "in", dutyRoleIds);
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.query("id,boid,bsed,bsled,eventid", new QFilter[]{dutyRoleFilter.or(parentDutyRoleFilter), curVersionFilter});
    }

    public boolean isExistNotEnable(List<Long> idList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter idFilter = new QFilter("id", "in", idList).and(new QFilter("enable", "!=", (Object)"10"));
        return serviceHelper.isExists(idFilter);
    }

    public DynamicObject[] queryRelationhis(List<Long> roles, Date date) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter boidFilter = new QFilter("role", "in", roles);
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        String field = "id, role, parent, reportingtype";
        return helper.queryOriginalArray(field, new QFilter[]{boidFilter, datastatusFilter, iscurrentVersionFilter, bsedFilter, bsledFilter, enableFilter, initStatusFilter});
    }

    public DynamicObject[] queryChildWorkRole(List<Long> parent, Date date, Long reportRelationTypeId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter boidFilter = new QFilter("parent", "in", parent);
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter reportRelationTypeFilter = new QFilter("reportingtype.id", "=", (Object)reportRelationTypeId);
        String field = "id, role, parent, reportingtype";
        return helper.queryOriginalArray(field, new QFilter[]{boidFilter, datastatusFilter, iscurrentVersionFilter, bsedFilter, bsledFilter, enableFilter, initStatusFilter, reportRelationTypeFilter});
    }

    public List<DynamicObject> queryChangeRelationhis(List<Long> roles, Date date) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter boidFilter = new QFilter("role", "in", roles);
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter enableFilter = new QFilter("enable", "!=", (Object)"0");
        QFilter qFilter = new QFilter("reportingtype.id", "!=", (Object)1010);
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(new QFilter[]{datastatusFilter, iscurrentVersionFilter, qFilter, bsedFilter, bsledFilter, boidFilter, enableFilter});
        return Arrays.asList(dynamicObjects);
    }

    public List<DynamicObject> queryPositionRelationhis(List<Long> roles) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter boidFilter = new QFilter("role", "in", roles);
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter enableFilter = new QFilter("enable", "!=", (Object)"0");
        QFilter qFilter = new QFilter("reportingtype.id", "!=", (Object)1010);
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(new QFilter[]{datastatusFilter, iscurrentVersionFilter, qFilter, boidFilter, enableFilter});
        return Arrays.asList(dynamicObjects);
    }

    public DynamicObject[] queryRelationHisVersions(List<Long> roles) {
        HRBaseServiceHelper reportRelationServiceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter boIdFilter = new QFilter("role", "in", roles);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        return reportRelationServiceHelper.queryOriginalArray("id, role, role.name, role.number, parent, reportingtype, role.adminorg, bsed, bsled", new QFilter[]{boIdFilter, dataStatusFilter, isCurrentVersionFilter}, "bsed asc");
    }

    public DynamicObject[] queryEnabledReportRelations(Date date, Long workroleId, Long reportingtype) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter filter = new QFilter("boid", "=", (Object)workroleId).and(new QFilter("reportingtype", "=", (Object)reportingtype)).and(new QFilter("bsed", "<=", (Object)date)).and(new QFilter("bsled", ">=", (Object)date).and(new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"})));
        return serviceHelper.query("id,role,parent,reportingtype,role.adminorg,parent.adminorg", new QFilter[]{filter});
    }

    public DynamicObject[] queryAllNonAdministrativeRelationHisVersionsByDytyRoles(List<Long> dutyRoleIds) {
        HRBaseServiceHelper reportRelationServiceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter boIdFilter = new QFilter("role.position", "in", dutyRoleIds);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "-2", "0"});
        QFilter typeFilter = new QFilter("reportingtype", "!=", (Object)1010L);
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        return reportRelationServiceHelper.queryOriginalArray("id, role, role.name, role.number,role.position,parent, reportingtype, role.adminorg, bsed, bsled,hisversion,sourcevid,datastatus,modifytime,modifier,boid", new QFilter[]{boIdFilter, dataStatusFilter, isCurrentVersionFilter, typeFilter});
    }

    public DynamicObject[] queryPositionHisVersion(Set<Long> boIds) {
        HRBaseServiceHelper reportRelationServiceHelper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter[] qFilters = new QFilter[]{new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"}), new QFilter("boid", "in", boIds), new QFilter("iscurrentversion", "=", (Object)"0")};
        return reportRelationServiceHelper.queryOriginalArray("boid, bsed, id, bsled, datastatus", qFilters, "bsed desc");
    }

    public Map<Long, List<ReportHisLoopCheckEntity>> queryPosHisEnableAdminRelByTimeRange(Date effdt, Date leffdt, List<String> reportTypeIdList) {
        String sql = "select froleid,fparentid,fbsed,fbsled,freportingtypeid from t_hbpm_reportingrelation where fdatastatus in ('0','1','2') and fenable = '1' and fparentid <> 0 and freportingtypeid in (" + String.join((CharSequence)",", reportTypeIdList) + ") and fsourceid = '1010' and fiscurrentversion = '0' ";
        StringBuilder sb = new StringBuilder();
        sb.append(sql);
        ArrayList params = Lists.newArrayListWithExpectedSize((int)8);
        sb.append(" and fbsled >= ? ");
        params.add(HRDateTimeUtils.truncateDate((Date)effdt));
        if (leffdt != null) {
            sb.append(" and fbsed <= ? ");
            params.add(HRDateTimeUtils.truncateDate((Date)leffdt));
        }
        return (Map)HRDBUtil.query((DBRoute)PositionConstants.DB_ROUTE_HBPM, (String)sb.toString(), (Object[])params.toArray(new Object[0]), rs -> {
            HashMap<Long, ArrayList<ReportHisLoopCheckEntity>> resultMap = new HashMap<Long, ArrayList<ReportHisLoopCheckEntity>>(16);
            while (rs.next()) {
                long role = rs.getLong("froleid");
                ReportHisLoopCheckEntity entity = new ReportHisLoopCheckEntity();
                entity.setRole(role);
                entity.setParent(rs.getLong("fparentid"));
                entity.setBsed(rs.getDate("fbsed"));
                entity.setBsled(rs.getDate("fbsled"));
                entity.setReportingtype(rs.getString("freportingtypeid"));
                ArrayList<ReportHisLoopCheckEntity> list = (ArrayList<ReportHisLoopCheckEntity>)resultMap.get(role);
                if (list == null) {
                    list = new ArrayList<ReportHisLoopCheckEntity>();
                }
                list.add(entity);
                resultMap.put(role, list);
            }
            return resultMap;
        });
    }

    private static class ReportingrelationQueryInstance {
        private static ReportingrelationQueryRepository INSTANCE = new ReportingrelationQueryRepository();

        private ReportingrelationQueryInstance() {
        }
    }
}

