/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class StandardPositionRepository {
    public static StandardPositionRepository getInstance() {
        return StandardPositionRepositoryInstance.INSTANCE;
    }

    public DynamicObject[] queryAllStandardPosition(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter orgFilter = new QFilter("id", "in", ids);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.query("id,number,name,positiontype,positionclassify,jobscm,job,lowjoblevel,highjoblevel,lowjobgrade,highjobgrade", new QFilter[]{orgFilter, isCurrentFilter});
    }

    public DynamicObject[] queryAllHasInitStandardPosition(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter orgFilter = new QFilter("id", "in", ids);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        isCurrentFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        QFilter enableFilter = new QFilter("enable", "!=", (Object)"10");
        return serviceHelper.query("id,number,boid,bsed,bsled,firstbsed,name,positiontype,positionclassify,jobscm,job,lowjoblevel,highjoblevel,lowjobgrade,highjobgrade", new QFilter[]{orgFilter, isCurrentFilter, enableFilter});
    }

    public DynamicObject[] queryAllUnDarkStandardPositionByJobIds(List<Long> jobIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter filter = new QFilter("job.id", "in", jobIds);
        filter.and(new QFilter("createmode", "!=", (Object)"3"));
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public DynamicObject[] queryAllDarkStandardPositionByJobIds(List<Long> jobIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter filter = new QFilter("job.id", "in", jobIds);
        filter.and(new QFilter("createmode", "=", (Object)"3"));
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{filter, isCurrentFilter});
    }

    public DynamicObject[] queryAllDarkStandardIdsPositionByJobIds(List<Long> jobIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter filter = new QFilter("id", "in", jobIds);
        filter.and(new QFilter("createmode", "=", (Object)"3"));
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.queryOriginalArray("id", new QFilter[]{filter, isCurrentFilter});
    }

    public DynamicObject[] querySPHis(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter idFilter = new QFilter("id", "in", ids);
        return serviceHelper.query("id,boid,number,name,positiontype,job,lowjoblevel,highjoblevel,lowjobgrade,highjobgrade,entryentity,entryentity.adminorg,entryentity.iscontainsu,bsed,bsled", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryHisByBoids(List<Long> boIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter idFilter = new QFilter("boid", "in", boIds);
        idFilter.and(new QFilter("iscurrentversion", "!=", (Object)"1"));
        idFilter.and(new QFilter("datastatus", "in", Arrays.asList("0", "1", "2", "-2")));
        return serviceHelper.query("id,boid,number,name,positiontype,job,lowjoblevel,highjoblevel,lowjobgrade,highjobgrade,entryentity,entryentity.adminorg,entryentity.iscontainsu,bsed,bsled", new QFilter[]{idFilter}, "boid desc,bsed desc,id desc");
    }

    public DynamicObject[] querySPHis(List<Long> ids, Date date) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter idFilter = new QFilter("boid", "in", ids);
        if (Objects.isNull(date)) {
            date = new Date();
        }
        idFilter.and(new QFilter("bsed", "<=", (Object)date));
        idFilter.and(new QFilter("bsled", ">=", (Object)date));
        idFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        idFilter.and(new QFilter("datastatus", "in", Arrays.asList("0", "1", "2")));
        return serviceHelper.query("id,boid,number,name,orgdesignbu,positiontype,positionclassify,description,jobscm,job,lowjoblevel,highjoblevel,lowjobgrade,highjobgrade", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryStdPositionByNumber(List<String> numbers, Date date) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter idFilter = new QFilter("number", "in", numbers);
        idFilter.and(new QFilter("bsed", "<=", (Object)date));
        idFilter.and(new QFilter("bsled", ">=", (Object)date));
        idFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        idFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        idFilter.and(new QFilter("datastatus", "in", Arrays.asList("0", "1", "2")));
        return serviceHelper.query("id,boid,number,name,enable,datastatus,firstbsed", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryStdPositionFirstBsedByNumbers(List<String> numbers) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter idFilter = new QFilter("number", "in", numbers);
        idFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        idFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        idFilter.and(new QFilter("datastatus", "in", Arrays.asList("0", "1", "2")));
        return serviceHelper.queryOriginalArray("id,boid,firstbsed", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryCurrentStdPositionByNumbers(String selectFields, List<String> numbers) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter filter = new QFilter("number", "in", numbers);
        filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        filter.and(new QFilter("initstatus", "=", (Object)"2"));
        filter.and(new QFilter("datastatus", "=", (Object)"1"));
        return serviceHelper.queryOriginalArray(selectFields, new QFilter[]{filter});
    }

    public DynamicObject[] queryStdPositionJobLevelAndJobGrade(List<Long> stdPositionIdList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter idFilter = new QFilter("id", "in", stdPositionIdList);
        String field = "id, lowjoblevel, highjoblevel, lowjobgrade, highjobgrade";
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        return helper.query(field, new QFilter[]{idFilter, initStatusFilter});
    }

    public void saveBatch(List<DynamicObject> dynamicObjects) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        serviceHelper.save(dynamicObjects.toArray(new DynamicObject[0]));
    }

    public List<DynamicObject> generateEmptyObject(int size) {
        if (size <= 0) {
            return null;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_stposition");
        ArrayList<DynamicObject> lists = new ArrayList<DynamicObject>(size);
        for (int i = 0; i < size; ++i) {
            DynamicObject dy = new DynamicObject((DynamicObjectType)dataEntityType);
            lists.add(dy);
        }
        return lists;
    }

    public DynamicObject[] queryStdPositionById(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter idFilter = new QFilter("id", "in", ids);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    public DynamicObject[] queryCurrentBoStdPositionByBoId(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter idFilter = new QFilter("boid", "in", ids);
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter, isCurrentFilter});
    }

    public DynamicObject[] queryStdPositionByOrg(List<Long> orgs) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter entryFilter = new QFilter("entryentity.adminorg.id", "in", orgs);
        String field = "id, number, name,positiontype,entryentity,entryentity.adminorg,entryentity.iscontainsu";
        return serviceHelper.query(field, new QFilter[]{isCurrentFilter, initStatusFilter, entryFilter});
    }

    public DynamicObject[] queryStdPositionVersionsByBo(List<Long> boidList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter entryFilter = new QFilter("boid", "in", boidList);
        String field = "id, boid";
        return serviceHelper.query(field, new QFilter[]{datastatusFilter, initStatusFilter, entryFilter});
    }

    public DynamicObject[] queryHisStdPositionByOrg(List<Long> orgs, Date date) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter entryFilter = new QFilter("entryentity.adminorg.id", "in", orgs).and("entryentity.adminorg.establishmentdate", "<=", (Object)date);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        String field = "id, boid, number, name,positiontype.id,entryentity,entryentity.adminorg.id,entryentity.iscontainsu,createorg.id";
        return serviceHelper.queryOriginalArray(field, new QFilter[]{enableFilter, bsedFilter, bsledFilter, datastatusFilter, iscurrentVersionFilter, initStatusFilter, entryFilter});
    }

    public DynamicObject[] queryHisVersionJobLevelAndJobGrade(List<Long> positionIdList, Date date) {
        QFilter boidFilter = new QFilter("boid", "in", positionIdList);
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter qFilter = boidFilter.and(datastatusFilter).and(iscurrentVersionFilter).and(initStatusFilter);
        if (date != null) {
            QFilter bsedFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)date));
            QFilter bsledFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)date));
            qFilter.and(bsedFilter).and(bsledFilter);
        }
        String field = "id, datastatus, boid, lowjoblevel.id, highjoblevel.id, lowjobgrade.id, highjobgrade.id";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        return serviceHelper.queryOriginalArray(field, new QFilter[]{qFilter});
    }

    public DynamicObject[] getStdPosIdByPermFilter(QFilter permFilter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter iscurrentversionQfilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter datastatusQFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter = enableFilter.and(datastatusQFilter).and(iscurrentversionQfilter).and(initStatusFilter).and(permFilter);
        DynamicObject[] stdPositions = serviceHelper.query("id", new QFilter[]{qFilter});
        List boids = Arrays.stream(stdPositions).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        QFilter hisDatastatusQFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2"});
        QFilter enableFilterNew = new QFilter("enable", "=", (Object)"1");
        QFilter initStatusFilterNew = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter boIdQFilter = new QFilter("boid", "in", boids);
        return serviceHelper.query("id", new QFilter[]{boIdQFilter.and(hisDatastatusQFilter).and(initStatusFilterNew).and(enableFilterNew)});
    }

    public DynamicObject[] querySPHisById(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_stposition");
        QFilter idFilter = new QFilter("id", "in", ids);
        return serviceHelper.query("id,boid,number,name,orgdesignbu,positiontype,positionclassify,description,jobscm,job,lowjoblevel,highjoblevel,lowjobgrade,highjobgrade", new QFilter[]{idFilter});
    }

    private static class StandardPositionRepositoryInstance {
        private static StandardPositionRepository INSTANCE = new StandardPositionRepository();

        private StandardPositionRepositoryInstance() {
        }
    }
}

