/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hbpm.common.enums.position.SyncStatusEnum;

public class SyncPositionLogRepository
extends HRBaseServiceHelper {
    private static final SyncPositionLogRepository REPOSITORY = new SyncPositionLogRepository("hbpm_syncpositionlog");

    public SyncPositionLogRepository(String entityName) {
        super(entityName);
    }

    public static SyncPositionLogRepository getRepository() {
        return REPOSITORY;
    }

    public void discardByPositionIds(List<Long> positionIds, String serviceName) {
        DynamicObject[] logs = this.queryNotSyncSuccessLogs(positionIds, serviceName, "syncstatus", null);
        if (logs.length == 0) {
            return;
        }
        Arrays.stream(logs).forEach(log -> log.set("syncstatus", (Object)SyncStatusEnum.DISCARD.getCode()));
        REPOSITORY.update(logs);
    }

    public Map<Long, DynamicObject> queryLatestNotSyncSuccessLog(List<Long> positionIds, String serviceName) {
        DynamicObject[] logs = this.queryNotSyncSuccessLogs(positionIds, serviceName, String.join((CharSequence)",", "position", "syncstatus", "errormsg", "synctime", "servicename", "positionvid", "retrycount"), "createtime desc");
        if (logs.length == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(logs).collect(Collectors.toMap(log -> log.getLong("position.id"), log -> log, (v1, v2) -> v1));
    }

    private DynamicObject[] queryNotSyncSuccessLogs(List<Long> positionIds, String serviceName, String selectProperties, String orderBy) {
        if (CollectionUtils.isEmpty(positionIds)) {
            return new DynamicObject[0];
        }
        QFilter filter = new QFilter("position", "in", positionIds);
        filter.and(new QFilter("servicename", "=", (Object)serviceName));
        filter.and(new QFilter("syncstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{SyncStatusEnum.WAIT_SYNC.getCode(), SyncStatusEnum.SYNCING.getCode(), SyncStatusEnum.SYNC_FAILED.getCode(), SyncStatusEnum.PARENT_WAIT_SYNC.getCode()})));
        return REPOSITORY.query(selectProperties, filter.toArray(), orderBy);
    }
}

