/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.repository.position;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class WorkRoleQueryRepository {
    private WorkRoleQueryRepository() {
    }

    public static WorkRoleQueryRepository getInstance() {
        return WorkRoleQueryInstance.INSTANCE;
    }

    public Map<Long, DynamicObject> queryWorkRoleToMap(List<Long> workRoleIds) {
        DynamicObject[] workRoles = this.queryWorkRoleByIds(workRoleIds);
        Map<Long, DynamicObject> workRoleMap = Arrays.stream(workRoles).collect(Collectors.toMap(workRole -> workRole.getLong("id"), workRole -> workRole));
        return workRoleMap;
    }

    public DynamicObject[] queryWorkRoleByIds(List<Long> workRoleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        QFilter idFilter = new QFilter("id", "in", workRoleIds);
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
    }

    public DynamicObject[] queryByDutyRoleIds(List<Long> dutyRoleIds) {
        QFilter dutyRoleFilter = new QFilter("position", "in", dutyRoleIds);
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{dutyRoleFilter, curVersionFilter});
    }

    public DynamicObject[] queryByDutyRoleHisByDutyRoleIds(Set<Long> dutyRoleIds, Date bsed) {
        QFilter dutyRoleFilter = new QFilter("position", "in", dutyRoleIds);
        QFilter hisVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0')).and(new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()}));
        QFilter dateFilter = new QFilter("bsled", ">=", (Object)bsed);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{dutyRoleFilter, hisVersionFilter, dateFilter});
    }

    public DynamicObject[] queryByDutyRoleIds4Disable(List<Long> dutyRoleIds) {
        QFilter dutyRoleFilter = new QFilter("position", "in", dutyRoleIds);
        QFilter curVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        return serviceHelper.query("id,boid,bsed,bsled,eventid", new QFilter[]{dutyRoleFilter, curVersionFilter});
    }

    public boolean isExistNotEnable(List<Long> idList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        QFilter idFilter = new QFilter("id", "in", idList).and(new QFilter("enable", "!=", (Object)"10"));
        return serviceHelper.isExists(idFilter);
    }

    public DynamicObject queryWorkRole(Date date, Long workroleId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        QFilter idFilter = new QFilter("boid", "=", (Object)workroleId).and(new QFilter("bsed", "<=", (Object)date)).and(new QFilter("bsled", ">=", (Object)date).and(new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"})));
        return serviceHelper.queryOne("number,name,roletype,adminorg,mainpeoincharge,parentrole,rolesourcetype,enable", idFilter);
    }

    public DynamicObject[] queryWorkroleHis(List<Long> boids, Date date) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_workroleshr");
        QFilter boidFilter = new QFilter("boid", "in", boids);
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        String field = "id, boid";
        return helper.queryOriginalArray(field, new QFilter[]{boidFilter, datastatusFilter, iscurrentVersionFilter, bsedFilter, bsledFilter, initStatusFilter});
    }

    public DynamicObject[] queryRelations(Date date, List<Long> workroleIds, Long roletypeId, Consumer<QFilter> addFilterConsumer) {
        if (workroleIds.isEmpty()) {
            return null;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbpm_reportingrelation");
        QFilter datastatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        QFilter iscurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter roletypeFilter = new QFilter("reportingtype", "=", (Object)roletypeId);
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter bsledFilter = new QFilter("bsled", ">=", (Object)HRDateTimeUtils.truncateDate((Date)date));
        QFilter initStatusFilter = new QFilter("initstatus", "not in", (Object)new String[]{"0", "1"});
        QFilter parnetFilter = new QFilter("parent", "!=", (Object)0);
        datastatusFilter.and(iscurrentVersionFilter).and(roletypeFilter).and(bsedFilter).and(bsledFilter).and(initStatusFilter).and(parnetFilter);
        addFilterConsumer.accept(datastatusFilter);
        return helper.query("role,parent,reportingtype", new QFilter[]{datastatusFilter});
    }

    public DynamicObject[] queryPositionHisVersion(Set<Long> boIds) {
        HRBaseServiceHelper workHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        QFilter[] qFilters = new QFilter[]{new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "2"}), new QFilter("boid", "in", boIds), new QFilter("iscurrentversion", "=", (Object)"0")};
        return workHelper.queryOriginalArray("boid, bsed, id, bsled,datastatus", qFilters, "bsed desc");
    }

    public DynamicObject[] queryWorkRoleById(Set<Long> workRoleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        QFilter idFilter = new QFilter("boid", "in", workRoleIds);
        return serviceHelper.query("id,boid,initstatus", new QFilter[]{idFilter});
    }

    public DynamicObject[] queryWorkRoleByBoidId(Set<Long> workRoleIds, String selectProperties) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        QFilter idFilter = new QFilter("boid", "in", workRoleIds);
        return serviceHelper.queryOriginalArray(selectProperties, idFilter.toArray());
    }

    public void saveWorkRoles(DynamicObject[] dynamicObjects) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        serviceHelper.save(dynamicObjects);
    }

    public void deleteWorkRolesByIds(Object[] pkId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        serviceHelper.delete(pkId);
    }

    public DynamicObject getEmptyDyn() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        return serviceHelper.generateEmptyDynamicObject();
    }

    public DynamicObject[] queryInitWorkRole(List<Long> boid) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbpm_workroleshr");
        QFilter boidFilter = new QFilter("boid", "in", boid);
        QFilter initStatusFilter = new QFilter("initstatus", "in", (Object)new String[]{"0", "1"});
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        return serviceHelper.loadDynamicObjectArray(new QFilter[]{boidFilter, initStatusFilter, dataStatusFilter});
    }

    private static class WorkRoleQueryInstance {
        private static WorkRoleQueryRepository INSTANCE = new WorkRoleQueryRepository();

        private WorkRoleQueryInstance() {
        }
    }
}

