/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.service.impl.common;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BOSRuntime;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ShardingParam;
import kd.bos.schedule.dao.dbImpl.DbJobOperation;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hrmp.hbpm.business.domain.repository.common.BosQueryRepository;
import kd.hrmp.hbpm.business.domain.service.common.IScheduleUpgradeService;

public class ScheduleUpgradeServiceImpl
implements IScheduleUpgradeService {
    private static Log log = LogFactory.getLog((String)"kd.hrmp.hbpm.business.domain.service.impl.common.ScheduleUpgradeServiceImpl");
    private static final String SHAREPARAMS = "SHAREPARAMS";

    @Override
    public void upgrade(String scheduleNumber) {
        log.info("ScheduleUpgradeServiceImpl.upgrade start {}", (Object)scheduleNumber);
        DynamicObject scheduleData = BosQueryRepository.getInstance().loadOneScheduleDynByNumber(scheduleNumber);
        if (scheduleData == null) {
            log.info("ScheduleUpgradeServiceImpl.upgrade cannot find this schedule scheduleNumber:{}", (Object)scheduleNumber);
            return;
        }
        DynamicObjectCollection tasks = scheduleData.getDynamicObjectCollection("entryentity");
        if (tasks == null || tasks.size() <= 0) {
            log.info("ScheduleUpgradeServiceImpl.upgrade has no job scheduleNumber:{}", (Object)scheduleNumber);
            return;
        }
        for (DynamicObject task : tasks) {
            DynamicObject job = task.getDynamicObject("jobnumber");
            String jobId = (String)job.getPkValue();
            JobInfo jobInfo = ScheduleService.getInstance().getObjectFactory().getJobDao().get(jobId);
            log.info("ScheduleUpgradeServiceImpl.upgrade jobInfo scheduleNumber:{},jobId:{},jobInfo:{}", new Object[]{scheduleNumber, jobId, jobInfo});
            if (!jobInfo.isEnable() || !this.isExistAppNum(jobInfo.getAppId())) continue;
            jobInfo.setScheduleId(scheduleData.getString("id"));
            this.dispatchJob(jobInfo);
        }
        log.info("ScheduleUpgradeServiceImpl.upgrade end {}", (Object)scheduleNumber);
    }

    private boolean isExistAppNum(String appNum) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appNum)) {
            return true;
        }
        return !BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)appNum)}).isEmpty();
    }

    private void dispatchJob(JobInfo jobInfo) {
        Map params;
        String appId;
        if (!jobInfo.isEnable()) {
            log.info("%s task is not enable", (Object)jobInfo.getName());
            return;
        }
        if (StringUtils.isBlank((CharSequence)jobInfo.getAppId())) {
            jobInfo.setAppId("bos");
        }
        if (!this.isExistAppNum(appId = jobInfo.getAppId())) {
            log.info("%s appid is not exist", (Object)appId);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appId) || BOSRuntime.isBOSApp((String)appId)) {
            jobInfo.setAppId("bos");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appId) || BOSRuntime.isBOSApp((String)appId)) {
            jobInfo.setAppId("bos");
        }
        long groupId = 0L;
        jobInfo.setGroupId(groupId);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setExecuteTime(1);
        if (jobInfo.getRetryTime() > 0 || jobInfo.getRouteMode() != RouteMode.RAMDOM) {
            groupId = DbJobOperation.getGroupMax();
            jobInfo.setGroupId(groupId);
        }
        if (jobInfo.getRouteMode() != null && jobInfo.getRouteMode() == RouteMode.SHARDINGTASK && (params = jobInfo.getParams()) != null && params.size() > 0) {
            Object shareParams = params.get(SHAREPARAMS);
            if (shareParams == null) {
                return;
            }
            List<ShardingParam> shareParamList = new ArrayList();
            try {
                shareParamList = JSON.parseArray((String)((String)shareParams), ShardingParam.class);
            }
            catch (Exception e) {
                HashMap shareParamMap = (HashMap)JSON.parseObject((String)((String)shareParams), HashMap.class);
                for (Map.Entry paramEntry : shareParamMap.entrySet()) {
                    shareParamList.add(new ShardingParam((String)paramEntry.getKey(), (String)paramEntry.getValue()));
                }
            }
            int index = 0;
            for (ShardingParam shardingParam : shareParamList) {
                jobInfo.setShardingParam(shardingParam);
                jobInfo.setShareIndex(++index);
                jobInfo.setExecuteTime(shareParamList.size());
                JobClient.dispatch((JobInfo)jobInfo);
            }
            return;
        }
        jobInfo.setFromScheduler(true);
        JobClient.dispatchToMaster((JobInfo)jobInfo);
    }
}

