/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.service.impl.position;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.model.Position;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.ext.BosPositionValidateReq;
import kd.hr.hbp.common.ext.BosPositionValidateResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.SyncPositionLogRepository;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.common.enums.position.SyncStatusEnum;
import kd.sdk.hr.hrmp.hbpm.extpoint.IBosPositionValidateServiceExt;

public class BosPositionServiceImpl
implements IBosPositionService {
    private static ThreadLocal<Map<String, List<Long>>> syncThreadLocal = new ThreadLocal();
    private static final Log LOGGER = LogFactory.getLog(BosPositionServiceImpl.class);

    @Override
    public Map<String, List<Long>> addWaitSyncLogs(DynamicObject[] beforePositionDys, DynamicObject[] afterPositionDys) {
        if (afterPositionDys == null || afterPositionDys.length == 0) {
            LOGGER.warn("afterPositionDys is empty");
            return Collections.emptyMap();
        }
        if (this.isDisableSyncPlatformPosition()) {
            return Collections.emptyMap();
        }
        List<DynamicObject> positions = Arrays.stream(afterPositionDys).filter(position -> HRStringUtils.equals((String)position.getString("initstatus"), (String)"2")).filter(position -> HRStringUtils.equals((String)position.getString("datastatus"), (String)"1")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(positions)) {
            LOGGER.info("positions is empty");
            return Collections.emptyMap();
        }
        int size = positions.size();
        Map<Object, Object> beforePositionMap = beforePositionDys != null && beforePositionDys.length > 0 ? Arrays.stream(beforePositionDys).collect(Collectors.toMap(beforePositionDy -> beforePositionDy.getLong("boid"), beforePositionDy -> beforePositionDy, (v1, v2) -> v2)) : Collections.emptyMap();
        List positionBoIds = positions.stream().map(position -> position.getLong("boid")).collect(Collectors.toList());
        Map bosPositionsMap = UserServiceHelper.getPositions(positionBoIds, (boolean)true);
        HashMap positionMap = new HashMap(size);
        HashMap<String, List<Long>> syncPositionIdsMap = new HashMap<String, List<Long>>(size);
        positions.forEach(position -> {
            String serviceName;
            long positionId = position.getLong("boid");
            Position bosPosition = (Position)bosPositionsMap.get(positionId);
            positionMap.put(positionId, position);
            long changeSceneId = position.getLong("changescene.id");
            if (changeSceneId == 1070L) {
                serviceName = "enablePosition";
                if (bosPosition == null) {
                    if (!syncPositionIdsMap.containsKey("addOrUpdatePosition")) {
                        syncPositionIdsMap.put("addOrUpdatePosition", new ArrayList(16));
                    }
                    ((List)syncPositionIdsMap.get("addOrUpdatePosition")).add(positionId);
                    return;
                }
            } else if (changeSceneId == 1040L) {
                serviceName = "disablePosition";
            } else {
                serviceName = "addOrUpdatePosition";
                DynamicObject beforePosition = (DynamicObject)beforePositionMap.get(positionId);
                if (!HRObjectUtils.isEmpty((Object)beforePosition) && bosPosition != null) {
                    String afterEnable = position.getString("enable");
                    String beforeEnable = beforePosition.getString("enable");
                    if (!HRStringUtils.equals((String)beforeEnable, (String)afterEnable)) {
                        String enableOrDisableServiceName;
                        String string = enableOrDisableServiceName = HRStringUtils.equals((String)beforeEnable, (String)"1") ? "disablePosition" : "enablePosition";
                        if (this.comparePositionIsNeedSync((DynamicObject)position, bosPosition, enableOrDisableServiceName)) {
                            if (!syncPositionIdsMap.containsKey(enableOrDisableServiceName)) {
                                syncPositionIdsMap.put(enableOrDisableServiceName, new ArrayList(16));
                            }
                            ((List)syncPositionIdsMap.get(enableOrDisableServiceName)).add(positionId);
                        }
                    }
                }
            }
            if (this.comparePositionIsNeedSync((DynamicObject)position, bosPosition, serviceName)) {
                if (!syncPositionIdsMap.containsKey(serviceName)) {
                    syncPositionIdsMap.put(serviceName, new ArrayList(16));
                }
                ((List)syncPositionIdsMap.get(serviceName)).add(positionId);
            }
        });
        SyncPositionLogRepository syncPositionLogRepository = SyncPositionLogRepository.getRepository();
        ArrayList syncPositionLogs = new ArrayList(size);
        syncPositionIdsMap.forEach((serviceName, positionIds) -> {
            syncPositionLogRepository.discardByPositionIds((List<Long>)positionIds, (String)serviceName);
            syncPositionLogs.addAll(positionIds.stream().map(positionId -> this.buildSyncPositionLog((DynamicObject)positionMap.get(positionId), (String)serviceName)).collect(Collectors.toList()));
        });
        syncPositionLogRepository.save(syncPositionLogs.toArray(new DynamicObject[0]));
        syncThreadLocal.set(syncPositionIdsMap);
        return syncPositionIdsMap;
    }

    @Override
    public List<BosPositionValidateResult> bosPositionValidate(List<BosPositionValidateReq> reqs) {
        if (CollectionUtils.isEmpty(reqs)) {
            LOGGER.warn("reqs is empty");
            return Collections.emptyList();
        }
        List<BosPositionValidateResult> exVallidateResults = this.exVallidate(reqs);
        if (exVallidateResults != null) {
            LOGGER.info("exVallidate size:{}", (Object)exVallidateResults.size());
            return exVallidateResults;
        }
        int size = reqs.size();
        ArrayList<BosPositionValidateResult> results = new ArrayList<BosPositionValidateResult>(size);
        try {
            ArrayList<String> positionNumbers = new ArrayList<String>(size);
            for (BosPositionValidateReq positionDy : reqs) {
                positionNumbers.add(positionDy.getPositionNumber());
                BosPositionValidateResult result = new BosPositionValidateResult();
                result.setResult(true);
                results.add(result);
            }
            if (this.isDisableSyncPlatformPosition()) {
                return results;
            }
            LOGGER.info("UserServiceHelper.getPositionsByNumber positionNumbers:{}", positionNumbers);
            Map bosPositionMap = UserServiceHelper.getPositionsByNumber(positionNumbers, (boolean)false);
            LOGGER.info("UserServiceHelper.getPositionsByNumber bosPositionMap:{}", (Object)bosPositionMap);
            for (int i = 0; i < size; ++i) {
                String positionName;
                long bosPositionId;
                BosPositionValidateReq req = reqs.get(i);
                String positionNumber = req.getPositionNumber();
                if (!bosPositionMap.containsKey(positionNumber)) continue;
                BosPositionValidateResult result = (BosPositionValidateResult)results.get(i);
                Position bosPosition = (Position)bosPositionMap.get(positionNumber);
                long positionId = req.getPositionId();
                if (positionId == (bosPositionId = bosPosition.getId())) continue;
                long bosPositionOrgId = bosPosition.getDptId();
                long positionOrgId = req.getPositionOrgId();
                String bosPositionName = bosPosition.getName().getLocaleValue();
                if (HRStringUtils.equals((String)bosPositionName, (String)(positionName = req.getPositionName().getLocaleValue())) && bosPositionOrgId == positionOrgId) {
                    if (positionId == 0L) {
                        result.setBosPositionId(bosPositionId);
                        continue;
                    }
                    result.setResult(false);
                    result.setMessage(ResManager.loadKDString((String)"\u3010\u57fa\u7840\u670d\u52a1\u4e91-\u4f01\u4e1a\u5efa\u6a21-\u4eba\u5458\u7ba1\u7406-\u5c97\u4f4d\u3011\u4e2d\u5df2\u5b58\u5728\u4e00\u6837\u7684\u5c97\u4f4d\uff0c\u8bf7\u4fee\u6539", (String)"BosPositionServiceImpl_3", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
                    continue;
                }
                result.setResult(false);
                result.setMessage(ResManager.loadKDString((String)"\u5c97\u4f4d\u7f16\u7801\u5728\u3010\u57fa\u7840\u670d\u52a1\u4e91-\u4f01\u4e1a\u5efa\u6a21-\u4eba\u5458\u7ba1\u7406-\u5c97\u4f4d\u3011\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539", (String)"BosPositionServiceImpl_1", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            String message = ResManager.loadKDString((String)"\u5e73\u53f0\u5c97\u4f4d\u6821\u9a8c\u5f02\u5e38", (String)"BosPositionServiceImpl_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            LOGGER.error(message, (Throwable)e);
            String errorMessage = String.format("%s\uff1a%s", message, e.getMessage());
            for (BosPositionValidateResult result : results) {
                result.setResult(false);
                result.setMessage(errorMessage);
            }
        }
        return results;
    }

    private List<BosPositionValidateResult> exVallidate(List<BosPositionValidateReq> reqs) {
        List list;
        HRPluginProxy pluginProxy = HRPlugInProxyFactory.create(null, IBosPositionValidateServiceExt.class, (String)"kd.sdk.hr.hrmp.hbpm.extpoint.IBosPositionValidateServiceExt", null);
        List exResult = pluginProxy.callReplace(plugin -> plugin.bosPositionValidate(reqs));
        if (exResult != null && !exResult.isEmpty() && exResult.get(0) instanceof List && !(list = (List)exResult.get(0)).isEmpty()) {
            return list;
        }
        return null;
    }

    @Override
    public void addOrUpdatePositions(List<Long> positionIds) {
        this.syncBosPosition(positionIds, "addOrUpdatePosition", (positions, syncLogMap) -> {
            List bosPositionReqs = positions.stream().map(positionDy -> {
                Position position = new Position();
                position.setId(positionDy.getLong("boid"));
                position.setNumber(positionDy.getString("number"));
                position.setName(positionDy.getLocaleString("name"));
                position.setDptId(positionDy.getLong("adminorg.id"));
                position.setRemarks(positionDy.getLocaleString("description"));
                String isLeader = positionDy.getString("isleader");
                position.setMainPosition(Boolean.valueOf(HRStringUtils.equals((String)isLeader, (String)"1")));
                position.setSuperiorPositionId(positionDy.getLong("parent.id"));
                String enable = positionDy.getString("enable");
                position.setEnable(HRStringUtils.equals((String)enable, (String)"1"));
                return position;
            }).collect(Collectors.toList());
            LOGGER.info("invoke UserServiceHelper.addOrUpdatePositions bosPositionReqs:{}", bosPositionReqs);
            TXHandle txHandle = TX.requiresNew();
            OperationResult operationResult = null;
            try {
                operationResult = (OperationResult)UserServiceHelper.addOrUpdatePositions(bosPositionReqs);
            }
            catch (Exception e) {
                LOGGER.error("invoke UserServiceHelper.addOrUpdatePositions error ", (Throwable)e);
                txHandle.markRollback();
            }
            finally {
                txHandle.close();
                LOGGER.info("invoke UserServiceHelper.addOrUpdatePositions return operationResult:{}", (Object)operationResult);
            }
            return operationResult;
        });
    }

    @Override
    public void enablePositions(List<Long> positionIds) {
        this.syncBosPosition(positionIds, "enablePosition", (positions, syncLogMap) -> {
            Set positionIdSet = positions.stream().map(position -> position.getLong("id")).collect(Collectors.toSet());
            LOGGER.info("invoke UserServiceHelper.enablePosition positionIdSet:{}", positionIdSet);
            TXHandle txHandle = TX.requiresNew();
            Map result = null;
            try {
                result = UserServiceHelper.enablePosition(positionIdSet);
            }
            catch (Exception e) {
                LOGGER.error("invoke UserServiceHelper.enablePosition error ", (Throwable)e);
                txHandle.markRollback();
            }
            finally {
                txHandle.close();
                LOGGER.info("invoke UserServiceHelper.enablePosition return result:{}", (Object)result);
            }
            return result;
        });
    }

    @Override
    public void disablePositions(List<Long> positionIds) {
        this.syncBosPosition(positionIds, "disablePosition", (positions, syncLogMap) -> {
            Set positionIdSet = positions.stream().map(position -> position.getLong("id")).collect(Collectors.toSet());
            LOGGER.info("invoke UserServiceHelper.disablePosition positionIdSet:{}", positionIdSet);
            TXHandle txHandle = TX.requiresNew();
            Map result = null;
            try {
                result = UserServiceHelper.disablePosition(positionIdSet);
            }
            catch (Exception e) {
                LOGGER.error("invoke UserServiceHelper.disablePosition error ", (Throwable)e);
                txHandle.markRollback();
            }
            finally {
                txHandle.close();
                LOGGER.info("invoke UserServiceHelper.disablePosition return result:{}", (Object)result);
            }
            return result;
        });
    }

    private void syncBosPosition(List<Long> positionIds, String serviceName, BiFunction<List<DynamicObject>, Map<Long, DynamicObject>, Object> function) {
        Map<Long, DynamicObject> syncLogMap;
        SyncPositionLogRepository syncPositionLogRepository;
        block12: {
            if (CollectionUtils.isEmpty(positionIds)) {
                LOGGER.warn("positionIds is empty");
                return;
            }
            LOGGER.info("start sync position positionIds:{},serviceName:{}", positionIds, (Object)serviceName);
            if (this.isDisableSyncPlatformPosition()) {
                return;
            }
            syncPositionLogRepository = SyncPositionLogRepository.getRepository();
            syncLogMap = syncPositionLogRepository.queryLatestNotSyncSuccessLog(positionIds, serviceName);
            if (syncLogMap.isEmpty()) {
                LOGGER.info("syncLogMap is empty");
                return;
            }
            try {
                ArrayList<Long> syncLogPositionIds = new ArrayList<Long>(syncLogMap.keySet());
                DynamicObject[] positions = PositionQueryRepository.getInstance().queryCurEffectingPosition(syncLogPositionIds, String.join((CharSequence)",", "boid", "adminorg.id", "description", "parent.id", "isleader", "enable", "sourcevid"));
                if (positions.length == 0) {
                    LOGGER.info("positions is empty");
                    return;
                }
                Map bosPositionsMap = UserServiceHelper.getPositions(new ArrayList<Long>(syncLogPositionIds), (boolean)true);
                List<DynamicObject> needSyncPositions = Arrays.stream(positions).filter(position -> this.comparePositionIsNeedSync((DynamicObject)position, (Position)bosPositionsMap.get(position.getLong("id")), serviceName)).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(needSyncPositions)) {
                    LOGGER.info("needSyncPositions is empty");
                    return;
                }
                List parentPositionIds = needSyncPositions.stream().map(position -> position.getLong("parent.id")).filter(parentId -> parentId != 0L).collect(Collectors.toList());
                Map parentBosPositionMap = UserServiceHelper.getPositions(parentPositionIds, (boolean)false);
                Date syncTime = new Date();
                Object result = function.apply(needSyncPositions, syncLogMap);
                needSyncPositions.forEach(position -> {
                    long positionId = position.getLong("boid");
                    DynamicObject syncLog = (DynamicObject)syncLogMap.get(positionId);
                    String syncStatus = syncLog.getString("syncstatus");
                    if (HRStringUtils.equals((String)syncStatus, (String)SyncStatusEnum.SYNC_FAILED.getCode()) || HRStringUtils.equals((String)syncStatus, (String)SyncStatusEnum.PARENT_WAIT_SYNC.getCode())) {
                        int retryCount = syncLog.getInt("retrycount");
                        syncLog.set("retrycount", (Object)(retryCount + 1));
                    }
                    syncLog.set("synctime", (Object)syncTime);
                    syncLog.set("syncstatus", (Object)SyncStatusEnum.SYNC_SUCCESS.getCode());
                    syncLog.set("positionvid", (Object)position.getLong("sourcevid"));
                    long parentId = position.getLong("parent.id");
                    if (parentId != 0L && !parentBosPositionMap.containsKey(parentId) && HRStringUtils.equals((String)serviceName, (String)"addOrUpdatePosition")) {
                        syncLog.set("syncstatus", (Object)SyncStatusEnum.PARENT_WAIT_SYNC.getCode());
                    }
                });
                if (result instanceof OperationResult) {
                    OperationResult operationResult = (OperationResult)result;
                    if (!operationResult.isSuccess()) {
                        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                        for (IOperateInfo operateInfo : allErrorOrValidateInfo) {
                            Long positionId2 = (Long)operateInfo.getPkValue();
                            DynamicObject syncPositionLog = syncLogMap.get(positionId2);
                            syncPositionLog.set("errormsg", (Object)operateInfo.getMessage());
                            syncPositionLog.set("syncstatus", (Object)SyncStatusEnum.SYNC_FAILED.getCode());
                        }
                    }
                    break block12;
                }
                if (result instanceof Map) {
                    Map resultMap = (Map)result;
                    if (!resultMap.isEmpty()) {
                        resultMap.forEach((positionId, message) -> {
                            DynamicObject syncPositionLog = (DynamicObject)syncLogMap.get(positionId);
                            if (HRStringUtils.isNotEmpty((String)message)) {
                                syncPositionLog.set("errormsg", message);
                                syncPositionLog.set("syncstatus", (Object)SyncStatusEnum.SYNC_FAILED.getCode());
                            }
                        });
                    }
                    break block12;
                }
                throw new RuntimeException("Unsupported result");
            }
            catch (Exception e) {
                String message2 = ResManager.loadKDString((String)"\u540c\u6b65\u5e73\u53f0\u5c97\u4f4d\u5f02\u5e38", (String)"BosPositionServiceImpl_2", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
                LOGGER.error(message2, (Throwable)e);
                String errorMessage = String.format("%s\uff1a%s", message2, e.getMessage());
                syncLogMap.forEach((positionId, syncLog) -> {
                    syncLog.set("errormsg", (Object)errorMessage);
                    syncLog.set("syncstatus", (Object)SyncStatusEnum.SYNC_FAILED.getCode());
                    syncLog.set("synctime", (Object)new Date());
                });
            }
        }
        syncPositionLogRepository.update(syncLogMap.values().toArray(new DynamicObject[0]));
        LOGGER.info("end sync position positionIds:{},serviceName:{}", positionIds, (Object)serviceName);
    }

    private DynamicObject buildSyncPositionLog(DynamicObject position, String serviceName) {
        DynamicObject syncPositionLog = SyncPositionLogRepository.getRepository().generateEmptyDynamicObject();
        syncPositionLog.set("position", (Object)position.getLong("boid"));
        syncPositionLog.set("positionvid", (Object)position.getLong("id"));
        syncPositionLog.set("name", (Object)position.getString("name"));
        syncPositionLog.set("number", (Object)position.getString("number"));
        syncPositionLog.set("adminorg", position.get("adminorg"));
        syncPositionLog.set("parent", position.get("parent"));
        syncPositionLog.set("isleader", (Object)position.getString("isleader"));
        syncPositionLog.set("enable", (Object)position.getString("enable"));
        syncPositionLog.set("syncstatus", (Object)SyncStatusEnum.WAIT_SYNC.getCode());
        syncPositionLog.set("retrycount", (Object)0);
        syncPositionLog.set("servicename", (Object)serviceName);
        syncPositionLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        return syncPositionLog;
    }

    @Override
    public boolean isDisableSyncPlatformPosition() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_odcconfigparam");
        QFilter filter = new QFilter("number", "=", (Object)"isPositionSyncPlatform");
        DynamicObject config = serviceHelper.queryOne("value", filter.toArray());
        if (HRObjectUtils.isEmpty((Object)config) || HRStringUtils.equals((String)config.getString("value"), (String)"0")) {
            LOGGER.info("sync position not enabled");
            return true;
        }
        return false;
    }

    private boolean comparePositionIsNeedSync(DynamicObject positionDy, Position bosPosition, String serviceName) {
        String enable = positionDy.getString("enable");
        switch (serviceName) {
            case "addOrUpdatePosition": {
                if (bosPosition == null) {
                    return HRStringUtils.equals((String)positionDy.getString("enable"), (String)"1");
                }
                if (!HRStringUtils.equals((String)positionDy.getLocaleString("name").getLocaleValue(), (String)bosPosition.getName().getLocaleValue())) {
                    return true;
                }
                if (!HRStringUtils.equals((String)positionDy.getString("number"), (String)bosPosition.getNumber())) {
                    return true;
                }
                if (positionDy.getLong("adminorg.id") != bosPosition.getDptId()) {
                    return true;
                }
                if (positionDy.getLong("parent.id") != bosPosition.getSuperiorPositionId()) {
                    return true;
                }
                if (!HRStringUtils.equals((String)positionDy.getLocaleString("description").getLocaleValue(), (String)bosPosition.getRemarks().getLocaleValue())) {
                    return true;
                }
                return HRStringUtils.equals((String)positionDy.getString("isleader"), (String)"1") != bosPosition.isMainPosition();
            }
            case "disablePosition": {
                if (bosPosition == null) {
                    return false;
                }
                return HRStringUtils.equals((String)enable, (String)"0") && bosPosition.isEnable();
            }
            case "enablePosition": {
                if (bosPosition == null) {
                    return true;
                }
                return HRStringUtils.equals((String)enable, (String)"1") && !bosPosition.isEnable();
            }
        }
        return false;
    }

    @Override
    public void commonSyncPositions() {
        Map<String, List<Long>> toSyncPositionMap = syncThreadLocal.get();
        if (toSyncPositionMap == null || toSyncPositionMap.size() == 0) {
            return;
        }
        toSyncPositionMap.forEach((serviceName, positionIds) -> {
            switch (serviceName) {
                case "addOrUpdatePosition": {
                    this.addOrUpdatePositions((List<Long>)positionIds);
                    break;
                }
                case "enablePosition": {
                    this.enablePositions((List<Long>)positionIds);
                    break;
                }
                case "disablePosition": {
                    this.disablePositions((List<Long>)positionIds);
                    break;
                }
            }
        });
        syncThreadLocal.remove();
    }
}

