/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.service.impl.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.HBPMEventRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.ChangeMsgServiceImpl;
import kd.hrmp.hbpm.business.domain.service.impl.position.PositionChangeDetailServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.ChangeEventService;
import kd.hrmp.hbpm.business.domain.service.position.IBosPositionService;
import kd.hrmp.hbpm.business.utils.model.ChangeDetailEntity;
import kd.hrmp.hbpm.common.constants.ChangeEventConstants;

public class ChangeEventServiceImpl
implements ChangeEventService {
    private Date now;
    public String sourceType = "";
    private Map<Long, Long> afterVidToBillIdMap;
    private static final ChangeEventServiceImpl INSTANCE = new ChangeEventServiceImpl();

    public static ChangeEventServiceImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public void handleChangeEvent(String sourceType, DynamicObject[] beforeData, DynamicObject[] afterData, Map<Long, Long> afterVidToBillIdMap, boolean isInitSource, boolean isSendMsg) {
        if (!this.checkParams(sourceType, afterData)) {
            return;
        }
        this.sourceType = sourceType;
        this.afterVidToBillIdMap = afterVidToBillIdMap;
        Map<Object, Object> beforeMap = beforeData == null ? Maps.newHashMapWithExpectedSize((int)8) : Arrays.stream(beforeData).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("boid"), dynamicObject -> dynamicObject));
        long[] eventIds = DB.genGlobalLongIds((int)afterData.length);
        int index = 0;
        ArrayList eventList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        ArrayList eventDetailList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        ArrayList opDetailList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        ArrayList excludeInitData = Lists.newArrayListWithExpectedSize((int)afterData.length);
        this.now = new Date();
        ArrayList changeDetails = Lists.newArrayListWithExpectedSize((int)afterData.length);
        ArrayList positionTypeChangedIdList = Lists.newArrayListWithExpectedSize((int)afterData.length);
        for (DynamicObject after : afterData) {
            String datastatus = after.getString("datastatus");
            if (HRStringUtils.equals((String)sourceType, (String)"10") && HRStringUtils.equals((String)"0", (String)datastatus)) continue;
            long eventId = eventIds[index++];
            long boid = after.getLong("boid");
            DynamicObject before = (DynamicObject)beforeMap.get(boid);
            DynamicObject event = this.handleEventSum(after, eventId);
            eventList.add(event);
            DynamicObject eventDetail = this.handleEventDetal(after, eventId);
            eventDetailList.add(eventDetail);
            DynamicObject operDetail = this.handleOperDetail(after, before, eventId, sourceType);
            opDetailList.add(operDetail);
            if (HRStringUtils.equals((String)sourceType, (String)"10") && HRStringUtils.equals((String)after.getString("initstatus"), (String)"2") && isSendMsg) {
                excludeInitData.add(after);
            }
            Long modifier = RequestContext.get().getCurrUserId();
            Long changeOperateId = after.getLong("changeoperate.id");
            Long changeTypeId = after.getLong("changetype.id");
            Long changeSceneId = after.getLong("changescene.id");
            Long changeReasonId = after.getLong("changedesc.id");
            Date changeDate = after.getDate("bsed");
            changeDetails.add(new ChangeDetailEntity(boid, before, after, eventId, this.now, modifier, changeOperateId, changeTypeId, changeSceneId, changeReasonId, changeDate, null));
            if (before == null || before.getLong("positiontype.id") == after.getLong("positiontype.id") || !HRStringUtils.equals((String)"1", (String)datastatus)) continue;
            positionTypeChangedIdList.add(after.getLong("boid"));
        }
        HBPMEventRepository.getInstance().saveBatch("hbpm_changetransum", eventList);
        HBPMEventRepository.getInstance().saveBatch("hbpm_changetrandetail", eventDetailList);
        HBPMEventRepository.getInstance().saveBatch("hbpm_changeoperdetail", opDetailList);
        ChangeMsgServiceImpl msg = new ChangeMsgServiceImpl(eventList, positionTypeChangedIdList);
        msg.handleChangeMsg(excludeInitData);
        new PositionChangeDetailServiceImpl().saveChangeDetail(changeDetails);
        IBosPositionService.getInstance().addWaitSyncLogs(beforeData, afterData);
    }

    private boolean checkParams(String sourceType, DynamicObject[] afterData) {
        if (!ChangeEventConstants.sourceTypeEntity.containsKey(sourceType)) {
            return false;
        }
        return afterData != null && afterData.length != 0;
    }

    private DynamicObject handleEventSum(DynamicObject after, Long eventId) {
        DynamicObject event = this.newEmptyDynamicObject("hbpm_changetransum");
        Long id = ChangeEventServiceImpl.createId("hbpm_changetransum");
        event.set("id", (Object)id);
        event.set("creator", (Object)RequestContext.get().getCurrUserId());
        event.set("createtime", (Object)this.now);
        event.set("event", (Object)eventId);
        event.set("targetposition", (Object)after.getLong("boid"));
        event.set("changetype", (Object)after.getString("changetype.id"));
        event.set("changescene", (Object)after.getString("changescene.id"));
        event.set("changereason", (Object)after.getString("changedesc.id"));
        event.set("changedate", (Object)after.getDate("bsed"));
        if (this.afterVidToBillIdMap != null) {
            event.set("billid", (Object)this.afterVidToBillIdMap.get(after.getLong("id")));
        }
        return event;
    }

    private DynamicObject handleEventDetal(DynamicObject after, Long eventId) {
        DynamicObject event = this.newEmptyDynamicObject("hbpm_changetrandetail");
        Long id = ChangeEventServiceImpl.createId("hbpm_changetrandetail");
        event.set("id", (Object)id);
        event.set("creator", (Object)RequestContext.get().getCurrUserId());
        event.set("createtime", (Object)this.now);
        event.set("event", (Object)eventId);
        event.set("targetposition", (Object)after.getLong("boid"));
        event.set("changetype", (Object)after.getString("changetype.id"));
        event.set("changescene", (Object)after.getString("changescene.id"));
        event.set("changereason", (Object)after.getString("changedesc.id"));
        event.set("changedate", (Object)after.getDate("bsed"));
        return event;
    }

    private DynamicObject handleOperDetail(DynamicObject after, DynamicObject before, Long eventId, String sourceType) {
        DynamicObject operDetail = this.newEmptyDynamicObject("hbpm_changeoperdetail");
        Long id = ChangeEventServiceImpl.createId("hbpm_changeoperdetail");
        operDetail.set("id", (Object)id);
        operDetail.set("creator", (Object)RequestContext.get().getCurrUserId());
        operDetail.set("createtime", (Object)this.now);
        operDetail.set("event", (Object)eventId);
        operDetail.set("position", (Object)after.getLong("boid"));
        operDetail.set("changeoperate", (Object)after.getLong("changeoperate.id"));
        operDetail.set("changedate", (Object)after.getDate("bsed"));
        operDetail.set("beforeposition", (Object)(before == null ? 0L : before.getLong("id")));
        operDetail.set("afterposition", (Object)(after.getLong("changetype.id") == 1030L ? 0L : after.getLong("id")));
        return operDetail;
    }

    private static Long createId(String pageValue) {
        return ORM.create().genLongId(pageValue);
    }

    private DynamicObject newEmptyDynamicObject(String pageValue) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pageValue);
        return new DynamicObject((DynamicObjectType)dataEntityType);
    }

    @Override
    public void delEvent(List<Long> positionIds) {
        HRBaseServiceHelper eventsumHelper = new HRBaseServiceHelper("hbpm_changetransum");
        DynamicObject[] eventsums = eventsumHelper.queryOriginalArray("id,event", new QFilter[]{new QFilter("TARGETPOSITION", "in", positionIds)});
        Set<Long> eventIds = Arrays.stream(eventsums).map(eventsum -> eventsum.getLong("event")).collect(Collectors.toSet());
        HBPMEventRepository.getInstance().delEventSum(eventIds);
        HBPMEventRepository.getInstance().delEventDetail(eventIds);
        HBPMEventRepository.getInstance().delOpDetail(eventIds);
    }

    @Override
    public Map<Long, List<DynamicObject>> getOpdetailByEventIds(List<Long> eventIds) {
        if (eventIds == null || eventIds.size() == 0) {
            return Maps.newHashMapWithExpectedSize((int)8);
        }
        DynamicObject[] opDetails = HBPMEventRepository.getInstance().selectOpDetail(eventIds);
        HashMap eventIdToDetailsMap = Maps.newHashMapWithExpectedSize((int)eventIds.size());
        Arrays.stream(opDetails).forEach(opDetail -> {
            Long eventId = opDetail.getLong("event");
            List details = (List)eventIdToDetailsMap.get(eventId);
            if (details == null) {
                details = Lists.newArrayListWithExpectedSize((int)eventIds.size());
            }
            details.add(opDetail);
            eventIdToDetailsMap.put(eventId, details);
        });
        return eventIdToDetailsMap;
    }
}

