/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.service.impl.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.HBPMMsgRepository;
import kd.hrmp.hbpm.business.domain.service.position.ChangeMsgService;
import kd.hrmp.hbpm.business.task.PublishTask;

public class ChangeMsgServiceImpl
implements ChangeMsgService {
    private static ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)"HBPMChangeMsgServiceThreadpool", (int)1, (int)4);
    private static ThreadLocal<List<Long>> msgIdThreadLocal = new ThreadLocal();
    private static final Log logger = LogFactory.getLog(ChangeMsgServiceImpl.class);
    private Date changetime = new Date();
    private Map<Long, String> posToMsgNumberMap;
    private List<Long> positionTypeChangedIdList;

    public ChangeMsgServiceImpl() {
    }

    public ChangeMsgServiceImpl(List<DynamicObject> eventList, List<Long> positionTypeChangedIdList) {
        if (CollectionUtils.isEmpty(eventList)) {
            return;
        }
        this.posToMsgNumberMap = eventList.stream().collect(Collectors.toMap(event -> event.getLong("targetposition"), event -> event.getString("event")));
        this.changetime = eventList.get(0).getDate("createtime");
        this.positionTypeChangedIdList = positionTypeChangedIdList;
    }

    public ChangeMsgServiceImpl(DynamicObject revisePosition, DynamicObject reviseLog, List<Long> positionTypeChangedIdList) {
        this.posToMsgNumberMap = new HashMap<Long, String>();
        this.posToMsgNumberMap.put(revisePosition.getLong("boid"), reviseLog.getString("id"));
        this.positionTypeChangedIdList = positionTypeChangedIdList;
    }

    @Override
    public void handleChangeMsg(List<DynamicObject> positions) {
        List<DynamicObject> msgList = this.saveChangeMsg(positions);
        if (msgList.isEmpty()) {
            return;
        }
        List ids = msgList.stream().map(msg -> msg.getLong("id")).collect(Collectors.toList());
        List<Long> idsFromLocal = msgIdThreadLocal.get();
        if (idsFromLocal != null) {
            ids.addAll(idsFromLocal);
        }
        msgIdThreadLocal.set(ids);
    }

    @Override
    public void sendMsg() {
        List<Long> ids = msgIdThreadLocal.get();
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        DynamicObject[] msgs = HBPMMsgRepository.getInstance().queryRetryMsgsById(ids);
        threadPool.execute((Runnable)new PublishTask(Arrays.asList(msgs)));
        msgIdThreadLocal.remove();
    }

    private List<DynamicObject> sortMsg(List<DynamicObject> msgs) {
        if (CollectionUtils.isEmpty(msgs)) {
            return Lists.newArrayListWithExpectedSize((int)8);
        }
        boolean sortFromLowToHigh = false;
        if (msgs.get(0).getLong("changeoperate.id") == 1030L) {
            sortFromLowToHigh = true;
        }
        HashMap posIdToMsgMap = Maps.newHashMapWithExpectedSize((int)msgs.size());
        HashMap posParentBoIdMap = Maps.newHashMapWithExpectedSize((int)msgs.size());
        for (DynamicObject msg : msgs) {
            DynamicObject pos = msg.getDynamicObject("position");
            posParentBoIdMap.put(pos.getLong("boid"), pos.getLong("parent.id"));
            posIdToMsgMap.put(pos.getLong("boid"), msg);
        }
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)msgs.size());
        for (DynamicObject msg : msgs) {
            DynamicObject pos = msg.getDynamicObject("position");
            long posId = pos.getLong("boid");
            this.addMsgFromHighToLow(posId, posParentBoIdMap, posIdToMsgMap, msgList);
        }
        if (sortFromLowToHigh) {
            Collections.reverse(msgList);
        }
        return msgList;
    }

    private void addMsgFromHighToLow(long posId, Map<Long, Long> posParentBoIdMap, Map<Long, DynamicObject> posIdToMsgMap, List<DynamicObject> msgList) {
        DynamicObject msg = posIdToMsgMap.get(posId);
        Long parent = posParentBoIdMap.get(posId);
        if (parent == null || parent == 0L) {
            if (!msgList.contains(msg)) {
                msgList.add(msg);
            }
            return;
        }
        DynamicObject parentMsg = posIdToMsgMap.get(parent);
        if (parentMsg == null || msgList.contains(parentMsg)) {
            if (!msgList.contains(msg)) {
                msgList.add(msg);
            }
            return;
        }
        this.addMsgFromHighToLow(parent, posParentBoIdMap, posIdToMsgMap, msgList);
        if (!msgList.contains(msg)) {
            msgList.add(msg);
        }
    }

    @Override
    public void clear() {
        msgIdThreadLocal.remove();
    }

    private List<DynamicObject> saveChangeMsg(List<DynamicObject> positions) {
        if (CollectionUtils.isEmpty(positions) || CollectionUtils.isEmpty(this.posToMsgNumberMap)) {
            return Lists.newArrayListWithExpectedSize((int)8);
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_changemsg");
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)positions.size());
        for (DynamicObject pos : positions) {
            long changetype = pos.getLong("changetype.id");
            if (changetype == 1050L) continue;
            DynamicObject msg = new DynamicObject((DynamicObjectType)dataEntityType);
            this.setMsgValue(msg, pos);
            msgList.add(msg);
        }
        List<DynamicObject> sortMsgList = this.sortMsg(msgList);
        HBPMMsgRepository.getInstance().saveBatch(sortMsgList);
        return msgList;
    }

    @Override
    public void retrySend(DynamicObject[] needRetrysendMsgs) {
        PublishTask publishTask = new PublishTask();
        publishTask.publish(Arrays.asList(needRetrysendMsgs), true);
    }

    private void setMsgValue(DynamicObject msg, DynamicObject pos) {
        msg.set("changescene", (Object)pos.getDynamicObject("changescene"));
        msg.set("changeoperate", (Object)pos.getDynamicObject("changeoperate"));
        msg.set("changereason", (Object)pos.getDynamicObject("changedesc"));
        msg.set("changetype", (Object)pos.getDynamicObject("changetype"));
        msg.set("changedesc", (Object)pos.getString("changeexplain"));
        msg.set("changeuser", (Object)pos.getString("modifier_id"));
        msg.set("position", (Object)pos);
        msg.set("adminorg", (Object)pos.getLong("adminorg.id"));
        msg.set("sendstate", (Object)"0");
        msg.set("effetdate", (Object)pos.getDate("bsed"));
        msg.set("org", (Object)pos.getDynamicObject("org"));
        msg.set("changetime", (Object)this.changetime);
        msg.set("number", (Object)this.posToMsgNumberMap.get(pos.getLong("boid")));
        msg.set("status", (Object)Character.valueOf('C'));
        msg.set("enable", (Object)"1");
        long changeoperate = pos.getLong("changeoperate.id");
        this.setMsgPublishInfo(changeoperate, pos, msg);
        msg.set("msgparams", (Object)this.getMsgParams(msg));
    }

    @Override
    public String getMsgParams(DynamicObject msg) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)8);
        long boid = msg.getDynamicObject("position").getLong("boid");
        params.put("boid", boid);
        params.put("number", msg.getString("position.number"));
        params.put("name", msg.getString("position.name"));
        params.put("date", "bsed");
        params.put("adminorg.number", msg.getString("position.adminorg.number"));
        params.put("adminorg.name", msg.getString("position.adminorg.name"));
        params.put("changeoperate.number", msg.getString("changeoperate.number"));
        params.put("changeoperate.name", msg.getString("changeoperate.name"));
        params.put("changedate", msg.getDate("effetdate"));
        params.put("eventId", msg.getString("number"));
        long changeoperate = msg.getLong("changeoperate.id");
        params.put("changeoperate", changeoperate);
        if (changeoperate == 1030L) {
            params.put("enable", msg.getString("position.enable"));
        } else {
            params.put("changescene.number", msg.getString("changescene.number"));
            params.put("changescene.name", msg.getString("changescene.name"));
        }
        String datastatus = msg.getDynamicObject("position").getString("datastatus");
        params.put("datastatus", datastatus);
        params.put("positiontypechanged", Boolean.FALSE);
        if (!(changeoperate != 1020L && changeoperate != 1040L || HRStringUtils.equals((String)"1", (String)datastatus))) {
            params.put("ispreversion", Boolean.TRUE);
        }
        if (HRStringUtils.equals((String)"1", (String)datastatus) && !CollectionUtils.isEmpty(this.positionTypeChangedIdList) && this.positionTypeChangedIdList.contains(boid)) {
            params.put("positiontypechanged", Boolean.TRUE);
        }
        return SerializationUtils.serializeToBase64((Object)params);
    }

    private void setMsgPublishInfo(long changeoperate, DynamicObject pos, DynamicObject msg) {
        String desc;
        String tag;
        String title;
        if (changeoperate == 1010L) {
            title = String.format(ResManager.loadKDString((String)"\u65b0\u589e\u5c97\u4f4d\uff08\u7f16\u7801\uff1a%1$s\uff0c \u540d\u79f0\uff1a%2$s\uff09", (String)"ChangeEventServiceImpl_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]), pos.getString("number"), pos.getString("name"));
            tag = ResManager.loadKDString((String)"\u5c97\u4f4d\u65b0\u589e", (String)"ChangeEventServiceImpl_3", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            desc = ResManager.loadKDString((String)"\u5c97\u4f4d\u65b0\u589e\u901a\u77e5", (String)"ChangeEventServiceImpl_6", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
        } else if (changeoperate == 1020L) {
            title = String.format(ResManager.loadKDString((String)"\u53d8\u66f4\u5c97\u4f4d\uff08\u7f16\u7801\uff1a%1$s\uff0c \u540d\u79f0\uff1a%2$s\uff09", (String)"ChangeEventServiceImpl_1", (String)"hrmp-hbpm-business", (Object[])new Object[0]), pos.getString("number"), pos.getString("name"));
            tag = ResManager.loadKDString((String)"\u5c97\u4f4d\u53d8\u66f4", (String)"ChangeEventServiceImpl_4", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            desc = ResManager.loadKDString((String)"\u5c97\u4f4d\u53d8\u66f4\u901a\u77e5", (String)"ChangeEventServiceImpl_7", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
        } else if (changeoperate == 1030L) {
            title = String.format(ResManager.loadKDString((String)"\u7981\u7528\u5c97\u4f4d\uff08\u7f16\u7801\uff1a%1$s\uff0c \u540d\u79f0\uff1a%2$s\uff09", (String)"ChangeEventServiceImpl_2", (String)"hrmp-hbpm-business", (Object[])new Object[0]), pos.getString("number"), pos.getString("name"));
            tag = ResManager.loadKDString((String)"\u5c97\u4f4d\u7981\u7528", (String)"ChangeEventServiceImpl_5", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            desc = ResManager.loadKDString((String)"\u5c97\u4f4d\u7981\u7528\u901a\u77e5", (String)"ChangeEventServiceImpl_8", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
        } else if (changeoperate == 1040L) {
            title = String.format(ResManager.loadKDString((String)"\u4fee\u8ba2\u5c97\u4f4d\uff08\u7f16\u7801\uff1a%1$s\uff0c \u540d\u79f0\uff1a%2$s\uff09", (String)"ChangeEventServiceImpl_9", (String)"hrmp-hbpm-business", (Object[])new Object[0]), pos.getString("number"), pos.getString("name"));
            tag = ResManager.loadKDString((String)"\u5c97\u4f4d\u4fee\u8ba2", (String)"ChangeEventServiceImpl_10", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
            desc = ResManager.loadKDString((String)"\u5c97\u4f4d\u4fee\u8ba2\u901a\u77e5", (String)"ChangeEventServiceImpl_11", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
        } else {
            title = "";
            tag = "";
            desc = "";
        }
        msg.set("msgtag", (Object)tag);
        msg.set("msgtitle", (Object)(title.length() > 50 ? title.substring(0, 50) : title));
        msg.set("msgdesc", (Object)desc);
    }
}

