/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.service.impl.position;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hrmp.hbpm.business.domain.bo.position.ChangeDetailBo;
import kd.hrmp.hbpm.business.domain.bo.position.PositionChangeDetailBo;
import kd.hrmp.hbpm.business.domain.repository.position.CommonQueryRepository;
import kd.hrmp.hbpm.business.domain.service.position.IChangeDetailDisplayService;
import kd.hrmp.hbpm.business.ext.PositionCompareEntryServiceExt;
import kd.hrmp.hbpm.business.utils.DynamicConvertUtils;

public class PositionChangeDetailDisplayServiceImpl
implements IChangeDetailDisplayService {
    private Map<String, Map<String, IDataEntityProperty>> propsMap = new HashMap<String, Map<String, IDataEntityProperty>>(4);

    @Override
    public List<ChangeDetailBo> buildChangeDetail(List<DynamicObject> detailInfos) {
        HashSet<Long> conditions;
        if (detailInfos == null || detailInfos.size() <= 0) {
            return null;
        }
        List<PositionChangeDetailBo> results = this.buildChangeDetailBos(detailInfos);
        HashMap<String, HashSet<String>> queryInfo = new HashMap<String, HashSet<String>>(4);
        HashMap<String, HashSet<Long>> queryConditionInfo = new HashMap<String, HashSet<Long>>(detailInfos.size());
        for (PositionChangeDetailBo bo : results) {
            Long afterValueId;
            Long beforeValueId;
            String changEntity = bo.getChangEntity();
            String propKey = bo.getPropKey();
            HashSet<String> propKeys = (HashSet<String>)queryInfo.get(changEntity);
            if (propKeys == null) {
                propKeys = new HashSet<String>(4);
            }
            propKeys.add(propKey);
            queryInfo.put(changEntity, propKeys);
            conditions = (Set)queryConditionInfo.get(changEntity);
            if (conditions == null) {
                conditions = new HashSet<Long>(4);
            }
            if ((beforeValueId = bo.getBeforeValueId()) != null && beforeValueId > 0L) {
                conditions.add(beforeValueId);
            }
            if ((afterValueId = bo.getAfterValueId()) != null && afterValueId > 0L) {
                conditions.add(afterValueId);
            }
            queryConditionInfo.put(changEntity, conditions);
        }
        HashMap<String, DynamicObject[]> datas = new HashMap<String, DynamicObject[]>(16);
        for (Map.Entry entry : queryInfo.entrySet()) {
            DynamicObject[] queryDatas;
            String entityCode = (String)entry.getKey();
            Set queryCols = (Set)entry.getValue();
            conditions = (HashSet<Long>)queryConditionInfo.get(entityCode);
            if (conditions == null || conditions.size() <= 0 || (queryDatas = CommonQueryRepository.getInstance().loadColsInfoById(entityCode, queryCols, conditions)) == null || queryDatas.length <= 0) continue;
            datas.put(entityCode, queryDatas);
        }
        this.buildDisplayInfo(results, datas);
        return ChangeDetailBo.buildBos(results);
    }

    private List<PositionChangeDetailBo> buildChangeDetailBos(List<DynamicObject> diffInfos) {
        ArrayList<PositionChangeDetailBo> bos = new ArrayList<PositionChangeDetailBo>(diffInfos.size());
        for (DynamicObject dynamicObject : diffInfos) {
            PositionChangeDetailBo bo = new PositionChangeDetailBo();
            bo.setDetailId(dynamicObject.getLong("id"));
            bo.setPropKey(dynamicObject.getString("propkey"));
            bo.setBeforeValue(dynamicObject.getString("beforevalue"));
            bo.setAfterValue(dynamicObject.getString("aftervalue"));
            bo.setChangEntity(dynamicObject.getString("changentity"));
            bo.setBeforeValueId(DynamicConvertUtils.getDataFromValue(dynamicObject.getString("beforevalue")));
            bo.setAfterValueId(DynamicConvertUtils.getDataFromValue(dynamicObject.getString("aftervalue")));
            bos.add(bo);
        }
        return bos;
    }

    private List<PositionChangeDetailBo> buildDisplayInfo(List<PositionChangeDetailBo> bos, Map<String, DynamicObject[]> datas) {
        if (bos == null || bos.size() <= 0 || datas == null || datas.size() <= 0) {
            return null;
        }
        HashMap<String, Map<Long, DynamicObject>> dataMap = new HashMap<String, Map<Long, DynamicObject>>(datas.size());
        for (Map.Entry<String, DynamicObject[]> entry : datas.entrySet()) {
            String entityCode = entry.getKey();
            Map<Long, DynamicObject> value = Arrays.stream((Object[])entry.getValue()).collect(Collectors.toMap(data -> data.getLong("id"), v1 -> v1, (v1, v2) -> v2));
            dataMap.put(entityCode, value);
        }
        PositionCompareEntryServiceExt serviceExt = PositionCompareEntryServiceExt.getInstance();
        for (PositionChangeDetailBo bo : bos) {
            String changeEntity = bo.getChangEntity();
            Map queryData = (Map)dataMap.get(changeEntity);
            if (queryData == null) continue;
            bo.setServiceExt(serviceExt);
            bo.setBeforeValueInfo((DynamicObject)queryData.get(bo.getBeforeValueId()));
            bo.setAfterValueInfo((DynamicObject)queryData.get(bo.getAfterValueId()));
            this.setDisplayInfo(bo);
        }
        return bos;
    }

    private PositionChangeDetailBo setDisplayInfo(PositionChangeDetailBo bo) {
        if (bo == null) {
            return null;
        }
        IDataEntityProperty prop = this.getProp(bo.getChangEntity(), bo.getPropKey());
        if (prop != null) {
            return DynamicConvertUtils.setDisplayValueByProp(bo, prop);
        }
        return bo;
    }

    private IDataEntityProperty getProp(String entityCode, String propKey) {
        Map<String, IDataEntityProperty> props = this.getMainEntityProps(entityCode);
        if (props == null || props.size() <= 0) {
            return null;
        }
        return props.get(propKey);
    }

    private Map<String, IDataEntityProperty> getMainEntityProps(String entityCode) {
        MainEntityType mainEntityType;
        DataEntityPropertyCollection mainEntityTypeProps;
        Map<String, IDataEntityProperty> props = this.propsMap.get(entityCode);
        if (props == null && (mainEntityTypeProps = (mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityCode)).getProperties()) != null && mainEntityTypeProps.size() > 0) {
            Map<String, IDataEntityProperty> propMap = mainEntityTypeProps.stream().collect(Collectors.toMap(data -> data.getName(), v1 -> v1, (v1, v2) -> v2));
            props = propMap;
            this.propsMap.put(entityCode, propMap);
        }
        return props;
    }
}

