/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.service.impl.position;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hrmp.hbpm.business.domain.bo.workrole.ReportRelationHisPreDataVersionBo;
import kd.hrmp.hbpm.business.domain.repository.position.PositionChangeDetailRepository;
import kd.hrmp.hbpm.business.domain.service.impl.position.ReportRelationHisServiceImpl;
import kd.hrmp.hbpm.business.domain.service.position.IChangeDetailService;
import kd.hrmp.hbpm.business.utils.DynamicConvertUtils;
import kd.hrmp.hbpm.business.utils.model.ChangeDetailEntity;
import kd.hrmp.hbpm.common.constants.PositionDetailConstants;

public class PositionChangeDetailServiceImpl
implements IChangeDetailService {
    private static Log LOG = LogFactory.getLog(PositionChangeDetailServiceImpl.class);
    private MainEntityType dataEntityTypeDetail = MetadataServiceHelper.getDataEntityType((String)"hbpm_chgrecord");
    private MainEntityType dataEntityTypeEvent = MetadataServiceHelper.getDataEntityType((String)"hbpm_chgrecordevt");
    private MainEntityType dataEntityTypeEventDetail = MetadataServiceHelper.getDataEntityType((String)"hbpm_chgrecorddetail");
    private GetIdsMethod getIdsMethod;

    @Override
    public void saveChangeDetail(List<ChangeDetailEntity> changeDetails) {
        if (changeDetails == null || changeDetails.size() <= 0) {
            LOG.info("PositionChangeDetailServiceImpl saveChangeDetail valideAndFilterData changeDetails {}", changeDetails);
            return;
        }
        List<Long> boids = changeDetails.stream().filter(data -> data.getBoid() != null).map(ChangeDetailEntity::getBoid).collect(Collectors.toList());
        LOG.info("PositionChangeDetailServiceImpl saveChangeDetail valideAndFilterData changeDetails  boids {}", boids);
        if (boids == null || boids.size() <= 0) {
            return;
        }
        HashMap<Long, DynamicObject> detailMap = new HashMap<Long, DynamicObject>(boids.size());
        DynamicObject[] exitMainDatas = PositionChangeDetailRepository.getInstance().getBaseInfoByPositionIds(boids);
        detailMap.putAll(Arrays.stream(exitMainDatas).collect(Collectors.toMap(dy -> dy.getLong("position.id"), dy -> dy, (v1, v2) -> v2)));
        this.getIdsMethod = new GetIdsMethod(changeDetails.size());
        ArrayList<DynamicObject> detailNewData = new ArrayList<DynamicObject>(boids.size() - detailMap.size());
        ArrayList<DynamicObject> eventNewData = new ArrayList<DynamicObject>(changeDetails.size());
        ArrayList<DynamicObject> eventDetailNewData = new ArrayList<DynamicObject>(changeDetails.size() * 2);
        ArrayList<ChangeDetailEntity> relationChangeDatas = new ArrayList<ChangeDetailEntity>(changeDetails.size());
        ArrayList<ChangeDetailEntity> attrChangeDatas = new ArrayList<ChangeDetailEntity>(changeDetails.size());
        for (ChangeDetailEntity data2 : changeDetails) {
            if (data2.getChangeSceneId() == 1030L) {
                relationChangeDatas.add(data2);
                continue;
            }
            attrChangeDatas.add(data2);
        }
        LOG.info("PositionChangeDetailServiceImpl saveChangeDetail attrChangeDatas {}", attrChangeDatas);
        this.dealChangeInfo(detailMap, attrChangeDatas, detailNewData, eventNewData, eventDetailNewData);
        LOG.info("PositionChangeDetailServiceImpl saveChangeDetail relationChangeDatas {}", relationChangeDatas);
        this.dealReportRelationChangeInfo(detailMap, relationChangeDatas, eventNewData, eventDetailNewData);
        if (detailNewData.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])detailNewData.toArray(new DynamicObject[0]));
        }
        if (eventNewData.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])eventNewData.toArray(new DynamicObject[0]));
        }
        if (eventDetailNewData.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])eventDetailNewData.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public void rollbackChangeDetailByBatchNumber(long batchNumber) {
        LOG.info("PositionChangeDetailServiceImpl rollbackChangeDetailByBatchNumber start batchNumber:{}", (Object)batchNumber);
        if (batchNumber <= 0L) {
            return;
        }
        DynamicObject[] changeRecord = PositionChangeDetailRepository.getInstance().getInfoByBatchNumber(batchNumber);
        if (changeRecord == null || changeRecord.length <= 0) {
            return;
        }
        ArrayList<Long> changeRecordIds = new ArrayList<Long>(changeRecord.length);
        ArrayList<Long> changeRecordEventIds = new ArrayList<Long>(changeRecord.length);
        ArrayList<Long> changeRecordDetailIds = new ArrayList<Long>(changeRecord.length);
        Arrays.stream(changeRecord).forEach(data -> {
            changeRecordIds.add(data.getLong("id"));
            DynamicObjectCollection eventDyns = data.getDynamicObjectCollection("evententry");
            if (eventDyns != null && eventDyns.size() > 0) {
                for (DynamicObject event : eventDyns) {
                    changeRecordEventIds.add(event.getLong("id"));
                    DynamicObjectCollection detailDyns = event.getDynamicObjectCollection("detailentry");
                    if (eventDyns == null || eventDyns.size() <= 0) continue;
                    changeRecordDetailIds.addAll(detailDyns.stream().map(detail -> detail.getLong("id")).collect(Collectors.toSet()));
                }
            }
        });
        if (changeRecordIds.size() > 0) {
            PositionChangeDetailRepository.getInstance().deleteChgRecordByIds(changeRecordIds);
        }
        if (changeRecordEventIds.size() > 0) {
            PositionChangeDetailRepository.getInstance().deleteChgRecordByIds(changeRecordEventIds);
        }
        if (changeRecordDetailIds.size() > 0) {
            PositionChangeDetailRepository.getInstance().deleteChgRecordByIds(changeRecordDetailIds);
        }
        LOG.info("PositionChangeDetailServiceImpl rollbackChangeDetailByBatchNumber end  batchNumber:{}", (Object)batchNumber);
    }

    private void dealChangeInfo(Map<Long, DynamicObject> detailMap, List<ChangeDetailEntity> attrChangeDatas, List<DynamicObject> detailNewData, List<DynamicObject> eventNewData, List<DynamicObject> eventDetailNewData) {
        for (ChangeDetailEntity data : attrChangeDatas) {
            DynamicObject after = data.getAfter();
            if (after == null) continue;
            long boid = after.getLong("boid");
            DynamicObject dyDetail = detailMap.get(boid);
            if (dyDetail == null) {
                dyDetail = this.buildDetailData(data);
                detailMap.put(boid, dyDetail);
                detailNewData.add(dyDetail);
            }
            DynamicObject dyEvent = this.buildEventData(data, dyDetail.getLong("id"));
            eventNewData.add(dyEvent);
            Long changeSceneId = data.getChangeSceneId();
            if (changeSceneId == 1010L || changeSceneId == 1050L || data.getBefore() == null) continue;
            List<DynamicObject> eventDetails = this.buildChangeEventDetailEntity(data, dyEvent.getLong("id"));
            eventDetailNewData.addAll(eventDetails);
        }
    }

    private void dealReportRelationChangeInfo(Map<Long, DynamicObject> detailMap, List<ChangeDetailEntity> relationChangeDatas, List<DynamicObject> eventNewData, List<DynamicObject> eventDetailNewData) {
        if (relationChangeDatas != null && relationChangeDatas.size() > 0) {
            ReportRelationHisServiceImpl service = new ReportRelationHisServiceImpl();
            List<ReportRelationHisPreDataVersionBo> bos = service.getNonAdminReportRelationPreVersionDataByPositions(relationChangeDatas);
            Map<Long, ReportRelationHisPreDataVersionBo> boMap = bos.stream().collect(Collectors.toMap(ReportRelationHisPreDataVersionBo::getEventId, v1 -> v1, (v1, v2) -> v2));
            for (ChangeDetailEntity data : relationChangeDatas) {
                long boid;
                DynamicObject dyDetail;
                Long eventId = data.getEventId();
                ReportRelationHisPreDataVersionBo reportRelationHisPreDataVersionBo = boMap.get(eventId);
                if (reportRelationHisPreDataVersionBo == null || (dyDetail = detailMap.get(boid = reportRelationHisPreDataVersionBo.getPositionBoId().longValue())) == null) continue;
                DynamicObject dyEvent = this.buildEventData(data, dyDetail.getLong("id"));
                eventNewData.add(dyEvent);
                DynamicObject eventDetails = this.buildRelationChangeEventDetailEntity(data, reportRelationHisPreDataVersionBo, dyEvent.getLong("id"));
                eventDetailNewData.add(eventDetails);
            }
        }
    }

    private DynamicObject buildDetailData(ChangeDetailEntity data) {
        DynamicObject positionData = data.getAfter();
        DynamicObject dyDetail = new DynamicObject((DynamicObjectType)this.dataEntityTypeDetail);
        dyDetail.set("id", (Object)this.getIdsMethod.getId());
        dyDetail.set("creator", positionData.get("creator"));
        dyDetail.set("createtime", positionData.get("createtime"));
        dyDetail.set("modifier", positionData.get("modifier"));
        dyDetail.set("modifytime", positionData.get("modifytime"));
        dyDetail.set("initdatasource", positionData.get("initdatasource"));
        dyDetail.set("initstatus", positionData.get("initstatus"));
        dyDetail.set("initbatch", positionData.get("initbatch"));
        dyDetail.set("position", (Object)positionData.getLong("boid"));
        dyDetail.set("org", positionData.get("org"));
        return dyDetail;
    }

    private DynamicObject buildEventData(ChangeDetailEntity data, long detailId) {
        DynamicObject dyEvent = new DynamicObject((DynamicObjectType)this.dataEntityTypeEvent);
        dyEvent.set("id", (Object)this.getIdsMethod.getId());
        dyEvent.set("event", (Object)data.getEventId());
        dyEvent.set("targetposition", (Object)data.getBoid());
        dyEvent.set("changetype", (Object)data.getChangeTypeId());
        dyEvent.set("changescene", (Object)data.getChangeSceneId());
        dyEvent.set("changedate", (Object)data.getChangeDate());
        dyEvent.set("operatetime", (Object)data.getOperateTime());
        dyEvent.set("operator", (Object)data.getModifier());
        dyEvent.set("parent", (Object)detailId);
        dyEvent.set("changereason", (Object)data.getChangeReasonId());
        DynamicObject after = data.getAfter();
        if (after != null) {
            dyEvent.set("hisposition", (Object)after.getLong("id"));
        }
        return dyEvent;
    }

    private List<DynamicObject> buildChangeEventDetailEntity(ChangeDetailEntity data, long eventId) {
        DynamicObject positionData = data.getAfter();
        DynamicObject beforeData = data.getBefore();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(16);
        DynamicConvertUtils dynamicCompareUtils = new DynamicConvertUtils(PositionDetailConstants.EXCLUDEPROPS);
        List<DynamicConvertUtils.CompareResult> compareResults = dynamicCompareUtils.compareAndGetAllDiffCol(positionData, beforeData);
        if (compareResults != null && compareResults.size() > 0) {
            for (DynamicConvertUtils.CompareResult compareResult : compareResults) {
                if (compareResult.isSame()) continue;
                DynamicObject dyEventdetail = new DynamicObject((DynamicObjectType)this.dataEntityTypeEventDetail);
                dyEventdetail.set("changeoperate", (Object)data.getChangeOperateId());
                dyEventdetail.set("changentity", (Object)positionData.getDataEntityType().getName());
                dyEventdetail.set("parent", (Object)eventId);
                dyEventdetail.set("propkey", (Object)compareResult.getPropKey());
                dyEventdetail.set("beforevalue", (Object)compareResult.getBeforeValue());
                dyEventdetail.set("aftervalue", (Object)compareResult.getAfterValue());
                result.add(dyEventdetail);
            }
        }
        return result;
    }

    private DynamicObject buildRelationChangeEventDetailEntity(ChangeDetailEntity data, ReportRelationHisPreDataVersionBo bo, long eventId) {
        List<DynamicObject> datas = bo.getData();
        List<Long> beforeDatas = bo.getPreVersionIds();
        DynamicObject dyEventdetail = new DynamicObject((DynamicObjectType)this.dataEntityTypeEventDetail);
        dyEventdetail.set("changeoperate", (Object)data.getChangeOperateId());
        dyEventdetail.set("changentity", (Object)"hbpm_reportingrelation");
        dyEventdetail.set("parent", (Object)eventId);
        dyEventdetail.set("propkey", (Object)"reportrelation");
        if (datas != null && datas.size() > 0) {
            Set sourceIds = datas.stream().map(dataInfo -> dataInfo.getLong("id")).collect(Collectors.toSet());
            dyEventdetail.set("aftervalue", (Object)StringUtils.join((Object[])sourceIds.toArray(), (String)","));
        }
        if (beforeDatas != null && beforeDatas.size() > 0) {
            dyEventdetail.set("beforevalue", (Object)StringUtils.join((Object[])beforeDatas.toArray(), (String)","));
        }
        return dyEventdetail;
    }

    public static class GetIdsMethod {
        private int size;
        private Queue<Long> ids;

        private GetIdsMethod(int size) {
            this.size = size;
        }

        public void initIds() {
            long[] dbIds = DB.genGlobalLongIds((int)this.size);
            LinkedList<Long> ids = new LinkedList<Long>();
            for (long id : dbIds) {
                ids.add(id);
            }
            this.ids = ids;
        }

        public long getId() {
            if (this.ids == null || this.ids.size() <= 0) {
                this.initIds();
            }
            if (this.ids == null || this.ids.size() <= 0) {
                return 0L;
            }
            Long id = this.ids.poll();
            return id == null ? 0L : id;
        }
    }
}

