/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.service.impl.position;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hrmp.hbpm.business.domain.service.position.IPositionJobService;

public class PositionJobServiceImpl
implements IPositionJobService {
    private static PositionJobServiceImpl instance = new PositionJobServiceImpl();

    public static PositionJobServiceImpl getInstance() {
        return instance;
    }

    @Override
    public List<Map<String, Object>> queryJobHis(List<Long> jobBoIds, Date effectDate) {
        List result = Lists.newArrayListWithExpectedSize((int)jobBoIds.size());
        Map<String, Object> jobHisInfo = this.acquireJobInfoMicroService("selectJobHisinfo", jobBoIds, effectDate);
        if (CollectionUtils.isEmpty(jobHisInfo)) {
            return result;
        }
        if (Objects.isNull(jobHisInfo.get("data"))) {
            return result;
        }
        result = (List)jobHisInfo.get("data");
        return result;
    }

    @Override
    public DynamicObject[] queryJobHisAndRefHis(List<Long> jobIds) {
        Map<String, Object> result = this.acquireJobInfoMicroService("queryJobHisAndRefHis", jobIds);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        DynamicObject[] jobHisAndRefHis = (DynamicObject[])result.get("data");
        return jobHisAndRefHis;
    }

    @Override
    public List<Map<String, Object>> queryGradeHisInfo(List<Long> gradeBoIds, Date effectDate) {
        return this.queryGradeOrLevelHisInfo("selectGradeHisinfo", gradeBoIds, effectDate);
    }

    @Override
    public List<Map<String, Object>> queryLevelHisInfo(List<Long> levelBoIds, Date effectDate) {
        return this.queryGradeOrLevelHisInfo("selectLevelHisinfo", levelBoIds, effectDate);
    }

    private List<Map<String, Object>> queryGradeOrLevelHisInfo(String method, List<Long> gradeOrLevelBoIds, Date effectDate) {
        List result = Lists.newArrayListWithExpectedSize((int)gradeOrLevelBoIds.size());
        Map<String, Object> gradeOrLevelHisInfo = this.acquireJobInfoMicroService(method, gradeOrLevelBoIds, effectDate);
        if (CollectionUtils.isEmpty(gradeOrLevelHisInfo)) {
            return result;
        }
        if (Objects.isNull(gradeOrLevelHisInfo.get("data"))) {
            return result;
        }
        result = (List)gradeOrLevelHisInfo.get("data");
        return result;
    }

    private Map<String, Object> acquireJobInfoMicroService(String method, List<Long> boIds, Date effectDate) {
        Map jobInfoResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMHisVerService", (String)method, (Object[])new Object[]{boIds, effectDate});
        return jobInfoResult;
    }

    private Map<String, Object> acquireJobInfoMicroService(String method, List<Long> jobIds) {
        Map jobInfoResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMHisVerService", (String)method, (Object[])new Object[]{jobIds});
        return jobInfoResult;
    }
}

