/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.service.impl.position;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisBaseBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisOperateType;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hrmp.hbpm.business.domain.service.position.IPositionService;
import kd.hrmp.hbpm.common.constants.PositionConstants;

public class PositionServiceImpl
implements IPositionService {
    @Override
    public DynamicObject[] batchSave(DynamicObject[] positions) {
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setHisDyns(positions);
        hisVersionParamBo.setOperateType(EnumHisOperateType.SAVE_VERSION.getType());
        hisVersionParamBo.setEntityNumber("hbpm_positionhr");
        HisResponse versionChangeRespDataHisResponse = HisModelController.getInstance().hisVersionChange(hisVersionParamBo);
        VersionChangeRespData data = (VersionChangeRespData)versionChangeRespDataHisResponse.getData();
        DynamicObject[] newDynamicObjects = data.getNewDynamicObjects();
        return (DynamicObject[])Arrays.stream(newDynamicObjects).filter(dyn -> !dyn.getBoolean("iscurrentversion")).toArray(DynamicObject[]::new);
    }

    @Override
    public DynamicObject[] batchEnableOrDisable(DynamicObject[] positions, String enable) {
        Arrays.stream(positions).forEach(position -> {
            if ("enable".equals(enable)) {
                position.set("changetype", (Object)1020L);
                position.set("enable", (Object)"1");
                position.set("enabler", (Object)RequestContext.get().getCurrUserId());
                position.set("enabledate", (Object)new Date());
                position.set("bsed", (Object)new Date());
            } else if ("disable".equals(enable)) {
                position.set("changetype", (Object)1040L);
                position.set("enable", (Object)"0");
                position.set("disabler", (Object)RequestContext.get().getCurrUserId());
                position.set("disabledate", (Object)new Date());
                position.set("bsed", (Object)new Date());
                position.set("changedesc", null);
                position.set("changeexplain", null);
            }
        });
        return this.batchHisVersionChange(positions);
    }

    @Override
    public DynamicObject[] batchChange(DynamicObject[] positions) {
        Arrays.stream(positions).forEach(position -> {
            Object changetype = position.get("changetype");
            if (changetype == null || changetype instanceof Long && (Long)changetype == 0L) {
                position.set("changetype", (Object)PositionConstants.CHANGETYPE_CHANGE_ID);
            }
        });
        return this.batchHisVersionChange(positions);
    }

    @Override
    public void batchDeleted(List<Long> ids) {
        this.deleteBo(ids);
    }

    private void deleteBo(List<Long> boIdList) {
        HisBaseBo hisBaseBo = new HisBaseBo();
        hisBaseBo.setEntityNumber("hbpm_positionhr");
        hisBaseBo.setBoIdList(boIdList);
        HisModelController.getInstance().deleteBo(hisBaseBo);
    }

    private DynamicObject[] batchHisVersionChange(DynamicObject[] positions) {
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        ArrayList listHisVersionParamBo = Lists.newArrayList();
        HisVersionParamBo hisVersionParamBo = new HisVersionParamBo();
        hisVersionParamBo.setEntityNumber(positions[0].getDynamicObjectType().getName());
        ArrayList positonDynList = Lists.newArrayListWithExpectedSize((int)positions.length);
        for (DynamicObject dyn2 : positions) {
            DynamicObject newDyn = new DynamicObject(dyn2.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)dyn2, (DynamicObject)newDyn);
            if (!dyn2.containsProperty("boid") || dyn2.getLong("boid") == 0L) {
                newDyn.set("boid", (Object)dyn2.getLong("id"));
            }
            positonDynList.add(newDyn);
        }
        hisVersionParamBo.setHisDyns(positonDynList.toArray(new DynamicObject[0]));
        listHisVersionParamBo.add(hisVersionParamBo);
        hisVersionParamListBo.setMainEntityNumber(positions[0].getDynamicObjectType().getName());
        hisVersionParamListBo.setListHisVersionParamBo((List)listHisVersionParamBo);
        HisResponse batchVersionChangeRespDataHisResponse = HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
        DynamicObject[] newDynamicObjects = ((VersionChangeRespData)((BatchVersionChangeRespData)batchVersionChangeRespDataHisResponse.getData()).getVersionChangeRespDataList().get(0)).getNewDynamicObjects();
        newDynamicObjects = (DynamicObject[])Arrays.stream(newDynamicObjects).filter(dyn -> !dyn.getBoolean("iscurrentversion")).toArray(DynamicObject[]::new);
        return newDynamicObjects;
    }

    @Override
    public DynamicObject revisePositionVersion(DynamicObject position) {
        DynamicObject[] result = this.batchChange(new DynamicObject[]{position});
        return result[0];
    }

    @Override
    public void saveFutureEffectFailResult(Map<Long, String> errMap) {
        HRBaseServiceHelper futureEffectHelper = new HRBaseServiceHelper("homs_posefflog");
        Date createTime = HRDateTimeUtils.getNowDateTime();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)errMap.size());
        for (Map.Entry<Long, String> entry : errMap.entrySet()) {
            DynamicObject emptyDyn = futureEffectHelper.generateEmptyDynamicObject();
            long posId = entry.getKey();
            String failreason = entry.getValue();
            emptyDyn.set("positionid", (Object)posId);
            emptyDyn.set("failreason", (Object)failreason);
            emptyDyn.set("createtime", (Object)createTime);
            list.add(emptyDyn);
        }
        futureEffectHelper.save(list.toArray(new DynamicObject[0]));
    }
}

