/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.service.impl.position;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.hrmp.hbpm.business.domain.bo.position.ChangeDetailBo;
import kd.hrmp.hbpm.business.domain.bo.position.ReportRelationChangeDetailBo;
import kd.hrmp.hbpm.business.domain.repository.position.CommonQueryRepository;
import kd.hrmp.hbpm.business.domain.service.position.IChangeDetailDisplayService;
import kd.hrmp.hbpm.business.utils.DynamicConvertUtils;

public class ReportRelationChangeDetailDisplayServiceImpl
implements IChangeDetailDisplayService {
    private Set<String> propKeys = Sets.newHashSet((Object[])new String[]{"role", "parent", "reportingtype", "enable"});

    @Override
    public List<ChangeDetailBo> buildChangeDetail(List<DynamicObject> detailInfos) {
        if (detailInfos == null || detailInfos.size() <= 0) {
            return null;
        }
        List<ReportRelationChangeDetailBo> results = this.buildChangeDetailBos(detailInfos);
        HashSet<Long> conditions = new HashSet<Long>(detailInfos.size());
        for (ReportRelationChangeDetailBo bo : results) {
            Set<Long> afterValueIds;
            Set<Long> beforeValueIds = bo.getBeforeValueIds();
            if (beforeValueIds != null && beforeValueIds.size() > 0) {
                conditions.addAll(beforeValueIds);
            }
            if ((afterValueIds = bo.getAfterValueIds()) == null || afterValueIds.size() <= 0) continue;
            conditions.addAll(afterValueIds);
        }
        if (conditions.size() > 0) {
            DynamicObject[] queryDatas = CommonQueryRepository.getInstance().loadColsInfoById("hbpm_reportingrelation", this.propKeys, conditions);
            this.buildDisplayInfo(results, queryDatas);
        }
        return ChangeDetailBo.buildBos(results);
    }

    private List<ReportRelationChangeDetailBo> buildDisplayInfo(List<ReportRelationChangeDetailBo> bos, DynamicObject[] datas) {
        if (bos == null || bos.size() <= 0 || datas == null || datas.length <= 0) {
            return null;
        }
        Map<Long, DynamicObject> dataMap = Arrays.stream(datas).collect(Collectors.toMap(data -> data.getLong("id"), v1 -> v1, (v1, v2) -> v2));
        for (ReportRelationChangeDetailBo bo : bos) {
            Set<Long> afterValueIds;
            Set<Long> beforeValueIds = bo.getBeforeValueIds();
            if (beforeValueIds != null && beforeValueIds.size() > 0) {
                List beforeValueInfos = Optional.ofNullable(bo.getBeforeValueInfos()).orElseGet(() -> new ArrayList());
                beforeValueIds.stream().forEach(id -> {
                    DynamicObject data = (DynamicObject)dataMap.get(id);
                    if (data != null) {
                        beforeValueInfos.add(data);
                    }
                });
                bo.setBeforeValueInfos(beforeValueInfos);
            }
            if ((afterValueIds = bo.getAfterValueIds()) != null && afterValueIds.size() > 0) {
                List afterValueInfos = Optional.ofNullable(bo.getAfterValueInfos()).orElseGet(() -> new ArrayList());
                afterValueIds.stream().forEach(id -> {
                    DynamicObject data = (DynamicObject)dataMap.get(id);
                    if (data != null) {
                        afterValueInfos.add(data);
                    }
                });
                bo.setAfterValueInfos(afterValueInfos);
            }
            this.setDisplayInfo(bo);
        }
        return bos;
    }

    private List<ReportRelationChangeDetailBo> buildChangeDetailBos(List<DynamicObject> diffInfos) {
        ArrayList<ReportRelationChangeDetailBo> bos = new ArrayList<ReportRelationChangeDetailBo>(diffInfos.size());
        for (DynamicObject dynamicObject : diffInfos) {
            ReportRelationChangeDetailBo bo = new ReportRelationChangeDetailBo();
            bo.setDetailId(dynamicObject.getLong("id"));
            bo.setPropKey(dynamicObject.getString("propkey"));
            bo.setBeforeValue(dynamicObject.getString("beforevalue"));
            bo.setAfterValue(dynamicObject.getString("aftervalue"));
            bo.setChangEntity(dynamicObject.getString("changentity"));
            bo.setBeforeValueIds(DynamicConvertUtils.getDatasFromValue(dynamicObject.getString("beforevalue")));
            bo.setAfterValueIds(DynamicConvertUtils.getDatasFromValue(dynamicObject.getString("aftervalue")));
            bos.add(bo);
        }
        return bos;
    }

    private ReportRelationChangeDetailBo setDisplayInfo(ReportRelationChangeDetailBo bo) {
        if (bo == null) {
            return null;
        }
        List<DynamicObject> beforeValueInfos = bo.getBeforeValueInfos();
        List<DynamicObject> afterValueInfos = bo.getAfterValueInfos();
        if (!(beforeValueInfos != null && beforeValueInfos.size() > 0 || afterValueInfos != null && afterValueInfos.size() > 0)) {
            return bo;
        }
        if (beforeValueInfos != null && beforeValueInfos.size() > 0) {
            bo.setBeforeValueDisplay(this.buildSingleReportRelationDisplay(beforeValueInfos));
        }
        if (afterValueInfos != null && afterValueInfos.size() > 0) {
            bo.setAfterValueDisplay(this.buildSingleReportRelationDisplay(afterValueInfos));
        }
        return bo;
    }

    private String buildSingleReportRelationDisplay(List<DynamicObject> valueInfos) {
        StringBuilder changeDisplay = new StringBuilder();
        for (DynamicObject reportRelation : valueInfos) {
            changeDisplay.append(this.getDisplayInfoFromDyn(reportRelation));
        }
        return changeDisplay.toString();
    }

    private String getDisplayInfoFromDyn(DynamicObject repotyRelation) {
        if (repotyRelation == null) {
            return "";
        }
        StringBuilder changeDisplay = new StringBuilder();
        DynamicObject reportingType = repotyRelation.getDynamicObject("reportingtype");
        DynamicObject reportParent = repotyRelation.getDynamicObject("parent");
        String enable = repotyRelation.getString("enable");
        if (StringUtils.equals((CharSequence)"0", (CharSequence)enable) || reportingType == null || reportParent == null) {
            return "";
        }
        changeDisplay.append(reportingType.getString("name")).append(" :").append(reportParent.getString("name")).append("  ");
        return changeDisplay.toString();
    }
}

