/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.service.impl.position;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.bo.workrole.ReportRelationHisPreDataVersionBo;
import kd.hrmp.hbpm.business.domain.repository.common.HisQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.ReportingrelationQueryRepository;
import kd.hrmp.hbpm.business.domain.service.position.IReportRelationHisService;
import kd.hrmp.hbpm.business.utils.model.ChangeDetailEntity;

public class ReportRelationHisServiceImpl
implements IReportRelationHisService {
    private static final long COMPARE_TIME = 500L;

    @Override
    public List<ReportRelationHisPreDataVersionBo> getNonAdminReportRelationPreVersionDataByPositions(List<ChangeDetailEntity> relationChangeDatas) {
        List<ReportRelationHisPreDataVersionBo> bos = ReportRelationHisPreDataVersionBo.buildBosByChangeEntity(relationChangeDatas);
        if (ObjectUtils.isEmpty(bos)) {
            return bos;
        }
        List<Long> canDealIdDataIds = bos.stream().map(ReportRelationHisPreDataVersionBo::getPositionBoId).collect(Collectors.toList());
        Object[] dataVersions = ReportingrelationQueryRepository.getInstance().queryAllNonAdministrativeRelationHisVersionsByDytyRoles(canDealIdDataIds);
        if (ObjectUtils.isEmpty((Object[])dataVersions)) {
            return bos;
        }
        Set<Long> reportRelationIds = Arrays.stream(dataVersions).map(data -> data.getLong("id")).collect(Collectors.toSet());
        Object[] roleHisEvents = HisQueryRepository.getInstance().loadAllRoleHisEventInfoByVIds(reportRelationIds);
        if (ObjectUtils.isEmpty((Object[])roleHisEvents)) {
            return bos;
        }
        ReportRelationHisServiceImpl.dealBoDataByQueryData(bos, (DynamicObject[])dataVersions, (DynamicObject[])roleHisEvents, "role.position");
        return bos;
    }

    private static void dealBoDataByQueryData(List<ReportRelationHisPreDataVersionBo> bos, DynamicObject[] dataVersions, DynamicObject[] roleHisEvents, String key) {
        if (ObjectUtils.isEmpty(bos) || ObjectUtils.isEmpty((Object[])dataVersions) || ObjectUtils.isEmpty((Object[])roleHisEvents)) {
            return;
        }
        ReportRelationHisServiceImpl.dealModifyInfoToDynFromHisEvent(dataVersions, roleHisEvents);
        ReportRelationHisServiceImpl.sortDataVersions(dataVersions);
        Map<Long, List<DynamicObject>> allDataMap = Arrays.stream(dataVersions).collect(Collectors.groupingBy(data -> data.getLong(key)));
        Map<Long, List<DynamicObject>> boMap = Arrays.stream(dataVersions).collect(Collectors.groupingBy(data -> data.getLong("boid")));
        for (ReportRelationHisPreDataVersionBo bo : bos) {
            Date bsed = bo.getBsed();
            Date modifyTime = bo.getModifyTime();
            Long boIdValue = 0L;
            boIdValue = HRStringUtils.equals((String)"role", (String)key) ? bo.getWorkRoleBoId() : bo.getPositionBoId();
            List<DynamicObject> reportRelations = allDataMap.get(boIdValue);
            if (ObjectUtils.isEmpty(reportRelations)) continue;
            List datas = Optional.ofNullable(bo.getData()).orElseGet(ArrayList::new);
            HashSet<Long> sourceVids = new HashSet<Long>(reportRelations.size());
            for (DynamicObject reportRelation : reportRelations) {
                if (!ReportRelationHisServiceImpl.judgeDynByTime(reportRelation, bsed, modifyTime)) continue;
                Long reportRelationBoid = reportRelation.getLong("boid");
                Long id = reportRelation.getLong("id");
                datas.add(reportRelation);
                List<DynamicObject> reportRelationUnderSameBoid = boMap.get(reportRelationBoid);
                DynamicObject preVersion = ReportRelationHisServiceImpl.getPreVersion(reportRelationUnderSameBoid, id);
                if (preVersion == null) continue;
                sourceVids.add(preVersion.getLong("id"));
            }
            bo.setData(datas);
            if (sourceVids.size() <= 0) continue;
            bo.setPreVersionIds(new ArrayList<Long>(sourceVids));
        }
    }

    private static void dealModifyInfoToDynFromHisEvent(DynamicObject[] dataVersions, DynamicObject[] roleHisEvents) {
        if (ObjectUtils.isEmpty((Object[])dataVersions) || ObjectUtils.isEmpty((Object[])roleHisEvents)) {
            return;
        }
        List valideRoleHisEvent = Arrays.stream(roleHisEvents).filter(data -> {
            String preStatus = data.getString("prestatus");
            return HRStringUtils.isEmpty((String)preStatus);
        }).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(valideRoleHisEvent)) {
            return;
        }
        Map<Long, DynamicObject> valideRoleHisEventMap = valideRoleHisEvent.stream().collect(Collectors.toMap(data -> data.getLong("vid"), vv -> vv, (v1, v2) -> v2));
        for (DynamicObject dataVersion : dataVersions) {
            Long id = dataVersion.getLong("id");
            DynamicObject eventData = valideRoleHisEventMap.get(id);
            if (eventData == null) continue;
            dataVersion.set("modifytime", eventData.get("modifytime"));
            dataVersion.set("modifier", eventData.get("modifier"));
        }
    }

    private static List<DynamicObject> sortDataVersions(DynamicObject[] dataVersions) {
        if (ObjectUtils.isEmpty((Object[])dataVersions)) {
            return new ArrayList<DynamicObject>(0);
        }
        List<DynamicObject> result = Arrays.stream(dataVersions).sorted((data1, data2) -> {
            Date bsed2;
            Date truncateBsed2;
            Date bsed1 = data1.getDate("bsed");
            Date truncateBsed1 = HRDateTimeUtils.truncateDate((Date)bsed1);
            if (truncateBsed1.equals(truncateBsed2 = HRDateTimeUtils.truncateDate((Date)(bsed2 = data2.getDate("bsed"))))) {
                Date modifyTime1 = data1.getDate("modifytime");
                Date modifyTime2 = data2.getDate("modifytime");
                return modifyTime1.getTime() > modifyTime2.getTime() ? 1 : -1;
            }
            return truncateBsed1.getTime() > truncateBsed2.getTime() ? 1 : -1;
        }).collect(Collectors.toList());
        return result;
    }

    private static DynamicObject getPreVersion(List<DynamicObject> datas, Long compareId) {
        if (ObjectUtils.isEmpty(datas) || compareId == null || compareId <= 0L) {
            return null;
        }
        int index = 0;
        for (DynamicObject data : datas) {
            Long id = data.getLong("id");
            if (compareId.longValue() == id.longValue()) {
                if (index == 0) {
                    return null;
                }
                return datas.get(index - 1);
            }
            ++index;
        }
        return null;
    }

    private static boolean judgeDynByTime(DynamicObject data, Date compareBsed, Date compareModifyTime) {
        Date compareBsedTruncate;
        Date bsed = data.getDate("bsed");
        Date bsedTruncate = HRDateTimeUtils.truncateDate((Date)bsed);
        if (!bsedTruncate.equals(compareBsedTruncate = HRDateTimeUtils.truncateDate((Date)compareBsed))) {
            return false;
        }
        Date modifyTime = data.getDate("modifytime");
        return Math.abs(compareModifyTime.getTime() - modifyTime.getTime()) <= 500L;
    }
}

