/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.domain.service.projectrole;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hrmp.hbpm.business.domain.repository.projectrole.ProjectRoleRepository;

public class ProRoleMsgService {
    private static final int MAX_TITLE_LENGTH = 50;
    private static final Log LOGGER = LogFactory.getLog(ProRoleMsgService.class);

    public static ProRoleMsgService getInstance() {
        return ProRoleMsgInstance.INSTANCE;
    }

    public void sendProRoleChgMsg(List<Map<String, Object>> msgMapList, Long newMainDutyProRoleBoId, Long oldMainDutyProRoleBoId, Date effDate) {
        if (ObjectUtils.isEmpty(msgMapList)) {
            return;
        }
        DynamicObject oldMainDutyProRoleDyn = null;
        if (oldMainDutyProRoleBoId != null && oldMainDutyProRoleBoId != 0L) {
            oldMainDutyProRoleDyn = ProjectRoleRepository.getInstance().getProRoleVersionInfoByBoId("id,boid", oldMainDutyProRoleBoId, "0", effDate);
        }
        HashMap<Long, Long> curVsOldMainDutyBoIdMap = new HashMap<Long, Long>(1);
        if (oldMainDutyProRoleDyn != null) {
            Long oldMainDutyVid = oldMainDutyProRoleDyn.getLong("id");
            curVsOldMainDutyBoIdMap.put(newMainDutyProRoleBoId, oldMainDutyVid);
            curVsOldMainDutyBoIdMap.put(oldMainDutyVid, oldMainDutyProRoleDyn.getLong("boid"));
        }
        for (Map<String, Object> msgMap : msgMapList) {
            HRProducerServiceHelper.publishAction(ProRoleMsgService.buildChangePublishInfo(msgMap, curVsOldMainDutyBoIdMap));
        }
    }

    public static Map<String, Object> buildChangePublishInfo(Map<String, Object> msgMap, Map<Long, Long> curVsOldMainDutyBoIdMap) {
        String msgTag = ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272\u53d8\u66f4", (String)"ProRoleMsgService_0", (String)"hrmp-hbpm-business", (Object[])new Object[0]);
        StringBuilder msgTitle = new StringBuilder();
        String title = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272\u201c%1$s\u201d\u53d8\u66f4\u5df2\u751f\u6548\u3002", (String)"ProRoleMsgService_1", (String)"hrmp-hbpm-business", (Object[])new Object[0]), msgMap.get("name"));
        if (title.length() > 50) {
            title = title.substring(0, 50);
        }
        msgTitle.append(title);
        HashMap<String, Object> actionInfo = new HashMap<String, Object>();
        actionInfo.put("msgNumber", msgMap.get("id") + "");
        actionInfo.put("senderId", 1L);
        actionInfo.put("sendTime", new Date());
        actionInfo.put("actionId", 1033101L);
        actionInfo.put("msgPubNo", "MP20221220001022");
        actionInfo.put("params", SerializationUtils.serializeToBase64(ProRoleMsgService.buildProRoleChgMsgParam(msgMap, curVsOldMainDutyBoIdMap)));
        actionInfo.put("msgTitle", msgTitle.toString());
        actionInfo.put("msgDesc", ResManager.loadKDString((String)"\u9879\u76ee\u89d2\u8272\u53d8\u66f4\u901a\u77e5", (String)"ProRoleMsgService_2", (String)"hrmp-hbpm-business", (Object[])new Object[0]));
        actionInfo.put("msgTag", msgTag);
        LOGGER.info("ProRoleMsgService.actionInfo,project.role.name={},actionInfo={}", msgMap.get("name"), (Object)SerializationUtils.toJsonString(actionInfo));
        return actionInfo;
    }

    public static Map<String, Map<String, Object>> buildProRoleChgMsgParam(Map<String, Object> msgMap, Map<Long, Long> curVsOldMainDutyBoIdMap) {
        Long id = (Long)msgMap.get("id");
        Long boId = (Long)msgMap.get("boid");
        Long oldMainDutyVid = curVsOldMainDutyBoIdMap.get(boId);
        HashMap<String, Map<String, Object>> msg = new HashMap<String, Map<String, Object>>(2);
        HashMap<String, Object> curData = new HashMap<String, Object>(8);
        curData.put("vid", id);
        curData.put("boId", boId);
        curData.put("dataType", msgMap.get("dataType"));
        msg.put("curProRole", curData);
        msg.put("oldProRole", new HashMap(8));
        if (oldMainDutyVid != null) {
            Map oldMainDutyMap = (Map)msg.get("oldProRole");
            oldMainDutyMap.put("vid", oldMainDutyVid);
            oldMainDutyMap.put("boId", curVsOldMainDutyBoIdMap.get(oldMainDutyVid));
            oldMainDutyMap.put("dataType", 1020L);
        }
        LOGGER.info("ProRoleMsgService.buildProRoleChgMsgParam,msg={}", msg);
        return msg;
    }

    private static class ProRoleMsgInstance {
        private static ProRoleMsgService INSTANCE = new ProRoleMsgService();

        private ProRoleMsgInstance() {
        }
    }
}

