/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class PositionParentValidateServiceHelper {
    private PositionParentValidateServiceHelper() {
    }

    public static PositionParentValidateServiceHelper getInstance() {
        return commonInstance.instance;
    }

    public List<DynamicObject> handleInitData(List<DynamicObject> dynamicObjectEntity, Map<String, Object> initMap, List<Long> errorIds) {
        if (CollectionUtils.isEmpty(dynamicObjectEntity) || CollectionUtils.isEmpty(initMap)) {
            return Lists.newArrayListWithExpectedSize((int)8);
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)dynamicObjectEntity.size());
        Map<String, DynamicObject> numberDynamicMap = this.numberDynamicMap(dynamicObjectEntity);
        Map<String, String> numberAndParentNumberMaps = this.numberAndParentNumberMaps(initMap);
        for (DynamicObject dynamicObject : dynamicObjectEntity) {
            DynamicObject parentDy = dynamicObject.getDynamicObject("parent");
            if (!HRObjectUtils.isEmpty((Object)parentDy)) {
                result.add(dynamicObject);
                continue;
            }
            String parentNumber = numberAndParentNumberMaps.get(dynamicObject.getString("number"));
            if (HRStringUtils.isEmpty((String)parentNumber)) {
                result.add(dynamicObject);
                continue;
            }
            DynamicObject parent = numberDynamicMap.get(parentNumber);
            if (!HRObjectUtils.isEmpty((Object)parent)) {
                dynamicObject.set("parent", (Object)parent);
                result.add(dynamicObject);
                continue;
            }
            errorIds.add(dynamicObject.getLong("id"));
            result.add(dynamicObject);
        }
        return result;
    }

    private Map<String, DynamicObject> numberDynamicMap(List<DynamicObject> dynamicObjectEntity) {
        return dynamicObjectEntity.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getString("number"), dy -> dy));
    }

    private Map<String, String> numberAndParentNumberMaps(Map<String, Object> initMap) {
        List mapData = (List)initMap.get("data");
        HashMap idAndNumberMaps = Maps.newHashMapWithExpectedSize((int)mapData.size());
        for (Map data : mapData) {
            String number = (String)data.get("parent");
            if (!HRStringUtils.isNotEmpty((String)number)) continue;
            idAndNumberMaps.put((String)data.get("number"), number);
        }
        return idAndNumberMaps;
    }

    private static class commonInstance {
        private static PositionParentValidateServiceHelper instance = new PositionParentValidateServiceHelper();

        private commonInstance() {
        }
    }
}

