/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;

public class DutyAndOrgSynServiceHelper {
    private Map<String, String> numberMap = this.initNumberPrefixCache();
    private static final String PAGE_HBSS_NUMBERPREFIX = "hbss_numberprefix";
    private static final String APP_KEY = "hbp";
    private static final String NUMBER_PREFIX = "numberprefix";
    private static final String TYPE = "type";
    private static final String TEAMTYPE_ID = "teamtype.id";
    private static final String ORGTYPE_ID = "orgtype.id";

    public String getNumberByNumberPrefix(String number, String type, Long teamtypeID, Long orgtypeID) {
        String key = this.getCacheKey(type, teamtypeID, orgtypeID);
        number = this.numberMap.get(key) + '_' + number;
        return number;
    }

    private Map<String, String> initNumberPrefixCache() {
        HashMap<String, String> modelMap = new HashMap();
        if (HRAppCache.get((String)APP_KEY).get(PAGE_HBSS_NUMBERPREFIX, Map.class) == null) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(PAGE_HBSS_NUMBERPREFIX);
            DynamicObject[] dynamicObject = serviceHelper.query("numberprefix,type,teamtype,orgtype", new QFilter[0]);
            String value = "";
            String key = "";
            for (int i = 0; i < dynamicObject.length; ++i) {
                key = this.getCacheKey(dynamicObject[i].getString(TYPE), dynamicObject[i].getLong(TEAMTYPE_ID), dynamicObject[i].getLong(ORGTYPE_ID));
                value = dynamicObject[i].get(NUMBER_PREFIX).toString();
                modelMap.put(key, value);
            }
            HRAppCache.get((String)APP_KEY).put(PAGE_HBSS_NUMBERPREFIX, modelMap);
        }
        modelMap = (Map)HRAppCache.get((String)APP_KEY).get(PAGE_HBSS_NUMBERPREFIX, Map.class);
        return modelMap;
    }

    private String getCacheKey(String type, Long teamtypeID, Long orgtypeID) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(type);
        keyBuilder.append('_');
        keyBuilder.append(teamtypeID);
        keyBuilder.append('_');
        keyBuilder.append(orgtypeID);
        return keyBuilder.toString();
    }
}

