/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.position;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.init.AbstractInitDomainDataService;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hbpm.business.application.impl.position.PositionInitServiceApplication;
import kd.hrmp.hbpm.business.application.position.IPositionInitServiceApplication;
import kd.hrmp.hbpm.business.init.PositionParentValidateServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class PositionInitDomainDataServiceImpl
extends AbstractInitDomainDataService {
    private static Log LOG = LogFactory.getLog(PositionInitDomainDataServiceImpl.class);
    private IPositionInitServiceApplication positionInitServiceApplication = new PositionInitServiceApplication();
    private Map<String, Object> result;
    private Map<Object, Set<Long>> idMapping;
    private List<DynamicObject> entityDycList;

    private void init() {
        this.result = this.getInfoWithDynamicObject();
        this.entityDycList = (List)this.result.get("data");
        this.idMapping = (Map)this.result.get("idmapping");
        this.setInitDefalutValue(this.entityDycList);
    }

    public void validate() {
        LOG.info("PositionInitDomainDataServiceImpl is validate start");
        this.init();
        this.callOp(true);
        LOG.info("PositionInitDomainDataServiceImpl is validate end");
    }

    public void save() {
        LOG.info("PositionInitDomainDataServiceImpl is save start");
        this.init();
        this.callOp(false);
        LOG.info("PositionInitDomainDataServiceImpl is save end");
    }

    private void callOp(boolean isValidate) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isInitValidate", String.valueOf(isValidate));
        ArrayList errorIds = Lists.newArrayListWithExpectedSize((int)16);
        List<DynamicObject> positions = PositionParentValidateServiceHelper.getInstance().handleInitData(this.entityDycList, this.getInfoWithMap(), errorIds);
        operateOption.setVariableValue("errorIds", JSON.toJSONString((Object)errorIds));
        this.handlePositionInfo(positions);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)this.getInitInParam().getEntityNumber(), (DynamicObject[])positions.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        HashMap errMap = Maps.newHashMapWithExpectedSize((int)16);
        ValidateResultCollection validateResult = result.getValidateResult();
        if (validateResult != null && !CollectionUtils.isEmpty((Collection)validateResult.getValidateErrors())) {
            List validateErrors = validateResult.getValidateErrors();
            for (ValidateResult validateError : validateErrors) {
                List errorPkIdList = validateError.getAllErrorInfo();
                errorPkIdList.forEach(err -> {
                    Long pkValue = (Long)err.getPkValue();
                    String message = err.getMessage();
                    Set messageSet = (Set)errMap.get(pkValue);
                    if (messageSet != null) {
                        messageSet.add(message);
                    } else {
                        HashSet<String> messages = new HashSet<String>();
                        messages.add(message);
                        errMap.put(pkValue, messages);
                    }
                });
            }
        }
        List successPkIds = result.getSuccessPkIds();
        LOG.info(String.format("PositionInitDomainDataServiceImpl successPkIds size is: %s", CollectionUtils.isEmpty((Collection)successPkIds) ? " " : Integer.valueOf(successPkIds.size())));
        this.buildInitOutParam(errMap);
    }

    private void handlePositionInfo(List<DynamicObject> positionInfos) {
        StringBuilder numberBuffer = new StringBuilder();
        for (DynamicObject positionInfo : positionInfos) {
            positionInfo.set("changetype", (Object)1050L);
            positionInfo.set("establishmentdate", (Object)positionInfo.getDate("bsed"));
            if (HRObjectUtils.isEmpty((Object)positionInfo.getDynamicObject("org")) && !HRObjectUtils.isEmpty((Object)positionInfo.getDynamicObject("adminorg"))) {
                positionInfo.set("org", (Object)positionInfo.getDynamicObject("adminorg").getDynamicObject("org"));
            }
            numberBuffer.append(positionInfo.getString("number")).append(',');
        }
        LOG.info(String.format("PositionInitDomainDataServiceImpl SAVE currentDate is: %s and numberBuffer is : %s", new Date(), numberBuffer.toString()));
    }

    private void buildInitOutParam(Map<Long, Set<String>> errMap) {
        this.idMapping.forEach((key, val) -> {
            if (!ObjectUtils.isEmpty((Object)val)) {
                if (errMap.containsKey(key)) {
                    val.forEach(midId -> this.getInitOutParam().addErrorMsg(midId, StringUtils.join((Iterable)((Iterable)errMap.get(key)), (String)";")));
                } else {
                    val.forEach(midId -> this.getInitOutParam().addSuccessMsg(midId, key.toString(), ""));
                }
            }
        });
    }

    public void changeStatus() {
        List<Long> positionIds = this.positionInitServiceApplication.changeInitStatus(this.getInitInParam().getBatchNumber(), this.getSourceStatus(), this.getTargetStatus());
        this.getInitOutParam().getHandleIdSet().addAll(positionIds);
    }

    public void rollback() {
        LOG.info("PositionInitDomainDataServiceImpl is rollback start");
        List<Long> rollbackIds = this.positionInitServiceApplication.rollback(this.getInitInParam().getBatchNumber());
        this.getInitOutParam().getHandleIdSet().addAll(rollbackIds);
    }
}

