/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbpm.business.service.position;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.util.CodeRuleSerialNumUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hbpm.business.domain.repository.position.PositionBillQueryRepository;
import kd.hrmp.hbpm.business.domain.repository.position.PositionQueryRepository;
import kd.hrmp.hbpm.business.utils.PositionUtils;

public class PositionServiceHelper {
    public static String getLocalValue(DynamicObject dynamicObject, String field) {
        if (ObjectUtils.isEmpty((Object)dynamicObject)) {
            return "";
        }
        return StringUtils.defaultString((String)dynamicObject.getString(field));
    }

    public static Map<Long, DynamicObject> covertNumDynamicObjectMap(DynamicObject[] dynamicObjects) {
        HashMap maps = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            maps.put(dynamicObject.getLong("boid"), dynamicObject);
        }
        return maps;
    }

    public static DynamicObject transferPositionToPositionBill(DynamicObject position) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"homs_positionbill");
        DynamicObject positionBill = new DynamicObject((DynamicObjectType)dataEntityType);
        HRDynamicObjectUtils.copy((DynamicObject)position, (DynamicObject)positionBill);
        positionBill.set("org", position.get("adminorg.org"));
        positionBill.set("hisnewversion", (Object)position.getLong("id"));
        positionBill.set("billno", (Object)PositionServiceHelper.getRandomNumber(8));
        positionBill.set("billstatus", (Object)"C");
        positionBill.set("auditstatus", (Object)"C");
        return positionBill;
    }

    public static List<DynamicObject> transferPositionToPositionBill(List<DynamicObject> positions) {
        ArrayList positionBills = Lists.newArrayListWithExpectedSize((int)positions.size());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"homs_positionbill");
        for (DynamicObject position : positions) {
            DynamicObject positionBill = new DynamicObject((DynamicObjectType)dataEntityType);
            HRDynamicObjectUtils.copy((DynamicObject)position, (DynamicObject)positionBill);
            positionBill.set("hisnewversion", (Object)position.getLong("id"));
            positionBill.set("billno", (Object)PositionServiceHelper.getRandomNumber(8));
            positionBill.set("billstatus", (Object)"C");
            positionBill.set("auditstatus", (Object)"C");
            positionBills.add(positionBill);
        }
        return positionBills;
    }

    public static List<DynamicObject> transferToPositionBill(List<DynamicObject> positions) {
        ArrayList positionBills = Lists.newArrayListWithExpectedSize((int)positions.size());
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"homs_positionbill");
        for (DynamicObject position : positions) {
            DynamicObject positionBill = new DynamicObject((DynamicObjectType)dataEntityType);
            HRDynamicObjectUtils.copy((DynamicObject)position, (DynamicObject)positionBill);
            Long positionId = position.getLong("id");
            if (positionId == null || positionId == 0L) {
                positionId = PositionUtils.createId("homs_positionbill");
            }
            positionBill.set("id", (Object)positionId);
            positionBill.set("billstatus", (Object)"C");
            positionBill.set("auditstatus", (Object)"C");
            positionBills.add(positionBill);
        }
        return positionBills;
    }

    public static List<DynamicObject> transferPositionBillToPosition(DynamicObject[] positionBills, long changeType) {
        ArrayList positions = Lists.newArrayListWithExpectedSize((int)positionBills.length);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_positionhr");
        for (DynamicObject positionBill : positionBills) {
            PositionServiceHelper.changeEnableFromBSed(positionBill);
            DynamicObject position = new DynamicObject((DynamicObjectType)dataEntityType);
            HRDynamicObjectUtils.copy((DynamicObject)positionBill, (DynamicObject)position);
            Long positionBillId = positionBill.getLong("id");
            if (positionBillId == 0L) {
                positionBillId = PositionUtils.createId("homs_positionbill");
                positionBill.set("id", (Object)positionBillId);
            }
            positionBill.set("billno", (Object)PositionServiceHelper.getRandomNumber(8));
            positionBill.set("auditstatus", (Object)"C");
            positionBill.set("billstatus", (Object)"C");
            position.set("id", (Object)positionBillId);
            position.set("changetype", (Object)changeType);
            position.set("initstatus", (Object)"2");
            position.set("initdatasource", (Object)"0");
            positions.add(position);
        }
        return positions;
    }

    private static void changeEnableFromBSed(DynamicObject positionBill) {
        positionBill.set("enable", (Object)"1");
    }

    public static List<DynamicObject> transferPositionBillToPositionForModify(DynamicObject[] positionBills) {
        return PositionServiceHelper.transferPositionBillToPositionForModify(positionBills, null);
    }

    public static List<DynamicObject> transferPositionBillToPositionForModify(DynamicObject[] positionBills, Map<Long, DynamicObject> positionBillMap) {
        ArrayList positions = Lists.newArrayListWithExpectedSize((int)positionBills.length);
        List<Long> positionVersionIds = Arrays.stream(positionBills).map(positionBill -> positionBill.getLong("hisnewversion")).collect(Collectors.toList());
        Map<Long, DynamicObject> versionIdAndPositionMap = PositionQueryRepository.getInstance().queryVersionIdAndPositionMap(positionVersionIds);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hbpm_positionhr");
        for (DynamicObject positionBill2 : positionBills) {
            DynamicObject position = new DynamicObject((DynamicObjectType)dataEntityType);
            HRDynamicObjectUtils.copy((DynamicObject)positionBill2, (DynamicObject)position);
            DynamicObject positionHisVersion = versionIdAndPositionMap.get(positionBill2.getLong("hisnewversion"));
            position.set("id", (Object)positionHisVersion.getLong("boid"));
            position.set("boid", (Object)positionHisVersion.getLong("boid"));
            position.set("initstatus", (Object)positionHisVersion.getString("initstatus"));
            position.set("initdatasource", (Object)positionHisVersion.getString("initdatasource"));
            position.set("initbatch", (Object)positionHisVersion.getString("initbatch"));
            if (positionBillMap != null) {
                positionBillMap.put(positionHisVersion.getLong("boid"), positionBill2);
            }
            positions.add(position);
        }
        return positions;
    }

    public static String getRandomNumber(int length) {
        return CodeRuleSerialNumUtil.getRandomNumber((int)length);
    }

    public static boolean isInitComplete(DynamicObject position) {
        return HRStringUtils.equals((String)"2", (String)position.getString("initstatus"));
    }

    public static boolean isEnabled(DynamicObject position) {
        return HRStringUtils.equals((String)"1", (String)position.getString("enable"));
    }

    public static void recycleNumber(DynamicObject[] positionBills) {
        if (positionBills == null || positionBills.length == 0) {
            return;
        }
        Map<String, DynamicObject> numberToBill = Arrays.stream(positionBills).filter(bill -> HRStringUtils.isNotEmpty((String)bill.getString("number"))).collect(Collectors.toMap(bill -> bill.getString("number"), bill -> bill));
        if (numberToBill.size() == 0) {
            return;
        }
        DynamicObject[] existPos = PositionBillQueryRepository.getInstance().queryPositionDataByNumbers(new ArrayList<String>(numberToBill.keySet()));
        Set existNumberSet = Arrays.stream(existPos).map(bill -> bill.getString("number")).collect(Collectors.toSet());
        for (String existNumber : existNumberSet) {
            numberToBill.remove(existNumber);
        }
        Map orgToPosMap = new ArrayList<DynamicObject>(numberToBill.values()).stream().collect(Collectors.groupingBy(bill -> bill.getLong("org.id"), Collectors.toList()));
        for (Map.Entry next : orgToPosMap.entrySet()) {
            Long orgId = next.getKey();
            String orgIdStr = null;
            if (orgId != 0L) {
                orgIdStr = String.valueOf(orgId);
            }
            List<DynamicObject> bills = next.getValue();
            CodeRuleServiceHelper.recycleBatchNumber((String)"homs_positionbill", (DynamicObject[])bills.toArray(new DynamicObject[0]), (String)orgIdStr, (String[])((String[])bills.stream().map(bill -> bill.getString("number")).toArray(String[]::new)));
        }
    }
}

